/*
   Copyright (C) 2011 by Stefan Taferner <taferner@kde.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, see <http://www.gnu.org/licenses/>.
*/

#include "log.h"
#include <iostream>


static const char* logLevels[] =
{
   "trace", "debug", "info", "warning", "error", 0
};

LogLevel Logger::sMinLogLevel = LOG_INFO;


Logger::Logger(const char* aFile, const int aLine, LogLevel aLevel)
:mLine(aLine)
,mLevel(aLevel)
{
   const char* pos = strrchr(aFile, '/');
   mFile = pos ? pos+1 : aFile;
}


Logger::~Logger()
{
   if (mLevel >= sMinLogLevel)
      log(mLevel, mMessage, mFile, mLine);
}


QString& Logger::operator()(LogLevel aLevel, QString aMessage)
{
   mLevel = aLevel;
   mMessage = aMessage;
   return mMessage;
}


void Logger::operator<<(const QString& aMessage)
{
   mMessage = aMessage;
}


void Logger::log(LogLevel aLevel, const QString& aMessage, const char* aFile, int aLine)
{
   std::cout<<logLevels[(int)aLevel]<<" - "<<(const char*)aMessage.toLocal8Bit()
            <<"  ["<<aFile<<":"<<aLine<<"]"<<std::endl;
}
