/*
   Copyright (C) 2008-2011 by Stefan Taferner <taferner@kde.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, see <http://www.gnu.org/licenses/>.
*/
#ifndef imagewidget_h
#define imagewidget_h

#include <QtGui/QWidget>

class QCheckBox;
class QComboBox;
class QLabel;
class QLineEdit;
class QPushButton;
class TabBase;
namespace KoverArtist { class Image; }


/** A high level gui widget for changing the various configuration elements
 * of a koverartist image.
 */
class ImageWidget: public QWidget
{
   Q_OBJECT
   typedef QWidget Inherited;

public:
   ImageWidget(KoverArtist::Image* img, TabBase* parent = 0);
   virtual ~ImageWidget();

signals:
   /** Emitted when the user changed image settings. */
   void changed();

public slots:
   /** Update the gui elements from the image. */
   virtual void updateContents();

   /** Open a file selection dialog and let the user select the image file. */
   virtual void selectFile();

   /** Set the image file name. */
   virtual void setFileName(const QString& fileName);

   /** Set image-on-sides. */
   virtual void setOnSides(bool enabled);

protected slots:
   /** Set/select the image position from the selected combobox entry. */
   virtual void setPosition(int comboBoxIndex);

   /** The user finished editing the file name. */
   virtual void fileNameEdited();

private:
   ImageWidget(const ImageWidget&);
   ImageWidget& operator=(const ImageWidget&);

protected:
   KoverArtist::Image *mImage;
   QComboBox *mCboPosition;
   QLineEdit *mEdtFileName;
   QPushButton *mBtnFileSelect;
   QCheckBox *mCbxOnSides;
};

#endif /*imagewidget_h*/
