/*
   Copyright (C) 2008-2011 by Stefan Taferner <taferner@kde.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, see <http://www.gnu.org/licenses/>.
*/
#ifndef effectwidget_h
#define effectwidget_h

#include <QtGui/QWidget>

class KColorButton;
class QComboBox;
class QSlider;
class QLabel;
class QColor;
namespace KoverArtist { class Effect; }


/** A high level gui widget for changing the various configuration elements
 *  of a koverartist effect.
 */
class EffectWidget: public QWidget
{
   typedef QWidget Inherited;
   Q_OBJECT

public:
   EffectWidget(KoverArtist::Effect* e, QWidget* parent = 0);
   virtual ~EffectWidget();

signals:
   /** Emitted when the user changed effect settings. */
   void changed();

public slots:
   /** Update the gui elements from the effect. */
   virtual void updateContents();

   /** Set the effect type. */
   virtual void setType(int effectType);

   /** Set the primary effect color. */
   virtual void setColor1(const QColor& color);

   /** Set the secondary effect color. */
   virtual void setColor2(const QColor& color);

   /** Set the size of the effect. */
   virtual void setSize(int size);

   /** Set the transparency (0..255). */
   virtual void setTrans(int alpha);

protected slots:
   virtual void sendChanged();

protected:
   KoverArtist::Effect *mEffect;
   KColorButton *mBtnColor1, *mBtnColor2;
   QSlider *mSldSize, *mSldTrans;
   QLabel *mLblSize, *mLblTrans, *mLblSizeVal, *mLblTransVal;
   QComboBox *mCboType;
};

#endif /*effectwidget_h*/
