#################################################
#   Copyright (C) 2005 by Brian Arnold
#   brian@ae6gn.com
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the
#   Free Software Foundation, Inc.,
#   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#################################################


require 'rexml/document'
include REXML

def saveSettings(file)
	eRoot = Element.new("kenigma")


	eWheel = Element.new("wheel")

	eR1 = Element.new("wheel1")
	eR1.text = @inUse["rotor1"]

	eR2 = Element.new("wheel2")
	eR2.text = @inUse["rotor2"]

	eR3 = Element.new("wheel3")
	eR3.text = @inUse["rotor3"]

 	eR4 = Element.new("wheel4")
 	if @inUse["rotor4"] == nil then
 		eR4.text = nil
 	 else
 		eR4.text = @inUse["rotor4"]
 	end

 	eRef = Element.new("ref")
 	eRef.text = @inUse["ref"]

 	eWheel.elements << eR1
 	eWheel.elements << eR2
 	eWheel.elements << eR3
 	eWheel.elements << eR4
 	eWheel.elements << eRef


 	ePos = Element.new("position")

 	eP1 = Element.new("rotor1")
	eP1.text = @rotorPos1.text

	eP2 = Element.new("rotor2")
	eP2.text = @rotorPos2.text

	eP3 = Element.new("rotor3")
	eP3.text = @rotorPos3.text

 	eP4 = Element.new("rotor4")
 	eP4.text = @rotorPos4.text

 	ePos.elements << eP1
 	ePos.elements << eP2
 	ePos.elements << eP3
 	ePos.elements << eP4


 	eTextWindow = Element.new("textwindow")

  	eEnabled = Element.new("enabled")
  	texwin = @viewText_WindowAction.isOn
  	if texwin == false then
		texwin = "false"
	 else
	 	texwin = "true"
  	end
  	eEnabled.text = texwin

 	eTextWindow.elements << eEnabled



 	eSteckerBoard = Element.new("steckerboard")

 	eEnabled = Element.new("enabled")

 	steckboard = @viewSteckerAction.isOn
 	if steckboard == false then
 		steckboard = "false"
 	 else
 		steckboard = "true"
 	end
 	eEnabled.text = steckboard

 	eSteckerBoard.elements << eEnabled


 	eRoot.elements << eWheel
 	eRoot.elements << ePos
 	eRoot.elements << eTextWindow
 	eRoot.elements << eSteckerBoard

 	xmlSave = Document.new
 	xmlSave << XMLDecl.new("1.0", "UTF-8")
 	xmlSave << DocType.new("kenigma", 'SYSTEM "kenigma.dtd"')
 	xmlSave.add_element(eRoot)
	#xmlSave.write($stdout, 0)  # Print to shell
	#print "\n"

 	#f = File.new(file, "w+")
	#xmlSave.write(f, 0)
	#f.close

   f = KDE::SaveFile.new(file)
   #file.textStream << str
   xmlSave.write(f.textStream, 0)
   f.close
end

def loadSettings(file)
	f = File.open(file, "r")
	xmlOpen = Document.new(f)
	@inUse["rotor1"] = xmlOpen.root.elements['wheel'].elements['wheel1'].text
	@Rotor1.currentText = xmlOpen.root.elements['wheel'].elements['wheel1'].text
	@inUse["rotor2"] = xmlOpen.root.elements['wheel'].elements['wheel2'].text
	@Rotor2.currentText = xmlOpen.root.elements['wheel'].elements['wheel2'].text
	@inUse["rotor3"] = xmlOpen.root.elements['wheel'].elements['wheel3'].text
	@Rotor3.currentText = xmlOpen.root.elements['wheel'].elements['wheel3'].text
	if xmlOpen.root.elements['wheel'].elements['wheel4'].text == nil then
		nil
	 else
		@inUse["rotor4"] = xmlOpen.root.elements['wheel'].elements['wheel4'].text
		@Rotor4.currentText = xmlOpen.root.elements['wheel'].elements['wheel4'].text
	end
	@inUse["ref"] = xmlOpen.root.elements['wheel'].elements['ref'].text
	@Ref.currentText = xmlOpen.root.elements['wheel'].elements['ref'].text

	@rotorPos1.text = xmlOpen.root.elements['position'].elements['rotor1'].text
	@position1 = xmlOpen.root.elements['position'].elements['rotor1'].text.slice(0) - 65
	@rotorPos2.text = xmlOpen.root.elements['position'].elements['rotor2'].text
	@position2 = xmlOpen.root.elements['position'].elements['rotor2'].text.slice(0) - 65
	@rotorPos3.text = xmlOpen.root.elements['position'].elements['rotor3'].text
	@position3 = xmlOpen.root.elements['position'].elements['rotor3'].text.slice(0) - 65
	@rotorPos4.text = xmlOpen.root.elements['position'].elements['rotor4'].text
	@position4 = xmlOpen.root.elements['position'].elements['rotor4'].text.slice(0) - 65

	if xmlOpen.root.elements['textwindow'].elements['enabled'].text == "true" then
		@viewText_WindowAction.toggle
		@textWindow.show
	end

	if xmlOpen.root.elements['steckerboard'].elements['enabled'].text == "true" then
		@viewSteckerAction.toggle
		@steckerBoard.show
	end
	f.close
end
