#################################################
#   Copyright (C) 2005 by Brian Arnold
#   brian@ae6gn.com
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the
#   Free Software Foundation, Inc.,
#   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#################################################



# rotor list
$rotorList = Array.new
$rotorList[0] = "I"
$rotorList[1] = "II"
$rotorList[2] = "III"
$rotorList[3] = "IV"
$rotorList[4] = "V"
$rotorList[5] = "VI"
$rotorList[6] = "VII"
$rotorList[7] = "VIII"



# rotor wiring
$rotor = Array.new
$rotor[0] = "ABCDEFGHIJKLMNOPQRSTUVWXYZ"

$rotor[1] = "EKMFLGDQVZNTOWYHXUSPAIBRCJ" # rotor I
$rotor[2] = "AJDKSIRUXBLHWTMCQGZNPYFVOE" # rotor II
$rotor[3] = "BDFHJLCPRTXVZNYEIWGAKMUSQO" # rotor III
$rotor[4] = "ESOVPZJAYQUIRHXLNFTGKDCMWB" # rotor IV
$rotor[5] = "VZBRGITYUPSDNHLXAWMJQOFECK" # rotor V
$rotor[6] = "JPGVOUMFYQBENHZRDKASXLICTW" # rotor VI
$rotor[7] = "NZJHGRCXMYSWBOUFAIVLPEKQDT" # rotor VII
$rotor[8] = "FKQHTLXOCBJSPDZRAMEWNIUYGV" # rotor VIII
$rotor[9] = "LEYJVCNIXWPBQMDRTAKZGFUHOS" # Rotor 'b' M4 only
$rotor[10] = "FSOKANUERHMBTIYCWLQPZXVGJD" # Rotor 'c' M4 only


# rotor carry posions
$turnover = Hash.new
$turnover["I"] = "Q"
$turnover["II"] = "E"
$turnover["III"] = "V"
$turnover["IV"] = "J"
$turnover["V"] = "Z"
$turnover["VI"] = "Z, M"
$turnover["VII"] = "Z, M"
$turnover["VIII"] = "Z, M"



# reflector wiring
$reflector = Array.new
$reflector[0] = "ABCDEFGHIJKLMNOPQRSTUVWXYZ"

$reflector[1] = "EJMZALYXVBWFCRQUONTSPIKHGD" # reflector 'A'
$reflector[2] = "YRUHQSLDPXNGOKMIEBFZCWVJAT" # reflector 'B'
$reflector[3] = "FVPJIAOYEDRZXWGCTKUQSBNMHL" # reflector 'C'
$reflector[4] = "ENKQAUYWJICOPBLMDXZVFTHRGS" # reflector 'Thin B' M4 only
$reflector[5] = "RDOBJNTKVEHMLFCWZAXGYIPSUQ" # reflector 'Thin C' M4 only


def cypher1(input)
	@textWindow.setEnteredText(input)
	print input
	print " -> "
	input2 = input.slice(0) + @position1
	if input2 > 90 then
		input2 = input2 - 26
	end
	cyIn = $rotor[0].index(input2.chr)
	if cyIn == 26 then
		cyIn = 0
	end
	wheel1 = @inUse["rotor1"]
	case wheel1
		when "I" then wheel1 = 1
		when "II" then wheel1 = 2
		when "III" then wheel1 = 3
		when "IV" then wheel1 = 4
		when "V" then wheel1 = 5
		when "VI" then wheel1 = 6
		when "VII" then wheel1 = 7
		when "VIII" then wheel1 = 8
	end
	wheel1 = $rotor[wheel1.to_i]
	cyWheel1 = wheel1.slice(cyIn)
	cyWheel1 = cyWheel1 - @position1
	if cyWheel1 < 65 then
		cyWheel1 = cyWheel1 + 26
	end
	print cyWheel1.chr
	print " -> "
	cypher2(cyWheel1.chr)
end

def cypher2(input)
	input2 = input.slice(0) + @position2
	if input2 > 90 then
		input2 = input2 - 26
	end
	cyIn = $rotor[0].index(input2.chr)
	if cyIn == 26 then
		cyIn = 0
	end
	wheel2 = @inUse["rotor2"]
	case wheel2
		when "I" then wheel2 = 1
		when "II" then wheel2 = 2
		when "III" then wheel2 = 3
		when "IV" then wheel2 = 4
		when "V" then wheel2 = 5
		when "VI" then wheel2 = 6
		when "VII" then wheel2 = 7
		when "VIII" then wheel2 = 8
	end
	wheel2 = $rotor[wheel2.to_i]
	cyWheel2 = wheel2.slice(cyIn)
	cyWheel2 = cyWheel2 - @position2
	if cyWheel2 < 65 then
		cyWheel2 = cyWheel2 + 26
	end
	print cyWheel2.chr
	print " -> "
	cypher3(cyWheel2.chr)
end

def cypher3(input)
	input2 = input.slice(0) + @position3
	if input2 > 90 then
		input2 = input2 - 26
	end
	cyIn = $rotor[0].index(input2.chr)
	if cyIn == 26 then
		cyIn = 0
	end
	wheel3 = @inUse["rotor3"]
	case wheel3
		when "I" then wheel3 = 1
		when "II" then wheel3 = 2
		when "III" then wheel3 = 3
		when "IV" then wheel3 = 4
		when "V" then wheel3 = 5
		when "VI" then wheel3 = 6
		when "VII" then wheel3 = 7
		when "VIII" then wheel3 = 8
	end
	wheel3 = $rotor[wheel3.to_i]
	cyWheel3 = wheel3.slice(cyIn)
	cyWheel3 = cyWheel3 - @position3
	if cyWheel3 < 65 then
		cyWheel3 = cyWheel3 + 26
	end
	print cyWheel3.chr
	print " -> "
	if @inUse["rotor4"] == "none" then
		cypherRef(cyWheel3.chr)
	 else
		cypher4(cyWheel3.chr)
	end
end


def cypher4(input)
	input2 = input.slice(0) + @position4
	if input2 > 90 then
		input2 = input2 - 26
	end
	cyIn = $rotor[0].index(input2.chr)
	if cyIn == 26 then
		cyIn = 0
	end
	wheel4 = @inUse["rotor4"]
	case wheel4
		when "b" then wheel4 = 9
		when "c" then wheel4 = 10
	end
	wheel4 = $rotor[wheel4.to_i]
	cyWheel4 = wheel4.slice(cyIn)
	cyWheel4 = cyWheel4 - @position4
	if cyWheel4 < 65 then
		cyWheel4 = cyWheel4 + 26
	end
	print cyWheel4.chr
	print " -> "
	cypherRef(cyWheel4.chr)
end


def cypherRef(input)
	cyIn = $rotor[0].index(input)
	ref = @inUse["ref"]
	case ref
		when "A" then ref = 1
		when "B" then ref = 2
		when "C" then ref = 3
		when "b" then ref = 4
		when "c" then ref = 5
	end
	ref = $reflector[ref.to_i]
	cyRef = ref.slice(cyIn)
 	print cyRef.chr
 	print " -> "
 	if @inUse["rotor4"] == "none" then
		cypher3r(cyRef.chr)
	 else
		cypher4r(cyRef.chr)
	end
end

def cypher4r(input)
	input2 = input.slice(0) + @position4
	if input2 > 90 then
		input2 = input2 - 26
	end
	wheel4r = @inUse["rotor4"]
	case wheel4r
		when "b" then wheel4r = 9
		when "c" then wheel4r = 10
	end
	wheel4r = $rotor[wheel4r.to_i]
	cyIn = wheel4r.index(input2)
	if cyIn == 26 then
		cyIn = 0
	end
	cyWheel4r = $rotor[0].slice(cyIn)
	cyWheel4r = cyWheel4r - @position4
	if cyWheel4r < 65 then
		cyWheel4r = cyWheel4r + 26
	end
	print cyWheel4r.chr
	print " -> "
	cypher3r(cyWheel4r.chr)
end

def cypher3r(input)
	input2 = input.slice(0) + @position3
	if input2 > 90 then
		input2 = input2 - 26
	end
	wheel3r = @inUse["rotor3"]
	case wheel3r
		when "I" then wheel3r = 1
		when "II" then wheel3r = 2
		when "III" then wheel3r = 3
		when "IV" then wheel3r = 4
		when "V" then wheel3r = 5
		when "VI" then wheel3r = 6
		when "VII" then wheel3r = 7
		when "VIII" then wheel3r = 8
	end
	wheel3r = $rotor[wheel3r.to_i]
	cyIn = wheel3r.index(input2)
	if cyIn == 26 then
		cyIn = 0
	end
	cyWheel3r = $rotor[0].slice(cyIn)
	cyWheel3r = cyWheel3r - @position3
	if cyWheel3r < 65 then
		cyWheel3r = cyWheel3r + 26
	end
	print cyWheel3r.chr
	print " -> "
	cypher2r(cyWheel3r.chr)
end

def cypher2r(input)
	input2 = input.slice(0) + @position2
	if input2 > 90 then
		input2 = input2 - 26
	end
	wheel2r = @inUse["rotor2"]
	case wheel2r
		when "I" then wheel2r = 1
		when "II" then wheel2r = 2
		when "III" then wheel2r = 3
		when "IV" then wheel2r = 4
		when "V" then wheel2r = 5
		when "VI" then wheel2r = 6
		when "VII" then wheel2r = 7
		when "VIII" then wheel2r = 8
	end
	wheel2r = $rotor[wheel2r.to_i]
	cyIn = wheel2r.index(input2)
	if cyIn == 26 then
		cyIn = 0
	end
	cyWheel2r = $rotor[0].slice(cyIn)
	cyWheel2r = cyWheel2r - @position2
	if cyWheel2r < 65 then
		cyWheel2r = cyWheel2r + 26
	end
 	print cyWheel2r.chr
 	print " -> "
	cypher1r(cyWheel2r.chr)
end

def cypher1r(input)
	input2 = input.slice(0) + @position1
	if input2 > 90 then
		input2 = input2 - 26
	end
	wheel1r = @inUse["rotor1"]
	case wheel1r
		when "I" then wheel1r = 1
		when "II" then wheel1r = 2
		when "III" then wheel1r = 3
		when "IV" then wheel1r = 4
		when "V" then wheel1r = 5
		when "VI" then wheel1r = 6
		when "VII" then wheel1r = 7
		when "VIII" then wheel1r = 8
	end
	wheel1r = $rotor[wheel1r.to_i]
	cyIn = wheel1r.index(input2)
	if cyIn == 26 then
		cyIn = 0
	end
	cyWheel1r = $rotor[0].slice(cyIn)
	cyWheel1r = cyWheel1r - @position1
	if cyWheel1r < 65 then
		cyWheel1r = cyWheel1r + 26
	end
	print cyWheel1r.chr
	print "\n"
	print "\n"
	light(cyWheel1r.chr)
	@CypherLetter = cyWheel1r.chr
	@textWindow.setEncypheredText(@CypherLetter)
end



def light(letter)
	case letter
		when "A" then @ledA.on
		when "B" then @ledB.on
		when "C" then @ledC.on
		when "D" then @ledD.on
		when "E" then @ledE.on
		when "F" then @ledF.on
		when "G" then @ledG.on
		when "H" then @ledH.on
		when "I" then @ledI.on
		when "J" then @ledJ.on
		when "K" then @ledK.on
		when "L" then @ledL.on
		when "M" then @ledM.on
		when "N" then @ledN.on
		when "O" then @ledO.on
		when "P" then @ledP.on
		when "Q" then @ledQ.on
		when "R" then @ledR.on
		when "S" then @ledS.on
		when "T" then @ledT.on
		when "U" then @ledU.on
		when "V" then @ledV.on
		when "W" then @ledW.on
		when "X" then @ledX.on
		when "Y" then @ledY.on
		when "Z" then @ledZ.on
	end
end

def unlight(letter)
	case letter
		when "A" then @ledA.off
		when "B" then @ledB.off
		when "C" then @ledC.off
		when "D" then @ledD.off
		when "E" then @ledE.off
		when "F" then @ledF.off
		when "G" then @ledG.off
		when "H" then @ledH.off
		when "I" then @ledI.off
		when "J" then @ledJ.off
		when "K" then @ledK.off
		when "L" then @ledL.off
		when "M" then @ledM.off
		when "N" then @ledN.off
		when "O" then @ledO.off
		when "P" then @ledP.off
		when "Q" then @ledQ.off
		when "R" then @ledR.off
		when "S" then @ledS.off
		when "T" then @ledT.off
		when "U" then @ledU.off
		when "V" then @ledV.off
		when "W" then @ledW.off
		when "X" then @ledX.off
		when "Y" then @ledY.off
		when "Z" then @ledZ.off
	end
end