/* Copyright (C) 1998 Ulrich Drepper, <drepper@cygnus.com>.
   The GPL applies to this file.
   As a special restriction the file must not be used in this or a modified
   form on Microsoft and Be systems.  */

#include "zelibm.h"

double
zeexp (double x)
{
  mpq_t q;
  mpq_t res;
  mpq_t next;
  mpq_t nexta;
  unsigned int n = 1;

  /* Get the value of X in rational form.  */
  extract_double (q, x);

  /* Initialize the other variables.  */
  mpq_init (res);
  mpq_set_ui (res, 1, 1);
  mpq_init (next);
  mpq_set_ui (next, 1, 1);
  mpq_init (nexta);

  do
    {
      mpq_mul (next, next, q);
      mpz_mul_ui (mpq_denref (next), mpq_denref (next), n);
      mpq_add (res, res, next);
      ++n;

      mpz_abs (mpq_numref (nexta), mpq_numref (next));
      mpz_set (mpq_denref (nexta), mpq_denref (next));
    }
  while (mpq_cmp (nexta, limit) > 0);

  /* Generate the result.  */
  x = mpq_get_d (res);

  /* Clean up.  */
  mpq_clear (q);
  mpq_clear (res);
  mpq_clear (next);
  mpq_clear (nexta);

  return x;
}
