/* HASHING TABLE */

#include <stdlib.h>
#include <stdio.h>

#include "z80-asm.h"
#include "hash.h"
#include "asm.h"

struct table_type table[TABLE_SIZE];


/* hashing function */

unsigned int 
hash(char *slovo)
{
unsigned int a,b;

b=0;
for (a=0;a<strlen(slovo);a++)
 {
 b+=slovo[a];
 b*=MAGICKA_KONSTANTA;
 }
return b&(TABLE_SIZE-1);
}


/* adds item to hash table */

int 
add_to_table(char *txt,int address)
{
int a,c;
a=hash(txt);
c=table[a].count;
table[a].address=realloc(table[a].address,(c+1)*sizeof(int));
if (!table[a].address){fprintf(stderr,"Error: Not enough memory.\n");return 1;}
table[a].pointer=realloc(table[a].pointer,(c+1)*sizeof(char *));
if (!table[a].pointer){fprintf(stderr,"Not enough memory.\n");return 1;}

table[a].pointer[c]=txt;
table[a].address[c]=address;
table[a].count++;
return 0;
}


/* tests if label is in table */
/* returns address of label if true, otherwise -1 */

int 
is_in_table(char *txt)
{
int a,b;

if (pruchod==1)return address;   /* during first pass we don't need any labels */
a=hash(txt);
if (!table[a].count)return -1;
for (b=0;b<table[a].count;b++)
 if (!strcmp(txt,table[a].pointer[b])) return table[a].address[b];
return -1;
}


/* initializes hash table */

void 
hash_table_init(void)
{
int a;

for (a=0;a<TABLE_SIZE;a++)
 {
 table[a].count=0;
 table[a].address=NULL;
 table[a].pointer=NULL;
 }
}


/* removes hash table from memory */

void
free_hash_table(void)
{
int a,b;

for (a=0;a<TABLE_SIZE;a++)
 {
 free(table[a].address);
 for (b=0;b<table[a].count;b++)
  free(table[a].pointer[b]);
 free(table[a].pointer);
 }
}


