/*
 *  TemoraryFilename()  -   Creates a unique filename
 *
 *  RCS:
 *      $Revision: 1.1 $
 *      $Date: 1995/05/07 19:34:10 $
 *
 *  Security:
 *      Unclassified
 *
 *  Description:
 *      Adapted from ImageMagick
 *
 *  Input Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Output Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Return Values:
 *      value   description
 *
 *  Side Effects:
 *      text
 *
 *  Limitations and Comments:
 *      text
 *
 *  Development History:
 *      who                 when        why
 *      muquit@semcor.com   11/15/94    muquit
 */

#include "xhead.h"
#include "xymrolo.h"


#define TemporaryDirectory  "/tmp"
#define TemporaryTemplate   "%s/yroloXXXXXX"

void TemporaryFilename(filename)
char
    *filename;
{
    char
        *directory;
    
    directory = (char *) getenv("TMPDIR");

    if (directory == (char *) NULL)
        directory = TemporaryDirectory;
    
    (void) sprintf (filename, TemporaryTemplate, directory);
    (void) mktemp(filename);

return;
}
