/*
 *  SelectedCB()    - callback routine for selected list
 *
 *  RCS:
 *      $Revision: 1.1 $
 *      $Date: 1995/05/07 19:34:10 $
 *
 *  Security:
 *      Unclassified
 *
 *  Description:
 *      text
 *
 *  Input Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Output Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Return Values:
 *      value   description
 *
 *  Side Effects:
 *      text
 *
 *  Limitations and Comments:
 *      text
 *
 *  Development History:
 *      when    who     why
 *  11/12/94    muquit  first cut
 */

#include "xhead.h"
#include "xymrolo.h"

void SelectedCB (widget, client_data, call_data)
Widget
    widget;
XtPointer
    client_data;
XtPointer
    call_data;
{
    XmListCallbackStruct
        *list = (XmListCallbackStruct *) call_data;
    
    XmTextPosition
        pos;

    int
        n;

    char
        *s;
    
    n = list->item_position - 1;

#ifdef DEBUG
(void) fprintf(stderr,
    "n=%d\n", n);   
#endif

    if (n < 0)
        return;
    
    s = GetCardName(n);
    XmTextFieldSetString(GVnametextW,s);

    s = GetCompanyName(n);
    XmTextFieldSetString(GVcompanyTextW,s);

    /*
    ** address has 2 lines
    */
    s = GetAddress (n);
    XmTextSetString (GVaddressTextW, s);
    pos = XmTextGetLastPosition(GVaddressTextW);
    XmTextInsert (GVaddressTextW, pos,"\n");
    pos = XmTextGetLastPosition(GVaddressTextW);
    s = GetAddress2 (n);
    XmTextInsert(GVaddressTextW, pos, s);

    s = GetNumber1(n);
    XmTextFieldSetString (GVphone1TextW,s);

    s = GetNumber2(n);
    XmTextFieldSetString (GVphone2TextW,s);

    s = GetNumber3(n);
    XmTextFieldSetString (GVfaxTextW, s);

    s = GetEmail(n);
    XmTextFieldSetString(GVemailTextW,s);


    s = GetText(n);
    XmTextSetString (GVcommentTextW,s);


    DisplayedCard = n;

    /*
    ** make the delete button sensitive now
    */

    if (XtIsSensitive(GEditPbW) == False)
        XtSetSensitive (GEditPbW, True);

    if (XtIsSensitive(w_special[DELETE_PB_W]) == False)
        XtSetSensitive (w_special[DELETE_PB_W], True);

    if (XtIsSensitive(w_special[SENDMAIL_PB_W]) == False)
        XtSetSensitive (w_special[SENDMAIL_PB_W], True);

    XmTextSetString(w_special[MESSAGE_TEXT_W], "");
    WriteStatus(0,rolomessageTextW,"");

     if (XtIsManaged(w_special[ROLOVIEWFD_W]))
        EditCardCB ((Widget) NULL, (XtPointer) NULL, (XtPointer) NULL);
}

