/*
 *  MakeNewRolo ()  -   make a new rolodex
 *
 *  RCS:
 *      $Revision: 1.1 $
 *      $Date: 1995/05/07 19:34:10 $
 *
 *  Security:
 *      Unclassified
 *
 *  Description:
 *      Borrowed from mrolo
 *
 *  Input Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Output Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Return Values:
 *      value   description
 *
 *  Side Effects:
 *      text
 *
 *  Limitations and Comments:
 *      text
 *
 *  Development History:
 *      when    who     why
 *  11/12/94    muquit  first cut
 */

#include "xhead.h"
#include "xymrolo.h"

void MakeNewRolo (name, company, address, address2, number1, number2, number3,
    email, text, checkfield)
char
    *name,
    *company,
    *address,
    *address2,
    *number1,
    *number2,
    *number3,
    *email,
    *text;
int
    checkfield;
{
    RoloRec
        *rr,
        *pp;
    
    char
        *s;
    
    rr = (RoloRec *) malloc (sizeof(RoloRec));

    if (rr == (RoloRec *) NULL)
    {
        Warning("Memory Allocation Failed", "MakeNewRolo()");
        return;
    }

    rr->next = (RoloRec *) NULL;

    /*
    ** name
    */

    rr->name = mystrdup(name);
    s = index(rr->name, '\n');
    if (s != (char *) NULL)
        *s = '\0';

    /*
    ** company
    */

    rr->company = mystrdup(company);
    s = index(rr->company, '\n');
    if (s != (char *) NULL)
        *s = '\0';

    /*
    ** address
    */

    rr->address = mystrdup (address);
    s = index (rr->address, '\n');
    if (s != (char *) NULL)
        *s = '\0';

    /*
    ** 2nd line of address
    */

    rr->address2 = mystrdup (address2);
    s = index (rr->address2, '\n');
    if (s != (char *) NULL)
        *s = '\0';

    /*
    ** first phone number
    */

    rr->number = mystrdup(number1);
    s = index (rr->number, '\n');
    if (s != (char *) NULL)
        *s = '\0';
    
    /*
    ** second phone number
    */

    rr->number2 = mystrdup(number2);
    s = index (rr->number2, '\n');
    if (s != (char *) NULL)
        *s = '\0';

    /*
    ** fax number
    */

    rr->number3 = mystrdup (number3);
    s = index (rr->number3, '\n');
    if (s != (char *) NULL)
        *s = '\0';

    /*
    ** email
    */

    rr->email = mystrdup(email);
    s = index (rr->email, '\n');
    if (s != (char *) NULL)
        *s = '\0';


    /*
    ** comment text
    */

    rr->text = mystrdup(text);
    rr->on = 1;

    if (RoloList == (RoloRec *) NULL)
        RoloList = rr;
    else if (mystrcasecmp(RoloList->name,rr->name) > 0)
    {
        rr->next = RoloList;
        RoloList = rr;
    }
    else
    {
        for (pp=RoloList; pp->next != (RoloRec *) NULL; pp=pp->next)
            if (mystrcasecmp(pp->next->name,rr->name) > 0 )
                break;
        rr->next = pp->next;
        pp->next = rr;
    }

#ifdef DEBUG3
    {
        RoloRec
            *xx;
        for(xx=RoloList; xx != (RoloRec *)NULL; xx=xx->next)
        {
            (void) fprintf (stderr, "N: %s\n", xx->name);
            (void) fprintf (stderr, "E: %s\n", xx->email);
            (void) fprintf (stderr, "N1: %s\n", xx->number);
            (void) fprintf (stderr, "N2: %s\n", xx->number2);
            (void) fprintf (stderr, "T: %s\n", xx->text);
        }
    }
#endif
}
