/*
 *  main.c  - main module for Yrolo
 *
 *  RCS:
 *      $Revision: 1.1 $
 *      $Date: 1995/05/07 19:34:10 $
 *
 *  Security:
 *      Unclassified
 *
 *  Description:
 *
 *  Input Parameters:
 *      type    identifier  description
 *
 *      int argc;
 *      char **argv;
 *
 *  Output Parameters:
 *      type    identifier  description
 *
 *      None
 *
 *  Return Values:
 *      value   description
 *      none
 *
 *  Side Effects:
 *      None
 *
 *  Limitations and Comments:
 *      needs Motif and X library to compile
 *
 *  Development History:
 *      when    who     why
 *  10/28/94    muquit  first cut
 */

#include "xhead.h"

#include "defines.h"
#include "errcds.h"
#include "icon.xbm"

#define MAIN
#include "xymrolo.h"


typedef struct
{
    String
        ScrollbarBg;
    Boolean
        UseCardPixmaps;
} YAppResources, *YAppResourcesP;

#define YOffset(x) XtOffset(YAppResourcesP, x)

static XtResource resources[] =
{

    {"ScrollbarBg", "ScrollbarBg", XtRString, sizeof(String),
        YOffset(ScrollbarBg), XtRString, "Red"},
    {"UseCardPixmaps", "UseCardPixmaps", XtRBoolean, sizeof(Boolean),
        YOffset(UseCardPixmaps), XtRImmediate, (XtPointer) False},
};

/*
** define fallback resources
*/

static char *app_defaults[] =
{
#include "appdef.h"
    NULL
};

void main (argc, argv)
int
    argc;
char
    **argv;
{

/*    XtWorkProcId
        work_id;*/

    int
        depth;


    Pixmap
        iconPixmap;

    int
        rc = 0;

    int
        screen;

    XtAppContext
        app;
    
    register int
        i;

    Display
        *display;

    static Widget
        toplevelW;

    char
        *fname = (char *) NULL;
    
    int
        ishelp = 0;

    int
        isver = 0;

    int
        isfile = 0;
        
    char
        *yrmessage;
    int
        length;

    length = (int) strlen ("Yrolo by muquit@semcor.com") +
        (int) strlen(Version) + 15;

    yrmessage = (char *) malloc (length*sizeof(char));

    if (yrmessage == (char *) NULL)
        Error ("Memory Allocation Failed!", (char *) NULL);

    (void) sprintf(yrmessage, "Yrolo - Version %s by muquit@semcor.com",
        Version);
/*
** Initalize Globals ---Starts---
*/

    for (i=0; i < WIDGETEND+1; i++)
        w_special[i] = (Widget) NULL;

    for (i=0; i < 26; i++)
    {
        GArmPixmap[i] = (Pixmap) NULL;
        GBPixmap[i] = (Pixmap) NULL;
    }

    GVnametextW = (Widget) NULL;
    GVcompanyTextW = (Widget) NULL;

    GVemailTextW = (Widget) NULL;
    GVphone1TextW = (Widget) NULL;
    GVphone2TextW = (Widget) NULL;
    GVfaxTextW = (Widget) NULL;
    GVaddressTextW = (Widget) NULL;
    GVcommentTextW = (Widget) NULL;
    GEditPbW = (Widget) NULL;

    GEcompanyTextW = (Widget) NULL;
    GEaddressTextW = (Widget) NULL;
    GEaddressText2W = (Widget) NULL;
    GEfaxTextW = (Widget) NULL;

    rolomessageTextW = (Widget) NULL;
    messageTextW = (Widget) NULL;

    GSformdW = (Widget) NULL;
    GSnameTbW = (Widget) NULL;
    GScompanyTbW = (Widget) NULL;
    GSaddressTbW = (Widget) NULL;
    GSph1TbW = (Widget) NULL;
    GSph2TbW = (Widget) NULL;
    GSfaxTbW = (Widget) NULL;   
    GSemailTbW = (Widget) NULL;
    GSremarksTbW = (Widget) NULL;
    
    GerrorDialogW = (Widget) NULL;
    GwarningDialogW = (Widget) NULL;

    GsaverdW = (Widget) NULL;
    GsaverTextW = (Widget) NULL;
    GaboutW = (Widget) NULL;
    GinfodW = (Widget) NULL;
    GinfoTextW = (Widget) NULL;

    GhelpdW = (Widget) NULL;
    GhelpTextW = (Widget) NULL;
    GfileincD = (Widget) NULL;
    GsearchOutputdW = (Widget) NULL;
    GsearchListW = (Widget) NULL;

    GprintThisCardW= (Widget) NULL;
    GprintDialogW= (Widget) NULL;
    GprintNameTbW= (Widget) NULL;
    GprintCompanyTbW= (Widget) NULL;
    GprintAddressTbW= (Widget) NULL;
    GprintHomePhTbW= (Widget) NULL;
    GprintWorkPhTbW= (Widget) NULL; 
    GprintFaxTbW= (Widget) NULL; 
    GprintEmailTbW= (Widget) NULL;  
    GprintRemarksTbW = (Widget) NULL;
    GprintToPrinterTbW = (Widget) NULL;
    GprintToFileTbW = (Widget) NULL;
    GprintCommandTextW = (Widget) NULL;
    GprintToFileTextW = (Widget) NULL;
    GpsfileTypeTbW = (Widget) NULL;
    GtextfileTypeTbW = (Widget) NULL;

    GcautionCursor = (Cursor) NULL;

    RoloList = (RoloRec *) NULL;
    DisplayedCard = -1;
    rolofile = (char *) NULL;
    signature_added = False;

    GsaveAsing = True;
    GsaveAndExit = False;
    GwroteToTempfile = False;
    GuseFolderPixmaps = False;
    GrolodexModified = False;
    Gthiscard=0;
    *GtempFilename = '\0';
    GnumberOfCards = 0;
    *GversionString = '\0';
    GnoPixmaps = False;
	GmodalDialogActive = False;
    
    GprintDisplayedCard = False;
/*
** Initalize Globals ---Ends---
*/

    /*
    ** parse the command line
    */

    for (i=1; i <argc; i++)
    {
        if (!strncmp(argv[i],"-fg",3))
        {
            i++;
            continue;
        }
    
        if (!strncmp(argv[i],"-bg",3))
        {
            i++;
            continue;
        }
    
        if (!strncmp (argv[i], "-i",2))
        {
            continue;
        }
    
        if (!strncmp (argv[i], "-iconic",7))
        {
            continue;
        }
    
        if (!strncmp (argv[i], "-d", 2))
        {
            i++;
            continue;
        }

        if (!strncmp (argv[i], "-display",8))
        {
            i++;
            continue;
        }

        if (!strncmp (argv[i], "-xrm", 4))
        {
            i++;
            continue;
        }

        if (!strncmp (argv[i], "-synchronous", 12))
        {
            continue;
        }

        if (!strncmp (argv[i], "-h", 2))
        {
            ishelp++;
            continue;
        }

        if (!strncmp (argv[i], "-V", 2))
        {
            isver++;
            continue;
        }

        if (!strncmp (argv[i], "-nopixmaps", (int) strlen("-nopixmaps")))
        {
            GnoPixmaps = True;
            continue;
        }

        if (argv[i][0] != '-' ) /* the file name */
        {
            fname = argv[i];
            isfile = 1;
            continue;
        }

        Usage(argv[0]);
    }

    if (isver)
    {
        (void) fprintf(stderr,
            "\nyrolo $ Release %s $\n\n", Version);
        exit(1);
    }

    if (ishelp)
    {
        Usage (argv[0]);
    }
    /*
    ** create the temporary Global file..we will use this file
    ** for handling unusual circumstances
    */

    TemporaryFilename (GtempFilename);

    /*
    ** create toplevel widget
    */

    toplevelW =  XtVaAppInitialize (&app, "YRolo",
        NULL, 0, &argc, argv, app_defaults, NULL);
    
    XtVaSetValues (toplevelW, 
        XmNallowShellResize, True,
        NULL);
    
    w_special[TOPLEVEL_W] = toplevelW;

    SetResources(toplevelW);

    /*
    ** set the icon
    */
    display = XtDisplay(toplevelW);
    depth = XDefaultDepth (display, XDefaultScreen (display));

    iconPixmap = XCreatePixmapFromBitmapData (XtDisplay(toplevelW),
        DefaultRootWindow (XtDisplay(toplevelW)),
        icon_bits,
        icon_width,
        icon_height,
        BlackPixelOfScreen (XtScreen(toplevelW)),
        WhitePixelOfScreen (XtScreen(toplevelW)),
        depth);

    
    XtVaSetValues (toplevelW,
        XmNiconPixmap, iconPixmap,
        NULL);


    /*
    ** create main window Widget
    */
    (void) CreateMainWindow (toplevelW);

    /*
    ** create dialogs
    */
    CreateDialogs (toplevelW);

/**********************************NOT USED****************************/
    /*
    ** create the file selection dialog
    */
    /*work_id = XtAppAddWorkProc (app, CreateFileOpenDialog, toplevelW);*/

    /*
    ** create the save dialog
    */
    /*work_id = XtAppAddWorkProc (app, CreateSaveRoloD, toplevelW);*/

    /*
    ** create Search option dialog
    */
    /*work_id = XtAppAddWorkProc (app, CreateSearchOptionD, toplevelW);*/


    /*
    ** create the warning dialog ..ask for saving rolodex
    */

    /*work_id = XtAppAddWorkProc (app, CreateAskSaveDialogW, toplevelW);*/


    /*
    ** create the help dialog
    */

    /*work_id = XtAppAddWorkProc (app, CreateHelpDialog, toplevelW);*/


    /*
    ** create the include file selection dialog
    */

    /*work_id = XtAppAddWorkProc (app, CreateIncludeFileOpenD, 
        w_special[MAIL_FORMD_W]);*/


    /*
    ** create the search output list widget
    */

    /*work_id = XtAppAddWorkProc (app, CreateSearchOutputDiaog, toplevelW);*/


    /*
    ** create print dialog
    */

    /*work_id = XtAppAddWorkProc (app, CreatePrintDialog, toplevelW);*/

/**********************************NOT USED****************************/

    /*
    ** realize toplvel
    */
    XtRealizeWidget (toplevelW);

    screen = DefaultScreen (display);
    black_pixel = BlackPixel(display, screen);
    white_pixel = WhitePixel (display, screen);


    XSetErrorHandler (XError);

    /*
    ** create the caution cursor
    */

    GcautionCursor = MakeCautionCursor (display, black_pixel,
        white_pixel);


    if (isfile)
        rc = ReadList(fname);
    else
        rc = PrepareList();

    if (rc != 0)
        ShowErrorDialog (rc, (char *) NULL);
    /*
    ** go to event handling loop
    */
        WriteStatus(0,rolomessageTextW, yrmessage);
        (void) free ((char *) yrmessage);

    XtAppMainLoop (app);

}

void SetResources(widget)
Widget
    widget;
{
    YAppResources
        appResources;
    
    XtGetApplicationResources(widget, (XtPointer) &appResources,
        resources, XtNumber(resources), NULL, 0);
    
    scb_bgcolor = mystrdup(appResources.ScrollbarBg);

#ifdef DEBUG
    (void) fprintf (stderr, "Scrollbar BG: %s\n",
        scb_bgcolor);
#endif

    GuseFolderPixmaps = appResources.UseCardPixmaps;

#ifdef DEBUG
(void) fprintf(stderr,
    "Use FolderPixmaps: %d\n", GuseFolderPixmaps);
#endif

}

