/*
 *  IncludeFileCB() -   include file in the mail dialog
 *
 *  RCS:
 *      $Revision: 1.1 $
 *      $Date: 1995/05/07 19:34:10 $
 *
 *  Security:
 *      Unclassified
 *
 *  Description:
 *      text
 *
 *  Input Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Output Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Return Values:
 *      value   description
 *
 *  Side Effects:
 *      text
 *
 *  Limitations and Comments:
 *      text
 *
 *  Development History:
 *      who                 when        why
 *      muquit@semcor.com   18-Mar-95   first cut
 */


#include "xhead.h"
#include "xymrolo.h"

void IncludeFileCB(widget,client_data, call_data)
Widget
    widget;
XtPointer
    client_data,
    call_data;
{
    int
        rc = 0;

    char
        *file = (char *) NULL;

    XmFileSelectionBoxCallbackStruct
        *cbs = (XmFileSelectionBoxCallbackStruct *) call_data;

    if (!XmStringGetLtoR(cbs->value, XmSTRING_DEFAULT_CHARSET, &file))
    {
        Warning("Unable to get filename", (char *) NULL);
        return;
    }

    if (*file != '/')
    {
        char
            *dir,
            *newfile;

            if (XmStringGetLtoR(cbs->dir, XmSTRING_DEFAULT_CHARSET, &dir))
            {
                newfile = XtMalloc((int) strlen(dir) + 1 +
                    (int) strlen(file) + 1);

                (void) sprintf(newfile, "%s/%s", dir, file);
                XtFree (file);
                file = (char *) NULL;
                XtFree (dir);
                file = newfile;
            }
    }

    rc = IsFileReadable (file);

    switch (rc)
    {
        case -1:
        {
            WriteStatus (1, rolomessageTextW,
                "Could not stat file! Failed to attach!");
            break;
        }

        case -4:
        {
            WriteStatus (1, rolomessageTextW,
                "File is a directory, Unable to attach!");
            break;
        }   

        case -2:
        {
            WriteStatus (1, rolomessageTextW,
                "File is not a regular file!");
            break;
        }

        case -3:
        {
            WriteStatus (1, rolomessageTextW,
                "File is not readable! unable to attach!");
        }

        case 1: /* OK */
        {
            if (XtIsManaged(GfileincD))
            {
                XtUnmanageChild (GfileincD);
                XFlush (XtDisplay(GfileincD));
            }
                /*SetBusyCursorState (w_special[MAINWINDOW_W], True);
                SetBusyCursorState (w_special[MAIL_FORMD_W], True);*/
                SetCautionCursorState (w_special[MAINWINDOW_W],True);
                SetCautionCursorState (w_special[MAIL_FORMD_W],True);

                IncludeFileToWidget (w_special[LETTER_TEXT_W],file, False);

                SetCautionCursorState (w_special[MAINWINDOW_W],False);
                SetCautionCursorState (w_special[MAIL_FORMD_W],False);
                /*SetBusyCursorState (w_special[MAINWINDOW_W], False);
                SetBusyCursorState (w_special[MAIL_FORMD_W], False);*/
            break;
        }
    }

    if (file != (char *) NULL)
        XtFree (file);

}
