/*
 *  HelpCB()    -   callback routine for help
 *
 *  RCS:
 *      $Revision: 1.1 $
 *      $Date: 1995/05/07 19:34:10 $
 *
 *  Security:
 *      Unclassified
 *
 *  Description:
 *      text
 *
 *  Input Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Output Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Return Values:
 *      value   description
 *
 *  Side Effects:
 *      text
 *
 *  Limitations and Comments:
 *      text
 *
 *  Development History:
 *      who                 when        why
 *      muquit@semcor.com   12-Mar-95   first cut
 */


#include "xhead.h"
#include "defines.h"
#include "xymrolo.h"

void HelpCB (widget, client_data, call_data)
Widget
    widget;
XtPointer
    client_data;
XtPointer
    call_data;
{
    char
        *text = (char *) NULL;

    switch ((int) client_data)
    {
        case ABOUT_HELP:
        {
            break;
        }

        case HINTS_HELP:
        {
text ="Hints\n\n\
If the Yrolo program is started without any argument, it will try to open\n\
a file called \".yrolo.yr\" at your home directory. You may start adding\n\
card to the database right away.  This is the default card file\n\
Yrolo will open every time it is invoked without any argument. But you\n\
can change the default database file by setting the environment variable\n\
YROLODEX. As for Example, if your shell is csh or it's variant, at the shell\n\
prompt, type:\n\
    setenv YROLODEX path_of_your_rolo_file\n\n\
If your shell is sh or it's variant, at the shell prompt, type:\n\
    YROLODEX=path_of_your_rolo_file\n\
    export YROLODEX\n\n\
If you add cards to the database, they will be saved automatically to this\n\
file.  However if any unusual condition arises and Yrolo can not save your\n\
cards, it will try to detect it and prompt for a filename when you\n\
select \"Quit\" from the \"File\" menu.\n\n\
Yrolo accepts all standard X toolkit command line options.\n\n\
Please read the man page for details.  The class of Yrolo is \"YRolo\".\n\
Appropriate fallback resources are hardcoded, however if you insist to change\n\
resources, please look the file \"YRolo.ad\" and read the man page.\n\n\
To get Contextual Help, select the \"Context-Sensitive Help\" item from the\n\
Help menu, or press the F1 key.\n\n\
When the pointer turns into a question, click on any visible item on the\n\
window to get help about that item.  If no help is available, the pointer\n\
will change back to normal..nothing will happen.\n\
Enjoy!";

            break;
        }

        case FILE_MENU:
        {
text = "File Menu\n\n\
The File menu has the following Submenu items:\n\
    o Load Cards ...\n\
    o Print the displayed Card ...\n\
    o Print the entire Database ...\n\
    o Save As ...\n\
    o Quit\n\n\
Load Cards ...\n\
  When this item is selected, a File selection dialog box will pop-up.\n\
  Double click on a filenme to load that file. You also can enter file\n\
  at the \"Input File\" widget and press Ok to load a file.\n\
Print the displayed Card ...\n\
  This item can be selected after a card is being viewd by clicking on the\n\
  name item on the main list. After selecting this item a dialog will\n\
  pop-up. The cards can be printed to a printer or to a file. Print command\n\
  can be entered at the text widget. The permanent print command can be set\n\
  by using the environment variable \"PRINT_COMMAND\", e.g.,\n\
    setenv PRINT_COMMAND \"lpr -Ptxt\"\n\
  The print command can be a pipe as well, e,g.,\n\
    setenv PRINT_COMAMND \"a2ps | lpr -Pps\"\n\
  The printing can be restricted to any number of fields by toggling the\n\
  toggling the toggle buttons labeled \"Print Fields\".\n\
Print the entire Database ...\n\
  same as above except, the entire database will be printed.\n\
Save As ...\n\
  When this item is selected, a prompt dialog will request a filename\n\
  for saving the loaded databse. Enter the filename and click on OK\n\n\
Quit ...\n\
  That's how you exit Yrolo :-)"; 
        break;
        }

        case OPTIONS_MENU:
        {
text = "Options Menu\n\n\
The Options menu has one sub-menu item:\n\
   o Search Preferences ...\n\
   o Database Info ...\n\n\
Search Preferences ...\n\
  When this item is selected, a dialog will pop-up with many toggle\n\
  options.  By default, Yrolo searches the whole databse during search\n\
  operation. However, the search can be restricted by toggling the\n\
  options in this dialog. Click on OK button when your done.\n\n\
Database Info ...\n\
  When this item is selected, a dialog will pop-up with inforamtion\n\
  about the loaded Yrolo database. If this dialog is up, the infomation\n\
  will be updated with any changes in the database or with loading a new\n\
  database.";

            break;
        }

        case SEARCH_OPTIONS:
        {
text="Seach Preferences\n\n\
By defalult, Yrolo searches the whole database for a string during\n\
a search operation. However, you can restrict search by turning off the\n\
option at this dialog.\n\n\
Hints: If toggle button is depressed, it means it is ON otherwise it is OFF.\n\
(If you are on a SGI, you will see check mark for ON)";


            break;
        }


        case ADDRESS_LIST_HELP:
        {
text="Name List:\n\n\
When a valid Yrolo file is loaded, the Names are shown at this list\n\
widget.  When clicked on the name, the information associaced with\n\
the name is displayed on the text widgets located at the right side\n\
of the list widget.  The arrow keys can be used to scroll through the\n\
name lists.\n\n\
The Text widgets are not editable. If you want to add or modify a card,\n\
click on the \"Add Card\" or \"Edit Card\" push buttons respectively.\n\
Tab and Shift+Tab key combination can be used to traverse the widgets. To\n\
invoke a callback function using keyboard, press space bar when the\n\
specific widget is highlighted. The arrow keys can be used to traverse\n\
the widgets in a group.";
            break;
        }

        case FOLDER_PIXMAPS_HELP:
        {
text="Cards:\n\n\
When clicked on a labeled card, if the rolodex contains any name starting\n\
with this letter, this card will be brought at the top of the name list.\n\
If there is no card starting with this letter, lexically next available\n\
card will be displayed at the top of the name list.\n\n\
The look of the cards can be changed using X resource or from command line.\n\
By default, the cards will use pixmaps on top of the push buttons. If your\n\
X Server crashes or if you like to have plain push buttons, change the\n\
resouce \"UseCardPixmaps\" to False. Aslo, you can use the command line\n\
option \"-nopixmaps\" for plain push buttons for the cards.";

            break;
        }

        case STATUS_HELP:
        {
text = "Status Area:\n\n\
The status area is used to write certain informational or error messages.";

            break;
        }

        case SEARCH_HELP:
        {
text = "Searching the Database:\n\n\
The loaded databse can be searched by entering a string or a bunch of\n\
strings at the text widget, labeled \"Search Cards\". When you are done\n\
with entering the string, Hit the Return Key.  If there is a match, a\n\
dialog will pop-up with the matched list. Click on a list to view the\n\
card on the main viewing area. The search is case insensitive.\n\n\
By default, the whole database is searched.  However, the search\n\
can be restricted to one or many filelds by selecting the\n\
\"Search Preferences\" sub-menu item from the \"Options\" menu.";

            break;
        }

        case ADD_CARD_HELP:
        {
text = "Adding card to database:\n\n\
New cards can be added by clicking on this button. When this button is\n\
clicked, a window will pop-up. When the mouse is moved on that window,\n\
The very top text widget labeled \"Name:\" will have the focus. Start\n\
editing....You can go to the next item by hitting the Return key or\n\
clicking left mouse button in the text widget. You can fill up all or\n\
any item. When you are done, click on the Accept push button. A prompt\n\
dialog will request for the confirmation.\n\n\
The Accept button also can be activated from the Remarks text widget by\n\
pressing CTRL-D key combinations.\n\n\
If you do not want to add the card, click on the Dismiss button.";

            break;
        }

        case EDIT_CARD_HELP:
        {
text = "Editing Card:\n\n\
The \"Edit Card\" push button becomes sensitive when a rolodex card is\n\
is viewed by clicking on a name at the name list widget. When this button is\n\
clicked, a window will pop-up. When the mouse is moved on that window,\n\
The very top text widget labeled \"Name:\" will have the focus. Start\n\
editing....You can go to the next item by hitting the Return key or\n\
clicking left mouse button in the text widget. You can fill up all or\n\
any items. When you are done, click on the Accept push button. A prompt\n\
dialog will request for the confirmation\n\n\
The Accept button also can be activated from the Remarks text widget by\n\
pressing CTRL-D key combinations.\n\n\
If you changed your mind, click on the Dismiss button.";
            break;
        }

        case DELETE_CARD_HELP:
        {
text = "Deleting a Card:\n\n\
The \"Delete Card\" push button becomes sensitive when a rolodex card is\n\
being viewed by clicking on a name at the name list widget. When this\n\
button is clicked, a prompt dialog will ask for the confirmation.\n\n\
***********************************************************************\n\
WARNING: There is NO UNDELETE option at this time. DELETION IS PERMANENT.\n\
***********************************************************************";
            break;
        }

        case SEND_MAIL_HELP:
        {
text = "Sending Mail:\n\n\
The \"Send Mail\" push button becomes sensitive when a rolodex card is\n\
viewed by clicking on a name at the name list widget. When this button is\n\
clicked, a dialog will pop-up. The \"To\" field gets the focus by default.\n\n\
If the card has a email-address, the email-address will appear at the text\n\
widget labeled \"To\".  The addressed can be edited or many comma seperated\n\
addresses can be added. Hit Return key to go to the next item.\n\n\
The body of the mail is typed at the top scrolled window. If you have a\n\
.signature file at our home directory, the signature can be added by clicking\n\
on the \"Sign\" push button.\n\n\
A text or binary file can be included by clicking on the \"Include File\"\n\
push button. When the \"Include File\" button is pushed, a file selection\n\
dialog box will request for the filename.\n\n\
If the file is binary, it will be detected and automatically\n\
\"uuencoded\" before attaching.\n\n\
To send mail, press CTRL-D key combination while you are the the message\n\
editing window, or click on the \"Send Mail\" push button.  A information\n\
message will be displayed at the bottom scrolled window after the mail is\n\
sent.";

            break;
        }

        case VIEW_SCREEN_NAME_HELP:
        {
text = "Name:\n\n\
This is the Non-Editable area for displaying the Name or Any other\n\
category you chose to write in the Yrolo databse. The item is also\n\
displayed int the list widget at the left of the main window.\n\
This widget will be filled with the name item when you click\n\
on the name on the name list."; 

            break;
        }

        case VIEW_COMPANY_HELP:
        {
text = "Company:\n\n\
This is the Non-Editable area for displaying the Company field, if the\n\
database has any company field in it, otherwise, this area would be empty.\n\
This widget will be filled with the company name when clicked on the name\n\
on the name list.";
            break;
        }

        case VIEW_SCREEN_PH1_HELP:
        {
text = "Home Phone:\n\n\
This is the Non-Editable to area for displaying home phone number, if\n\
the database has any home phone number in it, otherwise, this widget\n\
would be empty. This widget will be filled with the home phone number\n\
when you click on the name on the name list.";
            break;
        }
        
        case VIEW_SCREEN_PH2_HELP:
        {
text = "Work Phone:\n\n\
This is the Non-Editable to area for displaying work phone number, if\n\
the database has any work phone number in it, otherwise, this widget\n\
would be empty. This widget will be filled with the work phone number\n\
when you click on the name on the name list.";
            break;
        }

        case VIEW_SCREEN_FAX_HELP:
        {
text = "Fax Number:\n\n\
This is the Non-Editable to area for displaying Fax number, if\n\
the database has any Fax number in it, otherwise, this widget\n\
would be empty. This widget will be filled with the Fax number\n\
when you click on the name on the name list.";
            break;
        }

        case VIEW_SCREEN_EMAIL_HELP:
        {
text = "Email Address:\n\n\
This is the Non-Editable area for displaying email address, if\n\
the database has any email address in it, otherwise, this widget\n\
would be empty. This widget will be filled with the email address\n\
when you click on the name on the name list.";
            break;
        }

        case VIEW_SCREEN_ADDRESS_HELP:
        {
text = "Address:\n\n\
This is the Non-Editable area for displaying persion's address, if\n\
the database has any address field in it, otherwise, this widget\n\
would be empty. This widget will be filled with the persion's address\n\
when you click on the name on the name list.";
            break;
        }

        case VIEW_SCREEN_REMARKS_HELP:
        {
text = "Remarks:\n\n\
This is the Non-Editable area for displaying remarks etc. if\n\
the database has any remakrs text in it, otherwise, this widget\n\
would be empty. This widget will be filled with the remarks text\n\
when you click on the name on the name list.";
            break;
        }

        case PRINT_CARDS:
        {
text = "Printing Cards:\n\n\
If you want to print the card/s to a printer, click on the \"Printer\"\n\
toggle button, otherwise, click on the \"File\" toggle button.\n\
Currently Yrolo supports only text mode. PostScript support will be added at\n\
the next release. The defalut print command is \"lpr\". However you can\n\
set it to your favorite print command by setting the environment variable\n\
PRINT_COMMAND. As for example, if your shell is csh, you can type:\n\n\
   setenv PRINT_COMMAND \"lpr -Ptxt\"\n\n\
The print command can be a pipe as well. As for example I use the ASCII to\n\
PostScript converter \"pform\" for printing cards to a PostScript printer.\n\n\
    setenv PRINT_COMMAND \"pform -q -s 8 -f Times-Roman -l6 -Pps\"\n\n\
or\n\n\
    setenv PRINT_COMAMND \"a2ps | lpr -Pps\"\n\n\
By default, the fields Name, Company and Address are selected for printing.\n\
You can select any combination of fields by toggling the toggle buttons\n\
labeled \"Print Fields\". When satisfiled, cick on the \"Print\" push\n\
button for printing or click on the \"Cancel\" button if changed your\n\
mind.\n\n\
If the menu item \"Print the displayed Card ...\" is selected from the\n\
\"File\" menu, the title of the print dialog will be \"Print Displayed\n\
Card\" otherwise the title will be \"Print All Cards\".\n\n\
Hints: If toggle button is depressed, it means it is ON otherwise it is OFF\n\
(If you are on a SGI, you will see check mark for ON).";
        break;
        }

        case FILE_OPEND_HELP:
        {
text="File Open:\n\n\
The file selection dialog allows traversal up and down through the\n\
directory structure using the mouse. Double clicking on ``..'' will move\n\
you up one directory. Double clicking on a filename will load that file.\n\
A file also can be loaded by entering it's path at the \"Input File\"\n\
text widget and pressing on the Ok button.\n\n\
Adding something like ``*.yr'' in the \"Filter\" widget will cause\n\
the dialog to display only the files with extension ``.yr''.  Adding\n\
``*.*'' will cause the dialog to display all the files in the directory.\n\n\
The dialog can be traversed using the Tab and Shift+Tab key combination.\n\
Press the Space bar to activate a selection. Arrow keys can be used to\n\
traverse a group of widgets, e.g. while your are on the Ok button, pressing\n\
right arrow key wil take you on the Filter button.";
            break;
        }

        default:
        {
            text = "Unknown Help request!!!";
            break;
        }

    }   /* switch */

    
    if (!XtIsManaged (GhelpdW))
        XtManageChild (GhelpdW);

    XtVaSetValues (GhelpTextW,
        XmNvalue, text,
        NULL);
	/*
	** make the help dialog accessible if a modal dialog is up
	*/
	if (GmodalDialogActive == True)
		XtAddGrab (GhelpdW, False, False);
}
