/*
 *  FileSize () - returns filesize in bytes
 *
 *  RCS:
 *      $Revision: 1.1 $
 *      $Date: 1995/05/07 19:34:10 $
 *
 *  Security:
 *      Unclassified
 *
 *  Description:
 *      text
 *
 *  Input Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Output Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Return Values:
 *      value   description
 *      -1 on failure
 *      filesize on success
 *
 *  Side Effects:
 *      text
 *
 *  Limitations and Comments:
 *      text
 *
 *  Development History:
 *      when    who     why
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>

long int FileSize(filename)
char
    *filename;
{
    struct stat
        statbuf;

    long int
        filesize;

    
    if(stat(filename, &statbuf))
    {
        return(-1); /* we can't stat */
    }
    else
    {
        filesize = statbuf.st_size;
    }

return (filesize);
}
