/*
 *  CreateSaveRoloD()   -   creates rolodex Save dialog
 *
 *  RCS:
 *      $Revision: 1.1 $
 *      $Date: 1995/05/07 19:34:10 $
 *
 *  Security:
 *      Unclassified
 *
 *  Description:
 *      text
 *
 *  Input Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Output Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Return Values:
 *      value   description
 *
 *  Side Effects:
 *      text
 *
 *  Limitations and Comments:
 *      text
 *
 *  Development History:
 *      who                 when        why
 *      muquit@semcor.com   29-Jan-95   first cut
 */


#include "xhead.h"
#include "xymrolo.h"

Boolean CreateSaveRoloD (parent)
Widget
    parent;
{
    int
        n;
    Arg
        args[10];

    XmString
        xmstr;

    Widget rcW;

    xmstr = XmStringCreateSimple ("Save Database");

    n = 0;
    XtSetArg (args[n], XmNdialogTitle, xmstr);  n++;
    XtSetArg (args[n], XmNtraversalOn, True);   n++;
    XtSetArg (args[n], XmNdialogStyle,
        XmDIALOG_PRIMARY_APPLICATION_MODAL);            n++;
    XtSetArg (args[n], XmNautoUnmanage, False); n++;
        
    GsaverdW = XmCreatePromptDialog (parent,
        "Saver", args, n);
    XmStringFree (xmstr);

    /*   
    ** unmanage things we won't need
    */   

    XtUnmanageChild(XmSelectionBoxGetChild (GsaverdW,
        XmDIALOG_TEXT));

    XtUnmanageChild(XmSelectionBoxGetChild (GsaverdW,
        XmDIALOG_SELECTION_LABEL));
/*
    XtUnmanageChild (XmSelectionBoxGetChild (GsaverdW,
        XmDIALOG_CANCEL_BUTTON));
*/
    XtUnmanageChild (XmSelectionBoxGetChild (GsaverdW,
        XmDIALOG_HELP_BUTTON));

    XtAddCallback (GsaverdW, XmNokCallback, 
        (XtCallbackProc) RoloSaveOkCB, NULL);
    
    XtAddCallback (GsaverdW, XmNcancelCallback, 
        (XtCallbackProc) UnmanageCB, (XtPointer) GsaverdW);
    /*
    ** create a rc
    */

    rcW = XtVaCreateWidget ("Src",
        xmRowColumnWidgetClass, GsaverdW,
        NULL);

    /*
    ** create the label
    */

    XtVaCreateManagedWidget ("Enter Saved Filename:",
        xmLabelGadgetClass, rcW,
        NULL);

    /*
    ** create the Text widget
    */

    GsaverTextW = XtVaCreateManagedWidget ("GsaverText",
        xmTextWidgetClass, rcW,
        NULL);

    XtAddCallback (GsaverTextW, XmNmodifyVerifyCallback,
        ModifyVerifyCB, NULL);

    XtManageChild (rcW);
    
    return (True);
}
