/*
 *  CreatePrintDialog() -   Creates the print dialog
 *
 *  RCS:
 *      $Revision: 1.1 $
 *      $Date: 1995/05/07 19:34:10 $
 *
 *  Security:
 *      Unclassified
 *
 *  Description:
 *      text
 *
 *  Input Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Output Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Return Values:
 *      value   description
 *
 *  Side Effects:
 *      text
 *
 *  Limitations and Comments:
 *      text
 *
 *  Development History:
 *      who                 when        why
 *      muquit@semcor.com   25-Mar-95   first cut
 */


#include "xhead.h"
#include "defines.h"
#include "xymrolo.h"

static void CancelCB _D ((Widget, XtPointer, XtPointer));

Boolean CreatePrintDialog (parent)
Widget
    parent;
{
    int
        n;

    Arg
        args[10];

    XmString
        xmstr;

    Widget
        printoLabW,
        printoRadioW,
        filetypeLabW,
        filetypeRadioW,
        printClabW,
        fileNlabW,
        separatorW,
        fieldsLabW,
        fieldsRadioW,
        formW;
        
    char
        *print_command;

    xmstr = XmStringCreateSimple ("Print Yrolo");

    n = 0;
    XtSetArg (args[n], XmNdialogTitle, xmstr);  n++;
    XtSetArg (args[n], XmNdialogStyle,
        XmDIALOG_PRIMARY_APPLICATION_MODAL);            n++;
    XtSetArg (args[n], XmNautoUnmanage, False);         n++;

    GprintDialogW = XmCreatePromptDialog (parent,
        "Printd", args, n);

    XmStringFree (xmstr);

	/*
	** register the dialog as modal
	*/
	RegisterAsModal (GprintDialogW);

    xmstr = XmStringCreateSimple ("Print");

    XtVaSetValues (GprintDialogW,
        XmNokLabelString, xmstr,
        NULL);

    XmStringFree (xmstr);

    XtUnmanageChild(XmSelectionBoxGetChild (GprintDialogW,
        XmDIALOG_TEXT));

    XtUnmanageChild(XmSelectionBoxGetChild (GprintDialogW,
        XmDIALOG_SELECTION_LABEL));


    XtAddCallback (GprintDialogW, XmNokCallback, 
        (XtCallbackProc) PrintFileCB, (XtPointer) NULL);
    XtAddCallback (GprintDialogW, XmNcancelCallback,
        (XtCallbackProc) CancelCB, (XtPointer) NULL);
    XtAddCallback (GprintDialogW, XmNhelpCallback,
        HelpCB, (XtPointer) PRINT_CARDS);

    /*
    ** create a form
    */

    formW = XtVaCreateWidget ("Prform",
        xmFormWidgetClass, GprintDialogW,
        NULL);

     
    /*
    ** Print To label
    */

    printoLabW = XtVaCreateManagedWidget ("Printo",
        xmLabelGadgetClass, formW,
        XmNtopAttachment, XmATTACH_FORM,
        XmNleftAttachment,      XmATTACH_FORM,
        XmNtopOffset, 5,
        NULL);

    /*
    ** create the radio box to hold the toggle buttons
    */

    n = 0;
    XtSetArg (args[n], XmNpacking, XmPACK_COLUMN);      n++;
    XtSetArg (args[n], XmNnumColumns, 2);               n++;
    XtSetArg (args[n], XmNradioAlwaysOne, True);        n++;
    XtSetArg (args[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
    XtSetArg (args[n], XmNleftWidget, printoLabW);      n++;

    printoRadioW = XmCreateRadioBox (formW, "Printradio",
        args, n);

    /*
    ** create the Printer Togge button
    */

    GprintToPrinterTbW = XtVaCreateManagedWidget ("Printer",
        xmToggleButtonGadgetClass, printoRadioW,
        XmNset, True,
        NULL);

    XtAddCallback (GprintToPrinterTbW, XmNvalueChangedCallback,
        (XtCallbackProc) PrintToggleCB, (XtPointer) NULL);

    /*
    ** create the File Toggle button
    */

    GprintToFileTbW = XtVaCreateManagedWidget ("File",
        xmToggleButtonGadgetClass, printoRadioW,
        NULL);

    XtAddCallback (GprintToFileTbW, XmNvalueChangedCallback,
        (XtCallbackProc) PrintToggleCB, (XtPointer) NULL);

    /*
    ** create the filetype label
    */

    filetypeLabW = XtVaCreateManagedWidget ("Filetype",
        xmLabelGadgetClass, formW,
        XmNtopAttachment, XmATTACH_WIDGET,
        XmNtopWidget, printoRadioW,
        XmNtopOffset, 5,
        XmNleftAttachment, XmATTACH_FORM,
        NULL);

    /*
    ** create the filetype radio box
    */

    n = 0;
    XtSetArg (args[n], XmNpacking, XmPACK_COLUMN);      n++;
    XtSetArg (args[n], XmNnumColumns, 2);               n++;
    XtSetArg (args[n], XmNradioAlwaysOne, True);        n++;
    XtSetArg (args[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
    XtSetArg (args[n], XmNleftWidget, filetypeLabW);        n++;
    XtSetArg (args[n], XmNtopAttachment, XmATTACH_WIDGET);  n++;
    XtSetArg (args[n], XmNtopWidget, printoRadioW);         n++;

    filetypeRadioW = XmCreateRadioBox (formW, "Filetyperadio",
        args, n);

    /*
    ** create the PostScriptToggle..not functional at this time
    */

    GpsfileTypeTbW = XtVaCreateManagedWidget ("Psfile",
        xmToggleButtonGadgetClass, filetypeRadioW,
        XmNset, False,
        XmNsensitive, False,
        NULL);

    /*
    ** create the Text toggle 
    */

    GtextfileTypeTbW = XtVaCreateManagedWidget ("Textfile",
        xmToggleButtonGadgetClass, filetypeRadioW,
        XmNset, True,
        NULL);


    /*
    ** create Print Command label
    */

    printClabW = XtVaCreateManagedWidget ("PrintCommand",
        xmLabelGadgetClass, formW,
        XmNtopAttachment, XmATTACH_WIDGET,
        XmNtopWidget, filetypeRadioW,
        XmNtopOffset, 5,
        XmNleftAttachment, XmATTACH_FORM,
        NULL);

    /*
    ** create the print coammand text w
    */

    GprintCommandTextW = XtVaCreateManagedWidget ("Nametext",
        xmTextFieldWidgetClass, formW,
        XmNleftAttachment, XmATTACH_WIDGET,
        XmNleftWidget, printClabW,
        XmNtopAttachment, XmATTACH_WIDGET,
        XmNtopWidget, filetypeRadioW,
        XmNtopOffset, 5,
        XmNrightAttachment, XmATTACH_FORM,
        NULL);

    XtAddCallback (GprintCommandTextW, 
        XmNactivateCallback, ReturnHit, NULL);

    /*
    ** set the default print command on the widget
    */

    print_command = (char *) getenv ("PRINT_COMMAND");

    if (print_command == (char *) NULL)
        print_command = PrintCommand;

    XmTextFieldSetString (GprintCommandTextW, print_command);

    /*
    ** create the filename label
    */

    fileNlabW = XtVaCreateManagedWidget ("Filename",
        xmLabelGadgetClass, formW,
        XmNtopAttachment, XmATTACH_WIDGET,
        XmNtopWidget, GprintCommandTextW,
        XmNtopOffset, 5,
        XmNleftAttachment, XmATTACH_FORM,
        NULL);

    /*
    ** create the filename Text Widget
    */

    GprintToFileTextW = XtVaCreateManagedWidget ("Nametext",
        xmTextFieldWidgetClass, formW,
        XmNleftAttachment, XmATTACH_WIDGET,
        XmNleftWidget, fileNlabW,
        XmNtopAttachment, XmATTACH_WIDGET,
        XmNtopOffset, 5,
        XmNtopWidget, GprintCommandTextW,
        XmNrightAttachment, XmATTACH_FORM,
        NULL);
    XtAddCallback (GprintToFileTextW,
        XmNactivateCallback, ReturnHit, NULL);

    /*
    ** create a separator
    */
    separatorW = XtVaCreateManagedWidget ("Pseparator",
        xmSeparatorGadgetClass, formW,
        XmNleftAttachment, XmATTACH_FORM,
        XmNrightAttachment, XmATTACH_FORM,
        XmNtopAttachment, XmATTACH_WIDGET,
        XmNtopWidget, GprintToFileTextW,
        XmNtopOffset,  7,
        NULL);


    /*
    ** create the label Print Fields
    */

    fieldsLabW = XtVaCreateManagedWidget ("Printfields",
        xmLabelGadgetClass, formW,
        XmNtopAttachment, XmATTACH_WIDGET,
        XmNtopWidget, separatorW,
        XmNleftAttachment, XmATTACH_FORM,
        NULL);

    /*
    ** create the radio box
    */


    n = 0;
    XtSetArg(args[n], XmNpacking, XmPACK_COLUMN);           n++;
    XtSetArg(args[n], XmNradioBehavior, False);             n++;
    XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET);   n++;
    XtSetArg(args[n], XmNtopWidget, fieldsLabW);            n++;
    XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM);    n++;

    fieldsRadioW = XmCreateRadioBox (formW, "Fieldradio",
        args, n);

    /*
    ** create the toggle buttons
    */

    /*
    ** Name
    */

    GprintNameTbW = XtVaCreateManagedWidget ("PrintName",
        xmToggleButtonGadgetClass, fieldsRadioW,
        XmNset, (XtArgVal) True,
        NULL);

    /*
    ** Company
    */
    GprintCompanyTbW = XtVaCreateManagedWidget ("PrintCompany",
        xmToggleButtonGadgetClass, fieldsRadioW,
        XmNset, (XtArgVal) True,
        NULL);

    /*
    ** Address
    */
     GprintAddressTbW = XtVaCreateManagedWidget ("PrintAddress",
        xmToggleButtonGadgetClass, fieldsRadioW,
        XmNset, (XtArgVal) True,
        NULL);

    /*
    ** Home Phone
    */

    GprintHomePhTbW = XtVaCreateManagedWidget ("PrintHomePhone",
        xmToggleButtonGadgetClass, fieldsRadioW,
        XmNset, (XtArgVal) False,
        NULL);

    /*
    ** Work Phone
    */

    GprintWorkPhTbW = XtVaCreateManagedWidget ("PrintWorkPhone",
        xmToggleButtonGadgetClass, fieldsRadioW,
        XmNset, (XtArgVal) False,
        NULL);
    /*
    ** fax
    */

    GprintFaxTbW = XtVaCreateManagedWidget ("PrintFax",
        xmToggleButtonGadgetClass, fieldsRadioW,
        XmNset, (XtArgVal) False,
        NULL);

    /*
    ** email
    */

    GprintEmailTbW = XtVaCreateManagedWidget ("PrintEmail",
        xmToggleButtonGadgetClass, fieldsRadioW,
        XmNset, (XtArgVal) False,
        NULL);

    /*
    ** remarks
    */

    GprintRemarksTbW = XtVaCreateManagedWidget ("PrintRemarks",
        xmToggleButtonGadgetClass, fieldsRadioW,
        XmNset, (XtArgVal) False,
        NULL);

    XtManageChild (fieldsRadioW);
    XtManageChild (filetypeRadioW);
    XtManageChild (printoRadioW);
    XtManageChild (formW);

    return (True);
}

static void CancelCB (widget, client_data, call_data)
Widget
    widget;
XtPointer
    client_data,
    call_data;
{
    XtUnmanageChild (widget);
    SetBusyCursorState (w_special[MAINWINDOW_W], False);
}
