/*
 *  mr2yr -  converts mrolo13 database to yrolo database
 *
 *  RCS:
 *      $Revision: 1.1 $
 *      $Date: 1995/04/18 01:38:04 $
 *
 *  Security:
 *      Unclassified
 *
 *  Description:
 *      this program converts mrolo13 database to yrolo format
 *
 *  Compile
 *  
 *      gcc -O mr2yr.c -o mr2yr
 *      or
 *      cc -O mr2yr.c -o mr2yr
 *
 *  Usage
 *  
 *      mr2yr mrolo_file yrolo_file
 *
 *      mrolo_file is the name of the mrolo database file
 *      yrolo_file is the name of the yrolo database.
 *
 *  Comment
 *      Careful about the 2nd argument!
 *      It will overwrite the specifiled file. e.g., if you type:
 *           mr2yr file1 file2
 *       If file2 exists and writable if will overwrite it. If file2
 *       does not exist, it will be created.
 *
 *  Development History:
 *      who                 when        why
 *      muquit@semcor.com   17-Apr-95   first cut
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#define ROLODEX_MAGICK "-YROLODEX-"
#define VersionString "Version1.1"
#define MaxStrSize 100000

#if __STDC__ || defined(sgi) || defined(_AIX)
#define _D(formal_parameters) formal_parameters
#else
#define const
#define _D(forma_parameters) ()
#endif  /* __STDC__ */

void
    Usage _D ((char *));

void main(argc, argv)
int
    argc;
char
    **argv;
{
    FILE
        *mrfp,
        *yrfp;

    int
        rc = 0;

    char
        *name,
        *number1,
        *number2,
        *comment;

    char
        *s;

    int
        c;

    mrfp = (FILE *) NULL;
    yrfp = (FILE *) NULL;

    if (argc != 3)
        Usage (argv[0]);

   /*
   ** open the mrolo file
   */

   mrfp = fopen(argv[1], "r");

   if (mrfp == (FILE *) NULL)
   {
        (void) fprintf (stderr,"Unable to open mrolo file \"%s\" for reading\n",
            argv[1]);
         exit(1);
   }

   /*
   ** open yrolo file
   */

/*    rc = access (argv[2], F_OK);

    if (rc == 0)
    {
        (void) fprintf (stderr,
            "\nFile %s Exists! Will not overwrite exiting file!!\n\n", argv[2]);
         exit(2);
    }
*/

    yrfp = fopen (argv[2], "w");

    if (yrfp == (FILE *) NULL)
    {
        (void) fprintf (stderr,"Unable to open file \"%s\" for writing\n",
            argv[2]);
         exit(1);
    }

    (void) fprintf (yrfp, ROLODEX_MAGICK);
    (void) fprintf (yrfp, "\n");
    (void) fprintf (yrfp, VersionString);
    (void) fprintf (yrfp, "\n");
    
    /*
    ** allocate space for mrolo fields
    */
    name = (char *) malloc(sizeof(char)*200);
    number1 = (char *) malloc(sizeof(char)*100);
    number2 = (char *) malloc(sizeof(char)*100);
    comment = (char *) malloc(sizeof(char)*MaxStrSize);
      
    if ((name == (char *) NULL) ||
        (number1 == (char *) NULL) ||
        (number2 == (char *) NULL) ||
        (comment == (char *) NULL))
    {
        (void) fprintf (stderr,
            "Memory Allocation Failed!\n");
        exit(3);
    }

    while (!feof(mrfp))
    {
        (void) fgets (name, 200, mrfp);

        if (feof(mrfp))
            break;

        s = strchr(name, '\014');    

        if (s == (char *) NULL)
        {
            (void) fgets (number1, 100, mrfp);
            s = strchr (number1, '\014');

            if (s == (char *) NULL)
            {
                (void) fgets (number2, 100, mrfp);
                s = strchr (number2, '\014');
            }
        }

        if (s != (char *) NULL)
        {
            ungetc(12, mrfp);
            *s = '\0';
        }

        s = comment;

        while (1)
        {
            c = fgetc (mrfp);

            if (c < 1 || c == 12)
            {
                *s = '\0';
                break;
            }

            *s = (char ) c;
            s++;
        }

        while (c != 12 && !feof(mrfp))
            c = fgetc (mrfp);

        (void) fputs (name, yrfp);
        (void) fputs ("\n", yrfp); /* no company field */
        (void) fputs ("\n", yrfp); /* no address field */
        (void) fputs ("\n", yrfp); /* no address field */
        (void) fputs (number1, yrfp);
        (void) fputs (number2, yrfp);
        (void) fputs ("\n", yrfp); /* no fax field */
        (void) fputs ("\n", yrfp); /* no email field */
        (void) fputs (comment, yrfp);
        (void) fputc ('\014', yrfp);
        (void) fputs ("\n\n", yrfp);

        for (c=fgetc(mrfp); c == '\n'; c = fgetc(mrfp));

        if (c != -1)
            ungetc ((char) c, mrfp);
    } /* while (!feof(mrfp)) */

    (void) free ((char *) name);
    (void) free ((char *) number1);
    (void) free ((char *) number2);
    (void) free ((char *) comment);
}

void Usage (progname)
char
    *progname;
{
    (void) fprintf (stderr,
        "\nmr2yr 1.1 - Converts database from mrolo13 to yrolo format\n");
    (void) fprintf (stderr,"by muquit@semcor.com, 1995\n");
    (void) fprintf (stderr,"\n");
    (void) fprintf (stderr,"Usage: %s mrolo_file yrolofile\n", progname);
    (void) fprintf (stderr,"\n");
    exit(1);
}
