/*
 *  AllocateColor() - Allocates color and returns Pixel Value
 *
 *  RCS:
 *      $Revision: 1.1 $
 *      $Date: 1995/05/07 19:34:10 $
 *
 *  Security:
 *      Unclassified
 *
 *  Description:
 *      This function allocates color and returns the pixel index of the
 *      colormap.  If the requested color is not available, it will try
 *      to determine the closest possible color.
 *
 *  Input Parameters:
 *      type    identifier  description
 *
 *      Display     *display
 *      Colormap    colormap
 *      int         R, G, B
 *
 *  Output Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Return Values:
 *      value   description
 *      
 *      returns the pixel value
 *
 *  Side Effects:
 *      text
 *
 *  Limitations and Comments:
 *      text
 *
 *  Development History:
 *      when    who     why
 *  11/2/93     mm      first_cut
 *  06/1/94     mm      returns the best pixel if colormap is full
 */

#include "xhead.h"
#include "defines.h"
#include "xymrolo.h"

unsigned int AllocateColor (display, colormap,R, G, B)
Display
    *display;

Colormap
    colormap;

int
    R,
    G,
    B;

{
    XColor
        color;
    int
        status;
    int
        screen;

    screen = DefaultScreen(display);

    /*
    ** detemine the intensities from the R, G, abd B values
    */

    color.red = R<<8;
    color.green = G<<8;
    color.blue = B<<8;
    color.flags = DoRed | DoGreen | DoBlue;
    
    status = XAllocColor (display, colormap, &color);

    if (status == 0)
    {
        /*
        ** Colormap is FULL, Now find the closest possible color
        */
        
        (void) BestPixel (display, colormap, (XColor *) NULL,
                    (unsigned int) Min(DisplayCells(display,screen),256), 
                    &color);
    }
    
    return (color.pixel);
}
