/*
 *  AddSignature()  -   appends .signature at the end of mail
 *
 *  RCS:
 *      $Revision: 1.1 $
 *      $Date: 1995/05/07 19:34:10 $
 *
 *  Security:
 *      Unclassified
 *
 *  Description:
 *      text
 *
 *  Input Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Output Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Return Values:
 *      value   description
 *
 *  Side Effects:
 *      text
 *
 *  Limitations and Comments:
 *      text
 *
 *  Development History:
 *      who                 when        why
 *      muquit@semcor.com   28-Nov-94   first cut
 */

#include "xhead.h"
#include "defines.h"
#include "xymrolo.h"

void AddSignature()
{
    static XmTextPosition
        pos;

    struct stat
        statbuf;

    char
        *sigtext = (char *) NULL;

    char
        *home;

    char
        *sigfile = (char *)NULL;

    int
        length;

    FILE
        *fp = (FILE *) NULL;

    home = getenv("HOME");

    if (home != (char *) NULL)
    {
        length = (int) strlen(home)+strlen(".signature")+100;

        sigfile = (char *) malloc(length*sizeof(char));

        if (sigfile == (char *) NULL)
        {
            Warning("Memory Allocation Failed", "AddSignature()");
            goto ExitProcessing;
        }

        *sigfile = (char) NULL;
        (void) strcat(sigfile,home);
        (void) strcat(sigfile, "/");
        (void) strcat(sigfile, ".signature");
#ifdef DEBUG
        (void) fprintf(stderr,
            "Signature File: %s\n", sigfile);
#endif

        fp = fopen(sigfile, "r");
        if (fp != (FILE *) NULL)
        {
            (void) stat(sigfile, &statbuf);
            if (statbuf.st_size == 0)
            {
                WriteStatusMessage(1, messageTextW,
                    "Empty .signature file!!\n");   
                goto ExitProcessing;
            }
            sigtext = XtMalloc((unsigned) statbuf.st_size+1);
            if (!sigtext)
            {   
                Warning("Memory allocation Failed", "sigtext:XtMalloc");
                goto ExitProcessing;
            }
            
            if (!fread(sigtext,sizeof(char), statbuf.st_size+1, fp))
                Warning("Could not read the whole signature!",(char *)NULL);

            sigtext[statbuf.st_size] = '\0';

            pos = XmTextGetLastPosition(w_special[LETTER_TEXT_W]);
            XmTextInsert (w_special[LETTER_TEXT_W], pos, "\n\n--\n");
            pos = XmTextGetLastPosition(w_special[LETTER_TEXT_W]);
            XmTextInsert (w_special[LETTER_TEXT_W], pos, sigtext);
            XmTextShowPosition (w_special[LETTER_TEXT_W], pos);
            signature_added = True;
        }
        else
        {
            WriteStatusMessage(1,
                messageTextW,
                "Please put your signature in the file \".signature\"\n");

            WriteStatusMessage(0, messageTextW,
                " at your home directory first!\n");
        }
    }

ExitProcessing:

    if (sigfile != (char *) NULL)
        (void) free ((char *) sigfile);

    if (fp != (FILE *) NULL)
        (void) fclose ((FILE *) fp);

    if (sigtext)
        XtFree(sigtext);

    return;
}
