/* test performance of dict and fuzzdict classes
 */

#include <stdio.h>
#include <strings.h>

#include "dict.h"
#include "fuzzdict.h"

main (argc, argv)
int	argc;
char	**argv;
{
	FILE*	file;
	char	buf[512];
	char*	vec[12];
	int	i,n;
	dict_value_t (*add)(), (*find)();
	Dict	(*new)();
	Dict	table;
	dict_key_t	*flat;

	if (strcmp(argv[1], "-fuzz")==0) {
		add = (dict_value_t(*)())fuzzdict_add;
		find = (dict_value_t(*)())fuzzdict_find;
		new = (Dict(*)())fuzzdict_new;
		argc--; argv++;
	}
	else {
		add = dict_add;
		find = dict_find;
		new = dict_new;
	}

	table = new();
	for (argc--,argv++; argc > 0; argc--,argv++) {
		file = fopen (*argv, "r");
		if (file == NULL)
			die ("Can't open '%s'", *argv);

		printf ("grabbing symbols from '%s' ...\n", *argv);
		while (fgets (buf, sizeof buf, file)) {
			n = strsplit (buf, vec, 12, (char*)0);
			while (n > 0) {
				add (table, vec[n-1], strdup(vec[n-1]));
				n--;
			}
		}
		fclose (file);
	}

	/* Now search the table several times */
	dict_printOn (table, stdout);
	printf ("searching ...\n");
	flat = dict_keys (table);
	
	for (n = 0; n < 10; n++) {
		for (i = 0; flat[i]; i++) {
			find (table, flat[i]);
		}
	}
	return 0;
}

die (gasp, a1,a2,a3)
char*	gasp;
int	a1, a2, a3;
{
	fprintf (stderr, "die: ");
	fprintf (stderr, gasp, a1, a2, a3);
	putc ('\n', stderr);
	fflush (stderr);

	exit (1);
}
