/* Class FuzzDict:
 *
 * A symbol table which permits abbreviated matches.
 */
#ifndef _CLASS_FuzzDict_
#define _CLASS_FuzzDict_

#ifdef _CLASS_FuzzDict_PRIVATE_
# define _CLASS_Dict_PRIVATE_
#endif

#include "dict.h"

typedef struct _FuzzDict_* FuzzDict;

	
#ifdef __STDC__

	FuzzDict	fuzzdict_new ();
	int		fuzzdict_ignoreCase (
				FuzzDict 	self,
				int		yesno
			);
	FuzzDict	fuzatab_dispose ( FuzzDict self );
	dict_value_t	fuzzdict_find (
				FuzzDict 	self,
				dict_key_t	key
			);
	dict_value_t	fuzzdict_add (
				FuzzDict 	self,
				dict_key_t	key,
				dict_value_t	value
			);
	dict_value_t	fuzzdict_remove (
				FuzzDict 	self,
				dict_key_t	key
			);

#else	/* !__STDC__ */

	FuzzDict	fuzzdict_new ();
	int		fuzzdict_ignoreCase ( );
	FuzzDict	fuzatab_dispose ();
	dict_value_t	fuzzdict_find ();
	dict_value_t	fuzzdict_add ();
	dict_value_t	fuzzdict_remove ();

#endif	/* !__STDC__ */

/* Now define some macros to call on common functions */
#define fuzzdict_keys(S)	dict_keys((Dict)S)
#define fuzzdict_values(S)	dict_values((Dict)S)


/* Following declarations are private for class FuzzDict
 * and sub-classes.
 */
#ifdef _CLASS_FuzzDict_PRIVATE_
#define _CLASS_FuzzDict_VARS_ \
	_CLASS_Dict_VARS_ \
	dict_key_t*	keylist; \
	int	keylistValid; \
	int	(*compare)(); \
	int	(*sort)();

struct _FuzzDict_ {
	_CLASS_FuzzDict_VARS_
};
#endif	/* _CLASS_FuzzDict_PRIVATE_ */

#endif	/* !_CLASS_FuzzDict_ */
