/* Symbol Table:
 *
 * Public declarations
 */

#ifndef _CLASS_Dict_
#define _CLASS_Dict_

typedef struct _Dict_* Dict;
typedef char*	dict_key_t;
typedef void*	dict_value_t;


/* Public functions:
 */

#if defined (__STDC__)

	/* Create new Dict and return identifier to it */
	Dict	dict_new ();

	/* Dispose of a Dict, cleaning up all allocated storage */
	Dict	dict_dispose (
			Dict stp
		);

	/* Find value associated with key <name> */
	dict_value_t	dict_find (
			Dict stp,
			dict_key_t	name
		);

	dict_key_t	dict_findKey (
			Dict stp,
			dict_key_t	name
		);

	/* Create association between key <name> and value <value> */
	dict_value_t	dict_add (
			Dict stp,
			dict_key_t	name,
			dict_value_t	value
		);

	dict_value_t	dict_remove (
			Dict stp,
			dict_key_t	name
		);

	/* Return list of keys in the symbol table */
	dict_key_t*	dict_keys (
			Dict stp
		);

	/* Return list of values in the symbol table */
	dict_value_t*	dict_values (
			Dict stp
		);

	/* Set key matching to ignore/respect case distinctions */
	int		dict_ignoreCase (
			Dict stp,
			int yesno
		);


#else	/* !__STDC__ */

	Dict	dict_new ();

	Dict	dict_dispose ();

	dict_value_t	dict_find ();

	dict_key_t	dict_findKey ();

	dict_value_t	dict_add ( );

	dict_value_t	dict_remove ( );

	dict_key_t*	dict_keys ();

	dict_value_t*	dict_values ();

	int		dict_ignoreCase ();

#endif	/* !__STDC__ */


/* Class Dict:
 *
 * These functions manage an in-memory set of <key, value> pairs, where
 * <key> is a standard nul-terminated C string, and <value> is an
 * arbitrary pointer-sized value.  The Dict class internally allocates
 * space to store copies of the <key> argument, so the caller may
 * re-use the space for its copy of the <key> argument after any call
 * which requires it.  The <value> argument is not used or examined by
 * Dict routines in any way; its significance is totally determined by
 * the caller.
 *
 *
 * Usage:
 *
 * One creates a symbol table with the function dict_new().  The return
 * is the symbol table identifier to be used in all subsequent calls.
 *
 * A <key, value> association is created by the dict_add() function,
 * which requires a Dict identifier returned from previous dict_new()
 * call, and a <key, value> pair.
 *
 * The value associated with the key <key> is returned by the dict_find()
 * function.
 *
 * An association is removed by the dict_remove() call; it returns the
 * value previously associated with <key>, if any.
 *
 * Finally, one may dispose of a Dict with the dict_dispose() function.
 * All storage allocated internally for this Dict is freed.  Storage
 * referenced by <value> fields in existing associations is not touched.
 *
 *
 *
 * Implementation:
 *
 * Internally, Dict uses a hash table with chain on collision.  The
 * hash table is expanded automatically according to internal constraints.
 * The caller is assured under most circumstances that access is reasonably
 * efficient.  Insertion is always efficient, however there is now check
 * for duplicate keys on insertion.  Thus, two associations with the same
 * key may exist.  In this case, the most recently inserted association will
 * be return by the dict_find() and dict_delete() functions.
 *
 * Multiple instances of Dict may be in operation simultaneously.  All
 * state information is kept in a private data structure allocated at
 * creation.
 */

/* Following are private declarations for
 * the Dict class itself and sub-classes
 */
#ifdef _CLASS_Dict_PRIVATE_
typedef unsigned int dict_hash_t;

#define _CLASS_Dict_VARS_ \
	struct _SymEnt_** head;		/* array of linked-list pointers */ \
	int	nhead;			/* size of above */		    \
	int	nheadinuse;		/* number of list heads used */     \
	int	nitems;			/* number of objects in the list */ \
	char*	error;			/* error message on failure */	    \
	int	(*f_compare)();						    \
	dict_hash_t	(*f_hash)();

struct _Dict_ {
	_CLASS_Dict_VARS_
};

#endif	/* _CLASS_Dict_PRIVATE_ */

#endif	/* !_CLASS_Dict_ */
