/*
 * Copyright (c) 1993, 1999 Alexandre Wennmacher (wennmach@geo.Uni-Koeln.DE)
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 * This product includes software developed by Alexandre Wennmacher.
 * 4. The name of Alexandre Wennmacher may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY ALEXANDRE WENNMACHER AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL ALEXANDRE WENNMACHER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

#define NCOLORS   17
#define BLACK    (NCOLORS - 1)
#define HIGH     (NCOLORS - 2)

struct _color {
    unsigned short red;
    unsigned short green;
    unsigned short blue;
} color[NCOLORS] = {
    { 12800, 12800, 40960 },     /* Sea */
    {     0, 40000,     0 },     /* dark green (depressions) */
    { 15360, 53760,  7680 },     /* green */
    { 32768, 55040, 24320 },     /* green */
    { 41472, 55040, 24320 },     /* green */
    { 52224, 55040, 24320 },     /* green */
    { 61952, 55040, 20480 },     /* yellowish */
    { 65280, 47104, 24832 },     /* yellowish brown */
    { 65280, 44288, 12288 },     /* red brown */
    { 65280, 40192, 12288 },     /* redder brown */
    { 57344, 39680, 13056 },     /* brown */
    { 55000, 47000, 29000 },     /* brown */
    { 49408, 46848, 28672 },     /* brown */
    { 47616, 43520, 32768 },     /* brown */
    { 46080, 48128, 46080 },     /* light gray */
    { 53760, 53760, 53760 },     /* blanc casse, HIGH value */
    {     0,     0,     0 }      /* black for Dummy, BLACK value */
};
