/*
 * Copyright (c) 1999 Alexandre Wennmacher (wennmach@geo.Uni-Koeln.DE)
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 * This product includes software developed by Alexandre Wennmacher.
 * 4. The name of Alexandre Wennmacher may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY ALEXANDRE WENNMACHER AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL ALEXANDRE WENNMACHER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */
#include <sys/types.h>
#include <sys/mman.h>
#include <stdio.h>
#include "Sphere.h"
#include "SphereDim.h"

/* Solaris hack: */
#ifndef MAP_FILE
#define MAP_FILE 0x0
#endif

int
main()
{
    short int dat;
    int i;
    FILE *f_dat, *f_o;
    register_t *addr;
    const size_t len = NPOINTS*sizeof(register_t);

    f_dat = fopen("world.dat", "r");
    if (f_dat == NULL) {
        perror("compile_world: could not open world.dat");
        exit(1);
    }
    f_o   = fopen("world.o", "w+");
    if (f_dat == NULL) {
        perror("compile_world: could not open world.o");
        exit(1);
    }
    if (ftruncate(fileno(f_o), len) != 0) {
        perror("compile_world: could not ftruncate world.o");
        exit(1);
    }
    addr = (register_t *)mmap(NULL, len, PROT_READ | PROT_WRITE,
      MAP_FILE | MAP_SHARED, fileno(f_o), 0);
    if (addr == (register_t *)MAP_FAILED) {
        perror("compile_world: could not mmap");
        exit(1);
    }

    for (i = 0; i < NPOINTS; i++) {
         fscanf(f_dat, "%hd", &dat);
         *(addr + i) = (register_t)dat;
    }

    (void)fclose(f_dat);
    (void)fclose(f_o);
    exit(0);
}
