// xsc: Copyright (c) 1993-2005 by Mark B. Hanson (mbh@panix.com).

// @(#)$Id: minefield.h,v 3.7 2005/01/02 19:11:17 mark Exp $

#ifdef	XSC_MINEFIELD_H

class Minefield;

#else	// XSC_MINEFIELD_H
#define	XSC_MINEFIELD_H

#include "buzzer.h"
#include "castle.h"
#include "king.h"
#include "laser.h"
#include "ship.h"
#include "stats.h"

class Minefield {
private:
    int nummines;
    Buzzer *buzzers;

public:
    Minefield(void);
    ~Minefield(void);

    void render(const bool) const;
    void draw(void) const;
    void erase(void) const;

    void move(Castle *, Ship *) const;
    void resize(const int, const int) const;
    bool hit(Laser *) const;
    void launch(King *, Castle *) const;
    void upgrade(Castle *) const;
    void snuff(void) const;
    void pause(bool) const;
};


inline void
Minefield::draw(void) const
{
    render(true);
} // Minefield::draw


inline void
Minefield::erase(void) const
{
    render(false);
} // Minefield::erase

#endif	// XSC_MINEFIELD_H
