// xsc: Copyright (c) 1993-2005 by Mark B. Hanson (mbh@panix.com).

// @(#)$Id: king.h,v 3.6 2005/01/02 19:11:17 mark Exp $

#ifdef	XSC_KING_H

class King;

#else	// XSC_KING_H
#define	XSC_KING_H

#include "castle.h"
#include "fireball.h"
#include "laser.h"
#include "minefield.h"
#include "ship.h"
#include "stats.h"
#include "tthing.h"

class King : public virtual Tthing {
private:
    Fireball *fireball;
    bool living;

public:
    King(void);
    ~King(void);

    void render(const bool);

    void turn(Castle *, Ship *);
    void resize(const int, const int);
    bool hit(Castle *, Laser *, Minefield *, Stats *);
    void reincarnate(void);
    void pause(const bool) const;

    bool alive(void) const;
};


inline void
King::reincarnate(void)
{
    living = true;
} // King::reincarnate


inline bool
King::alive(void) const
{
    return living;
} // King::alive

#endif	// XSC_KING_H
