// xsc: Copyright (c) 1993-2005 by Mark B. Hanson (mbh@panix.com).

// @(#)$Id: args.h,v 3.2 2005/01/02 19:11:17 mark Exp $

#ifndef	XSC_ARGS_H
#define	XSC_ARGS_H

namespace Args {

struct info {
    KeySym ccw;		// the key which turns the ship counterclockwise
    KeySym cw;		// the key which turns the ship clockwise
    KeySym thrust;	// the key which thrusts the ship
    KeySym fire;	// the key which fires the ship's laser
    KeySym pause;	// the key which pauses the game
    KeySym iconify;	// the key which iconifies the window
    KeySym quit;	// the key which quits the game
    KeySym start;	// the key which starts the game
    float fps;		// frames per second
    short x;		// x offset of the window
    short y;		// y offset of the window
    short percent;	// percent of the display the window should take up
    bool nowarp;	// don't mess with the cursor
    bool nobeep;	// don't beep if a wrong key is hit
    bool nopause;	// don't pause when the cursor leaves the window
    bool stats;		// output statistics (actual fps, etc.)
    bool bw;		// black and white display
};

void init(struct info *const);
void set(struct info *const, const int, const char *const []);

} // namespace Args

#endif	// XSC_ARGS_H
