/*
 * Copyright 1991-1998, Brown University, Providence, RI.
 * 
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose other than its incorporation into a
 * commercial product is hereby granted without fee, provided that the
 * above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Brown University not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * BROWN UNIVERSITY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR ANY
 * PARTICULAR PURPOSE.  IN NO EVENT SHALL BROWN UNIVERSITY BE LIABLE FOR
 * ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */
/************************************************************************
*									*
*   xmx.h								*
*									*
************************************************************************/
/*
**	Rationalize Predefines
*/
	/* SPARCompiler C 3.x predefines __SVR4 under Solaris 2.x */
#if defined(__SVR4) && !defined(SVR4)
#define SVR4	1
#endif

#if defined(SVR4) && !defined(SYSV)
#define SYSV	1
#endif

/*
**	Portability
*/

#ifdef _AIX
#define ulong_t ulong__t
#define uint_t uint__t
#endif
#ifdef SVR4
#define ulong_t ulong__t
#define uint_t uint__t
#define queue_t queue__t
#define resource_t resource__t
#endif
#ifdef sgi
#endif

/*
**	Defaults
*/
#define DEFAULTDISPLAY	1

#define RID_MASK	0x001fffff
#define RID_BASE_MASK	0x1fc00000
#define RID_SERVER_MASK	0x00200000
#define RID_MASKBITS	22	/* number of bits in mask */
#define NOCLIENTS	128	/* maximum number of client connections */
#define MAXCOLVAL	65535
#define MOBUFSIZE	128	/* motion buffer size */
#define EXPOS_Q_LEN	8	/* per window exposure queue length */

#define MAXDEPTH	32	/* largest depth - an X protocol invarient */

#define BIGUINT		0xffffffff	/* a large unsigned integer value */
#define ALLBITSMASK	0xffffffff

#define LISTSZ		64		/* # of 32-bit units in list element */
/*
**	Largest request in 4-byte units.  If this is increased, note
**	that MAXCHUNKSIZE, below, must always be 4 * MAXREQSIZE or larger.
*/
#define MAXREQSIZE	16383		/* 65535/4 */
/*
**	Largest size, in bytes, of a chunk with requests in it.  Chunks
**	that grow larger than this get queued automatically.  If this is
**	increased, then the definitions of the offsets in the op_*_t
**	structures in ptc.h must be increased from u16_t to u32_t.  This
**	value must be at least 4 times MAXREQSIZE.
*/
#define MAXCHUNKSIZE  65535
/*
**	Blocks further client reads.  This value governs - very roughly -
**	how closely synchronized the servers are.  A larger value allows
**	faster machines/connections to get further ahead.  A smaller
**	value will tend to make faster machines wait for others to
**	catch up.
*/
#define BIGBUFFER     (2*MAXCHUNKSIZE)

/*
**	Input Event Mask Alterations
**		ALLOW masks are ANDed with their corresponding input masks
**		SET masks are ORed with their corresponding input masks
*/
#define IE_SHELLSET	(	StructureNotifyMask )
/*
				ResizeRedirectMask)
*/

#define IE_ROOTSET	(	ExposureMask)

#define IE_FLOORALLOW	(	KeymapStateMask |\
				ExposureMask |\
				VisibilityChangeMask)
#define IE_FLOORSET	(	KeyPressMask |\
				KeyReleaseMask |\
				ButtonPressMask |\
				ButtonReleaseMask |\
				PointerMotionMask |\
				OwnerGrabButtonMask)
#define IE_SEATALLOW	(	ExposureMask |\
				VisibilityChangeMask )
#ifdef TODO
#define IE_SEATSET	(	seatmask)
#else
#define IE_SEATSET	(	KeyPressMask |\
				KeyReleaseMask |\
				ButtonPressMask |\
				ButtonReleaseMask )
#endif
#define IE_VIEWALLOW	(	ExposureMask |\
				VisibilityChangeMask )
#define IE_VIEWSET	(	0)

/*
**	Seat-only masks - these use bits in X Input Event Masks that
**	are unused in the protocol spec.
*/
#define SeatMaskKeyPress	(1L<<25)
#define SeatMaskKeyRelease	(1L<<26)
#define SeatMaskButtonPress	(1L<<27)
#define SeatMaskButtonRelease	(1L<<28)
#define SeatMaskMask		(SeatMaskKeyPress |\
				 SeatMaskKeyRelease |\
				 SeatMaskButtonPress |\
				 SeatMaskButtonRelease)
#define SeatMaskShift(m)	((m << 25) & SeatMaskMask)
#define SeatMaskUnshift(m)	(((m) & SeatMaskMask) >> 25)

#define MkCompMask(wp)		wp->compmask =	wp->xmask->mask |\
						SeatMaskShift(wp->xmcmask->mask)
/*
**	Some additional EventMask mask values for tagging requests.
*/
#define IsShellMask		(1L<<29)
#define IsRootMask		(1L<<30)

/*
**	Buffer Content Descriptor Types
*/
#define C_NONE		0	/* not set */
#define C_REQ		1	/* request */
#define C_REP		2	/* reply */
#define C_IM		3	/* image */

/*
**	Connection Types
*/
#define CLOSED		0	/* non- or no longer existent connection */
#define XPORT		1	/* X client port */
#define CLIENT		2	/* X client socket */
#define SERVER		3	/* server socket */
#define XMCPORT		4	/* XMC client port */
#define XMC		5	/* multiplexor control protocol connection */
#define XDMCP		6	/* xdmcp connection */

/*
**	X Protocol Types
*/
#define P_NONE		0	/* nothing */
#define P_REQUEST	1	/* request */
#define P_REPLY		2	/* reply */
#define P_ERROR		3	/* error */
#define P_EVENT		4	/* event */
#define P_EVENT_SWAPPED	5	/* event (with bytes/words swapped) */
#define P_IMAGE		6	/* image */
#define P_CONNECT	7	/* connection setup block */
#define P_CONNECT_SWAPPED	8	/* connection setup block (swapped) */
#define P_EXT		9	/* extension */

/*
**	Queue Destinations
*/
#define Q_NONE		0	/* no destination */
#define Q_XSERVER	1	/* X server */
#define Q_XCLIENT	2	/* X client */
#define Q_XMCCLIENT	3	/* XMC client */

/*
**	Queue Destination Classes
*/
#define QC_NONE		0	/* nowhere */
#define QC_KETCHUP	1	/* all servers setting up */
#define QC_QSERV	2	/* query server */
#define QC_ALLSERV	3	/* all ready servers */
#define QC_FLOOR	4	/* all servers in floor mode */
#define QC_SEAT		5	/* all servers in seat mode */
#define QC_VIEW		6	/* all servers in view mode */

/*
**	Debugging Levels
*/
#define D_NONE		0x00000000 /* suppress errors (except upon abort) */
#define D_ERRORS	0x00000001 /* print errors - default */
	/* all levels below require compiling -DDEBUG */
#define D_PROTO1	0x00000002 /* print incoming client protocol */
#define D_PROTO2	0x00000004 /* print outgoing virtual client protocol */
#define D_PROTO3	0x00000008 /* print incoming server protocol */
#define D_PROTO4	0x00000010 /* print outgoing virtual server protocol */
#define D_PROTOd	0x00000020 /* print (protocol) detail */
#define D_PROTOq	0x00000040 /* print protocol to and from query server */
#define D_PROTO		(D_PROTO1 | D_PROTO2 | D_PROTO3 | D_PROTO4)
#define D_PROTOx	0x00000080 /* XMC protocol */
#define D_NETWORK	0x00000100 /* networking code */
#define D_BUFFERS	0x00000200 /* buffer module messages */
#define D_IMAGE		0x00000400 /* trace image processing operations */
#define D_HASH		0x00000800 /* trace hash table operations */
#define D_SM		0x00001000 /* trace seq number mapping operations */
#define D_CHUNK		0x00002000 /* trace chunk operations */
#define D_COLOR		0x00004000 /* trace color operations */
#define D_LIST		0x00008000 /* trace list operations */
#define D_GRABS		0x00010000 /* trace grab processing */
#define D_SELECT	0x00020000 /* trace selection processing */
#define D_VCONF		0x00040000 /* trace virtual configuration operations */
#define D_EXPOS		0x00080000 /* trace exposure queue operations */
#define D_PTC		0x00100000 /* trace request translation operations */
#define D_AUTH		0x00200000 /* trace access/authority operations */
#define D_SWAP		0x00400000 /* trace byte swapping operations */
#define D_REPLY		0x00800000 /* print 'soft' reply errors */
#define D_PMAP		0x01000000 /* trace pixel mapping operations */
#define D_KEYMAP	0x02000000 /* trace key mapping operations */
#define D_FOCUS		0x04000000 /* trace focus processing */
#define D_RESET		0x08000000 /* trace server add operations */
#define D_PAINFUL	0x10000000 /* more internal messages */
#define D_VERIFY	0x20000000 /* run internal verification checks */

/*
**	Virtual Configuration States
*/
#define VC_MUSH		0	/* vconf malleable */
#define VC_INFLUX	1	/* vconf is resetting (transitional state) */
#define VC_FIXED		2	/* vconf is set */

/*
**	Server States
*/
#define S_ZOMBIE	0	/* transitional non-state */
#define S_NAMED		1	/* host:display named */
#define S_INPROGRESS	2	/* connection initiated, not completed */
#define S_BLOCKED	3	/* add blocked pending previous add */
#define S_POKED		4	/* client block sent */
#define S_KETCHUP	5	/* in the process of catching up */
#define S_READY		6	/* active */
#define S_NSTATES	7	/* number of states */

/*
**	Server/Vconf States
*/
#define SV_MERGED	0x1	/* configuration merged into vconf */
#define SV_MAPPED	0x2	/* mapped to vconf */

/*
**	Server Reset/Sync States
*/
#define SR_NONE		0x0
#define SR_SYNC		0x1	/* server is part of a pending sync */
#define SR_RESET	0x2	/* server is part of a pending reset */

/*
**	Client States
*/
#define K_NEW		1	/* connected, nothing received yet */
#define K_READY		2	/* expect requests */
#define K_DEAD		3	/* no connection, but resources are retained */

/*
**	Root Flags - per server, per root window flags
*/
#define RF_NONE		0x00	/* nothing */
#define RF_OWNCMAP	0x01	/* create default colormap */
#define RF_OWNROOT	0x02	/* create shell root window */

/*
**	Buffer Storage Types
*/
#define B_STATIC	0
#define B_FREEONWRITE	1

/*
**	Mapping Types
*/
#define MT_CLIENTDATA	1
#define MT_ATOM		2
#define	MT_SHARED_RID	3
#define	MT_SERVER_RID	4
#define	MT_EVENT_MASK	5
#define	MT_ROOT_PIXEL	6
#define	MT_IMAGE_LEN	7
#define	MT_IMAGE	8
#define MT_G_EXPOSE	9
#define	MT_SEQ_RANGE	10
#define	MT_SEQ_REPLY	11
#define MT_ERROR	12
#define MT_EVENT	13
#define MT_REPLY	14
#define MT_CONN_SETUP	15

/*
**	Reset Levels
*/
#define R_SOFT		0
#define R_HARD		1
#define R_RECONFIG	2

/*
**	Drawable Types
*/
#define W_WINDOW	0
#define W_PIXMAP	1
#define W_SHELL		2
#define W_TPTR		3

/*
**	Color Cell Status Values
*/
#define CS_FREE		0x0
#define CS_READ		0x1
#define CS_WRITE	0x2
#define CS_HIDDEN	0x4
#define CS_ALLOC	(CS_READ | CS_WRITE)
#define CS_ALL		0

/*
**	Telepointer Masks
*/
#define TP_IMAGE	0x1
#define TP_COLOR	0x2

/*
**	Synchronization Action Masks
*/
#define SYNC_NONE	0x0
#define SYNC_CLIENT	0x1
#define SYNC_HASHTAB	0x2

/*
**	MIT-defined Communication Protocol Address Families
*/
#ifndef FamilyInternet
#define FamilyInternet		0	/* FamilyInternet */
#define FamilyDECnet		1	/* FamilyDECnet */
#define FamilyChaos		2	/* FamilyChaos */
#endif
#ifndef FamilyLocal
#define FamilyLocal		256	/* FamilyLocal */
#define FamilyWild		65535	/* FamilyWild */
#endif

/*
**	Implied by CW constants in X.h
*/
#define IWBackPixmap            0
#define IWBackPixel             1
#define IWBorderPixmap          2
#define IWBorderPixel           3
#define IWBitGravity            4
#define IWWinGravity            5
#define IWBackingStore          6
#define IWBackingPlanes         7
#define IWBackingPixel          8
#define IWOverrideRedirect      9
#define IWSaveUnder             10
#define IWEventMask             11
#define IWDontPropagate         12
#define IWColormap              13
#define IWCursor                14

#define IWCount			15

/*
**	Implied by GC constants in X.h
*/
#define IGFunction		0
#define IGPlaneMask		1
#define IGForeground		2
#define IGBackground		3
#define IGLineWidth		4
#define IGLineStyle		5
#define IGCapStyle		6
#define IGJoinStyle		7
#define IGFillStyle		8
#define IGFillRule		9
#define IGTile			10
#define IGStipple		11
#define IGTileStipXOrigin	12
#define IGTileStipYOrigin	13
#define IGFont			14
#define IGSubwindowMode		15
#define IGGraphicsExposures	16
#define IGClipXOrigin		17
#define IGClipYOrigin		18
#define IGClipMask		19
#define IGDashOffset		20
#define IGDashList		21
#define IGArcMode		22

#define IGCount			23

/*
**	Same as XA_LAST_PREDEFINED in Xatom.h
*/
#define MAX_PREDEF_ATOM		68
/*
**	XLFD property atoms are predefined, too, but not guaranteed
**	to match server implementations.
*/
#define MAX_KNOWN_ATOM		112

/*
**	hash table sizes
*/
#define VMAPSIZE		1024	/* virtual config resource table size */

/*
**	macros
*/

#ifdef MALLOC_DEBUG
#define malloc(sz)	debug_malloc(sz)
#define calloc(n,sz)	debug_calloc((n),(sz))
#define free(ptr)	debug_free((char *)ptr)
#endif

#define MALLOC(ptr,type,size)	(((ptr)=(type)malloc((int)size)) == (type)0 ?\
			err(-1, "malloc returned zero [%d]\n",(size)) : 0)
#define CALLOC(ptr,type,N,size)\
			(((ptr)=(type)calloc((int)(N),(int)(size)))==(type)0 ?\
			err(-1, "calloc returned zero [%d*%d]\n",(N),(size)):0)

#ifdef DEBUG
#define DEBUG0(lev,fmt)		if (debug & (lev)) warn(fmt)
#define DEBUG1(lev,fmt,A)	if (debug & (lev)) warn(fmt,A)
#define DEBUG2(lev,fmt,A,B)	if (debug & (lev)) warn(fmt,A,B)
#define DEBUG3(lev,fmt,A,B,C)	if (debug & (lev)) warn(fmt,A,B,C)
#define DEBUG4(lev,fmt,A,B,C,D)	if (debug & (lev)) warn(fmt,A,B,C,D)
#define DEBUG5(lev,fmt,A,B,C,D,E)	if (debug & (lev)) warn(fmt,A,B,C,D,E)
#define DEBUG6(lev,fmt,A,B,C,D,E,F)	if (debug & (lev)) warn(fmt,A,B,C,D,E,F)
#define D_CALL0(lev,rtn)	if (debug & (lev)) rtn()
#define D_CALL1(lev,rtn,A)	if (debug & (lev)) rtn(A)
#define D_CALL2(lev,rtn,A,B)	if (debug & (lev)) rtn(A,B)
#define D_CALL3(lev,rtn,A,B,C)	if (debug & (lev)) rtn(A,B,C)
#define D_CALL4(lev,rtn,A,B,C,D)	if (debug & (lev)) rtn(A,B,C,D)
#else
#define DEBUG0(lev,fmt)
#define DEBUG1(lev,fmt,A)
#define DEBUG2(lev,fmt,A,B)
#define DEBUG3(lev,fmt,A,B,C)
#define DEBUG4(lev,fmt,A,B,C,D)
#define DEBUG5(lev,fmt,A,B,C,D,E)
#define DEBUG6(lev,fmt,A,B,C,D,E,F)
#define D_CALL0(lev,rtn)
#define D_CALL1(lev,rtn,A)
#define D_CALL2(lev,rtn,A,B)
#define D_CALL3(lev,rtn,A,B,C)
#define D_CALL4(lev,rtn,A,B,C,D)
#endif

#ifndef PAD
#define PAD(A)		((4 - ((A) % (uint_t)4)) % 4)
#endif

#define SWAP2(s)	{register char _t = ((char *)&(s))[0];\
			((char *)&(s))[0] = ((char *)&(s))[1];\
			((char *)&(s))[1] = _t;}

#define SWAP4(s)	{register char _t = ((char *)&(s))[0];\
			((char *)&(s))[0] = ((char *)&(s))[3];\
			((char *)&(s))[3] = _t;\
			_t = ((char *)&(s))[1];\
			((char *)&(s))[1] = ((char *)&(s))[2];\
			((char *)&(s))[2] = _t;}

#define SWAP2L(sp,n)	{register int _i;\
			register u16_t *_p = (u16_t *)(sp);\
			for (_i=0; _i<(int)(n); _i++)\
				SWAP2(_p[_i]);\
			}

#define SWAP4L(sp,n)	{register int _i;\
			register u32_t *_p = (u32_t *)(sp);\
			for (_i=0; _i<(int)(n); _i++)\
				SWAP4(_p[_i]);\
			}

#define CPSWAP2(s,d)	((char *)&(d))[0] = ((char *)&(s))[1];\
			((char *)&(d))[1] = ((char *)&(s))[0]

#define CPSWAP4(s,d)	((char *)&(d))[0] = ((char *)&(s))[3];\
			((char *)&(d))[1] = ((char *)&(s))[2];\
			((char *)&(d))[2] = ((char *)&(s))[1];\
			((char *)&(d))[3] = ((char *)&(s))[0]

#define NUMONES(m,n) {	/* HAKMEM #169 */\
	(n) = ((m) >> 1) & 033333333333;\
	(n) = (m) - (n) - (((n) >> 1) & 033333333333);\
	(n) = ((((n) + ((u32_t)(n) >> 3)) & 030707070707) % 077);\
}

#ifndef MIN
#define MIN(a,b)	((a)<(b)?(a):(b))
#endif
#ifndef MAX
#define MAX(a,b)	((a)>(b)?(a):(b))
#endif

#define RUP(n,inc)	((((n)+(inc)-1)/(inc))*(inc))
#define RDN(n,inc)	(((n)/(inc))*(inc))

/*
**	Compare sequence numbers.  They are unsigned shorts that roll over.
*/
#define SEQNO_LT(A,B)	(((A)<(B)&&(B)-(A)<32768) || ((A)>(B)&&(A)-(B)>32768))
#define SEQNO_GE(A,B)	(((A)>=(B)&&(A)-(B)<32768) || ((A)<(B)&&(B)-(A)>32768))

/*
**	Do windows overlap?
#define LAP(x1,y1,w1,h1,x2,y2,w2,h2)\
	(x1 < (x2+w2-1) && (x1+w1-1) > x2 && y1 < (y2+h2-1) && (y1+h1-1) > y2)
*/
#define OVERLAP(w1,w2) (\
	w1->x < (w2->x+(s16_t)w2->dwb.width-1) &&\
	(w1->x+(s16_t)w1->dwb.width-1) > w2->x &&\
	w1->y < (w2->y+(s16_t)w2->dwb.height-1) &&\
	(w1->y+(s16_t)w1->dwb.height-1) > w2->y )

#define LEFTEDGE(w)	((w)->x)
#define TOPEDGE(w)	((w)->y)
#define FULLWIDTH(w)	((s16_t)((w)->dwb.width + 2 * (w)->borderwidth))
#define FULLHEIGHT(w)	((s16_t)((w)->dwb.height + 2 * (w)->borderwidth))
#define XOFFSET(w)	((w)->x + (s16_t)(w)->borderwidth)
#define YOFFSET(w)	((w)->y + (s16_t)(w)->borderwidth)
/*
**	hashtab_t accessor
*/
#define hash_dirty(tab)	(tab)->dirty

/*
**	buffer_t accessors
*/
#ifdef DEBUG
#define buf_chunk(bp)		(bp)->tail
#define buf_chunksize(chp)	((chp)->valid ? (chp)->sz :\
				(quit(-1, "invalid chunk [0x%x]", (chp)), 0))
#define buf_active(bp)	((bp)->tail->sz)
#define buf_avail(bp)	((bp)->sz - (bp)->tail->off - (bp)->tail->sz)
#define buf_used(bp)	((bp)->tail->off + (bp)->tail->sz - (bp)->tfree)
#define buf_data(chp)	(((chp)->valid &&\
			  (chp)->curp == (chp)->bp->bp + (chp)->off)?\
				(chp)->bp->bp + (chp)->off :\
				(quit(-1, "invalid chunk"), (char *)0))
#define buf_curdata(bp)	buf_data((bp)->tail)
#define buf_next(bp)	((bp)->bp + (bp)->tail->off + (bp)->tail->sz)
#define buf_grow(bp,N)	(bp)->tail->sz += (N)
#define buf_lop(chp,N)	(chp)->sz -= (N);\
			(chp)->off += (N);\
			(chp)->curp += (N);\
			(chp)->bp->tfree += (N)
#define chunk_addcontext(chp,cxp)\
	((chp)->cstkp == 0 && ((chp)->cstkp = cstk_new()),\
	(void)cstk_push((chp)->cstkp, (cxp)))
#define buf_addcontext(bp,cxp)	chunk_addcontext((bp)->tail,cxp)
#else
#define buf_chunk(bp)		(bp)->tail
#define buf_chunksize(chp)	((chp)->sz)
#define buf_active(bp)	((bp)->tail->sz)
#define buf_avail(bp)	((bp)->sz - (bp)->tail->off - (bp)->tail->sz)
#define buf_used(bp)	((bp)->tail->off + (bp)->tail->sz - (bp)->tfree)
#define buf_data(chp)	((chp)->bp->bp + (chp)->off)
#define buf_curdata(bp)	((bp)->bp + (bp)->tail->off)
#define buf_next(bp)	((bp)->bp + (bp)->tail->off + (bp)->tail->sz)
#define buf_grow(bp,N)	(bp)->tail->sz += (N)
#define buf_lop(chp,N)	(chp)->sz -= (N);\
			(chp)->off += (N);\
			(chp)->curp += (N);\
			(chp)->bp->tfree += (N)
#define chunk_addcontext(chp,cxp)\
	((chp)->cstkp == 0 && ((chp)->cstkp = cstk_new()),\
	(void)cstk_push((chp)->cstkp, (cxp)))
#define buf_addcontext(bp,cxp)	chunk_addcontext((bp)->tail,cxp)
#endif

/*
**	list operations
*/
#define list_size(lp)	((lp)->nval)

#define list_put(lp,val)\
	if ((lp)->tix == LISTSZ) {\
		list_bump(lp);\
		(lp)->tix = 0;\
	}\
	(lp)->tail->v[(lp)->tix++] = (val);\
	(lp)->nval++

/*
**	etime_t accessor
*/
#define time_assign(a,b)\
   {  (b).mo = (a).mo;\
      (b).ms = (a).ms;\
   }

/*
**	expression to compare two timestamps (<, = or > zero)
*/
#define time_cmp(a,b)\
   ((a).mo < (b).mo ? -1 :\
      ((a).mo > (b).mo ? 1 :\
         ((a).ms < (b).ms ? -1 :\
            ((a).ms > (b).ms ? 1 : 0))))

/*
**	convert etime_t structure to timestamp_t
*/
#define time_stamp(p)	(((p).mo < vtime.mo) ? 1 : (p).ms)

/*
**	client dereference
*/
#define client_of(rid)	(clients[((rid)&RID_BASE_MASK)>>RID_MASKBITS])
#define client_ptr(clinum)	(clients[clinum])

#ifdef RetainTemporary
#define client_cmp(c1,c2)\
   (((c1) && (c1)==(c2)) || ((c1)==0 && (c2)->closedownmode==RetainTemporary))
#endif

/*
**	construct a server-specific rid from a generic one
*/
#define mkrid(sp,id)	( ((id) << (sp)->smap.shift) | (sp)->smap.base )

/*
**	hmmm
*/
#define pp_assign(pp1, pp2)\
   if (pp2)\
      ((pp1) = (pp2))->refs++;\
   else\
      (pp1) = 0

/************************************************************************
*									*
*   types								*
*									*
************************************************************************/
typedef unsigned long	ulong_t;	/* an unsigned long */
typedef unsigned int	uint_t;		/* an unsigned word */
typedef unsigned long	u32_t;		/* a 32 bit unsigned int */
typedef unsigned short	u16_t;		/* a 16 bit unsigned int */
typedef unsigned char	u8_t;		/* an 8 bit unsigned int */

typedef int		slong_t;	/* signed long */
typedef int		sint_t;		/* signed word */
typedef long		s32_t;		/* a 32 bit signed int */
typedef short		s16_t;		/* a 16 bit signed int */
typedef char		s8_t;		/* an 8 bit signed int */

typedef u8_t		kcode_t;

typedef u32_t		rid_t;
typedef u32_t		atom_t;
typedef u32_t		pixel_t;
typedef u32_t		mask_t;
typedef u32_t		ksym_t;

#define G_SETPOS	0x01
#define G_ABSWIDTH	0x02
#define G_ABSHEIGHT	0x04
#define G_CHORIZ	0x08
#define G_CVERT		0x10
#define G_FROMRIGHT	0x20
#define G_FROMBOTTOM	0x40
/*
**	max (absolute or relative)
*/
typedef struct {
   int		abs;
   uint_t	n;
   double	r;
}max_t;

/*
**	geometry
*/
typedef struct {
   u16_t	what;
   double	wr, hr;
   u16_t	w, h, x, y;
}geom_t;

/*
**	options
*/
typedef struct _opts {
	u16_t	dpy;		/* display we're listening on */
	char *	auth;		/* name of authorization file */
	u8_t	bs;		/* disable backing store */
	char *	co;		/* filename of RGB database */
	pixel_t	cs;		/* cell alloc starting point */
	u8_t	ctp;		/* default telepointer image/color constant? */
	u8_t	dc;		/* delay virtual configuration? */
	u8_t	dpi;		/* screen resolution */
	geom_t *geomp;		/* virtual screen geometry */
	u8_t	glob;		/* hostname globbing? */
	u8_t	install;	/* install colormaps? */
	int	mdpynum;	/* XMC display number */
	max_t *	maxcolsp;	/* max number of root colormap cells */
	u8_t	notp;		/* no default telepointer? */
	u8_t	owncmap;	/* don't use root cmap? */
	u8_t	quiet;		/* suppress informational messages? */
	u8_t	resize;		/* allow user to resize virtual root? */
	u16_t	sto;		/* server connection timout */
	u8_t	su;		/* disable save-under support */
	u16_t	to;		/* client connection timeout */
	u8_t	wm;		/* force backing store to WhenMapped */
	u8_t	xdm;		/* listen for xdmcp connections */
	u8_t	xmc;		/* listen for xmcp connections */
}opts_t;

/*
**	opaque types
*/
typedef u8_t			iord_t;		/* image.c */
typedef struct _cmap_t		cmap_t;		/* cmap.c */
typedef struct _prop_t		prop_t;		/* prop.c */
typedef struct _grab_t		grab_t;		/* inp.c */
typedef struct _rxq_t		rxq_t;		/* rx.h */
typedef struct _cursor_t	cursor_t;	/* res.h */
typedef struct _pixmap_t	pixmap_t;	/* res.h */
typedef struct _font_t		font_t;		/* res.h */
typedef struct _sm_t		sm_t;		/* sm.h */
typedef struct _expvec_t	expvec_t;	/* expos.c */
typedef struct _ktm_t		ktm_t;		/* kpm.c */

typedef struct _cookie_t {
   u16_t		namelen;
   u16_t		datalen;
   char *		name;
   char *		data;
}cookie_t;

/*
**	generic pointer list
*/
typedef struct _plist_t {
   void *		ptr;
   struct _plist_t *	next;
}plist_t;

/*
**	partial packet type
*/
typedef struct _pp_t {
   uint_t		nmore;		/* number of bytes we're expecting */
   u8_t			type;		/* data type */
   u8_t			depth;		/*	depth of image */
   u16_t		width;		/*	width of image */
   iord_t		iord;		/* 	image data order */
   int			refs;		/* references */
   struct _pp_t *	next;
}pp_t;

/*
**	buffer type
*/
typedef struct _buffer_t {
   u8_t			type;	/* storage type */
   u8_t			clinum;	/* zero, unless a real client's buffer */
   uint_t		sz;	/* size of buffer */
   uint_t		tfree;	/* "trapped" free space */
   char *		bp;	/* buffer base pointer */
   struct _chunk_t *	head;	/* chunk list head */
   struct _chunk_t *	tail;	/* chunk list tail */
   struct _buffer_t *	next;
}buffer_t;

/*
**	list element type
*/
typedef struct _lblk_t {
	u32_t		v[LISTSZ];	/* values */
	struct _lblk_t	*next;
}lblk_t;

/*
**	list type
*/
typedef struct _list_t {
   u16_t		hix;		/* index of head value */
   u16_t		tix;		/* index of tail value */
   u16_t		nval;		/* number of values in list */
   lblk_t *		head;		/* list of blocks */
   lblk_t *		tail;
   struct _list_t *	next;
}list_t;

/*
**	chunk type
*/
typedef struct _chunk_t {
   buffer_t *		bp;	/* buffer containing chunk */
   uint_t		off;	/* start of data */
   uint_t		sz;	/* size of chunk */
   u16_t		refs;	/* queue references to this chunk */
   u8_t			type;	/* type of data in chunk */
   void *		dptr;	/* pointer to metadata */
   pp_t *		lpp;	/* leading partial packet info */
   pp_t *		tpp;	/* leading partial packet info */
   struct _chunk_t *	prev;	/* buffer chunk (doubly linked) list */
   struct _chunk_t *	next;
#ifdef DEBUG
   u8_t			valid;	/* debug field */
   char *		curp;	/* debugging: redundant pointer */
#endif
}chunk_t;

/*
**	queue type
*/
typedef struct _queue_t {
   int			fd;	/* a convenience */
   u16_t		dest;	/* destination */
   u16_t		hold;	/* boolean, send or wait */
   union {
	struct _server_t *	sp;
	struct _client_t *	cp;
	struct _xmc_t *		xp;
        char *			np;
   }dst;
   uint_t		nbytes;	/* total number of bytes to be written */
   pp_t *		pp;	/* partial packet info of last chunk written */
   uint_t		off;	/* bytes already written from first chunk */
   u16_t		qnel;	/* next queue element */
   u16_t		wnel;	/* next wait list element */
   u16_t		qsz;	/* size of queue */
   u16_t		wsz;	/* size of waitlist */
   chunk_t **		queue;	/* queue of chunks */
   chunk_t **		wait;	/* queue of chunks */
   struct _queue_t *	next;
}queue_t;

/*
**	hash table type (partially opaque)
*/
typedef struct {
	short			dirty;	/* if >0, map has marked entries */
	int			size;	/* size of hash table */
	struct _entry_t **	map;	/* client -> server map (opaque) */
	struct _entry_t **	unmap;	/* server -> client map (opaque) */
}hashtab_t;

/*
**	timestamp types
*/
typedef u32_t		timestamp_t;

typedef struct {
   u32_t		mo;	/* "months" (2^32 milliseconds) */
   timestamp_t		ms;	/* milliseconds */
}etime_t;

/*
**	host address
*/
typedef struct {
   u16_t		family;
   u16_t		length;
   char *		address;
}hostaddr_t;

/*
**	per server root window info
*/
typedef struct {
   uint_t		flags;		/* RF_ flags */
   pixel_t		whitePixel;
   pixel_t		blackPixel;
   int			pixWidth;	/* size of actual screen */
   int			pixHeight;
   int			ok;		/* is following offset okay? */
   int			xoff, yoff;	/* offset of virtual root to root */
   int			width, height;	/* size of virtual root */
   rid_t		realcmap;	/* real rid of default cmap */
   rid_t		realshell;	/* real rid of shell window */
   pixel_t		*pmap;
   mask_t		currentInputMask;
}root_t;

/*
**	server resource mapping info
*/
typedef struct {
   mask_t	base;
   mask_t	mask;
   kcode_t	minkey;		/* min keycode */
   kcode_t	keycnt;		/* keycode count */
   int		shift;		/* number of low order bits NOT in mask */
   iord_t	iordv[MAXDEPTH+1];	/* image orders */
   atom_t *	amp;		/* atom map */
   hashtab_t *	mp;
   root_t	root;
   ktm_t *	ktmp;		/* keycode translation map */
}smap_t;

/*
**	per server, per extension info
*/
typedef struct {
   char *	name;
   u8_t		present;
   u8_t		opcode;
   u8_t		first_event;
   u8_t		first_error;
}ext_t;

/*
**	per client info
*/
typedef struct _client_t {
   int		fd;		/* connection */
   queue_t *	qp;		/* queue */
   u8_t		swap;		/* byte swap? */
   u8_t		clinum;		/* client number == base>>RID_MASKBITS */
   u8_t		state;		/* state of xmx/client connection */
   u8_t		closedownmode;	/* like it sez */
   rid_t	id;		/* client id */
   u16_t	seqno;		/* sequence number of last request */
   u16_t	oseqno;		/* last outgoing sequence number */
   u16_t	refs;		/* resource refs */
   rxq_t *	rxqp;		/* context queue for pending replies */
   list_t *	eslp;		/* event sequence number list */
   hostaddr_t	addr;		/* address of client */
   mask_t	base;		/* mask is a constant (RID_MASK) */
   smap_t *	smap;		/* optional server resource map (for one-way)*/
   pp_t *	pp;		/* incoming partial packet info */
}client_t;

typedef struct _resource_t {
   client_t *		client;
}resource_t;

/*
**	info that pixmaps and windows share
*/
typedef struct {
   resource_t		res;		/* common block header */
   u8_t			type;		/* W_WINDOW, etc */
   u8_t			depth;
   u16_t		width;
   u16_t		height;
}drawable_t;

/*
**	telepointer image sources
*/
typedef struct _tpim_t {
   int		refs;		/* count of references */
   s16_t	hotx, hoty;	/* hot spot */
   u16_t	width, height;	/* size of image */
   rid_t	sbmid;		/* source bitmap */
   rid_t	mbmid;		/* mask bitmap */
   rid_t	spmid;		/* source pixmap */
   rid_t	mpmid;		/* mask pixmap */
}tpim_t;

/*
**	telepointer info
*/
typedef struct _tp_t {
   drawable_t		dwb;		/* to stuff in hash table */
   rid_t		id;		/* resource id */
   u8_t			mask;		/* use image/color? */
   u8_t			show;		/* logically mapped */
   u8_t			refs;		/* number of floors assigned */
   s16_t		x, y;		/* current virtual root location */
   struct _window_t *	wp;		/* current topmost enclosing window */
   struct _server_t *	sp;		/* last server in control */
   rid_t		wid;		/* pointer window resource id */
   pixel_t		fg;		/* foreground color */
   pixel_t		bg;		/* background color */
   tpim_t *		tpimp;		/* image source */
   struct _tp_t *	prev;
   struct _tp_t *	next;
}tp_t;

/*
**	xmc client info
*/
typedef struct _xmc_t {
   int		fd;
   queue_t *	qp;		/* queue */
   u8_t		accepted;
   u8_t		swap;
   u16_t	seqno;
   mask_t	base;
   mask_t	eventmask;
   hostaddr_t	addr;		/* address of client */
   struct _xmc_t *next;
}xmc_t;

/*
**	per server info
*/
typedef struct _server_t {
   char *	tag;		/* usually hostname */
   u16_t	taglen;		/* length of tag */
   u8_t		mode;		/* input mode: floor, seat or view */
   u8_t		state;		/* state of xmx/server connection */
   u8_t		lastq;		/* last queue to write */
   xmc_t *	grabbed;	/* is server's input grabbed? */
   cookie_t *	cookie;		/* authority for connection */
   geom_t *	geomp;		/* optional virtual root geometry */
   int		fd;		/* connection */
   queue_t *	qp;		/* queue */
   u32_t	id;		/* xmc id of this server */
   hostaddr_t	addr;		/* defines host */
   u16_t	seqno;		/* sequence number of last reply */
   u16_t	display;	/* display number */
   u16_t	screen;		/* screen number */
   u16_t	nexts;		/* number of extensions */
   ext_t *	exts;		/* extensions supported */
   sm_t *	smp;		/* sequence number map */
   char *	block;		/* connection block */
   smap_t	smap;		/* server resource map */
   pp_t *	pp;		/* incoming partial packet info */
   tp_t *	tpp;		/* telepointer assigned to this server */
   struct _server_t *next;	/* next input server */
}server_t;

typedef struct _port_t {
   u16_t	family;		/* socket address family */
}port_t;

/*
**	visual info
*/
typedef struct _visual_t {
   rid_t		cid;		/* visualID */
   u8_t			class;		/* class */
   u8_t			depth;		/* depth */
   u16_t		bprgb;		/* bitsPerRGB */
   u16_t		nentries;	/* colormapEntries */
   mask_t		rmask;		/* redMask */
   mask_t		gmask;		/* greenMask */
   mask_t		bmask;		/* blueMask */
   struct _visual_t *	next;
}visual_t;

typedef struct _colormap_t {
   resource_t		res;		/* common block header */
   u8_t			installed;	/* installed ? */
   u8_t			bpc;		/* bits per color */
   u8_t			mappixels;	/* need to map pixel values */
   u8_t			depth;		/* depth of window used to create */
   rid_t		cid;		/* client id */
   rid_t		vid;		/* virtual id */
   rid_t		wid;		/* dummy window id */
   visual_t *		vp;		/* visual of this colormap */
   cmap_t *		cmap;		/* internal rep of colormap */
   plist_t *		winlist;	/* windows that use this colormap */
   struct _colormap_t *	last;
   struct _colormap_t *	next;
}colormap_t;

/*
**	inputmask data structure
*/
typedef struct _masknode_t	masknode_t;	/* imask.c (opaque) */

typedef struct _inmask_t {
   mask_t		mask;		/* composite mask */
   masknode_t *		mnp;		/* list of client/mask pairs */
}inmask_t;

/*
**	window info
*/
typedef struct _window_t {
   drawable_t		dwb;		/* drawable info */
   rid_t		cid;		/* real client's resource id */
   rid_t		vid;		/* virtual client resource id */
   u8_t			mapped;		/* mapped? */
   u16_t		level;		/* level in window heirarchy */
   s16_t		x, y;		/* location */
   u16_t		borderwidth;
   u16_t		class;
   visual_t *		vp;		/* visual */
   cursor_t *		cursp;		/* cursor of this window (or null) */
   pixmap_t *		bgpxp;		/* background pixmap */
   pixmap_t *		bdpxp;		/* border pixmap */
   mask_t		attmask;	/* value mask - which atts were set? */
   u32_t		atts[15];	/* attributes */
   prop_t *		props;		/* property list */
   inmask_t *		xmask;		/* x client event mask(s) */
   inmask_t *		xmcmask;	/* xmc client event mask(s) */
   mask_t		compmask;	/* composite mask */
   grab_t *		buttons;	/* list of button grabs */
   grab_t *		keys;		/* list of key grabs */
   colormap_t *		mp;		/* colormap */
   expvec_t *		expos_q;	/* queue of pending exposures */
   plist_t *		saveset;	/* clients whose savesets we're in */
   struct _window_t *	parent;		/* parent window */
   struct _window_t *	prevsib;	/* previous sibling */
   struct _window_t *	nextsib;	/* next sibling */
   struct _window_t *	child;		/* children */
}window_t;

typedef struct {
   u8_t			depth;		/* depth */
   rid_t		pixmap;		/* a throwaway pixmap */
   rid_t		gc;		/* xmx-private gc */
}screendepth_t;

typedef struct {
   pixel_t		whitePixel;
   pixel_t		blackPixel;
   u16_t		pixWidth;
   u16_t		pixHeight;
   u16_t		mmWidth;
   u16_t		mmHeight;
   u16_t		minInstalledMaps;
   u16_t		maxInstalledMaps;
   uint_t		maxcols;	/* max no. of colors to alloc */
   u8_t			backingStore;
   u8_t			saveUnders;
   colormap_t *		colormap;	/* default colormap */
   rid_t		vservroot;	/* maps to the real root window */
   rid_t		vservcmap;	/* maps to the real default cmap */
   rid_t		rootpixmap;	/* rootweave pattern */
   rid_t		borderpixmap;	/* all black */
   rid_t		rootcmap;	/* maps to real or root cmap */
   rid_t		iconpixmap;	/* xmx's icon pixmap */
   rid_t		shellroot;	/* "shell" root window id */
   rid_t		rootvid;	/* virtual root id */
   rid_t		cmapvid;	/* virtual root cmap id, if needed */
   rid_t		cursor;		/* maps to xmx's root cursor */
   drawable_t *		shdp;		/* shell drawable (needed?) */
   window_t *		wp;		/* root window */
   int			ndepths;	/* number of depths */
   screendepth_t *	dv;		/* vector of supported depths */
   screendepth_t *	dp;		/* pointer to root depth */
}screen_t;

/*
**	socket connection identifier
*/
typedef struct {		/* per socket/connection information */
   u16_t		type;		/* socket/connection type */
   buffer_t *		bp;		/* input buffer */
   union {
      port_t *		pp;
      server_t *	sp;
      client_t *	cp;
      xmc_t *		xp;
   }u;
}conn_t;

/************************************************************************
*									*
*   Global data								*
*									*
************************************************************************/
#ifdef DEFINE_GLOBALS
#define extern
#endif

extern uint_t debug;		/* debug level */
extern opts_t opt;		/* options */

extern int xmx_version_major;	/* major version number of this XMX */
extern int xmx_version_minor;	/* minor version number of this XMX */
extern char *xmx_release_status;/* release status of this XMX */
extern int xmx_patchlevel;	/* patchlevel of this XMX */

extern char endian;		/* 'B' if big-endian, 'l' if little-endian */

extern int num_serv;		/* number of servers in list */
extern server_t **servers;	/* server list */

extern int num_clients;		/* number of clients in list */
extern client_t **clients;	/* client list */

extern char *hostname;		/* our hostname */
extern int hostnamelen;		/* */
extern hostaddr_t me;		/* address of local machine */

extern screen_t vscreen;	/* virtual screen */

extern int vcstate;		/* state of virtual configuration */
extern hashtab_t *vmap;		/* virtual configuration resource id map */
extern iord_t viordv[MAXDEPTH+1];/* virtual configuration image data orders */
extern int config_mode;		/* ConfigAllow or ConfigDelay */

extern rxq_t *zrxqp;		/* client zero reply context queue */

extern mask_t seatmask;		/* SETME! event mask for SEAT mode servers */
extern server_t *qservp;	/* designated query server */

extern int exposures;		/* boolean - are there pending exposures? */
extern int ntimeouts;		/* number of clients or servers on the clock */

extern etime_t vtime;		/* virtual server current time */

extern window_t *focuswp;	/* current focus window */
extern window_t *ptrwp;		/* current pointer window */

extern conn_t *cv;		/* connection vector */

extern u32_t win_defs[IWCount];	/* window attribute defaults */
extern u32_t gc_defs[IGCount];	/* gc attribute defaults */

extern iord_t bmiord;		/* order of bitmaps (from "bitmap" program) */

#ifdef extern
#undef extern
#endif

/************************************************************************
*									*
*   Portability								*
*									*
************************************************************************/
#ifndef MAXHOSTNAMELEN
#ifdef SYS_NMLN
#define MAXHOSTNAMELEN	SYS_NMLN
#else
#define MAXHOSTNAMELEN	32
#endif
#endif

#ifdef SYSV
#ifdef index
#undef index
#endif
#define index(a,b)	strchr(a,b)
#define bcopy(a,b,c)	memcpy(b,a,c)
#define bcmp(a,b,c)	memcmp(b,a,c)
#define bzero(a,b)	memset(a,0,b)
#ifndef hpux
#define signal(a,b)	sigset(a,b)
#endif
#endif

#include "../include/funcproto.h"
