/*
 * Copyright 1991-1998, Brown University, Providence, RI.
 * 
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose other than its incorporation into a
 * commercial product is hereby granted without fee, provided that the
 * above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Brown University not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * BROWN UNIVERSITY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR ANY
 * PARTICULAR PURPOSE.  IN NO EVENT SHALL BROWN UNIVERSITY BE LIABLE FOR
 * ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */
/************************************************************************
*									*
*   vconf.h								*
*									*
*									*
************************************************************************/

#define VENDOR		"Brown University Computer Science"
#define X_MAJOR_VERSION	11
#define X_MINOR_VERSION	0

#define RELEASE		(VERSION_MAJOR*1000 + VERSION_MINOR*100 + PATCHLEVEL)

/*
**  In the virtual config, all keycodes are possible
*/
#define MIN_KEYCODE	8
#define MAX_KEYCODE	255
/*
**  per server hash table size
*/
#define VCONF_HASHSIZE	32

#define DOTSPERINCH	72.0
#define PXL2MM(pval)	(((double)(pval)/DOTSPERINCH) * 25.4)

#define VCSET_NONE	0x00
#define VCSET_SIZE	0x01
#define VCSET_DEPTHS	0x02
#define VCSET_EXTS	0x04

typedef struct _vtype_t {
   xVisualType		visual;
   xVisualType *	visualp;
   int			match;
   struct _vtype_t *	next;
}vtype_t;

typedef struct _depth_t {
   xDepth		depth;
   vtype_t *		vp;
   int			match;
   struct _depth_t *	next;
}depth_t;

typedef struct _format_t {
   xPixmapFormat	format;
   xPixmapFormat *	formatp;
   int			match;
   struct _format_t *	next;
}format_t;

typedef struct _extname_t {
   char *		name;
   int			match;
   struct _extname_t *	next;
}extname_t;

typedef struct _vconf_t {
   xConnSetupPrefix	prefix;
   xConnSetupPrefix *	prefixp;
   xConnSetup		setup;
   xConnSetup *		setupp;
   format_t *		fp;
   xWindowRoot		root;
   xWindowRoot *	rootp;
   depth_t *		dp;
   vtype_t *		rootvp;
   int			nexts;
   extname_t *		ep;
}vconf_t;

/*
**  depth constraint structure
*/
typedef struct _dcons_t {
   u8_t			depth;
   u8_t			classmask;
   struct _dcons_t *	next;
}dcons_t;

/*
**  virtual config constraint structure
*/
typedef struct _vcons_t {
   uint_t		mask;
   u16_t		width;
   u16_t		height;
   u8_t			rootdepth;
   u8_t			rootclass;
   dcons_t *		dcp;
   int			nextnames;
   char **		extnamep;
}vcons_t;
