/*
 * Copyright 1991-1998, Brown University, Providence, RI.
 * 
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose other than its incorporation into a
 * commercial product is hereby granted without fee, provided that the
 * above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Brown University not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * BROWN UNIVERSITY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR ANY
 * PARTICULAR PURPOSE.  IN NO EVENT SHALL BROWN UNIVERSITY BE LIABLE FOR
 * ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */
/************************************************************************
*									*
*    server.c								*
*									*
*	Routines to manage X server list.				*
*									*
************************************************************************/
#define NEED_REPLIES
#define NEED_EVENTS
#include <X11/Xproto.h>
#include <xmc.h>
#include "xmx.h"
#include "df.h"
#include "res.h"
#include "kpm.h"
#include "incl/server.pvt.h"

static int	max_serv = 0;

/************************************************************************
*									*
*    server_alloc							*
*									*
*	Allocate a server structure and link it into the servers list.	*
*	Returns the server structure.					*
*									*
************************************************************************/
server_t *
server_alloc
   AL((id, tag, taglen, family, length, address, display, screen, mode,
						window, geomp))
   DB u32_t id
   DD char *tag
   DD int taglen
   DD u16_t family
   DD u16_t length
   DD char *address
   DD u16_t display
   DD u16_t screen
   DD u8_t mode
   DD rid_t window
   DD geom_t *geomp
   DE
{
   register int i;
   register server_t *sp;
   register server_t **tserv;

   for (i=0; i<num_serv; i++)
      if (id == servers[i]->id)
         if (	family == servers[i]->addr.family &&
		display == servers[i]->display &&
		screen == servers[i]->screen &&
		length == servers[i]->addr.length &&
		bcmp(address, servers[i]->addr.address, length) == 0)
            return servers[i];
         else
            return (server_t *)0;	/* an error */

   if (MALLOC(sp, server_t *, sizeof(server_t)))
      return (server_t *)0;

   if (server_set_tag(sp, taglen, tag)) {
      free(sp);
      return (server_t *)0;
   }
   if (length) {
      if (MALLOC(sp->addr.address, char *, length)) {
         free(sp->tag);
         free(sp);
         return (server_t *)0;
      }
      bcopy(address, sp->addr.address, length);
   }
   sp->mode = mode;
   newstate(sp, S_NAMED);
   sp->lastq = 0;
   sp->grabbed = 0;
   sp->cookie = 0;
   sp->geomp = geomp;
   sp->fd = -1;
   sp->qp = queue_new(Q_XSERVER, (char *)sp);
   sp->id = id;
   sp->addr.family = family;
   sp->addr.length = length;
   sp->seqno = 1;
   sp->display = display;
   sp->screen = screen;
   sp->nexts = 0;
   sp->exts = 0;
   if ((sp->smp = sm_alloc()) == 0) {
      if (length)
         free(sp->addr.address);
      free(sp->tag);
      free(sp);
      return (server_t *)0;
   }
   sp->block = 0;
   sp->smap.base = 0;
   sp->smap.mask = 0;
   sp->smap.minkey = 0;
   sp->smap.keycnt = 0;
   sp->smap.shift = 0;
   bzero(&sp->smap.iordv[0], (MAXDEPTH+1)*sizeof(iord_t));
   sp->smap.amp = am_alloc();
   sp->smap.mp = 0;
   sp->smap.ktmp = kpm_new_ktm();

   sp->smap.root.flags = 0;
   sp->smap.root.whitePixel = 0;
   sp->smap.root.blackPixel = 0;
   sp->smap.root.pixWidth = 0;
   sp->smap.root.pixHeight = 0;
   sp->smap.root.ok = 0;
   sp->smap.root.xoff = 0;
   sp->smap.root.yoff = 0;
   sp->smap.root.width = 0;
   sp->smap.root.height = 0;
   if (opt.owncmap)
      sp->smap.root.flags |= RF_OWNCMAP;
   sp->smap.root.realcmap = 0;
   if (window)
      sp->smap.root.realshell = window;
   else {
      sp->smap.root.flags |= RF_OWNROOT;
      sp->smap.root.realshell = 0;
   }
   sp->smap.root.pmap = 0;
   sp->smap.root.currentInputMask = 0;

   sp->pp = 0;
   sp->tpp = 0;

   sp->next = (server_t *)0;
#ifdef DEBUG
   if (sizeof(server_t) != 196)
      warn("server_alloc: not updated since server_t last changed [%d]\n",
							sizeof(server_t));
#endif

   if (num_serv + 1 > max_serv) {
      if (CALLOC(tserv, server_t **, max_serv+256, sizeof(server_t *)))
         return 0;

      max_serv += 256;
      if (servers) {
         bcopy(servers, tserv, num_serv * sizeof(server_t *));
         free(servers);
      }
      servers = tserv;
   }
   servers[num_serv++] = sp;
   return sp;
}
int
server_set_tag
   AL((sp, taglen, tag))
   DB server_t *sp
   DD int taglen
   DD char *tag
   DE
{
   if (sp->taglen = taglen) {
      if (MALLOC(sp->tag, char *, taglen + 1))
         return -1;
      bcopy(tag, sp->tag, taglen);
      sp->tag[taglen] = '\0';
   }
   else
      sp->tag = "";

   return 0;
}

static int statevec[S_NSTATES];

void
server_state
   AL((sp, state))
   DB server_t *sp
   DD u8_t state
   DE
{
   if (statevec[sp->state])
      statevec[sp->state]--;

   statevec[state]++;

   sp->state = state;
}

static void
newstate
   AL((sp, state))
   DB server_t *sp
   DD u8_t state
   DE
{
   statevec[state]++;

   sp->state = state;
}

static void
nostate
   AL((sp))
   DB server_t *sp
   DE
{
   if (statevec[sp->state])
      statevec[sp->state]--;
}

int
server_count
   AL((state))
   DB u8_t state
   DE
{
   return statevec[state];
}

/************************************************************************
*									*
*   server_free								*
*									*
************************************************************************/
int
server_free
   AL((sp))
   DB server_t *sp
   DE
{
   register int i, j;
   register server_t *nsp;

   for (i=0; i<num_serv; i++)
      if (servers[i] == sp) {
         if (sp == qservp) {		/* if deleting qserv, replace it */
            nsp = 0;
            for (j=0; j<num_serv; j++)
               if (servers[j] != qservp) {
                  if (nsp) {
                     if (servers[j]->mode > nsp->mode)
                        nsp = servers[j];
                  }
                  else
                     nsp = servers[j];
                  if (nsp->mode == Floor)
                     break;
               }
            qservp = nsp;
         }
         if (sp->pp)
            pp_free(sp->pp);
         if (sp->qp)
            queue_free(sp->qp);
         if (sp->taglen)
            free(sp->tag);
         if (sp->cookie)
            cookie_free(sp->cookie);
         if (sp->geomp)
            free(sp->geomp);
         if (sp->addr.address)
            free(sp->addr.address);
         if (sp->smp)
            sm_free(sp->smp);
         if (sp->smap.amp)
            am_free(sp->smap.amp);
         if (sp->smap.mp)
            hash_free(sp->smap.mp);
         if (sp->smap.ktmp)
            kpm_free_ktm(sp->smap.ktmp);
         nostate(sp);
         free(sp);
         servers[i] = servers[--num_serv];
         servers[num_serv] = (server_t *)0;

         if (num_serv == 0)
            quit(1, "no X servers, exiting...\n");

         return 0;
      }
   return 1;
}

/************************************************************************
*									*
*   server_find								*
*									*
*	This needs to be a hash table. (TODO)				*
*									*
************************************************************************/
server_t *
server_find
   AL((id))
   DB u32_t id
   DE
{
   register int i;

   for (i=0; i<num_serv; i++)
      if (servers[i]->id == id)
         return servers[i];

   return (server_t *)0;
}
