/*
 * Copyright 1991-1998, Brown University, Providence, RI.
 * 
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose other than its incorporation into a
 * commercial product is hereby granted without fee, provided that the
 * above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Brown University not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * BROWN UNIVERSITY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR ANY
 * PARTICULAR PURPOSE.  IN NO EVENT SHALL BROWN UNIVERSITY BE LIABLE FOR
 * ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */
#include <xmc.h>
#include <xmclib.h>
#include <xmcp.h>
#include "common.h"

DispId *
XmcListDisplaysWithInfo
   AL((muxp, ndisp_return, info_return))
   DB Mux *muxp
   DD int *ndisp_return
   DD XmcDispInfo **info_return
   DE
{
   register int i, n;
   register char *cp;
   xmcListDisplaysWithInfoReq *p;
   xmcListDisplaysWithInfoReply *r;
   DispId *dispp;
   XmcDispInfo *infop;

   p = (xmcListDisplaysWithInfoReq *)Xmc_allocout(muxp,
						sz_xmcListDisplaysWithInfoReq);

   p->code = XMC_ListDisplaysWithInfo;
   p->length = sz_xmcListDisplaysWithInfoReq;

   muxp->outseqno++;

   Xmc_flush(muxp);

   if ((r = (xmcListDisplaysWithInfoReply *)Xmc_reply(muxp)) == 0)
      return 0;

   if ((n = r->count) == 0) {
      /*
      **  If count is zero, there are no displays and we're done.
      */
      dispp = 0;
      infop = 0;
   }
   else if ((dispp = (DispId *)malloc(n * sizeof(DispId))) == 0 ||
   	(infop = (XmcDispInfo *)malloc(n * sizeof(XmcDispInfo))) == 0) {
      /*
      **  got malloc error
      */
      if (dispp) {
         free(dispp);
         dispp = 0;
      }
   }
   else {
      /*
      **  happiness
      */
      for (i=0;;) {
         dispp[i] = r->dispID;

         cp = (char *)(r + 1);

         if (r->nBytesAddress) {
            if ((infop[i].addrp = (char *)malloc(r->nBytesAddress)) == 0) {
               free(dispp);
               XmcFreeDisplayInfo(infop, i);
               dispp = 0;
               break;	/* exit */
            }
            bcopy(cp, infop[i].addrp, r->nBytesAddress);
            cp += r->nBytesAddress;
         }
         else
            infop[i].addrp = 0;

         if (r->nBytesTag) {
            if ((infop[i].tag = (char *)malloc(r->nBytesTag + 1)) == 0) {
               free(dispp);
               XmcFreeDisplayInfo(infop, i+1);
               dispp = 0;
               break;	/* exit */
            }
            bcopy(cp, infop[i].tag, r->nBytesTag);
            infop[i].tag[r->nBytesTag] = '\0';
            cp += r->nBytesTag;
         }
         else
            infop[i].tag = 0;

         infop[i].mode = r->mode;
         infop[i].screen = r->screen;
         infop[i].display = r->displayNumber;
         infop[i].family = r->family;
         infop[i].addrlen = r->nBytesAddress;
         infop[i].tpID = r->tpID;
         infop[i].window = r->window;

         if (++i < n) {
            /*
            **  more coming...
            */
            Xmc_inclear(muxp, r->length);

            if ((r = (xmcListDisplaysWithInfoReply *)Xmc_reply(muxp)) == 0) {
               free(dispp);
               XmcFreeDisplayInfo(infop, i);
               dispp = 0;
               break;	/* exit */
            }
         }
         else
            break;	/* normal loop exit */
      }
   }
   Xmc_inclear(muxp, r->length);

   if (dispp) {
      *ndisp_return = n;
      *info_return = infop;
   }
   return dispp;
}

void
XmcFreeDisplayInfo
   AL((dispinfo, ndisp))
   DB XmcDispInfo *dispinfo
   DD int ndisp
   DE
{
   register int i;

   for (i=0; i<ndisp; i++) {
      if (dispinfo[i].addrp)
         free(dispinfo[i].addrp);
      if (dispinfo[i].tag)
         free(dispinfo[i].tag);
   }
   free(dispinfo);
}
