/*
 * Copyright 1991-1997, Brown University, Providence, RI.
 * 
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose other than its incorporation into a
 * commercial product is hereby granted without fee, provided that the
 * above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Brown University not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * BROWN UNIVERSITY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR ANY
 * PARTICULAR PURPOSE.  IN NO EVENT SHALL BROWN UNIVERSITY BE LIABLE FOR
 * ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */
/* next line is debugging...TODO */
#include <stdio.h>
#ifdef __STDC__
#include <stdarg.h>
#else
#include <varargs.h>
#endif
#include <X11/Xlib.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include <X11/Xaw/Simple.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Toggle.h>
#include <X11/Xaw/Viewport.h>

#include "ui.h"
#include "callbacks.h"

dialog_t *open_d;
dialog_t *save_d;
dialog_t *add_d;
dialog_t *drop_d;
error_t *errors;

static dialog_t *new_dialog();
static void center_popup();

static void popdown_error_cb();

void
ui_create(top, floor, seat, view, gridp)
   Widget top;
   int floor, seat, view;
   Widget *gridp;
{
   Widget parent;
   Widget w, shell, dialog, menu, radio;
   Dimension width, height;

   parent = XtCreateManagedWidget("parent", formWidgetClass, top, 0, 0);

   /*
   **	File button and pulldown
   */
   ui_create_pulldown("file", parent, &menu);
      /*
      **   Open menu element & dialog
      */
   open_d = new_dialog(top);
   open_d->enable = XtCreateManagedWidget("open", smeBSBObjectClass, menu, 0,0);
   ui_create_dialog("open", open_d, parent, OPEN_PROMPT);
   ui_create_dialog_dismiss("accept", open_d, open_cb, open_d->dialog);
   ui_create_dialog_dismiss("cancel", open_d, 0, 0);
      /*
      **   Save menu element & dialog
      */
   save_d = new_dialog(top);
   save_d->enable = XtCreateManagedWidget("save", smeBSBObjectClass, menu, 0,0);
   ui_create_dialog("save", save_d, parent, SAVE_PROMPT);
   ui_create_dialog_dismiss("accept", save_d, save_cb, save_d->dialog);
   ui_create_dialog_dismiss("cancel", save_d, 0, 0);

   (void)XtCreateManagedWidget("line", smeLineObjectClass, menu, 0, 0);
      /*
      **   Quit menu element
      */
   w = XtCreateManagedWidget("quit", smeBSBObjectClass, menu, 0, 0);
   XtAddCallback(w, XtNcallback, quit_cb, 0);

   /*
   **	Select button and pulldown
   */
   ui_create_pulldown("select", parent, &menu);
      /*
      **   All menu element
      */
   w = XtCreateManagedWidget("all", smeBSBObjectClass, menu, 0, 0);
   XtAddCallback(w, XtNcallback, all_cb, 0);

   /*
   **	Preferences button and pulldown
   */
   ui_create_pulldown("pref", parent, &menu);
      /*
      **   Tba menu element
      */
   w = XtCreateManagedWidget("tba", smeBSBObjectClass, menu, 0, 0);

   /*
   **	Telepointer toggle
   */
   w = XtCreateManagedWidget("teleptr", toggleWidgetClass, parent, 0,0);
   XtVaSetValues(w, XtNstate, True, 0);
   XtAddCallback(w, XtNcallback, teleptr_cb, 0);

   /*
   **	Add button and dialog
   */
   add_d = new_dialog(top);
   add_d->enable = XtCreateManagedWidget("add",commandWidgetClass,parent,0,0);
   ui_create_add_dialog(add_d, parent, ADD_PROMPT, floor, seat, view);

   /*
   **	Drop button and dialog
   */
   drop_d = new_dialog(top);
   drop_d->enable = XtCreateManagedWidget("drop",commandWidgetClass,parent,0,0);
   ui_create_drop_dialog(drop_d, parent, DROP_PROMPT);

   /*
   **	Floor/Seat/View buttons
   */
   w = XtCreateManagedWidget("floor", commandWidgetClass, parent, 0,0);
   XtAddCallback(w, XtNcallback, floor_cb, 0);
   w = XtCreateManagedWidget("seat", commandWidgetClass, parent, 0,0);
   XtAddCallback(w, XtNcallback, seat_cb, 0);
   w = XtCreateManagedWidget("view", commandWidgetClass, parent, 0,0);
   XtAddCallback(w, XtNcallback, view_cb, 0);
   /*
   **	Grab buttons
   */
   w = XtCreateManagedWidget("grab", commandWidgetClass, parent, 0,0);
   XtAddCallback(w, XtNcallback, grab_cb, 0);

   /*
   **	Error popup
   */
   errors = ui_create_error(top, parent);

   /*
   **   Main window
   */
   w = XtCreateManagedWidget(		"viewport",
					viewportWidgetClass,
					parent,
					0,
					0);
   *gridp = XtCreateManagedWidget(	"grid",
					simpleWidgetClass,
					w,
					0,
					0);
}

void
ui_create_radio(name, parent, value, leader, buttonp)
   String name;
   Widget parent;
   int value;
   Widget leader;
   Widget *buttonp;
{
   Widget w;

   w = XtCreateManagedWidget(name, toggleWidgetClass, parent, 0, 0);
   
   if (leader)
      XtVaSetValues(w, XtNradioData, value, XtNradioGroup, leader, 0);
   else
      XtVaSetValues(w, XtNradioData, value, 0);

   if (buttonp)
      *buttonp = w;
}

static void
blort(w, c, d)
   Widget w;
   XtPointer c,d;
{
printf("BLORT!\n");
}

ui_create_add_dialog(dp, parent, prompt, floor, seat, view)
   dialog_t *dp;
   Widget parent;
   char *prompt;
   int floor, seat, view;
{
   Widget w, input, radio;
   add_d_t *adp;

   dp->shell = XtCreatePopupShell(	"add_shell",
					transientShellWidgetClass,
					parent,
					0,
					0);
   if (dp->shell) {
XtAddCallback(dp->enable, XtNcallback, blort, (XtPointer)dp);
      XtAddCallback(dp->enable, XtNcallback, center_popup, (XtPointer)dp);
      XtAddCallback(dp->enable,XtNcallback,XtCallbackNone,(XtPointer)dp->shell);

      dp->dialog = XtCreateManagedWidget(	"add_form",
						formWidgetClass,
						dp->shell,
						0,
						0);
      w = XtCreateManagedWidget("add_label", labelWidgetClass, dp->dialog,0,0);
      XtVaSetValues(w,	XtNlabel, prompt,
			XtNborderWidth, 0,
			0);

      input = XtCreateManagedWidget(	"input",
					asciiTextWidgetClass,
					dp->dialog,
					0,
					0);
      XtVaSetValues(input,	XtNeditType, XawtextEdit,
				XtNpieceSize, 128,
				XtNtype, XawAsciiString,
				0);

      /*
      **   Floor/Seat/View radio group
      */
      w = XtCreateManagedWidget("mode_label", labelWidgetClass,dp->dialog,0,0);
      XtVaSetValues(w,	XtNlabel, "Input mode:",
			XtNborderWidth, 0,
			0);
      ui_create_radio("floor", dp->dialog, floor, 0, &radio);
      ui_create_radio("seat", dp->dialog, seat, radio, 0);
      ui_create_radio("view", dp->dialog, view, radio, 0);

      if ((adp = (add_d_t *)malloc(sizeof(add_d_t))) == 0)
         exit(-1);
      adp->input = input;
      adp->mode_radio = radio;
      ui_create_dialog_dismiss("accept", dp, add_cb, (XtPointer)adp);
      ui_create_dialog_dismiss("cancel", dp, 0, 0);
   }
}

ui_create_drop_dialog(dp, parent, prompt)
   dialog_t *dp;
   Widget parent;
   char *prompt;
{
   Widget w;

   dp->shell = XtCreatePopupShell(	"drop_shell",
					transientShellWidgetClass,
					parent,
					0,
					0);
   if (dp->shell) {
      XtAddCallback(dp->enable, XtNcallback, center_popup, (XtPointer)dp);
      XtAddCallback(dp->enable,XtNcallback,XtCallbackNone,(XtPointer)dp->shell);

      dp->dialog = XtCreateManagedWidget(	"drop_form",
						formWidgetClass,
						dp->shell,
						0,
						0);
      w = XtCreateManagedWidget("drop_label", labelWidgetClass, dp->dialog,0,0);
      XtVaSetValues(w,	XtNlabel, prompt,
			XtNborderWidth, 0,
			0);

      ui_create_dialog_dismiss("accept", dp, drop_cb, 0);
      ui_create_dialog_dismiss("cancel", dp, 0, 0);
   }
}

void
ui_create_pulldown(name, parent, menup)
   String name;
   Widget parent;
   Widget *menup;
{
   Widget w;
   char buf[64];

   sprintf(buf, "%s_menu", name);

   w = XtCreateManagedWidget(		name,
					menuButtonWidgetClass,
					parent,
					0,
					0);
   *menup = XtCreatePopupShell(		buf,
					simpleMenuWidgetClass,
					parent,
					0,
					0);
}

void
ui_create_dialog(name, dp, parent, prompt)
   String name;
   dialog_t *dp;
   Widget parent;
   String prompt;
{
   dp->shell = XtCreatePopupShell(	name,
					transientShellWidgetClass,
					parent,
					0,
					0);
   if (dp->shell) {
      dp->dialog = XtCreateManagedWidget("dialog",
					dialogWidgetClass,
					dp->shell,
					0,
					0);
      XtVaSetValues(dp->dialog, XtNlabel, prompt, XtNvalue, "", 0);
      XtAddCallback(dp->enable, XtNcallback, center_popup, (XtPointer)dp);
      XtAddCallback(dp->enable,XtNcallback,XtCallbackNone,(XtPointer)dp->shell);
   }
}

void
ui_create_dialog_dismiss(name, dp, callback, data)
   String name;
   dialog_t *dp;
   XtCallbackProc callback;
   XtPointer data;
{
   Widget w;
   XtPopdownIDRec *pdp;

   w = XtCreateManagedWidget(name, commandWidgetClass, dp->dialog, 0, 0);
   if (callback) {
      dp->accept = w;
      XtAddCallback(w, XtNcallback, callback, data);
   }
   else
      dp->cancel = w;

   if ((pdp = (XtPopdownIDRec *)malloc(sizeof(XtPopdownIDRec))) == 0)
      exit(-1);
   pdp->shell_widget = dp->shell;
   pdp->enable_widget = dp->enable;
   XtAddCallback(w, XtNcallback, XtCallbackPopdown, (XtPointer)pdp);
}

error_t *
ui_create_error(top, parent)
   Widget top;
   Widget parent;
{
   error_t *ep;

   if ((ep = (error_t *)malloc(sizeof(error_t))) == 0)
      exit(-1);
   ep->top = top;

   ep->shell = XtCreatePopupShell(	"error",
					transientShellWidgetClass,
					parent,
					0,
					0);
   if (ep->shell) {
      ep->form = XtCreateManagedWidget(	"error_form",
					formWidgetClass,
					ep->shell,
					0,
					0);
      ep->text = XtCreateManagedWidget(	"messages",
					asciiTextWidgetClass,
					ep->form,
					0,
					0);
   }
   ep->dismiss = XtCreateManagedWidget(	"dismiss",
					commandWidgetClass,
					ep->form,
					0,
					0);
   XtAddCallback(ep->shell, XtNpopupCallback, center_popup, (XtPointer)ep);
   XtAddCallback(ep->dismiss, XtNcallback, popdown_error_cb, (XtPointer)ep);

   return ep;
}

void
popdown_error_cb(w, client_data, call_data)
   Widget w;
   XtPointer client_data;
   XtPointer call_data;
{
   error_t *ep = (error_t *)client_data;

   XtPopdown(ep->shell);
}

char *
ui_get_dialog_string(dialog)
   Widget dialog;
{
   return XawDialogGetValueString(dialog);
}

int
ui_get_toggle_state(w)
   Widget w;
{
   Boolean state;

   XtVaGetValues(w, XtNstate, &state, 0);

   return (state == True);
}

void
ui_get_add_info(adp, strp, modep)
   add_d_t *adp;
   char **strp;
   int *modep;
{
   
   XtVaGetValues(adp->input, XtNstring, strp, 0);
   *modep = (int)XawToggleGetCurrent(adp->mode_radio);
}

void
ui_free_add_info(adp)
   add_d_t *adp;
{
   ui_free_string(adp->input);
}

void
ui_free_string(w)
   Widget w;
{
   XawAsciiSourceFreeString(w);
}

void
ui_popup_open()
{
   XtCallCallbacks(open_d->enable, XtNcallback, 0);
}

void
ui_popup_save()
{
   XtCallCallbacks(save_d->enable, XtNcallback, 0);
}

void
ui_popup_add()
{
   XtCallCallbacks(add_d->enable, XtNcallback, 0);
}

void
ui_dialog_accept(which)
   char *which;
{
   if (strcmp(which, "open") == 0)
      XtCallCallbacks(open_d->accept, XtNcallback, 0);
   else if (strcmp(which, "save") == 0)
      XtCallCallbacks(save_d->accept, XtNcallback, 0);
   else if (strcmp(which, "add") == 0)
      XtCallCallbacks(add_d->accept, XtNcallback, 0);
}

void
ui_dialog_cancel(which)
   char *which;
{
   if (strcmp(which, "open") == 0)
      XtCallCallbacks(open_d->cancel, XtNcallback, 0);
   else if (strcmp(which, "save") == 0)
      XtCallCallbacks(save_d->cancel, XtNcallback, 0);
   else if (strcmp(which, "add") == 0)
      XtCallCallbacks(add_d->cancel, XtNcallback, 0);
}

/************************************************************************
*									*
*   static routines							*
*									*
************************************************************************/

static dialog_t *
new_dialog(top)
   Widget top;
{
   dialog_t *dp;

   if ((dp = (dialog_t *)malloc(sizeof(dialog_t))) == 0)
      exit(-1);
   dp->top = top;

   return dp;
}

static void
center_popup(w, client_data, call_data)
   Widget w;
   XtPointer client_data;
   XtPointer call_data;
{
   Position x, y;
   Dimension sw, sh, dw, dh;
   popup_t *dp = (popup_t *)client_data;

   if (!XtIsRealized(dp->shell))
      XtRealizeWidget(dp->shell);

   XtVaGetValues(dp->top, XtNwidth, &sw, XtNheight, &sh, 0);
   XtVaGetValues(dp->shell, XtNwidth, &dw, XtNheight, &dh, 0);
   x = (Position)(sw/2 - dw/2);
   y = (Position)(sh/2 - dh/2);
   XtTranslateCoords(dp->top, x, y, &x, &y);
   if (x < 0) x = 0;
   if (y < 0) y = 0;
/*
printf("center_popup: doing XtVaSetValues of x and y...");
fflush(stdout);
*/
   XtVaSetValues(dp->shell, XtNx, x, XtNy, y, 0);
printf("done.\n");
fflush(stdout);
}

void
ui_error
#ifdef __STDC__
   (char *msg, ...)
#else
   (va_alist)
#endif
{
   char buf[128];
#ifdef __STDC__
   va_list pvar;

   va_start(pvar, msg);
#else
   va_list pvar;
   char *msg;

   va_start(pvar);
   msg = va_arg(pvar,char*);
#endif

   vsprintf(buf, msg, pvar);
   XtVaSetValues(errors->text, XtNstring, buf, 0);

   XtPopup(errors->shell, XtGrabNone);
}
