/*
 * Copyright 1991-1997, Brown University, Providence, RI.
 * 
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose other than its incorporation into a
 * commercial product is hereby granted without fee, provided that the
 * above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Brown University not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * BROWN UNIVERSITY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR ANY
 * PARTICULAR PURPOSE.  IN NO EVENT SHALL BROWN UNIVERSITY BE LIABLE FOR
 * ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */
/************************************************************************
*									*
*	ig_priv.h							*
*									*
************************************************************************/
#define DEFAULT_GRID_WIDTH	20
#define DEFAULT_GRID_HEIGHT	100

#define gridval(gp,row,col)	((gp)->grid[(row)*(gp)->gridw+(col)])


typedef struct _image_t {
   Pixmap		normal;
   Pixmap		invert;
   uchar_t *		image;
   uchar_t *		mask;
   Dimension		width;
   Dimension		height;
}image_t;

/*
**	node in view list
*/
typedef struct _IGView {
   image_t **		imagev;
   Dimension		width;
   Dimension		height;
   char *		fontname;
   XFontStruct *	fsp;
   int			ascent;
   int			descent;
   struct _IGView *	next;
}IGView_t;

typedef struct _IconGrid {
   int realized;		/* have graphics been initialized? */
   XtAppContext context;
   Widget widget;
   GC gc_xor;
   GC gc_copy;
   GC gc_invert;
   GC gc_flip;
   Dimension width, height;
   int vx, vy;			/* visible region - offset */
   Dimension vwidth, vheight;	/* visible region - size */
   IGIcon *curicon;		/* selected icon */
   int motion;			/* are we in motion? */
   int origx, origy;		/* click down location or hotspot */
   int lastx, lasty;		/* current move location */
   IGView viewp;		/* list of views */
   IGView curviewp;		/* current view (if null, text only) */
   int nstates;			/* no. of elements in state and image vectors */
   int nicons;			/* no. of icons in icon list */
   IGIcon *icons;		/* icon list */
   uint_t gridsz;		/* size of grid array in ptr units */
   IGIcon **grid;		/* 2d array of icon ptrs - the grid */
   uint_t gridw, gridh;		/* real grid size */
   uint_t gridlw, gridlh;	/* logical grid size */
   uint_t padx, pady;		/* grid padding */
   Dimension sqwidth, sqheight;	/* size of a grid square */
}IconGrid_t;

typedef struct _acn_t {
   XtAppContext		context;
   struct _acn_t *	next;
}acn_t;
