/*
This product contains certain software code or other information
("AT&T Software") proprietary to AT&T Corp. ("AT&T").  The AT&T
Software is provided to you "AS IS".  YOU ASSUME TOTAL RESPONSIBILITY
AND RISK FOR USE OF THE AT&T SOFTWARE.  AT&T DOES NOT MAKE, AND
EXPRESSLY DISCLAIMS, ANY EXPRESS OR IMPLIED WARRANTIES OF ANY KIND
WHATSOEVER, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, WARRANTIES OF
TITLE OR NON-INFRINGEMENT OF ANY INTELLECTUAL PROPERTY RIGHTS, ANY
WARRANTIES ARISING BY USAGE OF TRADE, COURSE OF DEALING OR COURSE OF
PERFORMANCE, OR ANY WARRANTY THAT THE AT&T SOFTWARE IS "ERROR FREE" OR
WILL MEET YOUR REQUIREMENTS.

Unless you accept a license to use the AT&T Software, you shall not
reverse compile, disassemble or otherwise reverse engineer this
product to ascertain the source code for any AT&T Software.

(c) AT&T Corp. All rights reserved.  AT&T is a registered trademark of AT&T Corp.

***********************************************************************

Description:

		Program to test the in-memory API to the XMill (de)compression routines

History:

      10/11/2002  - created by Hedzer Westra <hedzer@adlibsoft.com>

*/

#include "stdafx.h"

#ifdef WIN32
int _tmain(int argc, _TCHAR* argv[])
#else
int main(int argc, char* argv[])
#endif
{
#ifdef _DEBUG
	/* enable mem. leak dump at exit() */
	_CrtSetDbgFlag (_CRTDBG_LEAK_CHECK_DF );
	_CrtMemState state1, state2, state3;
	_CrtMemCheckpoint(&state1);
#endif

	int stat = 0;
	FILE *scriptfile = NULL;
	testsettings *testset = new testsettings();

	if (argc < 6 && argc != 2) {
		printf("usage:\n\t%s times "
				 "{\"bzip2\"|\"gzip\"|\"nozip\"|\"ppmdi\"} "
				 "{\"decomp\"|\"compdecomp\"|\"targetsize\"}"
				 "{\"lossless\"|\"lossy\"} "
				 "{\"plain\"|\"exprs\"} "
				 "[targetsize] file1 [file2 [..]]\n"
				 "\t%s script",
				 argv[0], argv[0]);
		goto cleanup;
	}

	printf("starting xmilltest\n\n");

	/* parse cmdline */
	if ((testset->times = atoi (argv[1])) == 0) {
		/* assume script */
		scriptfile = fopen(argv[1], "r");
	} else {
		for (int i=2; i<6; i++) {
			testset->parsesetting(argv[i]);
		}
	}

	if (scriptfile) {
		stat = testset->run(scriptfile);
	} else {
		stat = testset->run(&argv[6], argc-6);
	}

	if (stat != 0) {
		printf ("There were errors in testing...\n");
	}

cleanup:
	if (scriptfile) {
		fclose (scriptfile);
	}
	/* free all XMill memory and settings */
	delete testset;

#ifdef _DEBUG
	_CrtMemCheckpoint(&state2);
	_CrtMemDifference(&state3,&state1,&state2);
	_CrtMemDumpStatistics(&state3);
	_CrtDumpMemoryLeaks();
#endif

	printf("xmilltest done\n");

	return stat;
}

