/* XMLPPM: an XML compressor
Copyright (C) 2003 James Cheney

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contacting the author:
James Cheney
Computer Science Department
Cornell University
Ithaca, NY 14850

jcheney@cs.cornell.edu
*/
/****************************************************************************
 *  This file is part of PPMd project                                       *
 *  Written and distributed to public domain by Dmitry Shkarin 1997,        *
 *  1999-2001                                                               *
 *  Contents: PPMII model description and encoding/decoding routines        *
 ****************************************************************************/
/* Created 3/2003 by Hedzer Westra to interface to XMLPPM
 */

#include "stdafx.h"

PPMDIData::PPMDIData(PPMDI *f)
{
   //SubRange = {0,0,0};
   low = code = range = 0;

   allocsize = 0;
   alloc = NULL;

   setFp (f);
}

void PPMDIData::dropAlloc()
{
   if (alloc) {
      alloc->StopSubAllocator();
      delete alloc;
   }
}

PPMDIData::~PPMDIData()
{
   dropAlloc();
}

SubAlloc* PPMDIData::getAlloc(int size)
{
   if (!alloc || allocsize != size) {
      dropAlloc();
      alloc = new SubAlloc();
      alloc->StartSubAllocator(size);
      allocsize = size;
   }
   return alloc;
}

SubAlloc* PPMDIData::getAlloc()
{
   return alloc;
}

void PPMDIData::setFp(PPMDI *f)
{
   fp = f;
}

PPMDI* PPMDIData::getFp()
{
   return fp;
}