/*
This product contains certain software code or other information
("AT&T Software") proprietary to AT&T Corp. ("AT&T").  The AT&T
Software is provided to you "AS IS".  YOU ASSUME TOTAL RESPONSIBILITY
AND RISK FOR USE OF THE AT&T SOFTWARE.  AT&T DOES NOT MAKE, AND
EXPRESSLY DISCLAIMS, ANY EXPRESS OR IMPLIED WARRANTIES OF ANY KIND
WHATSOEVER, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, WARRANTIES OF
TITLE OR NON-INFRINGEMENT OF ANY INTELLECTUAL PROPERTY RIGHTS, ANY
WARRANTIES ARISING BY USAGE OF TRADE, COURSE OF DEALING OR COURSE OF
PERFORMANCE, OR ANY WARRANTY THAT THE AT&T SOFTWARE IS "ERROR FREE" OR
WILL MEET YOUR REQUIREMENTS.

Unless you accept a license to use the AT&T Software, you shall not
reverse compile, disassemble or otherwise reverse engineer this
product to ascertain the source code for any AT&T Software.

(c) AT&T Corp. All rights reserved.  AT&T is a registered trademark of AT&T Corp.

***********************************************************************

History:

      24/11/99  - initial release by Hartmut Liefke, liefke@seas.upenn.edu
                                     Dan Suciu,      suciu@research.att.com
*/

//********************************************************************
//********************************************************************

// This module contains the standard user compressors, such as 'u', 'u8', 'di', ...

#include "stdafx.h"

//********************************************************************
// For decompression, we have a couple of utility functions
inline void IntToStr(long val, char *tmpstr, int tmplen, char **retptr)
   // Converts an integer to a string and returns a pointer to the string
{
   char *ptr=tmpstr+tmplen-1; // We start from the back of the string
   *ptr='\0';

   if(val<0)
   {
      val=-val;
      do
      {
         ptr--;
         *ptr=(val%10)+'0';
         val=val/10;
      }
      while(val>0);

      ptr--;
      *ptr='-';
		*retptr = ptr;
      return;
   }
   else
   {
      do
      {
         ptr--;
         *ptr=(val%10)+'0';
         val=val/10;
      }
      while(val>0);

		*retptr = ptr;
      return;
   }
}

inline void PrintZeros(XMLOutput *output,unsigned long zeronum)
   // Prints a sequence of zero's
{
	/* read-only static */
   static char zerostr[]="0000000000";

   while(zeronum>10)
   {
      output->characters(zerostr,10);
      zeronum-=10;
   }
   output->characters(zerostr,zeronum);
}

#define TMPLEN 20

void PrintInteger(unsigned long val,char isneg,unsigned mindigits,XMLOutput *output)
{
	char  tmpstr[TMPLEN];
   char *ptr = NULL;

	IntToStr(val, tmpstr, TMPLEN, &ptr);
   unsigned len=strlen(ptr);

   if(isneg)
   {
      output->characters("-",1);
      if(mindigits>len+1)
         PrintZeros(output,mindigits-len-1);
   }
   else
   {
      if(mindigits>len)
         PrintZeros(output,mindigits-len);
   }
   output->characters(ptr,len);
}

//***************************************************************************
//***************************************************************************

char ParseUnsignedInt(char *str,int len,unsigned long *val)
   // Parses a given string as a unsigned integer
   // Returns 1 if successful, otherwise 0.
{
   *val=0;

   if(len==0)
      return 0;

   do
   {
      if((*val)>=107374180L)
         return 0;

      (*val)*=10;

      if((*str<'0')||(*str>'9'))
         return 0;

      (*val)+=(unsigned)(*str-'0');
      str++;
      len--;
   }
   while(len>0);

   return 1;
}

char ParseSignedInt(char *str,int len,unsigned long *val,unsigned char *neg)
   // Parses a given string as a signed integer
   // Returns 1 if successful, otherwise 0.
{
   if(len==0)
      return 0;

   *val=0;

   if(*str=='-')
   {
      *neg=1;
      str++;
      len--;
      if(len==0)
         return 0;
   }
   else
      *neg=0;

   do
   {
      if(*val>=536870000L)
         return 0;

      (*val)*=10;

      if((*str<'0')||(*str>'9'))
         return 0;

      (*val)+=(unsigned)(*str-'0');
      str++;
      len--;
   }
   while(len>0);

   return 1;
}

char ParseSignedInt(char *str,int len,long *val)
   // Parses a given string as a signed integer
   // Returns 1 if successful, otherwise 0.
{
   unsigned char isneg;
   if(ParseSignedInt(str,len,(unsigned long *)val,&isneg)==0)
      return 0;

   if(isneg)
      *val=0xFFFFFFFFL-*val;
   return 1;
}
