/*
This product contains certain software code or other information
("AT&T Software") proprietary to AT&T Corp. ("AT&T").  The AT&T
Software is provided to you "AS IS".  YOU ASSUME TOTAL RESPONSIBILITY
AND RISK FOR USE OF THE AT&T SOFTWARE.  AT&T DOES NOT MAKE, AND
EXPRESSLY DISCLAIMS, ANY EXPRESS OR IMPLIED WARRANTIES OF ANY KIND
WHATSOEVER, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, WARRANTIES OF
TITLE OR NON-INFRINGEMENT OF ANY INTELLECTUAL PROPERTY RIGHTS, ANY
WARRANTIES ARISING BY USAGE OF TRADE, COURSE OF DEALING OR COURSE OF
PERFORMANCE, OR ANY WARRANTY THAT THE AT&T SOFTWARE IS "ERROR FREE" OR
WILL MEET YOUR REQUIREMENTS.

Unless you accept a license to use the AT&T Software, you shall not
reverse compile, disassemble or otherwise reverse engineer this
product to ascertain the source code for any AT&T Software.

(c) AT&T Corp. All rights reserved.  AT&T is a registered trademark of AT&T Corp.

***********************************************************************

History:

      24/11/99  - initial release by Hartmut Liefke, liefke@seas.upenn.edu
                                     Dan Suciu,      suciu@research.att.com
*/

//**************************************************************************
//**************************************************************************

// This module contains a special decompressor sequential decompression
// of small blocks of data. The decompressor maintains a temporary buffer
// that keeps the small blocks and that can be read sequentially by
// the client.

#ifndef __SMALLUNCOMPRESS_HPP__
#define __SMALLUNCOMPRESS_HPP__

#include <string.h>

#include "ZLib.hpp"
#include "Error.hpp"

class SmallBlockUncompressor : public Uncompressor
{
   // The buffer
   unsigned char  *buf;
   unsigned long  bufsize;

   
   unsigned char  *curptr;       // The current pointer into the buffer
   unsigned long  curdatasize;   // The remaining size

   Input          *input;        // The input file
public:

   // Uncompresses at least len bytes
   void UncompressMore(unsigned long *len);

public:
   SmallBlockUncompressor(Session *s,Input *myinput);
   ~SmallBlockUncompressor();
   void Init();

   unsigned char *GetCurPtr();
   unsigned long GetCurDataSize();

	// Loads 'len' bytes from the decompressor
   // and returns the pointer
   unsigned char *LoadData(unsigned long len);

	// Loads a compressed integer
   unsigned long LoadUInt32();

	// Loads a compressed signed integer
   unsigned long LoadSInt32(char *isneg);

	// Loads a string - a string starts with a length field
   // and the actual data follows
   // The pointer to the string is stored in '*str' and
   // the length is returns
   unsigned long myLoadString(char **str);
};

#endif /* __SMALLUNCOMPRESS_HPP__ */
