/*
This product contains certain software code or other information
("AT&T Software") proprietary to AT&T Corp. ("AT&T").  The AT&T
Software is provided to you "AS IS".  YOU ASSUME TOTAL RESPONSIBILITY
AND RISK FOR USE OF THE AT&T SOFTWARE.  AT&T DOES NOT MAKE, AND
EXPRESSLY DISCLAIMS, ANY EXPRESS OR IMPLIED WARRANTIES OF ANY KIND
WHATSOEVER, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, WARRANTIES OF
TITLE OR NON-INFRINGEMENT OF ANY INTELLECTUAL PROPERTY RIGHTS, ANY
WARRANTIES ARISING BY USAGE OF TRADE, COURSE OF DEALING OR COURSE OF
PERFORMANCE, OR ANY WARRANTY THAT THE AT&T SOFTWARE IS "ERROR FREE" OR
WILL MEET YOUR REQUIREMENTS.

Unless you accept a license to use the AT&T Software, you shall not
reverse compile, disassemble or otherwise reverse engineer this
product to ascertain the source code for any AT&T Software.

(c) AT&T Corp. All rights reserved.  AT&T is a registered trademark of AT&T Corp.

***********************************************************************

History:

      24/11/99  - initial release by Hartmut Liefke, liefke@seas.upenn.edu
                                     Dan Suciu,      suciu@research.att.com
*/

//********************************************************************
//********************************************************************

// This module contains the standard user compressors, such as 'u', 'u8', 'di', ...

#include "stdafx.h"

// The simple print compressor 'p'
PrintCompressor::PrintCompressor(Session *s): UserCompressor(s)
{
	Init();
}

PrintCompressor::PrintCompressor(): UserCompressor()
{
	Init();
}

void PrintCompressor::Init()
{
   datasize=0;contnum=0;isrejecting=1;canoverlap=1;isfixedlen=0;
}

char PrintCompressor::ParseString(char *str,unsigned len,char *dataptr)
{
	char s[STRLEN+1];
	char *str1 = new char[len+1];

	/* create error text */
	strncpy(str1, str, len);
	str1[len] = '\0';
   _snprintf(s, STRLEN, "Could not compress '%s'", str1);
	s[STRLEN] = '\0';
	trydela(str1);

	/* print or throw exception */
	session->PrintCompressorOutput(s);

   return 0;
}

void PrintCompressor::CompressString(char *str,unsigned len,CompressContainer *cont,char *dataptr)
{
}

PrintUncompressor::PrintUncompressor(Session *s): UserUncompressor(s)
{
	Init();
}

PrintUncompressor::PrintUncompressor(): UserUncompressor()
{
	Init();
}

void PrintUncompressor::Init()
{
	datasize=0;contnum=0;
}

void PrintUncompressor::UncompressItem(UncompressContainer *cont,char *dataptr,XMLOutput *xoutput)
{
}

char *PrintCompressorFactory::GetName()         
{  
	return "p"; 
}
char *PrintCompressorFactory::GetDescription()  
{  
	return "Print compressor"; 
}

UserCompressor *PrintCompressorFactory::InstantiateCompressor(char *paramstr,int len)
{
   return &compressor;
}

UserUncompressor *PrintCompressorFactory::InstantiateUncompressor(char *paramstr,int len)
{
   return &uncompressor;
}
