/*
This product contains certain software code or other information
("AT&T Software") proprietary to AT&T Corp. ("AT&T").  The AT&T
Software is provided to you "AS IS".  YOU ASSUME TOTAL RESPONSIBILITY
AND RISK FOR USE OF THE AT&T SOFTWARE.  AT&T DOES NOT MAKE, AND
EXPRESSLY DISCLAIMS, ANY EXPRESS OR IMPLIED WARRANTIES OF ANY KIND
WHATSOEVER, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, WARRANTIES OF
TITLE OR NON-INFRINGEMENT OF ANY INTELLECTUAL PROPERTY RIGHTS, ANY
WARRANTIES ARISING BY USAGE OF TRADE, COURSE OF DEALING OR COURSE OF
PERFORMANCE, OR ANY WARRANTY THAT THE AT&T SOFTWARE IS "ERROR FREE" OR
WILL MEET YOUR REQUIREMENTS.

Unless you accept a license to use the AT&T Software, you shall not
reverse compile, disassemble or otherwise reverse engineer this
product to ascertain the source code for any AT&T Software.

(c) AT&T Corp. All rights reserved.  AT&T is a registered trademark of AT&T Corp.

***********************************************************************

History:

      24/11/99  - initial release by Hartmut Liefke, liefke@seas.upenn.edu
                                     Dan Suciu,      suciu@research.att.com
*/

//********************************************************************
//********************************************************************

// This module contains the standard user compressors, such as 'u', 'u8', 'di', ...

#include "stdafx.h"

// The simple text compressor 't'
PlainTextCompressor::PlainTextCompressor(Session *s): UserCompressor(s)
{
   datasize=0;contnum=1;isrejecting=0;canoverlap=1;isfixedlen=0;
}

void PlainTextCompressor::CompressString(char *str,unsigned len,CompressContainer *cont,char *dataptr)
{
   cont->StoreUInt32(len);
   cont->StoreData(str,len);
}

PlainTextUncompressor::PlainTextUncompressor(Session *s): UserUncompressor(s)
{
	Init();
}

PlainTextUncompressor::PlainTextUncompressor(): UserUncompressor()
{
	Init();
}

void PlainTextUncompressor::Init()
{
   datasize=0;contnum=1;
}

void PlainTextUncompressor::UncompressItem(UncompressContainer *cont,char *dataptr,XMLOutput *xoutput)
{
   unsigned long len=cont->LoadUInt32();

   xoutput->characters((char *)cont->GetDataPtr(len),len);
}

char *PlainTextCompressorFactory::GetName()         
{  
	return "t"; 
}
char *PlainTextCompressorFactory::GetDescription()  
{  
	return "Plain text compressor"; 
}

UserCompressor *PlainTextCompressorFactory::InstantiateCompressor(char *paramstr,int len)
{
   if(paramstr!=NULL)
   {
      XMillException *e = new XMillException(XMILL_ERR_ARGUMENTS, "Plain text compressor 't' should not have any arguments ('");
      e->ErrorCont(paramstr,len);
      e->ErrorCont("')");
      throw e;
   }
   return new PlainTextCompressor(session);
}

UserUncompressor *PlainTextCompressorFactory::InstantiateUncompressor(char *paramstr,int len)
{
   return &uncompressor;
}
