/*
This product contains certain software code or other information
("AT&T Software") proprietary to AT&T Corp. ("AT&T").  The AT&T
Software is provided to you "AS IS".  YOU ASSUME TOTAL RESPONSIBILITY
AND RISK FOR USE OF THE AT&T SOFTWARE.  AT&T DOES NOT MAKE, AND
EXPRESSLY DISCLAIMS, ANY EXPRESS OR IMPLIED WARRANTIES OF ANY KIND
WHATSOEVER, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, WARRANTIES OF
TITLE OR NON-INFRINGEMENT OF ANY INTELLECTUAL PROPERTY RIGHTS, ANY
WARRANTIES ARISING BY USAGE OF TRADE, COURSE OF DEALING OR COURSE OF
PERFORMANCE, OR ANY WARRANTY THAT THE AT&T SOFTWARE IS "ERROR FREE" OR
WILL MEET YOUR REQUIREMENTS.

Unless you accept a license to use the AT&T Software, you shall not
reverse compile, disassemble or otherwise reverse engineer this
product to ascertain the source code for any AT&T Software.

(c) AT&T Corp. All rights reserved.  AT&T is a registered trademark of AT&T Corp.

***********************************************************************

History:

      24/11/99  - initial release by Hartmut Liefke, liefke@seas.upenn.edu
                                     Dan Suciu,      suciu@research.att.com
*/

//**************************************************************************
//**************************************************************************

// This module implements 'Compressor' and 'Uncompressor' -
// the interfaces to the ZLIB (either gzip or bzip) libary

#include "stdafx.h"

BZip::BZip(int idx, bool iscomp): Zipper(idx, iscomp)
{
	bzstate.bzalloc=bzalloc;
	bzstate.bzfree=zfree;
}

BZip::~BZip() 
{}

void BZip::initCompress() 
{
#ifdef HAVE_BZIP2
	if(BZ2_bzCompressInit(&bzstate,7,0,0) != BZ_OK)	{
#else
	if(bzCompressInit(&bzstate,7,0,0) != BZ_OK)	{
#endif
		throw new XMillException (XMILL_ERR_ZLIB, "Error while compressing container!");
	}
}

void BZip::setCompPtrs(char *nextout, char* nextin, int availin)
{
	bzstate.next_out = nextout;
	bzstate.next_in = nextin;
	bzstate.avail_in = availin;
}

int BZip::doCompress(int flag)
{
	if (flag == -1)
		flag = BZ_FINISH;
#ifdef HAVE_BZIP2
	return BZ2_bzCompress(&bzstate,flag);
#else
	return bzCompress(&bzstate,flag);
#endif
}

void BZip::endCompress() 
{
#ifdef HAVE_BZIP2
	if(BZ2_bzCompressEnd(&bzstate) != BZ_OK) {
#else
	if(bzCompressEnd(&bzstate) != BZ_OK) {
#endif
		throw new XMillException (XMILL_ERR_ZLIB, "Error while compressing container!");
	}
}

void BZip::initUncompress() 
{
#ifdef HAVE_BZIP2
	if(BZ2_bzDecompressInit(&bzstate,0,0) != BZ_OK) {
#else
	if(bzDecompressInit(&bzstate,0,0) != BZ_OK) {
#endif
		throw new XMillException (XMILL_ERR_ZLIB, "Error while uncompressing container!");
	}
}

void BZip::setUncompPtrs(char *nextout, int availout, int availin)
{
	bzstate.next_out = nextout;
	bzstate.avail_out = availout;
	bzstate.avail_in = availin;
}

void BZip::setNextOut(char* nextout)
{
	bzstate.next_out = nextout;
}

void BZip::setNextIn(char* nextin)
{
	bzstate.next_in = nextin;
}

void BZip::setAvailIn(int availin)
{
	bzstate.avail_in = availin;
}

char **BZip::getNextInPtr() 
{
	return (char **)&(bzstate.next_in);
}

void BZip::endUncompress()
{
#ifdef HAVE_BZIP2
	if(BZ2_bzDecompressEnd(&bzstate) != BZ_OK) {
#else
	if(bzDecompressEnd(&bzstate) != BZ_OK) {
#endif
		throw new XMillException (XMILL_ERR_ZLIB, "Error while uncompressing container!");
	}
}

bool BZip::needsReInit()
{
	return true;
}

int BZip::getAvailIn()
{
	return bzstate.avail_in;
}

int* BZip::getAvailInPtr()
{
	return (int*)&bzstate.avail_in;
}

int BZip::getAvailOut()
{
	return bzstate.avail_out;
}

int* BZip::getAvailOutPtr()
{
	return (int*)&bzstate.avail_out;
}

int BZip::getTotalOut()
{
#ifdef HAVE_BZIP2
	return bzstate.total_out_lo32;
#else
	return bzstate.total_out;
#endif
}

int BZip::getTotalIn()
{
#ifdef HAVE_BZIP2
	return bzstate.total_in_lo32;
#else
	return bzstate.total_in;
#endif
}

void BZip::resetTotals()
{
#ifdef HAVE_BZIP2
	bzstate.total_in_lo32 = 0;
	bzstate.total_in_hi32 = 0;
	bzstate.total_out_lo32 = 0;
	bzstate.total_out_hi32 = 0;
#else
	bzstate.total_in = 0;
	bzstate.total_out = 0;
#endif
}

int BZip::doUncompress()
{
#ifdef HAVE_BZIP2
	return BZ2_bzDecompress(&bzstate);
#else
	return bzDecompress(&bzstate);
#endif
}

