#include "xev.h"
#include "enemy.h"

PRIVATE char *fn[] = {
      "gbzakart.img",
      "zakart2.img"
};
PRIVATE Pixmap pixmap[2];
PRIVATE Pixmap pixmap_mask[2];
PRIVATE GC gc[2];

void GBZakartSetChar()
{
      int c_no;
      char img[CSIZE*CSIZE] , mask[3*20];
      XGCValues gcv;

      gcv.graphics_exposures = False;

      for(c_no = 0 ; c_no < 2 ; c_no++) {
            int x,y;
            
            sprintf(tpath , "%s/%s",IMAGE_DIR,fn[c_no]);
            LoadChar(tpath,img , sizeof(img));
	    pixmap[c_no] = XCreatePixmap(d,w,24,20,depth);
            bzero(mask , sizeof(mask));
	    gc[c_no] = XCreateGC(d,w,GCGraphicsExposures,&gcv);

	    for(y = 0 ; y < 20 ; y++)
              for(x = 0 ; x < 24 ; x++) {
                    if(img[y*CSIZE+x] != 100) {
                          mask[y*3+x/8] |= (1<< (x%8));
                          XSetForeground(d,gc[c_no],
                                         pixel[img[y*CSIZE+x]]);
                          XDrawPoint(d,pixmap[c_no],gc[c_no],x,y);
                    }
              }
            pixmap_mask[c_no] 
              = XCreateBitmapFromData(d,w,mask,24,20);
            XSetClipMask(d,gc[c_no],pixmap_mask[c_no]);
      }
}

void GBZakartFree()
{
      int i;

      for(i = 0 ; i < 2 ; i++) {
	    XFreePixmap(d,pixmap[i]);
	    XFreePixmap(d,pixmap_mask[i]);
	    XFreeGC(d,gc[i]);
      }
}

void GBZakartInit(enemy_no)
     int enemy_no;
{
      ToloidoInit(enemy_no);
      enemy[enemy_no].enemy_no = GBZAKART;
      enemy[enemy_no].vx = 0;
      enemy[enemy_no].vy = 10*65536;
      enemy[enemy_no].tmp1 = jx.sht[UNION]/10+10;
}

int GBZakart(enemy_no)
     int enemy_no;
{
      int i;
      int yararetaTL = 0;
      int dx,dy;
      int sx,sy , char_no = 0;
      
      enemy[enemy_no].x.dummy += enemy[enemy_no].vx;
      enemy[enemy_no].y.dummy += enemy[enemy_no].vy;
      enemy[enemy_no].tmp1 --;
      sx = enemy[enemy_no].x.sht[UNION];
      sy = enemy[enemy_no].y.sht[UNION];
      dx = jx.sht[UNION] - sx; dy = jy.sht[UNION] - sy;
      
      if(dx > -20 && dx < 20 && dy > -20 && dy < 20)
        yararetaTL = 1;
      
      for(i = 0 ; i < SHOT_NUM ; i++)
        {
              if(!shot[i].flag)
                continue;
	      
	      if((shot[i].x.sht[UNION] - sx) > -20 && 
		 (shot[i].x.sht[UNION] - sx) < 20
		 && (shot[i].y.sht[UNION] - sy) > -24 && 
		 (shot[i].y.sht[UNION] - sy) < 24)
		{
		      score += 1000;
		      shot[i].flag = 0;
                      BombInit(enemy_no);
		      return 0;
                }
        }
      
      if(sx < 0 ||sx > XSIZE
         || sy > YSIZE)
	{
              enemy[enemy_no].enemy_no = 0;
        }
      else
        {
	      if(enemy[enemy_no].tmp1 == 1)
		char_no = 1;
	      if(enemy[enemy_no].tmp1 == 0) {
		    GBZEShut(enemy_no,enemy[enemy_no].x.dummy,
			  enemy[enemy_no].y.dummy);
		    GeminiInit(enemy[enemy_no].x,enemy[enemy_no].y);

		    enemy[enemy_no].enemy_no = 0;
	      } else {
		    SetSprite(enemy[enemy_no].x.sht[UNION],
			      enemy[enemy_no].y.sht[UNION],
			      pixmap[char_no],gc[char_no],
			      CSIZE,CSIZE);
	      }
	}

      return yararetaTL;
}



