#if 0
    INDI
    Copyright (C) 2003 Elwood C. Downey

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#endif

/* a simple security detectors (really just something to use Lights)
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <math.h>
#include <sys/time.h>
#include <unistd.h>

#include "astro.h"
#include "indidevapi.h"


#define	POLLMS		1234		/* poll period, ms */

void secSim (void *userpointer);

/* operational info */
#define MYDEV "Security"		/* Device name we call ourselves */

/* security locations */
static ILight sec[] = {
    {"Yard",   "Yard", 		IPS_OK},
    {"Front",  "Front door",	IPS_OK},
    {"Rear",   "Rear door",     IPS_OK},
    {"Obs",    "Observatory",   IPS_OK},
    {"Garage", "Garage", 	IPS_OK},
};
static ILightVectorProperty secLt = {MYDEV, "Security", "Security Sensors", "",
   IPS_OK, sec, NARRAY(sec)};

/* send client definitions of all properties */
void
ISGetProperties (char const *dev)
{
	static int inited;

	if (dev && strcmp (MYDEV, dev))
	    return;

	if (!inited) {
	    /* start timer to simulate mount motion */
	    IEAddTimer (POLLMS, secSim, NULL);
	    inited = 1;
	}

	IDDefLight (&secLt, NULL);
}

void
ISNewNumber (const char *dev, const char *name, double *doubles, char *names[],
int n)
{
}

void
ISNewBLOB (const char *dev, const char *name, int sizes[],
    int blobsizes[], char *blobs[], char *formats[], char *names[], int n)
{
}


void
ISNewText (const char *dev, const char *name, char *texts[], char *names[],
int n)
{
}

void
ISNewSwitch (const char *dev, const char *name, ISState *states, char *names[],
int n)
{
}

/* update the "security" items over time for show */
void
secSim (void *userpointer)
{
	int i, j;

	for (i = 0; i < NARRAY(sec); i++) {
	    IPState s = sec[i].s;
	    int r = rand();
	    if (r < RAND_MAX/100)
		s = IPS_ALERT;
	    else if (r < RAND_MAX/10)
		s = IPS_OK;
	    if (s != sec[i].s) {
		sec[i].s = s;
		secLt.s = IPS_OK;
		for (j = 0; j < NARRAY(sec); j++)
		    if (sec[j].s > secLt.s)
			secLt.s = sec[j].s;
		if (sec[i].s == IPS_ALERT)
		    IDSetLight (&secLt, "Breach at %s", sec[i].label);
		else
		    IDSetLight (&secLt, "%s is secure", sec[i].label);
		break;
	    }
	}


	/* again */
	IEAddTimer (POLLMS, secSim, NULL);
}

/* For RCS Only -- Do Not Edit */
static char *rcsid[2] = {(char *)rcsid, "@(#) $RCSfile: security.c,v $ $Date: 2005/05/08 02:52:25 $ $Revision: 1.7 $ $Name:  $"};
