/* xdaliclock - a melting digital clock
 * Copyright (c) 1991-2009 Jamie Zawinski <jwz@jwz.org>
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation.  No representations are made about the suitability of this
 * software for any purpose.  It is provided "as is" without express or
 * implied warranty.
 */

#ifdef USE_IPHONE

# import <Foundation/Foundation.h>
# import <UIKit/UIKit.h>
# define NSView  UIView
# define NSRect  CGRect
# define NSSize  CGSize
# define NSColor UIColor
# define colorWithCalibratedHue colorWithHue
# define NSUserDefaultsController NSUserDefaults
# define NSArchiver NSKeyedArchiver

#else  /* !USE_IPHONE */

# import <Cocoa/Cocoa.h>

#endif /* !USE_IPHONE */


#import "xdaliclock.h"


@interface DaliClockView : NSView
{
  dali_config config;

  unsigned char *pixmap;

# ifndef USE_IPHONE
  NSImage *img;
# endif /* !USE_IPHONE */

  NSTimer *clockTimer;
  NSTimer *colorTimer;
  NSTimer *dateTimer;
  float autoDateInterval;

  BOOL ownWindow;
  BOOL constrainSizes;
  BOOL usesCountdownTimer;
  NSDate *countdownDate;

  NSColor *fg;
  NSColor *bg;
  NSColor *initialForegroundColor;
  NSColor *initialBackgroundColor;
}

+ (void)initializeDefaults:(NSUserDefaultsController *)controller;
+ (NSUserDefaultsController *)userDefaultsController;

- (void)setOwnWindow:(BOOL)own_p;
- (void)setConstrainSizes:(BOOL)constrain_p;
- (void)setAutoDate:(float)interval;
- (IBAction) aboutClick: (id)sender;

#ifdef USE_IPHONE
- (void)setFrameSize:(NSSize)newSize;
#endif /* !USE_IPHONE */


// Start timers
- (void)clockTick;
- (void)colorTick;
- (void)dateTick;


/* Bindable Properties:
     hourStyle
     timeStyle
     dateStyle
     cycleSpeed
     usesCountdownTimer
     countdownDate
     initialForegroundColor
     initialBackgroundColor
*/

@end
