/*
 * Copyright(c) 1992 Bell Communications Research, Inc. (Bellcore)
 * Copyright(c) 1995-99 Andrew Lister
 * Copyright  1999, 2000, 2001, 2002, 2003, 2004 by the LessTif Developers.
 *
 *                        All rights reserved
 * Permission to use, copy, modify and distribute this material for
 * any purpose and without fee is hereby granted, provided that the
 * above copyright notice and this permission notice appear in all
 * copies, and that the name of Bellcore not be used in advertising
 * or publicity pertaining to this material without the specific,
 * prior written permission of an authorized representative of
 * Bellcore.
 *
 * BELLCORE MAKES NO REPRESENTATIONS AND EXTENDS NO WARRANTIES, EX-
 * PRESS OR IMPLIED, WITH RESPECT TO THE SOFTWARE, INCLUDING, BUT
 * NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR ANY PARTICULAR PURPOSE, AND THE WARRANTY AGAINST IN-
 * FRINGEMENT OF PATENTS OR OTHER INTELLECTUAL PROPERTY RIGHTS.  THE
 * SOFTWARE IS PROVIDED "AS IS", AND IN NO EVENT SHALL BELLCORE OR
 * ANY OF ITS AFFILIATES BE LIABLE FOR ANY DAMAGES, INCLUDING ANY
 * LOST PROFITS OR OTHER INCIDENTAL OR CONSEQUENTIAL DAMAGES RELAT-
 * ING TO THE SOFTWARE.
 *
 * MatrixWidget Author: Andrew Wason, Bellcore, aw@bae.bellcore.com
 *
 * $Id: Matrix.c,v 1.145 2004/12/07 23:55:55 tobiasoed Exp $
 */

#ifdef HAVE_CONFIG_H
#include <XbaeConfig.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <assert.h>

#include <X11/StringDefs.h>
#include <X11/Xlib.h>

#include <Xm/XmP.h>
#include <Xm/AtomMgr.h>
#include <Xm/ScrollBar.h>
#include <Xm/DrawP.h>
#include <Xm/DragIcon.h>
#include <Xm/DragC.h>

#include <Xbae/Input.h>
#include <Xbae/MatrixP.h>
#include <Xbae/Clip.h>
#include <Xbae/Converters.h>
#include <Xbae/ScrollMgr.h>
#include <Xbae/Actions.h>
#include <Xbae/Create.h>
#include <Xbae/Methods.h>
#include <Xbae/Utils.h>
#include <Xbae/Shadow.h>
#include <Xbae/Draw.h>

#include <XbaeDebug.h>

#ifdef	WIN32
#define	EXTERNALREF	externalref __declspec(dllexport)
#else
#define	EXTERNALREF	/* nothing */
#endif

/*
** This should have been a compile-time option.
** for backwards compatability reasons with pre 4.50 versions.
**
** Added here, but the default is the same as 4.50.2.
**
** A.J.Fountain, IST, August 2003.
*/

#ifndef   DEFAULT_USE_XBAE_INPUT
#define   DEFAULT_USE_XBAE_INPUT    False
#endif                          /* DEFAULT_USE_XBAE_INPUT */

#ifndef XlibSpecificationRelease
#define XrmPermStringToQuark XrmStringToQuark
#endif

/*
 * Translations for Matrix (these will also be used by the Clip child).
 */
static char defaultTranslations[] =
    "<Btn1Up>           :   DefaultAction()\n"
    "<Btn1Down>         :   DefaultAction() EditCell(Pointer)\n"
    "Shift<Btn2Down>    :   ResizeColumns()\n"
    "<Btn2Down>         :   ProcessDrag()\n" 
    "<Btn1Motion>       :   HandleMotion() HandleTracking()\n"
    "<Motion>           :   HandleTracking()\n";

/*
 * Default translations for XmNtextTranslations resource
 */
static char default_text_translations[] = "#override\n"
    #if 0
    "Shift ~Ctrl ~Meta ~Alt <Key>Tab    :   EditCell(Left)\n"
    "~Ctrl ~Meta ~Alt <Key>Tab          :   EditCell(Right)\n"
    /* Still needed for the clip but not the textchild */
    "Shift Ctrl ~Meta ~Alt <Key>Tab     :   ManagerGadgetPrevTabGroup()\n"
    "Ctrl ~Meta ~Alt <Key>Tab           :   ManagerGadgetNextTabGroup()\n"
    #else
    /* Still needed for the clip but not the textchild */
    "Shift ~Ctrl ~Meta ~Alt <Key>Tab     :   ManagerGadgetPrevTabGroup()\n"
    "~Ctrl ~Meta ~Alt <Key>Tab           :   ManagerGadgetNextTabGroup()\n"
    #endif
    "Ctrl <Key>osfUp                    :   EditCell(Up)\n"
    "Ctrl <Key>osfDown                  :   EditCell(Down)\n"
    "Ctrl <Key>osfLeft                  :   EditCell(Left)\n"
    "Ctrl <Key>osfRight                 :   EditCell(Right)\n"
    "<Key>osfCancel                     :   CancelEdit(False)\n"
    "<Key>osfActivate                   :   CommitEdit(False)\n"
    "~Shift ~Meta ~Alt <Key>Return      :   CommitEdit(False)\n"
    "<Key>osfPageDown                   :   PageDown()\n"
    "<Key>osfPageUp                     :   PageUp()\n";

static char default_dialog_text_translations[] = "#override\n"
    #if 0
    "Shift ~Ctrl ~Meta ~Alt <Key>Tab    :   EditCell(Left)\n"
    "~Ctrl ~Meta ~Alt <Key>Tab          :   EditCell(Right)\n"
    /* Still needed for the clip but not the textchild */
    "Shift Ctrl ~Meta ~Alt <Key>Tab     :   ManagerGadgetPrevTabGroup()\n"
    "Ctrl ~Meta ~Alt <Key>Tab           :   ManagerGadgetNextTabGroup()\n"
    #else
    /* Still needed for the clip but not the textchild */
    "Shift ~Ctrl ~Meta ~Alt <Key>Tab     :   ManagerGadgetPrevTabGroup()\n"
    "~Ctrl ~Meta ~Alt <Key>Tab           :   ManagerGadgetNextTabGroup()\n"
    #endif
    "Ctrl <Key>osfUp                    :   EditCell(Up)\n"
    "Ctrl <Key>osfDown                  :   EditCell(Down)\n"
    "Ctrl <Key>osfLeft                  :   EditCell(Left)\n"
    "Ctrl <Key>osfRight                 :   EditCell(Right)\n"
    "<Key>osfActivate                   :   CommitEdit(False)\n"
    "~Shift ~Meta ~Alt <Key>Return      :   CommitEdit(False)\n"
    "<Key>osfPageDown                   :   PageDown()\n"
    "<Key>osfPageUp                     :   PageUp()\n";

#define offset(field)	XtOffsetOf(XbaeMatrixRec, field)

static XtResource resources[] = {
        {XmNallowColumnResize, XmCAllowResize, XmRBoolean, sizeof(Boolean),
         offset(matrix.allow_column_resize), XmRImmediate, (XtPointer) True}
        ,

        {XmNallowRowResize, XmCAllowResize, XmRBoolean, sizeof(Boolean),
         offset(matrix.allow_row_resize), XmRImmediate, (XtPointer) True}
        ,

        {XmNaltRowCount, XmCAltRowCount, XmRInt, sizeof(int),
         offset(matrix.alt_row_count), XmRImmediate, (XtPointer) 1},

        {XmNboldLabels, XmCBoldLabels, XmRBoolean, sizeof(Boolean),
         offset(matrix.bold_labels), XmRImmediate, (XtPointer) False}
        ,

        {XmNbuttonLabels, XmCButtonLabels, XmRBoolean, sizeof(Boolean),
         offset(matrix.button_labels), XmRImmediate, (XtPointer) False}
        ,

        {XmNbuttonLabelBackground, XmCColor, XmRPixel, sizeof(Pixel),
         offset(matrix.button_label_background), XmRCallProc,
         (XtPointer) xbaeCopyBackground}
        ,

        {XmNcalcCursorPosition, XmCCalcCursorPosition, XmRBoolean, sizeof(Boolean),
         offset(matrix.calc_cursor_position), XmRImmediate, (XtPointer) False}
        ,

        {XmNcellBackground, XmCColor, XmRPixel, sizeof(Pixel),
         offset(matrix.all_backgrounds), XmRCallProc,
         (XtPointer) xbaeCopyBackground}
        ,

        {XmNcellHighlightThickness, XmCHighlightThickness, XmRHorizontalDimension,
         sizeof(Dimension), offset(matrix.cell_highlight_thickness),
         XmRImmediate, (XtPointer) 2}
        ,

        {XmNcellMarginHeight, XmCMarginHeight, XmRVerticalDimension,
         sizeof(Dimension), offset(matrix.cell_margin_height),
         XmRImmediate, (XtPointer) 3}
        ,

        {XmNcellMarginWidth, XmCMarginWidth, XmRHorizontalDimension,
         sizeof(Dimension), offset(matrix.cell_margin_width),
         XmRImmediate, (XtPointer) 3}
        ,

        {XmNcellShadowThickness, XmCShadowThickness, XmRDimension,
         sizeof(Dimension), offset(matrix.cell_shadow_thickness),
         XmRImmediate, (XtPointer) 1}
        ,

        {XmNcellShadowType, XmCShadowType, XmRShadowType,
         sizeof(unsigned char), offset(matrix.cell_shadow_type), XmRImmediate,
         (XtPointer) XmSHADOW_OUT},

        {XmNclipWindow, XmCClipWindow, XmRWidget, sizeof(Widget),
         offset(matrix.clip_window), XmRImmediate, (XtPointer) NULL}
        ,

        {XmNcolor, XmCColor, XmRPixel, sizeof(Pixel *),
         offset(matrix.all_foregrounds), XmRCallProc,
         (XtPointer) xbaeCopyForeground}
        ,

        {XmNcolumnAlignments, XmCAlignments, XmRAlignmentArray,
         sizeof(unsigned char *), offset(matrix.column_alignments),
         XmRImmediate, (XtPointer) NULL},

        {XmNcolumnButtonLabels, XmCButtonLabels, XmRBooleanArray,
         sizeof(Boolean *), offset(matrix.column_button_labels),
         XmRImmediate, (XtPointer) NULL}
        ,

        {XmNshowColumnArrows, XmCButtonLabels, XmRBooleanArray,
         sizeof(Boolean *), offset(matrix.show_column_arrows),
         XmRImmediate, (XtPointer) NULL}
        ,

        {XmNcolumnFontBold, XmCButtonLabels, XmRBooleanArray,
         sizeof(Boolean *), offset(matrix.column_font_bold),
         XmRImmediate, (XtPointer) NULL}
        ,

        {XmNcolumnLabelAlignments, XmCAlignments, XmRAlignmentArray,
         sizeof(unsigned char *), offset(matrix.column_label_alignments),
         XmRImmediate, (XtPointer) NULL},

        {XmNcolumnLabelColor, XmCColor, XmRPixel, sizeof(Pixel),
         offset(matrix.column_label_color), XmRCallProc,
         (XtPointer) xbaeCopyForeground}
        ,

        {XmNcolumnLabels, XmCLabels, XmRStringArray, sizeof(String *),
         offset(matrix.column_labels), XmRImmediate, (XtPointer) NULL}
        ,
        {XmNXmColumnLabels, XmCXmLabels, XmRXmStringTable, sizeof(XmString *),
         offset(matrix.xmcolumn_labels), XmRImmediate, (XtPointer) NULL}
        ,

        {XmNcolumnMaxLengths, XmCColumnMaxLengths, XmRMaxLengthArray,
         sizeof(int *), offset(matrix.column_max_lengths),
         XmRImmediate, (XtPointer) NULL},

        {XmNcolumnShadowTypes, XmCShadowTypes, XmRShadowTypeArray,
         sizeof(unsigned char *), offset(matrix.column_shadow_types), XmRImmediate,
         (XtPointer) NULL},

        {XmNcolumnUserData, XmCUserDatas, XmRUserDataArray,
         sizeof(XtPointer *), offset(matrix.column_user_data), XmRImmediate,
         (XtPointer) NULL}
        ,

        {XmNcolumnWidths, XmCColumnWidths, XmRWidthArray, sizeof(short *),
         offset(matrix.column_widths), XmRImmediate, (XtPointer) NULL},

        {XmNcolumnWidthInPixels, XmCColumnWidthInPixels, XmRBoolean,
         sizeof(Boolean), offset(matrix.column_width_in_pixels),
         XmRImmediate, (XtPointer) False}
        ,

        {XmNrowHeightInPixels, XmCRowHeightInPixels, XmRBoolean,
         sizeof(Boolean), offset(matrix.row_height_in_pixels),
         XmRImmediate, (XtPointer) True}
        ,

        {XmNcolumns, XmCColumns, XmRInt, sizeof(int),
         offset(matrix.columns), XmRImmediate, (XtPointer) 1},

        {XmNdefaultActionCallback, XmCCallback, XmRCallback, sizeof(XtCallbackList),
         offset(matrix.default_action_callback), XmRCallback, (XtPointer) NULL}
        ,

        {XmNdoubleClickInterval, XmCDoubleClickInterval, XmRInt, sizeof(int),
         offset(matrix.double_click_interval), XmRCallProc,
         (XtPointer) xbaeCopyDoubleClick},

        {XmNdrawCellCallback, XmCCallback, XmRCallback, sizeof(XtCallbackList),
         offset(matrix.draw_cell_callback), XmRCallback, (XtPointer) NULL}
        ,

        {XmNenterCellCallback, XmCCallback, XmRCallback, sizeof(XtCallbackList),
         offset(matrix.enter_cell_callback), XmRCallback, (XtPointer) NULL}
        ,

        {XmNtrackCellCallback, XmCCallback, XmRCallback, sizeof(XtCallbackList),
         offset(matrix.track_cell_callback), XmRCallback, (XtPointer) NULL}
        ,

        {XmNevenRowBackground, XmCBackground, XmRPixel, sizeof(Pixel),
         offset(matrix.even_row_background), XmRCallProc,
         (XtPointer) xbaeCopyBackground}
        ,

        {XmNfill, XmCFill, XmRBoolean, sizeof(Boolean),
         offset(matrix.fill), XmRImmediate, (XtPointer) False}
        ,

        {XmNvertFill, XmCVertFill, XmRBoolean, sizeof(Boolean),
         offset(matrix.vert_fill), XmRImmediate, (XtPointer) False}
        ,

        {XmNhorzFill, XmCHorzFill, XmRBoolean, sizeof(Boolean),
         offset(matrix.horz_fill), XmRImmediate, (XtPointer) False}
        ,

        {XmNfixedColumns, XmCFixedColumns, XmRDimension, sizeof(Dimension),
         offset(matrix.fixed_columns), XmRImmediate, (XtPointer) 0}
        ,

        {XmNfixedRows, XmCFixedRows, XmRDimension, sizeof(Dimension),
         offset(matrix.fixed_rows), XmRImmediate, (XtPointer) 0}
        ,

        {XmNfontList, XmCFontList, XmRFontList, sizeof(XmFontList),
         offset(matrix.font_list), XmRString, (XtPointer) "fixed"}
        ,

        {XmNgridLineColor, XmCColor, XmRPixel, sizeof(Pixel),
         offset(matrix.grid_line_color), XmRCallProc,
         (XtPointer) xbaeCopyForeground}
        ,

        {XmNgridType, XmCGridType, XmRGridType,
         sizeof(unsigned char), offset(matrix.grid_type),
         XmRImmediate, (XtPointer) XmGRID_CELL_LINE},

        {XmNhorizontalScrollBar, XmCHorizontalScrollBar, XmRWidget, sizeof(Widget),
         offset(matrix.horizontal_sb), XmRImmediate, (XtPointer) NULL}
        ,

        {XmNhorizontalScrollBarDisplayPolicy, XmCMatrixScrollBarDisplayPolicy,
         XmRMatrixScrollBarDisplayPolicy, sizeof(unsigned char),
         offset(matrix.hsb_display_policy), XmRImmediate,
         (XtPointer) XmDISPLAY_AS_NEEDED},

        {XmNlabelActivateCallback, XmCCallback, XmRCallback,
         sizeof(XtCallbackList), offset(matrix.label_activate_callback),
         XmRCallback, (XtPointer) NULL}
        ,

        {XmNlabelFont, XmCFontList, XmRFontList, sizeof(XmFontList),
         offset(matrix.label_font_list), XmRString, (XtPointer) NULL}
        ,

        {XmNleaveCellCallback, XmCCallback, XmRCallback, sizeof(XtCallbackList),
         offset(matrix.leave_cell_callback), XmRCallback, (XtPointer) NULL}
        ,

        {XmNmodifyVerifyCallback, XmCCallback, XmRCallback, sizeof(XtCallbackList),
         offset(matrix.modify_verify_callback), XmRCallback, (XtPointer) NULL}
        ,

        {XmNoddRowBackground, XmCBackground, XmRPixel, sizeof(Pixel),
         offset(matrix.odd_row_background), XmRCallProc,
         (XtPointer) xbaeCopyBackground}
        ,

        {XmNprocessDragCallback, XmCCallback, XmRCallback, sizeof(XtCallbackList),
         offset(matrix.process_drag_callback), XmRCallback, (XtPointer) NULL}
        ,

        /* Resize callback resource. Added by mjs */
        {XmNresizeCallback, XmCCallback, XmRCallback, sizeof(XtCallbackList),
         offset(matrix.resize_callback), XmRCallback, (XtPointer) NULL}
        ,

        {XmNresizeColumnCallback, XmCCallback, XmRCallback, sizeof(XtCallbackList),
         offset(matrix.resize_column_callback), XmRCallback, (XtPointer) NULL}
        ,

        {XmNresizeRowCallback, XmCCallback, XmRCallback, sizeof(XtCallbackList),
         offset(matrix.resize_row_callback), XmRCallback, (XtPointer) NULL}
        ,

        {XmNreverseSelect, XmCReverseSelect, XmRBoolean, sizeof(Boolean),
         offset(matrix.reverse_select), XmRImmediate, (XtPointer) False}
        ,

        {XmNrowButtonLabels, XmCButtonLabels, XmRBooleanArray,
         sizeof(Boolean *), offset(matrix.row_button_labels),
         XmRImmediate, (XtPointer) NULL}
        ,

        {XmNrowHeights, XmCColumnWidths, XmRWidthArray, sizeof(short *),
         offset(matrix.row_heights), XmRImmediate, (XtPointer) NULL},

        {XmNrowLabelAlignment, XmCAlignment, XmRAlignment, sizeof(unsigned char),
         offset(matrix.row_label_alignment),
         XmRImmediate, (XtPointer) XmALIGNMENT_END},

        {XmNrowLabelColor, XmCColor, XmRPixel, sizeof(Pixel),
         offset(matrix.row_label_color), XmRCallProc,
         (XtPointer) xbaeCopyForeground}
        ,

        {XmNrowLabelWidth, XmCRowLabelWidth, XmRShort, sizeof(short),
         offset(matrix.row_label_width), XmRImmediate, (XtPointer) 0},

        {XmNrowLabels, XmCLabels, XmRStringArray, sizeof(String *),
         offset(matrix.row_labels), XmRImmediate, (XtPointer) NULL}
        ,

        {XmNrowShadowTypes, XmCShadowTypes, XmRShadowTypeArray,
         sizeof(unsigned char *), offset(matrix.row_shadow_types), XmRImmediate,
         (XtPointer) NULL},

        {XmNrowUserData, XmCUserDatas, XmRUserDataArray,
         sizeof(XtPointer *), offset(matrix.row_user_data), XmRImmediate,
         (XtPointer) NULL}
        ,

        {XmNrows, XmCRows, XmRInt, sizeof(int),
         offset(matrix.rows), XmRImmediate, (XtPointer) 1},

        {XmNscrollBackground, XmCColor, XmRPixel, sizeof(Pixel),
         offset(matrix.scroll_background), XmRCallProc,
         (XtPointer) xbaeCopyBackground}
        ,

        {XmNscrollBarPlacement, XmCScrollBarPlacement, XmRScrollBarPlacement,
         sizeof(unsigned char), offset(matrix.scrollbar_placement), XmRImmediate,
         (XtPointer) XmBOTTOM_RIGHT},

        {XmNselectCellCallback, XmCCallback, XmRCallback, sizeof(XtCallbackList),
         offset(matrix.select_cell_callback), XmRCallback, (XtPointer) NULL}
        ,

        {XmNselectScrollVisible, XmCSelectScrollVisible, XmRBoolean,
         sizeof(Boolean), offset(matrix.scroll_select), XmRImmediate,
         (XtPointer) True}
        ,

        {XmNselectedBackground, XmCColor, XmRPixel, sizeof(Pixel),
         offset(matrix.selected_background), XmRCallProc,
         (XtPointer) xbaeCopyForeground}
        ,

        {XmNselectedForeground, XmCColor, XmRPixel, sizeof(Pixel),
         offset(matrix.selected_foreground), XmRCallProc,
         (XtPointer) xbaeCopyBackground}
        ,

        {XmNselectionPolicy, XmCSelectionPolicy, XmRSelectionPolicy,
         sizeof(unsigned char), offset(matrix.selection_policy), XmRImmediate,
         (XtPointer) XmSINGLE_SELECT},

        /* Override Manager default */
        {XmNshadowThickness, XmCShadowThickness, XmRHorizontalDimension,
         sizeof(Dimension), XtOffsetOf(XmManagerRec, manager.shadow_thickness),
         XmRImmediate, (XtPointer) 2}
        ,

        {XmNshadowType, XmCShadowType, XmRShadowType,
         sizeof(unsigned char), offset(matrix.shadow_type), XmRImmediate,
         (XtPointer) XmSHADOW_IN},

        {XmNshowArrows, XmCShowArrows, XmRBoolean, sizeof(Boolean),
         offset(matrix.show_arrows), XmRImmediate, (XtPointer) False}
        ,

        {XmNspace, XmCSpace, XmRHorizontalDimension, sizeof(Dimension),
         offset(matrix.space), XmRImmediate, (XtPointer) 4}
        ,

        {XmNtextBackground, XmCTextBackground, XmRPixel, sizeof(Pixel),
         offset(matrix.text_background), XmRCallProc,
         (XtPointer) xbaeCopyBackground}
        ,

        {XmNtextField, XmCTextField, XmRWidget, sizeof(Widget),
         offset(matrix.text_field), XmRImmediate, (XtPointer) NULL}
        ,

        {XmNtextShadowThickness, XmCTextShadowThickness, XmRDimension,
         sizeof(Dimension), offset(matrix.text_shadow_thickness), XmRImmediate,
         (XtPointer) 0}
        ,

        {XmNtextTranslations, XmCTranslations, XmRTranslationTable,
         sizeof(XtTranslations), offset(matrix.text_translations),
         XmRString, (XtPointer) NULL}
        ,

        {XmNnonFixedDetachedTop, XmCNonFixedDetachedTop, XmRBoolean, sizeof(Boolean),
         offset(matrix.non_fixed_detached_top), XmRImmediate, (XtPointer) False}
        ,

        {XmNnonFixedDetachedLeft, XmCNonFixedDetachedLeft, XmRBoolean, sizeof(Boolean),
         offset(matrix.non_fixed_detached_left), XmRImmediate, (XtPointer) False}
        ,

        {XmNtrailingAttachedBottom, XmCTrailingAttachedBottom, XmRBoolean, sizeof(Boolean),
         offset(matrix.trailing_attached_bottom), XmRImmediate, (XtPointer) False}
        ,

        {XmNtrailingAttachedRight, XmCTrailingAttachedRight, XmRBoolean, sizeof(Boolean),
         offset(matrix.trailing_attached_right), XmRImmediate, (XtPointer) False}
        ,

        {XmNtrailingFixedColumns, XmCTrailingFixedColumns, XmRDimension,
         sizeof(Dimension), offset(matrix.trailing_fixed_columns),
         XmRImmediate, (XtPointer) 0}
        ,

        {XmNtrailingFixedRows, XmCTrailingFixedRows, XmRDimension,
         sizeof(Dimension), offset(matrix.trailing_fixed_rows),
         XmRImmediate, (XtPointer) 0}
        ,

        {XmNtraverseCellCallback, XmCCallback, XmRCallback, sizeof(XtCallbackList),
         offset(matrix.traverse_cell_callback), XmRCallback, (XtPointer) NULL}
        ,

        {XmNtraverseFixedCells, XmCTraverseFixedCells, XmRBoolean, sizeof(Boolean),
         offset(matrix.traverse_fixed), XmRImmediate, (XtPointer) False}
        ,

        {XmNunderlinePosition, XmCUnderlinePosition, XmRPosition, sizeof(Position),
         offset(matrix.underline_position), XmRImmediate, (XtPointer) 1}
        ,

        {XmNunderlineWidth, XmCUnderlineWidth, XmRDimension, sizeof(Dimension),
         offset(matrix.underline_width), XmRImmediate, (XtPointer) 1}
        ,

        {XmNvalueChangedCallback, XmCCallback, XmRCallback, sizeof(XtCallbackList),
         offset(matrix.value_changed_callback), XmRCallback, (XtPointer) NULL}
        ,

        {XmNverticalScrollBar, XmCVerticalScrollBar, XmRWidget, sizeof(Widget),
         offset(matrix.vertical_sb), XmRImmediate, (XtPointer) NULL}
        ,

        {XmNverticalScrollBarDisplayPolicy, XmCMatrixScrollBarDisplayPolicy,
         XmRMatrixScrollBarDisplayPolicy, sizeof(unsigned char),
         offset(matrix.vsb_display_policy), XmRImmediate,
         (XtPointer) XmDISPLAY_AS_NEEDED},

        {XmNvisibleColumns, XmCVisibleColumns, XmRDimension, sizeof(Dimension),
         offset(matrix.visible_columns), XmRImmediate, (XtPointer) 0}
        ,

        {XmNvisibleRows, XmCVisibleRows, XmRDimension, sizeof(Dimension),
         offset(matrix.visible_rows), XmRImmediate, (XtPointer) 0}
        ,

        {XmNwriteCellCallback, XmCCallback, XmRCallback, sizeof(XtCallbackList),
         offset(matrix.write_cell_callback), XmRCallback, (XtPointer) NULL}
        ,

        {XmNdesiredHeight, XmCDesiredHeight, XmRDimension, sizeof(Dimension),
         offset(matrix.desired_height), XmRImmediate, (XtPointer) 0}
        ,

        {XmNdesiredWidth, XmCDesiredWidth, XmRDimension, sizeof(Dimension),
         offset(matrix.desired_width), XmRImmediate, (XtPointer) 0}
        ,

        {XmNuseXbaeInput, XmCUseXbaeInput, XmRBoolean, sizeof(Boolean),
         offset(matrix.useXbaeInput), XmRImmediate, (XtPointer) DEFAULT_USE_XBAE_INPUT}
        ,

        {XmNmultiLineCell, XmCMultiLineCell, XmRBoolean, sizeof(Boolean),
         offset(matrix.multi_line_cell), XmRImmediate, (XtPointer) False}
        ,
};

#if (XmVERSION < 2)

/*
** Deprecated Code.
**
** A.J.Fountain, IST.
*/
#define XmeFromHorizontalPixels  _XmFromHorizontalPixels
#define XmeToHorizontalPixels    _XmToHorizontalPixels
#define XmeFromVerticalPixels  _XmFromVerticalPixels
#define XmeToVerticalPixels    _XmToVerticalPixels

#define	XmUNSPECIFIED_PIXEL	((Pixel) (~0))
#endif                          /* (XmVERSION < 2) */

static XmSyntheticResource syn_resources[] = {
        {XmNcellHighlightThickness, sizeof(Dimension), offset(matrix.cell_highlight_thickness),
         XmeFromHorizontalPixels, XmeToHorizontalPixels}
        ,

        {XmNcellMarginHeight, sizeof(Dimension), offset(matrix.cell_margin_height),
         XmeFromVerticalPixels, XmeToVerticalPixels}
        ,

        {XmNcellMarginWidth, sizeof(Dimension), offset(matrix.cell_margin_width),
         XmeFromHorizontalPixels, XmeToHorizontalPixels}
        ,

        {XmNcellShadowThickness, sizeof(Dimension),
         offset(matrix.cell_shadow_thickness), XmeFromHorizontalPixels,
         XmeToHorizontalPixels}
        ,

        {XmNspace, sizeof(Dimension), offset(matrix.space),
         XmeFromHorizontalPixels, XmeToHorizontalPixels}
        ,
};

/*
 * Declaration of methods
 */
static void ClassInitialize(void);
static void xbaeRegisterConverters(void);
static void ClassPartInitialize(XbaeMatrixWidgetClass);
static void Initialize(Widget, Widget, ArgList, Cardinal *);
static void Realize(XbaeMatrixWidget, XtValueMask *, XSetWindowAttributes *);
static void InsertChild(Widget);
static void Redisplay(Widget, XEvent *, Region);
static Boolean SetValues(XbaeMatrixWidget, XbaeMatrixWidget, XbaeMatrixWidget, ArgList, Cardinal *);
static void SetValuesAlmost(XbaeMatrixWidget, XbaeMatrixWidget, XtWidgetGeometry *,
                            XtWidgetGeometry *);
static void Destroy(XbaeMatrixWidget);
static XtGeometryResult GeometryManager(Widget, XtWidgetGeometry *, XtWidgetGeometry *);
static XtGeometryResult QueryGeometry(XbaeMatrixWidget, XtWidgetGeometry *, XtWidgetGeometry *);
static Boolean SetValuesHook(Widget w, ArgList args, Cardinal *nargs);
static void GetValuesHook(Widget w, ArgList args, Cardinal *nargs);

/*
 * Redraw function for clip widget
 */
static void ClipRedisplay(Widget, XRectangle *, XEvent *, Region);

/*
 * Private functions unique to Matrix
 */
static void ResizePerCell(XbaeMatrixWidget, XbaeMatrixWidget);

/*
 * Clip widget focusCallback
 */
static void TraverseInCB(Widget, XbaeMatrixWidget, XtPointer);

/*
 * Matrix actions
 */
static XtActionsRec actions[] = {
        {"EditCell", xbaeEditCellACT},
        {"CancelEdit", xbaeCancelEditACT},
        {"DefaultAction", xbaeDefaultActionACT},
        {"CommitEdit", xbaeCommitEditACT},
        {"ResizeColumns", xbaeResizeColumnsACT},
        {"SelectCell", xbaeSelectCellACT},
        {"TraverseNext", xbaeTraverseNextACT},
        {"TraversePrev", xbaeTraversePrevACT},
        {"ProcessDrag", xbaeProcessDragACT},
        {"HandleMotion", xbaeHandleMotionACT},
        {"HandleTracking", xbaeHandleTrackingACT},
        {"PageDown", xbaePageDownACT},
        {"PageUp", xbaePageUpACT}
};

/* *INDENT-OFF* */
static XmBaseClassExtRec BaseClassExtRec = {
        NULL,                       /* next_extension         */
        NULLQUARK,                  /* record_type            */
        XmBaseClassExtVersion,      /* version                */
        sizeof(XmBaseClassExtRec),  /* record_size            */
        NULL,                       /* InitializePrehook      */
        NULL,                       /* SetValuesPrehook       */
        NULL,                       /* InitializePosthook     */
        NULL,                       /* SetValuesPosthook      */
        NULL,                       /* secondaryObjectClass   */
        NULL,                       /* secondaryCreate        */
        NULL,                       /* getSecRes data         */
        {0},                        /* fastSubclass flags     */
        NULL,                       /* get_values_prehook     */
        NULL,                       /* get_values_posthook    */
        NULL,                       /* classPartInitPrehook   */
        NULL,                       /* classPartInitPosthook  */
        NULL,                       /* ext_resources          */
        NULL,                       /* compiled_ext_resources */
        0,                          /* num_ext_resources      */
        FALSE,                      /* use_sub_resources      */
        XmInheritWidgetNavigable,   /* widgetNavigable        */
        XmInheritFocusChange,       /* focusChange            */
        NULL                        /* wrapperdata            */
};

XbaeMatrixClassRec xbaeMatrixClassRec = {
    {
        /* core_class fields */
        (WidgetClass) & xmManagerClassRec,      /* superclass            */
        "XbaeMatrix",                           /* class_name            */
        sizeof(XbaeMatrixRec),                  /* widget_size           */
        ClassInitialize,                        /* class_initialize      */
        (XtWidgetClassProc)ClassPartInitialize, /* class_part_initialize */
        False,                                  /* class_inited          */
        (XtInitProc) Initialize,                /* initialize            */
        NULL,                                   /* initialize_hook       */
        (XtRealizeProc) Realize,                /* realize               */
        actions,                                /* actions               */
        XtNumber(actions),                      /* num_actions           */
        resources,                              /* resources             */
        XtNumber(resources),                    /* num_resources         */
        NULLQUARK,                              /* xrm_class             */
        True,                                   /* compress_motion       */
        XtExposeCompressMultiple 
        | XtExposeGraphicsExpose 
        | XtExposeNoExpose,                     /* compress_exposure     */
        True,                                   /* compress_enterleave   */
        False,                                  /* visible_interest      */
        (XtWidgetProc) Destroy,                 /* destroy               */
        (XtWidgetProc) xbaeResize,              /* resize                */
        (XtExposeProc) Redisplay,               /* expose                */
        (XtSetValuesFunc) SetValues,            /* set_values            */
        SetValuesHook,                          /* set_values_hook       */
        (XtAlmostProc) SetValuesAlmost,         /* set_values_almost     */
        GetValuesHook,                          /* get_values_hook       */
        NULL,                                   /* accept_focus          */
        XtVersionDontCheck,                     /* version               */
        NULL,                                   /* callback_private      */
        defaultTranslations,                    /* tm_table              */
        (XtGeometryHandler) QueryGeometry,      /* query_geometry        */
        NULL,                                   /* display_accelerator   */
        (XtPointer) & BaseClassExtRec           /* extension             */
    }
    ,
    {
        /* composite_class fields */
        GeometryManager,                        /* geometry_manager      */
        NULL,                                   /* change_managed        */
        InsertChild,                            /* insert_child          */
        XtInheritDeleteChild,                   /* delete_child          */
        NULL,                                   /* extension             */
    }
    ,
    {
        /* constraint_class fields */
        NULL,                                   /* resources             */
        0,                                      /* num_resources         */
        0,                                      /* constraint_size       */
        NULL,                                   /* initialize            */
        NULL,                                   /* destroy               */
        NULL,                                   /* set_values            */
        NULL                                    /* extension             */
    }
    ,
    {
        /* manager_class fields */
        XtInheritTranslations,                  /* translations          */
        syn_resources,                          /* syn_resources         */
        XtNumber(syn_resources),                /* num_syn_resources     */
        NULL,                                   /* syn_constraint_resources     */
        0,                                      /* num_syn_constraint_resources */
        XmInheritParentProcess,                 /* parent_process        */
        NULL                                    /* extension             */
    }
    ,
    {
        /* matrix_class fields */
        xbaeSetCell,                            /* set_cell              */
        xbaeGetCell,                            /* get_cell              */
        xbaeEditCell,                           /* edit_cell             */
        xbaeSelectCell,                         /* select_cell           */
        xbaeShowColumnArrows,                   /* show_column_arrows    */
        xbaeSelectRow,                          /* select_row            */
        xbaeSelectColumn,                       /* select_column         */
        xbaeDeselectAll,                        /* deselect_all          */
        xbaeSelectAll,                          /* select_all            */
        xbaeDeselectCell,                       /* deselect_cell         */
        xbaeDeselectRow,                        /* deselect_row          */
        xbaeDeselectColumn,                     /* deselect_column       */
        xbaeCommitEdit,                         /* commit_edit           */
        xbaeCancelEdit,                         /* cancel_edit           */
        xbaeAddRows,                            /* add_rows              */
        xbaeAddVarRows,                         /* add_var_rows          */
        xbaeDeleteRows,                         /* delete_rows           */
        xbaeAddColumns,                         /* add_columns           */
        xbaeDeleteColumns,                      /* delete_columns        */
        xbaeSetRowColors,                       /* set_row_colors        */
        xbaeSetColumnColors,                    /* set_column_colors     */
        xbaeSetCellColor,                       /* set_cell_color        */
        NULL,                                   /* extension             */
    }
};

EXTERNALREF WidgetClass xbaeMatrixWidgetClass = (WidgetClass) & xbaeMatrixClassRec;

static XtConvertArgRec convertArg[] = { 
    {XtWidgetBaseOffset, (XtPointer) XtOffsetOf(WidgetRec, core.screen), sizeof(Screen *)},
    {XtWidgetBaseOffset, (XtPointer) XtOffsetOf(WidgetRec, core.colormap), sizeof(Colormap)}
};
/* *INDENT-ON* */

static void xbaeRegisterConverters(void)
{
        /*
         * String to StringArray is used for XmNrowLabels and XmNcolumnLabels
         * We make a private copy of this table
         */
        XtSetTypeConverter(XmRString, XmRStringArray, XbaeCvtStringToStringArray, NULL, 0,
                           XtCacheAll | XtCacheRefCount, XbaeStringArrayDestructor);

        /*
         * String to String2DArray is used for XmNcells resource
         * We make a private copy of this table
         */
        XtSetTypeConverter(XmRString, XmRCellTable, XbaeCvtStringToCellTable, NULL, 0, XtCacheNone,
                           XbaeStringCellDestructor);

        /*
         * String to ShortArray is used for XmNcolumnWidths resource.
         * We make a private copy of this table
         */
        XtSetTypeConverter(XmRString, XmRWidthArray, XbaeCvtStringToWidthArray, NULL, 0,
                           XtCacheAll | XtCacheRefCount, XbaeWidthArrayDestructor);

        /*
         * String to IntArray is used for XmNcolumnMaxLengths resource.
         * We make a private copy of this table
         */
        XtSetTypeConverter(XmRString, XmRMaxLengthArray, XbaeCvtStringToMaxLengthArray, NULL, 0,
                           XtCacheAll | XtCacheRefCount, XbaeMaxLengthArrayDestructor);

        /*
         * String to PixelTable is used for XmNcolors
         * and XmNcellBackgrounds resources.
         */
        XtSetTypeConverter(XmRString, XmRPixelTable, XbaeCvtStringToPixelTable, convertArg,
		           XtNumber(convertArg), XtCacheNone, XbaePixelTableDestructor);

        /*
         * String to BooleanArray is used for XmNcolumnButtonLabels, XmNshowColumnArrows,
         * XmNcolumnFontBold, and XmNrowButtonLabels resources.
         */
        XtSetTypeConverter(XmRString, XmRBooleanArray, XbaeCvtStringToBooleanArray, NULL, 0,
                           XtCacheAll | XtCacheRefCount, XbaeBooleanArrayDestructor);

        /*
         * String to AlignmentArray is used for XmNcolumnAlignments
         * and XmNcolumnLabelAlignments resources.
         */
        XtSetTypeConverter(XmRString, XmRAlignmentArray, XbaeCvtStringToAlignmentArray, NULL, 0,
                           XtCacheAll | XtCacheRefCount, XbaeAlignmentArrayDestructor);

        /*
         * String to ShadowtypesArray.
         */
        XtSetTypeConverter(XmRString, XmRShadowTypeArray, XbaeCvtStringToShadowTypeArray, NULL, 0,
                           XtCacheAll | XtCacheRefCount, XbaeShadowTypeArrayDestructor);

        /*
         * String to grid type is used for XmNgridType
         */
        XtSetTypeConverter(XmRString, XmRGridType, XbaeCvtStringToGridType, NULL, 0, XtCacheAll,
                           NULL);

        /*
         * String to matrix display policy is used for
         * XmN{vertical,horizontal}ScrollBarDisplayPolicy
         */
        XtSetTypeConverter(XmRString, XmRMatrixScrollBarDisplayPolicy,
#ifdef __VMS
                           XbaeCvtStringToMatrixScrollBarD,
#else
                           XbaeCvtStringToMatrixScrollBarDisplayPolicy,
#endif
                           NULL, 0, XtCacheAll, NULL);
}

static void ClassInitialize(void)
{
        xbaeRegisterConverters();
}

static void ClassPartInitialize(XbaeMatrixWidgetClass mwc)
{
        register XbaeMatrixWidgetClass super = (XbaeMatrixWidgetClass) mwc->core_class.superclass;

        /*
         * Allow subclasses to inherit new Matrix methods
         */
        if (mwc->matrix_class.set_cell == XbaeInheritSetCell)
                mwc->matrix_class.set_cell = super->matrix_class.set_cell;
        if (mwc->matrix_class.get_cell == XbaeInheritGetCell)
                mwc->matrix_class.get_cell = super->matrix_class.get_cell;
        if (mwc->matrix_class.edit_cell == XbaeInheritEditCell)
                mwc->matrix_class.edit_cell = super->matrix_class.edit_cell;
        if (mwc->matrix_class.set_show_column_arrows == XbaeInheritShowColumnArrows)
                mwc->matrix_class.set_show_column_arrows =
                    super->matrix_class.set_show_column_arrows;
        if (mwc->matrix_class.select_cell == XbaeInheritSelectCell)
                mwc->matrix_class.select_cell = super->matrix_class.select_cell;
        if (mwc->matrix_class.select_row == XbaeInheritSelectRow)
                mwc->matrix_class.select_row = super->matrix_class.select_row;
        if (mwc->matrix_class.select_column == XbaeInheritSelectColumn)
                mwc->matrix_class.select_column = super->matrix_class.select_column;
        if (mwc->matrix_class.deselect_all == XbaeInheritDeselectAll)
                mwc->matrix_class.deselect_all = super->matrix_class.deselect_all;
        if (mwc->matrix_class.select_all == XbaeInheritSelectAll)
                mwc->matrix_class.select_all = super->matrix_class.select_all;
        if (mwc->matrix_class.deselect_cell == XbaeInheritDeselectCell)
                mwc->matrix_class.deselect_cell = super->matrix_class.deselect_cell;
        if (mwc->matrix_class.deselect_row == XbaeInheritDeselectRow)
                mwc->matrix_class.deselect_row = super->matrix_class.deselect_row;
        if (mwc->matrix_class.deselect_column == XbaeInheritDeselectColumn)
                mwc->matrix_class.deselect_column = super->matrix_class.deselect_column;
        if (mwc->matrix_class.commit_edit == XbaeInheritCommitEdit)
                mwc->matrix_class.commit_edit = super->matrix_class.commit_edit;
        if (mwc->matrix_class.cancel_edit == XbaeInheritCancelEdit)
                mwc->matrix_class.cancel_edit = super->matrix_class.cancel_edit;
        if (mwc->matrix_class.add_rows == XbaeInheritAddRows)
                mwc->matrix_class.add_rows = super->matrix_class.add_rows;
        if (mwc->matrix_class.add_var_rows == XbaeInheritAddVarRows)
                mwc->matrix_class.add_var_rows = super->matrix_class.add_var_rows;
        if (mwc->matrix_class.delete_rows == XbaeInheritDeleteRows)
                mwc->matrix_class.delete_rows = super->matrix_class.delete_rows;
        if (mwc->matrix_class.add_columns == XbaeInheritAddColumns)
                mwc->matrix_class.add_columns = super->matrix_class.add_columns;
        if (mwc->matrix_class.delete_columns == XbaeInheritDeleteColumns)
                mwc->matrix_class.delete_columns = super->matrix_class.delete_columns;
        if (mwc->matrix_class.set_row_colors == XbaeInheritSetRowColors)
                mwc->matrix_class.set_row_colors = super->matrix_class.set_row_colors;
        if (mwc->matrix_class.set_column_colors == XbaeInheritSetColumnColors)
                mwc->matrix_class.set_column_colors = super->matrix_class.set_column_colors;
        if (mwc->matrix_class.set_cell_color == XbaeInheritSetCellColor)
                mwc->matrix_class.set_cell_color = super->matrix_class.set_cell_color;
}


/* used/referenced only #ifdef NEED_24BIT_VISUAL */
Widget _XbaeGetShellAncestor(Widget w)
{
        Widget sh;

        for (sh = w; !XtIsShell(sh); sh = XtParent(sh));
        return sh;
}


/*
 * Callbacks for our scrollbars.
 */
static XtCallbackRec VSCallback[] = {
        {(XtCallbackProc) xbaeScrollVertCB, (XtPointer) NULL},
        {(XtCallbackProc) NULL, NULL}
};
static XtCallbackRec HSCallback[] = {
        {(XtCallbackProc) xbaeScrollHorizCB, (XtPointer) NULL},
        {(XtCallbackProc) NULL, NULL}
};

/*
 * This is all to initialize resources that are no more
 */
typedef struct {
	char	**	*cells;
	Pixel	**	colors;
	Pixel	**	background;
    int     left_column;
    int     top_row;
} subr_t;

static XtResource subresources[] = {
	{
		XmNcells,
		XmCCells,
		XmRCellTable,
		sizeof(XtPointer),
		XtOffsetOf(subr_t, cells),
		XmRImmediate,
		NULL
	},
	{
		XmNcolors,
		XmCColors,
		XmRPixelTable,
		sizeof(XtPointer),
		XtOffsetOf(subr_t, colors),
		XmRImmediate,
		NULL
	},
	{
		XmNcellBackgrounds,
		XmCColors,
		XmRPixelTable,
		sizeof(XtPointer),
		XtOffsetOf(subr_t, background),
		XmRImmediate,
		NULL
	},
    {
        XmNleftColumn, 
        XmCLeftColumn, 
        XmRInt, 
        sizeof(int),
        XtOffsetOf(subr_t, left_column), 
        XmRImmediate, 
        NULL
    },
    {
        XmNtopRow, 
        XmCTopRow, 
        XmRInt, 
        sizeof(int),
        XtOffsetOf(subr_t, top_row), 
        XmRImmediate, 
        NULL
    }
};

#include <Xm/DialogS.h>

/* ARGSUSED */
static void
Initialize(Widget rw, Widget nw, ArgList args, Cardinal *num_args)
{
        XbaeMatrixWidget	request = (XbaeMatrixWidget)rw;
        XbaeMatrixWidget	new = (XbaeMatrixWidget)nw;
        Dimension		marginHeight;
        subr_t			base;
        Arg			al[5];
        int			ac;

        DEBUGOUT(_XbaeDebug(__FILE__, nw, "Initialize\n"));
        DEBUGOUT(_XbaeDebugPrintArgList(__FILE__, nw, args, *num_args, False));

        /* To clean up if our display connection disappears on us */
        xbaeRegisterDisplay((Widget) new);

        new->matrix.per_cell = NULL;
        new->matrix.num_selected_cells = 0;

        /*
         * Initialize redisplay counters
         */
        new->matrix.disable_redisplay = 0;

        /*
         * SGO: Have to initialize GCs
         */
        new->matrix.grid_line_gc = 0;
        new->matrix.label_gc = 0;
        new->matrix.draw_gc = 0;
        new->matrix.pixmap_gc = 0;
        new->matrix.resize_top_shadow_gc = 0;
        new->matrix.resize_bottom_shadow_gc = 0;

        /*
         ** Private State Initialization, missing from 4.50.2
         **
         ** A.J.Fountain, IST.
         */
        new->matrix.current_parent = (Widget) 0;
        new->matrix.row_max_heights = (int *) 0;
        new->matrix.fid = 0;
        new->matrix.label_fid = 0;
        new->matrix.num_selected_cells = 0;

        /*
         * Check rows/cols set by resources for consistency/validity
         */
        if (new->matrix.rows < 0 || new->matrix.columns < 0) {
                XtAppWarningMsg(XtWidgetToApplicationContext((Widget) new), "initialize", "badSize",
                                "XbaeMatrix",
                                "XbaeMatrix: Number of rows or columns is less than zero",
                                (String *) NULL, (Cardinal *) NULL);
                if (new->matrix.rows < 0)
                        new->matrix.rows = 0;
                if (new->matrix.columns < 0)
                        new->matrix.columns = 0;
        }
        
        /*
         * We must have at least one non-fixed row/column. Only complain if there
         * are some to complain about, though. We may have none at all (yet).
         */
        if ((int) (new->matrix.fixed_rows + new->matrix.trailing_fixed_rows) > 0
            && (int) (new->matrix.fixed_rows + new->matrix.trailing_fixed_rows) >=
            new->matrix.rows) {
                XtAppWarningMsg(XtWidgetToApplicationContext((Widget) new), "initialize",
                                "tooManyFixed", "XbaeMatrix",
                                "XbaeMatrix: At least one row must not be fixed", NULL, 0);
                new->matrix.fixed_rows = 0;
                new->matrix.trailing_fixed_rows = 0;
        }
        if ((int) (new->matrix.fixed_columns + new->matrix.trailing_fixed_columns) > 0
            && (int) (new->matrix.fixed_columns + new->matrix.trailing_fixed_columns) >=
            new->matrix.columns) {
                XtAppWarningMsg(XtWidgetToApplicationContext((Widget) new), "initialize",
                                "tooManyFixed", "XbaeMatrix",
                                "XbaeMatrix: At least one column must not be fixed", NULL, 0);
                new->matrix.fixed_columns = 0;
                new->matrix.trailing_fixed_columns = 0;
        }

        /*
         * Warn if a deprecated grid_type was specified
         */
        if (new->matrix.grid_type >= XmGRID_LINE)
                /* Deprecated types. To be removed in next version. */
                XtAppWarningMsg(XtWidgetToApplicationContext((Widget) new), "cvtStringToGridType",
                                "deprecatedType", "XbaeMatrix",
                                "Value for GridType is deprecated and will "
                                "be removed in next release",
                                NULL, NULL);

        /* If no label font is specified, copy the default fontList, but if
         * we do then override the bold_labels resource 
         */
        if (!new->matrix.label_font_list)
                new->matrix.label_font_list = XmFontListCopy(new->matrix.font_list);
        else
                new->matrix.bold_labels = False;

        /*
         * Copy the fontList. Get fontStruct from fontList.
         */
        xbaeNewFont(new, /* from init */ 1);
        xbaeNewLabelFont(new);

        /*
         * Make sure column_widths were specified.  If not, use a default value.
         * This should keep the XDesigner users happy....
         */
        if (new->matrix.columns) {
                if (new->matrix.column_widths == NULL) {
                        int i;

                        new->matrix.column_widths = (short *) XtMalloc(new->matrix.columns * sizeof(short));
                        for (i = 0; i < new->matrix.columns; i++)
                                new->matrix.column_widths[i] = DEFAULT_COLUMN_WIDTH(new);
                } else {
                        xbaeCopyColumnWidths(new);
                }
        }
        
        /*
         * If row_heights weren't specified, use a default value for all the rows
         */
        if (new->matrix.rows) {
                if (new->matrix.row_heights == NULL) {
                        int i;

                        new->matrix.row_heights = (short *) XtMalloc(new->matrix.rows * sizeof(short));
                        for (i = 0; i < new->matrix.rows; i++)
                                new->matrix.row_heights[i] = DEFAULT_ROW_HEIGHT(new);
                } else {
                        xbaeCopyRowHeights(new);
                }
        }

        /*
         * Copy the pointed to resources.
         * If cells is NULL, we create an array of "" strings.
         */
        if (new->matrix.row_labels)
                xbaeCopyRowLabels(new);
        if (new->matrix.column_labels || new->matrix.xmcolumn_labels)
                xbaeCopyColumnLabels(new);
        else {
                new->matrix.column_label_lines = NULL;
                new->matrix.column_label_maxlines = 0;
        }

        if (new->matrix.row_shadow_types)
                xbaeCopyRowShadowTypes(new);
        if (new->matrix.column_shadow_types)
                xbaeCopyColumnShadowTypes(new);

        if (new->matrix.row_user_data)
                xbaeCopyRowUserData(new);
        if (new->matrix.column_user_data)
                xbaeCopyColumnUserData(new);

        if (new->matrix.column_button_labels)
                xbaeCopyColumnButtonLabels(new);
        if (new->matrix.row_button_labels)
                xbaeCopyRowButtonLabels(new);

        if (new->matrix.column_max_lengths)
                xbaeCopyColumnMaxLengths(new);

        if (new->matrix.column_alignments)
                xbaeCopyColumnAlignments(new);

        if (new->matrix.column_font_bold)
                xbaeCopyColumnFontBold(new);

        if (new->matrix.column_label_alignments)
                xbaeCopyColumnLabelAlignments(new);

        if (new->matrix.show_column_arrows)
                 xbaeCopyShowColumnArrows(new);

        /*
         * If user didn't specify a rowLabelWidth, then calculate one based on
         * the widest label
         */
        if (new->matrix.row_label_width == 0 && new->matrix.row_labels)
                new->matrix.row_label_width = xbaeMaxRowLabel(new);

        /*
         * Create our 4 children (SBs and textField are unmanaged for now)
         * they must be created in this order so our macros work
         * (horiz scroll, vert scroll and then clip and textField).
         * We scroll horizontally by pixels, vertically by rows.
         */
        new->matrix.horizontal_sb =
            XtVaCreateWidget("horizScroll", xmScrollBarWidgetClass, (Widget) new, 
                             XmNorientation, XmHORIZONTAL, 
                             XmNdragCallback, HSCallback, 
                             XmNvalueChangedCallback, HSCallback, 
                             XmNincrement, FONT_WIDTH(new), 
                             XmNsliderSize, 1,
                             XmNminimum, 0, 
                             XmNmaximum, 1, 
                             XmNbackground, new->matrix.scroll_background, 
                             XmNforeground, new->manager.foreground,
                             XmNbottomShadowColor, new->manager.bottom_shadow_color,
                             XmNbottomShadowPixmap, new->manager.bottom_shadow_pixmap,
                             XmNhighlightColor, new->manager.highlight_color, 
                             XmNhighlightPixmap, new->manager.highlight_pixmap, 
                             XmNtopShadowColor, new->manager.top_shadow_color, 
                             XmNtopShadowPixmap, new->manager.top_shadow_pixmap, 
                             NULL);

        HORIZ_ORIGIN(new) = 0;

        new->matrix.vertical_sb =
            XtVaCreateWidget("vertScroll", xmScrollBarWidgetClass, (Widget) new, 
                             XmNorientation, XmVERTICAL, 
                             XmNdragCallback, VSCallback, 
                             XmNvalueChangedCallback, VSCallback,
                             /* used default initializers, will be corrected afterwards */
                             XmNincrement, DEFAULT_ROW_HEIGHT(new),     /* SGO: changed default values to simple values, */
                             XmNminimum, 0,     /*  gonna be corrected in SetValues() */
                             XmNmaximum, 1,
                             XmNsliderSize, 1,
                             XmNbackground, new->matrix.scroll_background,
                             XmNforeground, new->manager.foreground,
                             XmNbottomShadowColor, new->manager.bottom_shadow_color,
                             XmNbottomShadowPixmap, new->manager.bottom_shadow_pixmap,
                             XmNhighlightColor, new->manager.highlight_color,
                             XmNhighlightPixmap, new->manager.highlight_pixmap,
                             XmNtopShadowColor, new->manager.top_shadow_color,
                             XmNtopShadowPixmap, new->manager.top_shadow_pixmap, 
                             NULL);

        VERT_ORIGIN(new) = 0;

        if (new->matrix.text_translations == NULL) {
                Widget shell = _XbaeGetShellAncestor(nw);

                if (XtIsSubclass(shell, xmDialogShellWidgetClass)) {
                        new->matrix.text_translations = XtParseTranslationTable(default_dialog_text_translations);
                } else {
                        new->matrix.text_translations = XtParseTranslationTable(default_text_translations);
                }
        }

        /*
         * Create 7 clips for the 7 scrollable regions.
         * Create the ClipChild widget managed so we can use it for traversal
         */
        new->matrix.clip_window = XtVaCreateManagedWidget("clip", xbaeClipWidgetClass, (Widget) new,
                                                          XmNexposeProc, ClipRedisplay,
                                                          XmNtraversalOn, new->manager.traversal_on,
                                                          XmNtranslations, new->matrix.text_translations, 
                                                          XmNbackground, new->core.background_pixel,
                                                          NULL);
        new->matrix.left_clip = XtVaCreateWidget("leftclip", xbaeClipWidgetClass, (Widget) new,
                                                 XmNexposeProc, ClipRedisplay,
                                                 XmNtraversalOn, False,
                                                 XmNbackground, new->core.background_pixel, 
                                                 NULL);
        new->matrix.right_clip = XtVaCreateWidget("rightclip", xbaeClipWidgetClass, (Widget) new,
                                                  XmNexposeProc, ClipRedisplay,
                                                  XmNtraversalOn, False,
                                                  XmNbackground, new->core.background_pixel, 
                                                  NULL);
        new->matrix.top_clip = XtVaCreateWidget("topclip", xbaeClipWidgetClass, (Widget) new,
                                                XmNexposeProc, ClipRedisplay,
                                                XmNtraversalOn, False,
                                                XmNbackground, new->core.background_pixel, 
                                                NULL);
        new->matrix.bottom_clip = XtVaCreateWidget("bottomclip", xbaeClipWidgetClass, (Widget) new,
                                                   XmNexposeProc, ClipRedisplay,
                                                   XmNtraversalOn, False,
                                                   XmNbackground, new->core.background_pixel, 
                                                   NULL);
        new->matrix.row_label_clip = XtVaCreateWidget("rowlabelclip", xbaeClipWidgetClass, (Widget) new,
                                                   XmNexposeProc, ClipRedisplay,
                                                   XmNtraversalOn, False,
                                                   XmNbackground, new->core.background_pixel, 
                                                   NULL);
        new->matrix.column_label_clip = XtVaCreateWidget("columnlabelclip", xbaeClipWidgetClass, (Widget) new,
                                                   XmNexposeProc, ClipRedisplay,
                                                   XmNtraversalOn, False,
                                                   XmNbackground, new->core.background_pixel, 
                                                   NULL);

        /*
         * Add a callback to the Clip widget so we know when it gets the focus
         * and can use it in traversal.
         */
        XtAddCallback(ClipChild(new), XmNfocusCallback, (XtCallbackProc) TraverseInCB,
                      (XtPointer) new);

        /*
         * Calculate an imaginary cellMarginHeight based on the largest of
         * the label and cell font.  If the font for the labels is bigger,
         * the cellMarginHeight needs to be increased to allow the cell font
         * to still appear centrally placed
         */
        if (LABEL_HEIGHT(new) > FONT_HEIGHT(new))
                marginHeight =
                    (int) (LABEL_HEIGHT(new) + (new->matrix.cell_margin_height * 2) -
                           FONT_HEIGHT(new)) / 2;
        else
                marginHeight = new->matrix.cell_margin_height;

        /*
         * Create text field (unmanaged for now) - its window will be reparented
         * in Realize to be a subwindow of Clip
         *
         * Set the shadow thickness to 0 to prevent a shadow drawn inside the
         * highlight region.  The shadow thickness is used to draw the shadows
         * *around* the highlight.
         *
         * Bug Fix for Release Xbae-4.50.3 with margin width -
         * If it 0 or less, then user cannot backspace in the Text Widget
         * doesn't work correctly.
         */
        if (new->matrix.cell_margin_width <= 1) {
                new->matrix.cell_margin_width = 3;      /* the original default */
        }
        
        new->matrix.text_field = XtVaCreateWidget("textField",
                                                  new->matrix.useXbaeInput 
                                                   ? xbaeInputWidgetClass 
                                                   : xmTextWidgetClass, 
                                                  (Widget) new, 
                                                  XmNmarginWidth, new->matrix.cell_margin_width, 
                                                  XmNmarginHeight, marginHeight, 
                                                  XmNtranslations, new->matrix.text_translations, 
                                                  XmNfontList, new->matrix.font_list, 
                                                  XmNshadowThickness, new->matrix.text_shadow_thickness, 
                                                  XmNbackground, new->matrix.text_background, 
                                                  XmNforeground, new->manager.foreground, 
                                                  XmNbottomShadowColor, new->manager.bottom_shadow_color,
                                                  XmNbottomShadowPixmap, new->manager.bottom_shadow_pixmap,
                                                  XmNhighlightThickness, new->matrix.cell_highlight_thickness,
                                                  XmNhighlightColor, new->manager.highlight_color,
                                                  XmNhighlightPixmap, new->manager.highlight_pixmap,
                                                  XmNeditMode, XmSINGLE_LINE_EDIT,
                                                  XmNnavigationType, XmNONE,
                                                  NULL);

        XtAddCallback(TextChild(new), XmNmodifyVerifyCallback, xbaeModifyVerifyCB, (XtPointer) new);
        XtAddCallback(TextChild(new), XmNvalueChangedCallback, xbaeValueChangedCB, (XtPointer) new);

        /* Add a handler on top of the text field to handle clicks on it */
        XtAddEventHandler(TextChild(new),
                          ButtonPressMask | ButtonReleaseMask,
                          True, (XtEventHandler) xbaeHandleClick, (XtPointer) new);
        XtAddEventHandler((Widget) new,
                          ButtonPressMask | ButtonReleaseMask,
                          True, (XtEventHandler) xbaeHandleClick, (XtPointer) new);

        /*
         * Compute cell text baseline based on TextField widget
         */
        new->matrix.text_baseline =
            XmTextGetBaseline(TextChild(new)) + new->matrix.cell_shadow_thickness;

        /*
         * Adjust the label_baseline according to the larger of the two fonts
         */
        if (LABEL_HEIGHT(new) == FONT_HEIGHT(new))
                new->matrix.label_baseline = new->matrix.text_baseline;
        else {
                if (LABEL_HEIGHT(new) < FONT_HEIGHT(new))
                        marginHeight =
                            (int) (FONT_HEIGHT(new) + new->matrix.text_shadow_thickness * 2 +
                                   new->matrix.cell_margin_height * 2 - LABEL_HEIGHT(new)) / 2;
                else
                        marginHeight =
                            new->matrix.cell_margin_height + new->matrix.text_shadow_thickness;

                new->matrix.label_baseline =
                    marginHeight + new->matrix.cell_shadow_thickness - new->matrix.label_font_y;
        }

        /*
         * Cache the pixel position of each column
         */

        new->matrix.column_positions = CreateColumnPositions(new);
        new->matrix.row_positions = CreateRowPositions(new);

        xbaeGetColumnPositions(new);
        xbaeGetRowPositions(new);

        /*
         * No cell ever had the focus
         */
        
        new->matrix.current_row = -1;
        new->matrix.current_column = -1;

        /*
         * Now we have created our GCs, check if the widget is sensitive
         */
        if (!new->core.sensitive) {
                XGCValues values;
                unsigned long valuemask = GCFillStyle;
                Display *dpy = XtDisplay(new);
                int i;

                values.fill_style = FillStippled;

                /*
                 * Change our drawing GC's to the stipple effect to indicate
                 * the widget is insensitive and redraw
                 */
                XChangeGC(dpy, new->matrix.draw_gc, valuemask, &values);
                XChangeGC(dpy, new->matrix.label_gc, valuemask, &values);
                XChangeGC(dpy, new->matrix.pixmap_gc, valuemask, &values);
                /*
                 * Propogate the insensitive feel to our children
                 */
                for (i = 0; i < XbaeNumChildren; i++)
                        XtSetSensitive(new->composite.children[i], False);
        }

        /*
         * Set the last row and column to an impossible value
         */
        new->matrix.last_row = -1;
        new->matrix.last_column = -1;
        new->matrix.last_click_time = (Time) 0;

        /*
         * Compute our size.  If either dimension was explicitly set to 0,
         * then that dimension is computed.
         * Use request because superclasses modify width/height.
         */
        if (request->core.width == 0 || request->core.height == 0)
                xbaeComputeSize(new, request->core.width == 0, request->core.height == 0);

        /*
         * Layout the scrollbars and clip widget based on our size
         */
        xbaeRelayout(new);

        new->matrix.traverseId = (XtIntervalId) 0;
        new->matrix.cursor = (Cursor) 0;

        /*
         * Deal with the hidden resources (that are no longer resources but elements of
         * the per cell structure).
         */
        base.cells = 0;
        XtGetSubresources(nw, &base, XtName(nw), "xbaeMatrixWidgetClass",
		        subresources, XtNumber(subresources),
		        args, *num_args);
        ac = 0;
        XtSetArg(al[ac], XmNcells, base.cells); ac++;
        XtSetArg(al[ac], XmNcolors, base.colors); ac++;
        XtSetArg(al[ac], XmNcellBackgrounds, base.background); ac++;
        XtSetArg(al[ac], XmNleftColumn, base.left_column); ac++;
        XtSetArg(al[ac], XmNtopRow, base.top_row); ac++;
        SetValuesHook(nw, al, &ac);
#if 0
        fprintf(stderr, "BASE cells %p\n", base.cells);
            { int i, j;
                for (i=0; i<new->matrix.rows; i++)
                    for (j=0; j<new->matrix.columns; j++)
                        fprintf(stderr, "\tCell[%d][%d] = {%s}\n", i, j, base.cells[i][j]);
            }
#endif
}

static void Realize(XbaeMatrixWidget mw, XtValueMask * valueMask, XSetWindowAttributes * attributes)
{

        *valueMask |= CWDontPropagate;
        attributes->do_not_propagate_mask =
            ButtonPressMask | ButtonReleaseMask | KeyPressMask | KeyReleaseMask | PointerMotionMask;

        /*
         * Don't call our superclasses realize method, because Manager sets
         * bit_gravity
         */
        XtCreateWindow((Widget) mw, InputOutput, CopyFromParent, *valueMask, attributes);

        /*
         * Now that we have a window...
         * Get/create our GCs
         */
        /*
         ** This code used to call the create methods directly,
         ** which isnt a great idea since SetValues makes assumptions
         ** which are not valid if the widget is not realized.
         **
         ** SetValues now creates the GC on the fly if necessary.
         ** Hence check if they are not created first.
         **
         ** A.J.Fountain, IST.
         */

        if (!mw->matrix.draw_gc)
                xbaeCreateDrawGC(mw);

        if (!mw->matrix.pixmap_gc)
                xbaeCreatePixmapGC(mw);

        if (!mw->matrix.label_gc)
                xbaeCreateLabelGC(mw);

        if (!mw->matrix.grid_line_gc)
                xbaeGetGridLineGC(mw);

        if (!mw->matrix.resize_top_shadow_gc)
                xbaeGetResizeTopShadowGC(mw);

        if (!mw->matrix.resize_bottom_shadow_gc)
                xbaeGetResizeBottomShadowGC(mw);

        /*
         * Reparent the textFields window to be a subwindow of Clip widget
         * (we need to realize them first)
         */
        XtRealizeWidget(TextChild(mw));
        XtRealizeWidget(ClipChild(mw));
        XtRealizeWidget(LeftClip(mw));
        XtRealizeWidget(RightClip(mw));
        XtRealizeWidget(TopClip(mw));
        XtRealizeWidget(BottomClip(mw));
        XtRealizeWidget(RowLabelClip(mw));
        XtRealizeWidget(ColumnLabelClip(mw));
        XReparentWindow(XtDisplay(mw), XtWindow(TextChild(mw)), XtWindow(ClipChild(mw)),
                        TextChild(mw)->core.x, TextChild(mw)->core.y);
        mw->matrix.current_parent = ClipChild(mw);

        /*
         * Make sure the user widgets get realized and
         * then reparented.
         * -- Linas */
        if (mw->matrix.per_cell) {
                int row, col;
                for (row = 0; row < mw->matrix.rows; row++) {
                        for (col = 0; col < mw->matrix.columns; col++) {
                                Widget uw = mw->matrix.per_cell[row][col].widget;
                                if (uw) {
                                        XtRealizeWidget(uw);

                                        if (XmIsGadget(uw)) {
                                                /*
                                                * FIX ME don't know how to deal with gadgets
                                                */
                                        } else {
                                                xbaePositionCellWidget(mw, row, col);
                                        }
                                }
                        }
                }
        }

        /*
         * Init
         */
        mw->matrix.prev_column = -1;    /* Used to compare tracking callback */
        mw->matrix.prev_row = -1;       /* Used to compare tracking callback */
}

static void InsertChild(Widget w)
{
        ((XmManagerWidgetClass) (xbaeMatrixWidgetClass->core_class.superclass))->composite_class.insert_child(w);
}

/*
 * This is the expose method for the Matrix widget.
 * It redraws the fixed labels, the cells in totally fixed cells
 * and the shadow.
 */

/* ARGSUSED */
static void Redisplay(Widget w, XEvent *event, Region region)
{
        XbaeMatrixWidget mw = (XbaeMatrixWidget) w;
        XRectangle expose;

        if (mw->matrix.disable_redisplay)
                return;

        if (!XtIsRealized(w))
                return;

        /*
         * Get the expose rectangle from the XEvent
         */

        switch (event->type) {
        case Expose:
        
                expose.x = event->xexpose.x;
                expose.y = event->xexpose.y;
                expose.width = event->xexpose.width;
                expose.height = event->xexpose.height;
                
                break;

        case GraphicsExpose:
        
                expose.x = event->xgraphicsexpose.x;
                expose.y = event->xgraphicsexpose.y;
                expose.width = event->xgraphicsexpose.width;
                expose.height = event->xgraphicsexpose.height;
                
                break;
                
        case NoExpose:
        default:
                return;
        }
        xbaeRedrawLabelsAndFixed(mw, &expose);
}

/*
 * This is the exposeProc function for the Clip widgets.
 * It handles expose events for the Clip widgets by redrawing those
 * non-fixed cells which were damaged.
 * It receives Expose, GraphicsExpose and NoExpose events.
 */

/* ARGSUSED */
static void ClipRedisplay(Widget w, XRectangle *expose, XEvent * event, Region r)
{
        XbaeMatrixWidget mw = (XbaeMatrixWidget) XtParent(w);
        XRectangle region;

        if (mw->matrix.disable_redisplay)
                return;

        /*
         * Make the expose rectangle relative to the matrix 
         */

        expose->x += w->core.x;
        expose->y += w->core.y;
        
        region.x = w->core.x;
        region.y = w->core.y;
        region.width = w->core.width;
        region.height = w->core.height;
        
        xbaeRedrawRegion(mw, expose, &region);
}

/*
 * Handle XmNcells, which is no longer a widget resource, but hidden in the per cell structure.
 */
static Boolean
SetValuesHook(Widget w, ArgList args, Cardinal *nargs)
{
	XbaeMatrixWidget	mw = (XbaeMatrixWidget)w;
	Boolean			redisplay = False;
	int			i, row, col;

	for (i=0; i<*nargs; i++) {
		DEBUGOUT(_XbaeDebug(__FILE__, w, "SetValuesHook(%s)\n", args[i].name));

        if (strcmp(args[i].name, XmNcells) == 0) {
			char	***cells = (char ***)args[i].value;

			if (!cells)
				continue;

			/*
			 * Create the per cell structure if needed
			 */
			if (! mw->matrix.per_cell)
				xbaeCreatePerCell(mw);

			/*
			 * This is a two-dimensional array of cells.
			 * Each cell is a string.
			 * Copy them.
			 */
			for (row = 0; row < mw->matrix.rows; row++) {
                if (cells[row] == NULL) {
                    XtAppWarningMsg(XtWidgetToApplicationContext((Widget) mw),
                                    "setValuesHook", "tooShort",
                                    "XbaeMatrix",
                                    "XbaeMatrix: Not enough rows in cells array",
                                    NULL, 0);
                    break;
                }
                
				for (col = 0; col < mw->matrix.columns; col++) {
                    if (cells[row][col] == &xbaeBadString) {
                        XtAppWarningMsg(XtWidgetToApplicationContext((Widget) mw),
                                        "setValuesHook", "tooShort",
                                        "XbaeMatrix",
                                        "XbaeMatrix: Not enough columns in cells array",
                                        NULL, 0);
                        break;
                    }
                    
                    if (mw->matrix.per_cell[row][col].CellValue) {
                        if (strcmp(mw->matrix.per_cell[row][col].CellValue, cells[row][col]) != 0) {
    						XtFree(mw->matrix.per_cell[row][col].CellValue);
    					    mw->matrix.per_cell[row][col].CellValue = XtNewString(cells[row][col]);
                            xbaeDrawCell(mw, row, col);
                        }
                    } else {
    					mw->matrix.per_cell[row][col].CellValue = XtNewString(cells[row][col]);
                        xbaeDrawCell(mw, row, col);
                    }
				}
            }

            if (XtIsManaged(TextChild(mw))) {
                    /* 
                     * Remove the modify verify callback when the text field is set.
                     * It thinks we are modifying the value - Motif thinks that
                     * it knows best but we know better! 
                     */
                    XtRemoveCallback(TextChild(mw), XmNmodifyVerifyCallback,
                                     xbaeModifyVerifyCB, (XtPointer) mw);
                    
                    XmTextSetString(TextChild(mw), mw->matrix.per_cell[mw->matrix.current_row][mw->matrix.current_column].CellValue);

                    XtAddCallback(TextChild(mw), XmNmodifyVerifyCallback,
                                  xbaeModifyVerifyCB, (XtPointer) mw);
            }

		} else if (strcmp(args[i].name, XmNcellShadowTypes) == 0) {
            unsigned char	**st = (unsigned char **)args[i].value;

            /* Tobias: FIXME There is no converter for this resource */

			if (!st)
				continue;

			/*
			 * Create the per cell structure if needed
			 */
			if (! mw->matrix.per_cell)
				xbaeCreatePerCell(mw);

			/*
			 * This is a two-dimensional array of data, each item is one byte.
			 */
			for (row = 0; row < mw->matrix.rows; row++) {
                if (st[row] == NULL) {
                    XtAppWarningMsg(XtWidgetToApplicationContext((Widget) mw),
                                    "setValuesHook", "tooShort",
                                    "XbaeMatrix",
                                    "XbaeMatrix: Not enough rows in cellsShadowTypes array",
                                    NULL, 0);
                    break;
                }
                
				for (col = 0; col < mw->matrix.columns; col++) {
                    if (st[row][col] == BAD_SHADOW) {
                        XtAppWarningMsg(XtWidgetToApplicationContext((Widget) mw),
                                        "setValuesHook", "tooShort",
                                        "XbaeMatrix",
                                        "XbaeMatrix: Not enough columns in cellsShadowTypes array",
                                        NULL, 0);
                        break;
                    }
                    
                    if (mw->matrix.per_cell[row][col].shadow_type != st[row][col]) {
					    mw->matrix.per_cell[row][col].shadow_type = st[row][col];
                        xbaeDrawCell(mw, row, col);
                    }
				}
            }

		} else if (strcmp(args[i].name, XmNcellBackgrounds) == 0) {
			Pixel	**bg = (Pixel **)args[i].value;;

			if (!bg)
				continue;

			/*
			 * Create the per cell structure if needed
			 */
			if (! mw->matrix.per_cell)
				xbaeCreatePerCell(mw);

			/*
			 * This is a two-dimensional array of data, each item is one byte.
			 */
			for (row = 0; row < mw->matrix.rows; row++) {
                if (bg[row] == NULL) {
                    XtAppWarningMsg(XtWidgetToApplicationContext((Widget) mw),
                                    "setValuesHook", "tooShort",
                                    "XbaeMatrix",
                                    "XbaeMatrix: Not enough rows in backgrounds array",
                                    NULL, 0);
                    break;
                }

				for (col = 0; col < mw->matrix.columns; col++) {
                    if (bg[row][col] == BAD_PIXEL) {
                        XtAppWarningMsg(XtWidgetToApplicationContext((Widget) mw),
                                        "setValuesHook", "tooShort",
                                        "XbaeMatrix",
                                        "XbaeMatrix: Not enough columns in backgrounds array",
                                        NULL, 0);
                        break;
                    }

					if (mw->matrix.per_cell[row][col].background != bg[row][col]) {
                        mw->matrix.per_cell[row][col].background = bg[row][col];			
                        xbaeDrawCell(mw, row, col);
                    }
                }
            }

		} else if (strcmp(args[i].name, XmNcolors) == 0) {
			Pixel	**fg = (Pixel **)args[i].value;

			if (! fg)
				continue;

			/*
			 * Create the per cell structure if needed
			 */
			if (! mw->matrix.per_cell)
				xbaeCreatePerCell(mw);

			/*
			 * This is a two-dimensional array of data, each item is one byte.
			 */
			for (row = 0; row < mw->matrix.rows; row++) {
                if (fg[row] == NULL) {
                    XtAppWarningMsg(XtWidgetToApplicationContext((Widget) mw),
                                    "setValuesHook", "tooShort",
                                    "XbaeMatrix",
                                    "XbaeMatrix: Not enough rows in colors array",
                                    NULL, 0);
                    break;
                }

				for (col = 0; col < mw->matrix.columns; col++) {
                    if (fg[row][col] == BAD_PIXEL) {
                        XtAppWarningMsg(XtWidgetToApplicationContext((Widget) mw),
                                        "setValuesHook", "tooShort",
                                        "XbaeMatrix",
                                        "XbaeMatrix: Not enough columns in colors array",
                                        NULL, 0);
                        break;
                    }

					if (mw->matrix.per_cell[row][col].color != fg[row][col]) {
    					mw->matrix.per_cell[row][col].color = fg[row][col];
                        xbaeDrawCell(mw, row, col);
                    }
                }
            }

		} else if (strcmp(args[i].name, XmNleftColumn) == 0) {
            XmScrollBarCallbackStruct call_data;
            call_data.value = xbaeCalculateHorizOrigin(mw, args[i].value);
            xbaeScrollHorizCB((Widget) HorizScrollChild(mw), NULL, &call_data);
            XtVaSetValues(HorizScrollChild(mw), XmNvalue, HORIZ_ORIGIN(mw), NULL);
        } else if (strcmp(args[i].name, XmNtopRow) == 0) {
            XmScrollBarCallbackStruct call_data;
            call_data.value = xbaeCalculateVertOrigin(mw, args[i].value);
            xbaeScrollVertCB((Widget) VertScrollChild(mw), NULL, &call_data);
            XtVaSetValues(VertScrollChild(mw), XmNvalue, VERT_ORIGIN(mw), NULL);
        }
	}
	return redisplay;
}

static void
GetValuesHook(Widget w, ArgList args, Cardinal *nargs)
{
	XbaeMatrixWidget	mw = (XbaeMatrixWidget)w;
	int			i, row, col;

	for (i=0; i<*nargs; i++) {
		if (strcmp(args[i].name, XmNcells) == 0) {
			char	***cells, ****p;
			/*
			 * If the per cell structure isn't there yet, don't return anything.
			 */
			if (! mw->matrix.per_cell)
				continue;	/* on to the next ARG */

			/*
			 * This is a two-dimensional array of cells.
			 * Each cell is a string.
			 * Copy them.
			 */
			cells = (char ***)XtMalloc(mw->matrix.rows * sizeof(char **));
			for (row = 0; row < mw->matrix.rows; row++) {
				cells[row] = (char **)XtMalloc(mw->matrix.columns * sizeof(char *));
				for (col = 0; col < mw->matrix.columns; col++) {
					cells[row][col] = XtNewString(
						mw->matrix.per_cell[row][col].CellValue);
				}
			}
			p = (char ****)args[i].value;
			*p = cells;
		} else if (strcmp(args[i].name, XmNcellShadowTypes) == 0) {
			unsigned char	**shadow_types, ***p;
			/*
			 * If the per cell structure isn't there yet, don't return anything.
			 */
			if (! mw->matrix.per_cell)
				continue;	/* on to the next ARG */

			/*
			 * This is a two-dimensional array of cells.
			 * Each cell is a string.
			 * Copy them.
			 */
			shadow_types = (unsigned char **)XtMalloc(mw->matrix.rows
				* sizeof(unsigned char *));
			for (row = 0; row < mw->matrix.rows; row++) {
				shadow_types[row] = (unsigned char *)XtMalloc(mw->matrix.columns);
				for (col = 0; col < mw->matrix.columns; col++) {
					shadow_types[row][col] = mw->matrix.per_cell[row][col].shadow_type;
				}
			}
			p = (unsigned char ***)args[i].value;
			*p = shadow_types;
		} else if (strcmp(args[i].name, XmNcellBackgrounds) == 0) {
			Pixel **bg, ***p;
			/*
			 * If the per cell structure isn't there yet, don't return anything.
			 */
			if (! mw->matrix.per_cell)
				continue;	/* on to the next ARG */

			/*
			 * This is a two-dimensional array of cells.
			 * Each cell is a string.
			 * Copy them.
			 */
			bg = (Pixel **)XtMalloc(mw->matrix.rows
				* sizeof(Pixel *));
			for (row = 0; row < mw->matrix.rows; row++) {
				bg[row] = (Pixel *)XtMalloc(mw->matrix.columns * sizeof(Pixel));
				for (col = 0; col < mw->matrix.columns; col++) {
					bg[row][col] = mw->matrix.per_cell[row][col].background;
				}
			}
			p = (Pixel ***)args[i].value;
			*p = bg;
		} else if (strcmp(args[i].name, XmNcolors) == 0) {
			Pixel **fg, ***p;
			/*
			 * If the per cell structure isn't there yet, don't return anything.
			 */
			if (! mw->matrix.per_cell)
				continue;	/* on to the next ARG */

			/*
			 * This is a two-dimensional array of cells.
			 * Each cell is a string.
			 * Copy them.
			 */
			fg = (Pixel **)XtMalloc(mw->matrix.rows
				* sizeof(Pixel *));
			for (row = 0; row < mw->matrix.rows; row++) {
				fg[row] = (Pixel *)XtMalloc(mw->matrix.columns * sizeof(Pixel));
				for (col = 0; col < mw->matrix.columns; col++) {
					fg[row][col] = mw->matrix.per_cell[row][col].color;
				}
			}
			p = (Pixel ***)args[i].value;
			*p = fg;
		} else if (strcmp(args[i].name, XmNleftColumn) == 0) {
            int *p = (int *) args[i].value;
            *p = xbaeLeftColumn(mw);
        } else if (strcmp(args[i].name, XmNtopRow) == 0) {
            int *p = (int *) args[i].value;
            *p = xbaeTopRow(mw);
        }
	}
}

/* ARGSUSED */
static Boolean
SetValues(XbaeMatrixWidget current, XbaeMatrixWidget request, XbaeMatrixWidget new, ArgList args,
          Cardinal * num_args)
{

        Boolean redisplay = False;      /* need to redraw */
        Boolean relayout = False;       /* need to layout, but same size */
        Boolean new_column_widths = False;      /* column widths changed */
        Boolean new_row_heights = False;        /* row heights changed */
        int n;
        Arg wargs[9];

#define NE(field)	(current->field != new->field)
#define EQ(field)	(current->field == new->field)

        /*
         * We cannot re-set either of the scrollbars, the textField or
         * clip window.
         */
        if (NE(matrix.vertical_sb) || NE(matrix.horizontal_sb) || NE(matrix.clip_window)
            || NE(matrix.text_field)) {
                XtAppWarningMsg(XtWidgetToApplicationContext((Widget) new), "setValues",
                                "set matrix children", "XbaeMatrix",
                                "XbaeMatrix: Cannot set matrix widget children", NULL, 0);
                new->matrix.vertical_sb = current->matrix.vertical_sb;
                new->matrix.horizontal_sb = current->matrix.horizontal_sb;
                new->matrix.clip_window = current->matrix.clip_window;
                new->matrix.text_field = current->matrix.text_field;
        }

        /*
         * If rows changed, then:
         *  row_labels must change or be NULL
         *  row_button_labels must change or be NULL
         */
        if (NE(matrix.rows)
            && ((new->matrix.row_labels && EQ(matrix.row_labels))
                || (new->matrix.row_button_labels && EQ(matrix.row_button_labels)))) {
                XtAppWarningMsg(XtWidgetToApplicationContext((Widget) new), "setValues", "rows",
                                "XbaeMatrix",
                                "XbaeMatrix: Number of rows changed but dependent resources did not",
                                NULL, 0);
                new->matrix.rows = current->matrix.rows;
                new->matrix.row_labels = current->matrix.row_labels;
                new->matrix.row_button_labels = current->matrix.row_button_labels;
        }

        /*
         * If columns changed, then:
         *  column_max_lengths must change or be NULL
         *  column_labels must change or be NULL
         *  column_xmlabels must change or be NULL
         *  column_alignments must change or be NULL
         *  column_button_labels must change or be NULL
         *  column_label_alignments must change or be NULL
         *  show_column_arrows must change or be NULL
         */
        if (NE(matrix.columns)
            && ((new->matrix.column_labels && EQ(matrix.column_labels))
                || (new->matrix.xmcolumn_labels && EQ(matrix.xmcolumn_labels))
                || (new->matrix.column_max_lengths && EQ(matrix.column_max_lengths))
                || (new->matrix.column_alignments && EQ(matrix.column_alignments))
                || (new->matrix.column_font_bold && EQ(matrix.column_font_bold))
                || (new->matrix.column_button_labels && EQ(matrix.column_button_labels))
                || (new->matrix.column_label_alignments && EQ(matrix.column_label_alignments))
                || (new->matrix.show_column_arrows && EQ(matrix.show_column_arrows)))) {
                XtAppWarningMsg(XtWidgetToApplicationContext((Widget) new), "setValues", "columns",
                                "XbaeMatrix",
                                "XbaeMatrix: Number of columns changed but dependent resources did not",
                                NULL, 0);
                /* FIX ME Are there memory leaks here ? */
                new->matrix.columns = current->matrix.columns;
                new->matrix.column_max_lengths = current->matrix.column_max_lengths;
                new->matrix.column_labels = current->matrix.column_labels;
                new->matrix.xmcolumn_labels = current->matrix.xmcolumn_labels;
                new->matrix.column_alignments = current->matrix.column_alignments;
                new->matrix.column_font_bold = current->matrix.column_font_bold;
                new->matrix.column_button_labels = current->matrix.column_button_labels;
                new->matrix.column_label_alignments = current->matrix.column_label_alignments;
                new->matrix.show_column_arrows = current->matrix.show_column_arrows;
        }

        /*
         * Make sure we have at least one row/column.
         */
        if (new->matrix.columns < 0 || new->matrix.rows < 0) {
                XtAppWarningMsg(XtWidgetToApplicationContext((Widget) new), "setValues", "size",
                                "XbaeMatrix", "XbaeMatrix: Number of rows or columns is less than zero",
                                NULL, 0);
                if (new->matrix.columns < 0)
                        new->matrix.columns = current->matrix.columns;
                if (new->matrix.rows < 0)
                        new->matrix.rows = current->matrix.rows;
        }


        /*
         * We must have at least one non-fixed row/column.
         * This could be caused by (trailing) fixed_rows/columns or
         * rows/columns changing.
         */
        if ((int) (new->matrix.fixed_rows + new->matrix.trailing_fixed_rows) > 0
            && (int) (new->matrix.fixed_rows + new->matrix.trailing_fixed_rows) >=
            new->matrix.rows) {
                XtAppWarningMsg(XtWidgetToApplicationContext((Widget) new), "setValues",
                                "tooManyFixed", "XbaeMatrix",
                                "XbaeMatrix: At least one row must not be fixed", NULL, 0);

                if (NE(matrix.fixed_rows))
                        new->matrix.fixed_rows = current->matrix.fixed_rows;
                if (NE(matrix.trailing_fixed_rows))
                        new->matrix.trailing_fixed_rows = current->matrix.trailing_fixed_rows;
                if (NE(matrix.rows))
                        new->matrix.rows = current->matrix.rows;
        }
        if ((int) (new->matrix.fixed_columns + new->matrix.trailing_fixed_columns) > 0
            && (int) (new->matrix.fixed_columns + new->matrix.trailing_fixed_columns) >=
            new->matrix.columns) {
                XtAppWarningMsg(XtWidgetToApplicationContext((Widget) new), "setValues",
                                "tooManyFixed", "XbaeMatrix",
                                "XbaeMatrix: At least one column must not be fixed", NULL, 0);

                if (NE(matrix.fixed_columns))
                        new->matrix.fixed_columns = current->matrix.fixed_columns;
                if (NE(matrix.trailing_fixed_columns))
                        new->matrix.trailing_fixed_columns = current->matrix.trailing_fixed_columns;
                if (NE(matrix.columns))
                        new->matrix.columns = current->matrix.columns;
        }

        if (NE(matrix.row_user_data)) {
                xbaeFreeRowUserData(current);
                if (new->matrix.row_user_data)
                        xbaeCopyRowUserData(new);
        }
        if (NE(matrix.column_user_data)) {
                xbaeFreeColumnUserData(current);
                if (new->matrix.column_user_data)
                        xbaeCopyColumnUserData(new);
        }
        if (NE(matrix.row_shadow_types)) {
                xbaeFreeRowShadowTypes(current);
                if (new->matrix.row_shadow_types)
                        xbaeCopyRowShadowTypes(new);
        }
        if (NE(matrix.column_shadow_types)) {
                xbaeFreeColumnShadowTypes(current);
                if (new->matrix.column_shadow_types)
                        xbaeCopyColumnShadowTypes(new);
        }

        if (NE(matrix.row_labels)) {
                /*
                 * If we added or deleted row_labels, we need to layout.
                 */
                if (!current->matrix.row_labels || !new->matrix.row_labels)
                        relayout = True;
                else
                        redisplay = True;

                xbaeFreeRowLabels(current);
                if (new->matrix.row_labels)
                        xbaeCopyRowLabels(new);
        }
        if (NE(matrix.column_labels) || NE(matrix.xmcolumn_labels)) {
                xbaeFreeColumnLabels(current);
                if (new->matrix.column_labels || new->matrix.xmcolumn_labels) {
                        xbaeCopyColumnLabels(new);
                } else {
                        new->matrix.column_label_lines = NULL;
                        new->matrix.column_label_maxlines = 0;
                }

                /*
                 * If the number of lines in column labels changed, we need to relayout
                 */
                if (current->matrix.column_label_maxlines != new->matrix.column_label_maxlines)
                        relayout = True;
                else
                        redisplay = True;
        }
        if (NE(matrix.column_max_lengths)) {
                xbaeFreeColumnMaxLengths(current);
                if (new->matrix.column_max_lengths)
                        xbaeCopyColumnMaxLengths(new);
                redisplay = True;
        }
        if (NE(matrix.column_alignments)) {
                xbaeFreeColumnAlignments(current);
                if (new->matrix.column_alignments)
                        xbaeCopyColumnAlignments(new);
                redisplay = True;
        }
        if (NE(matrix.column_button_labels)) {
                xbaeFreeColumnButtonLabels(current);
                if (new->matrix.column_button_labels)
                        xbaeCopyColumnButtonLabels(new);
                redisplay = True;
        }

        if (NE(matrix.show_column_arrows)) {
                xbaeFreeShowColumnArrows(current);
                if (new->matrix.show_column_arrows)
                        xbaeCopyShowColumnArrows(new);
                redisplay = True;
        }

        if (NE(matrix.column_font_bold)) {
                xbaeFreeColumnFontBold(current);
                if (new->matrix.column_font_bold)
                        xbaeCopyColumnFontBold(new);
                redisplay = True;
        }
        if (NE(matrix.row_button_labels)) {
                xbaeFreeRowButtonLabels(current);
                if (new->matrix.row_button_labels)
                        xbaeCopyRowButtonLabels(new);
                redisplay = True;
        }
        if (NE(matrix.column_label_alignments)) {
                xbaeFreeColumnLabelAlignments(current);
                if (new->matrix.column_label_alignments)
                        xbaeCopyColumnLabelAlignments(new);
                redisplay = True;
        }
        if (NE(matrix.row_label_alignment))
                redisplay = True;
        if (NE(matrix.row_label_color) || NE(matrix.column_label_color)
            || NE(matrix.button_label_background))
                redisplay = True;

        if (NE(matrix.grid_line_color)) {

                xbaeGetGridLineGC(new);

                if ((new->matrix.grid_type == XmGRID_CELL_LINE)
                    || (new->matrix.grid_type == XmGRID_ROW_LINE)
                    || (new->matrix.grid_type == XmGRID_COLUMN_LINE))
                        redisplay = True;
        }

        if (NE(matrix.alt_row_count)
            && (new->matrix.even_row_background != current->core.background_pixel
                || new->matrix.odd_row_background != current->core.background_pixel))
                redisplay = True;

        if (NE(matrix.even_row_background) || NE(matrix.odd_row_background) || NE(matrix.grid_type)
            || NE(matrix.selected_foreground) || NE(matrix.selected_background))
                redisplay = True;

        if (NE(matrix.grid_type) && (new->matrix.grid_type >= XmGRID_LINE))
                /* Deprecated types. To be removed in next version. */
                XtAppWarningMsg(XtWidgetToApplicationContext((Widget) new), "cvtStringToGridType",
                                "deprecatedType", "XbaeMatrix",
                                "Value for GridType is deprecated and will be removed in next release",
                                NULL, NULL);

        if (NE(matrix.cell_shadow_type) || NE(matrix.shadow_type) || NE(matrix.reverse_select))
                redisplay = True;

        /*
         * If traversal changes, pass through to Clip and textField children.
         */
        if (NE(manager.traversal_on)) {
                XtVaSetValues(ClipChild(new), XmNtraversalOn, new->manager.traversal_on, NULL);
        }
        if (NE(matrix.even_row_background) || NE(matrix.odd_row_background))
                redisplay = True;

        /*
         * Pass through primitive/manager resources to our children
         */
        n = 0;
        if (NE(core.background_pixel)) {
                /*
                 * Set all clip widgets to the new background (thanks Daiji)
                 */
                XtVaSetValues(ClipChild(new), XmNbackground, new->core.background_pixel, NULL);
                XtVaSetValues(LeftClip(new), XmNbackground, new->core.background_pixel, NULL);
                XtVaSetValues(RightClip(new), XmNbackground, new->core.background_pixel, NULL);
                XtVaSetValues(TopClip(new), XmNbackground, new->core.background_pixel, NULL);
                XtVaSetValues(BottomClip(new), XmNbackground, new->core.background_pixel, NULL);
                XtVaSetValues(RowLabelClip(new), XmNbackground, new->core.background_pixel, NULL);
                XtVaSetValues(ColumnLabelClip(new), XmNbackground, new->core.background_pixel, NULL);
                XtSetArg(wargs[n], XmNbackground, new->core.background_pixel);
                n++;
        }
        if (NE(manager.foreground)) {
                XtSetArg(wargs[n], XmNforeground, new->manager.foreground);
                n++;
        }
        if (NE(manager.bottom_shadow_color)) {
                XtSetArg(wargs[n], XmNbottomShadowColor, new->manager.bottom_shadow_color);
                n++;
        }
        if (NE(manager.bottom_shadow_pixmap)) {
                XtSetArg(wargs[n], XmNbottomShadowPixmap, new->manager.bottom_shadow_pixmap);
                n++;
        }
        if (NE(manager.highlight_color)) {
                XtSetArg(wargs[n], XmNhighlightColor, new->manager.highlight_color);
                n++;
        }
        if (NE(manager.highlight_pixmap)) {
                XtSetArg(wargs[n], XmNhighlightPixmap, new->manager.highlight_pixmap);
                n++;
        }
        if (NE(manager.top_shadow_color)) {
                XtSetArg(wargs[n], XmNtopShadowColor, new->manager.top_shadow_color);
                n++;
        }
        if (NE(manager.top_shadow_pixmap)) {
                XtSetArg(wargs[n], XmNtopShadowPixmap, new->manager.top_shadow_pixmap);
                n++;
        }
        if (n) {
                XtSetValues(VertScrollChild(new), wargs, n);
                DEBUGOUT(_XbaeDebug(__FILE__, VertScrollChild(new), "SetValues vsb "));
                DEBUGOUT(_XbaeDebugPrintArgList(__FILE__, VertScrollChild(new), wargs, n, False));
                XtSetValues(HorizScrollChild(new), wargs, n);
                XtSetValues(TextChild(new), wargs, n);
        }

        /*
         * Would really like to do this in the above,
         * but we need to override background_pixel.
         */
        if (EQ(matrix.text_background)
            && (current->matrix.text_background == current->core.background_pixel))
                new->matrix.text_background = new->core.background_pixel;
        if (NE(matrix.text_background) || NE(core.background_pixel)) {
                XtVaSetValues(TextChild(new), XmNbackground, new->matrix.text_background, NULL);
                if (XtIsManaged(TextChild(new)))
                        redisplay = True;
        }
        /*
         * Get a new XFontStruct and copy the fontList if it changed
         * and pass it to the textField.
         * Reset the HSB increment.
         * redisplay and relayout will be set below.
         */
        if (NE(matrix.font_list)) {
                xbaeNewFont(new, 0);

                XtVaSetValues(TextChild(new), XmNfontList, new->matrix.font_list, NULL);
                XtVaSetValues(HorizScrollChild(new), XmNincrement, FONT_WIDTH(new), NULL);
                XtVaSetValues(VertScrollChild(new), XmNincrement, DEFAULT_ROW_HEIGHT(new), NULL);

                /*
                 * Moved this down.
                 * While technically correct to free before calling xbaeNewFont, it opens
                 * the possibility that XmFontListCopy() obtains the exact same pointer from
                 * the allocation functions it uses.
                 * When that happens, there's no way anyone can detect a change :-(
                 */
                XmFontListFree(current->matrix.font_list);
        }

        if (NE(matrix.label_font_list)) {
                XmFontListFree(current->matrix.label_font_list);
                xbaeNewLabelFont(new);
                XtVaSetValues(HorizScrollChild(new), XmNincrement, FONT_WIDTH(new), NULL);
                XtVaSetValues(VertScrollChild(new), XmNincrement, DEFAULT_ROW_HEIGHT(new), NULL);
        }

        /*
         * Pass the cell resources on to the textField.
         * Both redisplay and relayout will be set below.
         *
         * If anything changed to affect cell total width or column positions,
         * recalc them
         */
        /*
         * Bugfix for 4.50.3 : if cell_margin_width <= 0, the text field
         * doesn't handle backspace correctly.
         */
        if (new->matrix.cell_margin_width < 1) {
                new->matrix.cell_margin_width = 3;
        }
        
        
        if (NE(matrix.column_widths)) {
                xbaeFreeColumnWidths(current);
                if (new->matrix.column_widths)
                        xbaeCopyColumnWidths(new);
                new_column_widths = relayout = redisplay = True;
        } else {
                if (NE(matrix.column_width_in_pixels)) {
                        /* 
                         * Convert the measuremnt of column_widths from pixels to characters and vice versa
                         */
                        int i;
                        if (new->matrix.column_width_in_pixels == True) {
                                for (i = 0; i < current->matrix.columns; i++) {
                                        new->matrix.column_widths[i] =
                                            (new->matrix.column_widths[i] * FONT_WIDTH(new)) +
                                            ((int) TEXT_WIDTH_OFFSET(new) * 2);
                                }
                        } else {
                                for (i = 0; i < current->matrix.columns; i++) {
                                        new->matrix.column_widths[i] =
                                            (new->matrix.column_widths[i] -
                                             ((int) TEXT_WIDTH_OFFSET(new) * 2)) / FONT_WIDTH(new);
                                }
                        }

                        new_column_widths = relayout = redisplay = True;
                }

                if (NE(matrix.columns)) {
                        /* 
                         * The number of columns changed but no new widths were given
                         */
                        new->matrix.column_widths = (short *) XtRealloc((XtPointer) new->matrix.column_widths, new->matrix.columns * sizeof(short));
                        current->matrix.column_widths = NULL;
                        if (new->matrix.columns > current->matrix.columns) {
                                /* 
                                 * There are new columns, init their width to the default 
                                 */
                                int i;
                                for(i = current->matrix.columns; i < new->matrix.columns; i++) {
                                        new->matrix.column_widths[i] = DEFAULT_COLUMN_WIDTH(new);
                                }
                        }
                }
        }

        if (NE(matrix.row_heights)) {
                xbaeFreeRowHeights(current);
                if (new->matrix.row_heights)
                        xbaeCopyRowHeights(new);
                new_row_heights = relayout = redisplay = True;
        } else {
                if (NE(matrix.row_height_in_pixels)) {
                        /* 
                         * Convert the measuremnt of row_heights from pixels to lines and vice versa
                         */
                        int i;
                        if (new->matrix.row_height_in_pixels == True) {
                                for (i = 0; i < current->matrix.rows; i++) {
                                        new->matrix.row_heights[i] =
                                            (new->matrix.row_heights[i] * TEXT_HEIGHT(new)) +
                                            ((int) TEXT_HEIGHT_OFFSET(new) * 2);
                                }
                        } else {
                                for (i = 0; i < current->matrix.rows; i++) {
                                        new->matrix.row_heights[i] =
                                            (new->matrix.row_heights[i] -
                                             ((int) TEXT_HEIGHT_OFFSET(new) * 2)) / TEXT_HEIGHT(new);
                                }
                        }

                        new_row_heights = relayout = redisplay = True;
                }
                
                if (NE(matrix.rows)) {
                        /* 
                         * The number of rows changed but no new heights were given
                         */
                        new->matrix.row_heights = (short *) XtRealloc((XtPointer) new->matrix.row_heights, new->matrix.rows * sizeof(short));
                        current->matrix.row_heights = NULL;
                        if (new->matrix.rows > current->matrix.rows) {
                                /* 
                                 * There are new rows, init their height to the default 
                                 */
                                int i;
                                for(i = current->matrix.rows; i < new->matrix.rows; i++) {
                                        new->matrix.row_heights[i] = DEFAULT_ROW_HEIGHT(new);
                                }
                        }
                }
        }

        /*
         * Pass the cell resources on to the textField.
         * Both redisplay and relayout will be set below.
         *
         * If anything changed to affect cell total width or column positions,
         * recalc them
         */
 
        if (NE(matrix.fid) || NE(matrix.label_fid)
            || NE(matrix.cell_margin_width)
            || NE(matrix.cell_margin_height)
            || NE(matrix.cell_highlight_thickness)
            || NE(matrix.cell_shadow_thickness)
            || NE(matrix.text_shadow_thickness)
            || NE(matrix.fixed_rows)
            || NE(matrix.fixed_columns)
            || NE(matrix.trailing_fixed_rows)
            || NE(matrix.trailing_fixed_columns)
            || NE(matrix.rows)
            || NE(matrix.columns)
            || new_column_widths || new_row_heights) {

                int marginHeight;

                /*
                 * If the number of rows or columns changed, we need to allocate new arrayas for 
                 * the private state
                 */

                if (NE(matrix.rows) || NE(matrix.columns)) {
                        ResizePerCell(current, new);
                        redisplay = True;

                        if (NE(matrix.rows)) {
                                xbaeFreeRowPositions(current);
                                new->matrix.row_positions = CreateRowPositions(new);
                        }

                        if (NE(matrix.columns)) {
                                xbaeFreeColumnPositions(current);
                                new->matrix.column_positions = CreateColumnPositions(new);
                        }
                }

                /*
                 * If anything but (trailing_)fixed_rows/columns or the highlight color
                 * changed, we need to recalc column positions.
                 */
                if (NE(matrix.fid) || NE(matrix.label_fid)
                    || NE(matrix.cell_margin_width)
                    || NE(matrix.cell_margin_height)
                    || NE(matrix.cell_highlight_thickness)
                    || NE(matrix.cell_shadow_thickness) 
                    || NE(matrix.text_shadow_thickness)
                    || NE(matrix.rows)
                    || NE(matrix.columns)
                    || new_column_widths 
                    || new_row_heights) {
                        xbaeGetColumnPositions(new);
                        xbaeGetRowPositions(new);
                }
                
                /*
                 * Recalculate the margin height, based on the larger of the
                 * label and general fonts.
                 */

                if (LABEL_HEIGHT(new) > FONT_HEIGHT(new)) {
                        marginHeight =
                            (int) (LABEL_HEIGHT(new) + (new->matrix.cell_margin_height * 2) -
                                   FONT_HEIGHT(new)) / 2;
                } else {
                        marginHeight = new->matrix.cell_margin_height;      /* by default */
                }

                if (new->matrix.current_row >= new->matrix.rows
                    || new->matrix.current_column >= new->matrix.columns) {
                        /*
                         * The cell that was edited disapeared under us. Unmanage the textchild
                         */
                        new->matrix.current_row = new->matrix.rows - 1;
                        new->matrix.current_column = new->matrix.columns - 1;
                        XtUnmanageChild(TextChild(new));
                }

                XtVaSetValues(TextChild(new), 
                              XmNhighlightThickness, new->matrix.cell_highlight_thickness,
                              XmNshadowThickness, new->matrix.text_shadow_thickness,
                              XmNmarginWidth, new->matrix.cell_margin_width,
                              XmNmarginHeight, marginHeight, 
                              NULL);

                /*
                 * Recalculate the baselines
                 */
                new->matrix.text_baseline =
                    XmTextGetBaseline(TextChild(new)) + new->matrix.cell_shadow_thickness
                    /* + new->matrix.text_shadow_thickness */ ;

                /*
                 * Adjust the label_baseline according to the larger of the two fonts
                 */
                if (LABEL_HEIGHT(new) == FONT_HEIGHT(new))
                        new->matrix.label_baseline = new->matrix.text_baseline;
                else {
                        if (LABEL_HEIGHT(new) < FONT_HEIGHT(new))
                                marginHeight =
                                    (FONT_HEIGHT(new) + new->matrix.text_shadow_thickness * 2 +
                                     new->matrix.cell_margin_height * 2 -
                                     (int) LABEL_HEIGHT(new)) / 2;
                        else
                                marginHeight =
                                    new->matrix.cell_margin_height +
                                    new->matrix.text_shadow_thickness;

                        new->matrix.label_baseline =
                            marginHeight + new->matrix.cell_shadow_thickness -
                            new->matrix.label_font_y;
                }

                /* JDS: The comment above this section says both redisplay and
                 * relayout get set, but only relayout was being set.  I noticed
                 * this because the resizeColumns action was setting the
                 * columnWidths, but the clip widget wasn't properly redrawing
                 * its cells when they were resized. This was in conjunction with
                 * calling clipRedisplay only when the matrix redisplayed instead
                 * of also when it relayedout :) (see the comment below).
                 *
                 * However, I'm not sure what else this might impact. But, I'm in
                 * favor of the change I made to only redisplay when the matrix
                 * redisplays since that's more efficient, I think, and it eliminated
                 * some ugly redraws that I at least encountered. So there :).
                 */
                redisplay = relayout = True;
        }

        /*
         * Install text_translations on textField and ClipChild
         */
        if (NE(matrix.text_translations)) {
                XtVaSetValues(TextChild(new), XmNtranslations, new->matrix.text_translations, NULL);
                XtVaSetValues(ClipChild(new), XmNtranslations, new->matrix.text_translations, NULL);
        }
        
        /*
         * If row_label_width was set to 0, calculate it.
         * Otherwise if it was changed, set flags.
         */
        if (new->matrix.row_label_width == 0 && new->matrix.row_labels) {
                new->matrix.row_label_width = xbaeMaxRowLabel(new);
                relayout = True;
        } else if (NE(matrix.row_label_width))
                relayout = True;

        /*
         * Check whether the widget is sensitive has changed and set our GC's
         * appropriately
         */
        if (XtIsSensitive((Widget) current) != XtIsSensitive((Widget) new)) {
                XGCValues values;
                int i;
                unsigned long valuemask = GCFillStyle;
                Display *dpy = XtDisplay(new);


                /* SGO: assuring that GCs are initialized. it could happen that we
                 * reach this point without initialized GC values.
                 */
                if (!new->matrix.draw_gc)
                        xbaeCreateDrawGC(new);
                if (!new->matrix.label_gc)
                        xbaeCreateLabelGC(new);
                if (!new->matrix.pixmap_gc)
                        xbaeCreatePixmapGC(new);


                if (!XtIsSensitive((Widget) new)) {
                        values.fill_style = FillStippled;

                        /*
                         * Change our drawing GC's to the stipple effect to indicate
                         * the widget is insensitive and redraw
                         */
                        XChangeGC(dpy, new->matrix.draw_gc, valuemask, &values);
                        XChangeGC(dpy, new->matrix.label_gc, valuemask, &values);
                        XChangeGC(dpy, new->matrix.pixmap_gc, valuemask, &values);
                        /*
                         * Propogate the insensitive feel to our children
                         */
                        for (i = 0; i < XbaeNumChildren; i++)
                                XtSetSensitive(new->composite.children[i], False);
                } else {
                        values.fill_style = FillSolid;

                        XChangeGC(dpy, new->matrix.draw_gc, valuemask, &values);
                        XChangeGC(dpy, new->matrix.label_gc, valuemask, &values);
                        XChangeGC(dpy, new->matrix.pixmap_gc, valuemask, &values);

                        for (i = 0; i < XbaeNumChildren; i++)
                                XtSetSensitive(new->composite.children[i], True);
                }
                redisplay = True;
        }

        /*
         * If our fill policy changed or our bottom attachment,
         * we must redisplay and relayout.
         */
        if (NE(matrix.fill) || NE(matrix.vert_fill) || NE(matrix.horz_fill)
            || NE(matrix.non_fixed_detached_top) || NE(matrix.non_fixed_detached_left)
            || NE(matrix.trailing_attached_bottom) || NE(matrix.trailing_attached_right)) {
                redisplay = True;
                relayout = True;
        }

        /*
         * If either of the scrollbar display policies changed,
         * we need to redisplay and relayout.
         */
        if (NE(matrix.vsb_display_policy) || NE(matrix.hsb_display_policy))
                relayout = True;

        /*
         * If the place of the scrollbars changes, we must redisplay
         */
        if (NE(matrix.scrollbar_placement))
                relayout = True;

        /*
         * Change created GCs if needed
         */

        if (NE(manager.foreground)) {
                /*
                 * We don't need to put the new foreground in draw_gc
                 * because it gets a new foreground when they are used.
                 */
                /*
                 ** On the other hand, blindly assuming that SetValues only gets called
                 ** post-realize is not a good idea.
                 **
                 ** This screws up GUI builders, unless the GC is also created here.
                 ** This comment applies to the other GC change routines called below...
                 **
                 ** A.J.Fountain, IST.
                 */
                redisplay = True;
        }
        if (NE(manager.foreground) || NE(manager.top_shadow_color) || NE(manager.top_shadow_pixmap)) {
                xbaeGetResizeTopShadowGC(new);
                redisplay = True;
        }
        if (NE(manager.foreground) || NE(manager.bottom_shadow_color) || NE(manager.bottom_shadow_pixmap)) {
                xbaeGetResizeBottomShadowGC(new);
                redisplay = True;
        }
        if (NE(matrix.fid)) {
                if (!new->matrix.draw_gc)
                        xbaeCreateDrawGC(new);

                XSetFont(XtDisplay(new), new->matrix.draw_gc, new->matrix.fid);
                redisplay = True;
        }

        if (NE(matrix.label_fid)) {
                if (!new->matrix.label_gc)
                        xbaeCreateLabelGC(new);

                XSetFont(XtDisplay(new), new->matrix.label_gc, new->matrix.label_fid);
                redisplay = True;
        }
        /*
         * See if any other resources changed which will require a relayout
         */
        if (NE(matrix.space) || NE(matrix.cell_shadow_thickness) || NE(manager.shadow_thickness))
                relayout = True;

        /*
         * If bold_labels or button labels changed, and we have labels,
         * we must redisplay
         */
        if ((NE(matrix.bold_labels) || NE(matrix.button_labels))
            && (new->matrix.row_labels || new->matrix.column_labels || new->matrix.xmcolumn_labels))
                redisplay = True;

        /*
         * If showArrows is changed, redisplay to get rid of existing arrows
         */
        if (NE(matrix.show_arrows))
                redisplay = True;

        /*
         * Compute a new size if:
         *   visible_rows or visible_columns changed.
         *   user set our width or height to zero.
         */
#if 1
        /* Cheap trick that works, provided by arcad.de */
        if (NE(core.width))
                new->matrix.visible_columns = 0;
        if (NE(core.height))
                new->matrix.visible_rows = 0;
#endif
        if (NE(matrix.visible_rows) || NE(matrix.visible_columns)
            || request->core.height == 0 || request->core.width == 0)
                xbaeComputeSize(new, request->core.width == 0, request->core.height == 0);

        /*
         * If our size didn't change, but we need to layout, call Relayout.
         * If our size did change, then Xt will call our Resize method for us.
         * If our size did change, but the new size is later refused,
         *   then SetValuesAlmost will call Resize to layout.
         */
        if (EQ(core.width) && EQ(core.height) && relayout)
                xbaeRelayout(new);

        /*
         * Force the Clip widget to redisplay.  Note: this may generate an
         * expose event for the current size of the Clip widget, and the Clip
         * widget may be sized smaller in set_values_almost.  The ClipRedisplay
         * function can handle this case.
         *
         * JDS: Don't need to force a redisplay on a relayout, since the Clip
         * widget's resize method (now non-NULL) will be called and Xt will
         * automatically do an expose after that occurs. Seems to work, anyways :).
         */

        if (redisplay)
                XbaeMatrixRefresh((Widget) new);
        
        /*
         * We want to return True when we need to redisplay or relayout.
         */
        return redisplay || relayout;

#undef NE
#undef EQ
}

/* ARGSUSED */
static void
SetValuesAlmost(XbaeMatrixWidget old, XbaeMatrixWidget new, XtWidgetGeometry * request,
                XtWidgetGeometry * reply)
{
        /*
         * If XtGeometryAlmost, accept compromize - Resize will take care of it
         */
        if (reply->request_mode) {
                *request = *reply;

#if XtSpecificationRelease > 4
                /*
                 * In R5, XtSetValues changed so that when a widgets parent
                 * returns XtGeometryAlmost, Xt will only call the widgets resize
                 * method if the widgets size actually changed.  It turns out that
                 * some manager widgets (old Wcl XmpTable and 1.1.x XmForm) return
                 * XtGeometryAlmost with a compromise size which is the widgets
                 * original size (not much of a compromise)!  This means as of R5,
                 * Matrix's resize method won't get called in that case.
                 *
                 * So, for R5 we explicitly call our relayout method here for the
                 * case of XtGeometryAlmost where our size did not change.
                 */
                if ((reply->request_mode & CWWidth || reply->request_mode & CWHeight)
                    && (old->core.width == new->core.width && old->core.height == new->core.height))
                        xbaeRelayout(new);
#endif
        }

        /*
         * If XtGeometryNo, call Relayout if it was a size change that was denied.
         * Accept the original geometry.
         * (we need to force a Relayout even though the size didn't 
         * change - set_values relies on this)
         */
        else {
                if ((request->request_mode & CWWidth || request->request_mode & CWHeight))
                        xbaeRelayout(new);

                request->request_mode = 0;
        }
}

static void Destroy(XbaeMatrixWidget mw)
{
        if (mw->matrix.traverseId) {
                XtRemoveTimeOut(mw->matrix.traverseId);
                mw->matrix.traverseId = 0;
        }

        /* SGO: just delete GCs when set. otherwise crashes could be produced */
        if (mw->matrix.label_gc) {
                XFreeGC(XtDisplay(mw), mw->matrix.label_gc);
                mw->matrix.label_gc = NULL;
        }
        if (mw->matrix.draw_gc) {
                XFreeGC(XtDisplay(mw), mw->matrix.draw_gc);
                mw->matrix.draw_gc = NULL;
        }
        if (mw->matrix.pixmap_gc) {
                XFreeGC(XtDisplay(mw), mw->matrix.pixmap_gc);
                mw->matrix.pixmap_gc = NULL;
        }

        if (mw->matrix.grid_line_gc) {
                XtReleaseGC((Widget) mw, mw->matrix.grid_line_gc);
                mw->matrix.grid_line_gc = NULL;
        }
        if (mw->matrix.resize_top_shadow_gc) {
                XtReleaseGC((Widget) mw, mw->matrix.resize_top_shadow_gc);
                mw->matrix.resize_top_shadow_gc = NULL;
        }
        if (mw->matrix.resize_bottom_shadow_gc) {
                XtReleaseGC((Widget) mw, mw->matrix.resize_bottom_shadow_gc);
                mw->matrix.resize_bottom_shadow_gc = NULL;
        }

        xbaeFreeRowLabels(mw);
        xbaeFreeColumnLabels(mw);
        xbaeFreeColumnWidths(mw);
        xbaeFreeColumnMaxLengths(mw);
        xbaeFreeColumnPositions(mw);
        xbaeFreeColumnAlignments(mw);
        xbaeFreeColumnButtonLabels(mw);
        xbaeFreeShowColumnArrows(mw);
        xbaeFreeColumnFontBold(mw);
        xbaeFreeRowButtonLabels(mw);
        xbaeFreeColumnLabelAlignments(mw);
        xbaeFreeRowUserData(mw);
        xbaeFreeColumnUserData(mw);
        xbaeFreeRowShadowTypes(mw);
        xbaeFreeColumnShadowTypes(mw);
        xbaeFreePerCell(mw);
        xbaeFreeRowPositions(mw);
        xbaeFreeRowHeights(mw);
        /* XmFontListFree(mw->matrix.font_list); */
        mw->matrix.font_list = NULL;
        /* XmFontListFree(mw->matrix.label_font_list); */
        mw->matrix.label_font_list = NULL;

        /* This is just here to have something to set a breakpoint to. */
        mw->matrix.label_font_set = NULL;
}

/*
 * Since we totally control our childrens geometry, allow anything.
 */

/* ARGSUSED */
static XtGeometryResult
GeometryManager(Widget w, XtWidgetGeometry * desired, XtWidgetGeometry * allowed)
{
#define Wants(flag) (desired->request_mode & flag)

        if (Wants(XtCWQueryOnly))
                return (XtGeometryYes);

        if (Wants(CWWidth))
                w->core.width = desired->width;
        if (Wants(CWHeight))
                w->core.height = desired->height;
        if (Wants(CWX))
                w->core.x = desired->x;
        if (Wants(CWY))
                w->core.y = desired->y;
        if (Wants(CWBorderWidth))
                w->core.border_width = desired->border_width;

        return (XtGeometryYes);

#undef Wants
}


/*
 * We would prefer to be the size calculated in ComputeSize and saved in
 * desired_width/height
 */
static XtGeometryResult
QueryGeometry(XbaeMatrixWidget mw, XtWidgetGeometry * proposed, XtWidgetGeometry * desired)
{
#define Set(bit) (proposed->request_mode & bit)

        desired->width = mw->matrix.desired_width;
        desired->height = mw->matrix.desired_height;
        desired->request_mode = CWWidth | CWHeight;

        if (Set(CWWidth) && proposed->width == desired->width && Set(CWHeight)
            && proposed->height == desired->height)
                return (XtGeometryYes);

        if (desired->width == mw->core.width && desired->height == mw->core.height)
                return (XtGeometryNo);

        return (XtGeometryAlmost);

#undef Set
}

/*
 * This functions is called through a timeout from the Clip focus CB proc.
 * The CB cannot call it directly because it might have been triggered
 * by XmProcessTraversal and we want to call XmProcessTraversal ourselves but
 * it's not a reentrant function.
 */
static void TraverseInTimeOut(XtPointer clip, XtIntervalId * timer)
{
        XbaeMatrixWidget mw = (XbaeMatrixWidget) XtParent((Widget) clip);
        xbaeObjectLock((Widget) mw);

        DEBUGOUT(_XbaeDebug(__FILE__, (Widget) mw, "TraverseIn\n"));

        /*
         * We want to give the focus back to the cell that was edited when
         * we lost the focus or start to edit the top-left cell
         */

        if (XtIsManaged(TextChild(mw))) {
                if (mw->matrix.scroll_select) {
                        xbaeMakeCellVisible(mw, mw->matrix.current_row, mw->matrix.current_column);
                }
                XmProcessTraversal(TextChild(mw), XmTRAVERSE_CURRENT);
        } else {
                int row;
                int column;

                if ((mw->matrix.traverse_fixed && 
                     mw->matrix.current_row >= 0 && mw->matrix.current_row < mw->matrix.rows) ||
                    (mw->matrix.current_row >= mw->matrix.fixed_rows && mw->matrix.current_row < TRAILING_HORIZ_ORIGIN(mw))) {
                        row = mw->matrix.current_row;
                } else {
                        row = xbaeTopRow(mw);
                }
                
                if ((mw->matrix.traverse_fixed && 
                     mw->matrix.current_column >= 0 && mw->matrix.current_column < mw->matrix.columns) ||
                    (mw->matrix.current_column >= mw->matrix.fixed_columns && mw->matrix.current_column < TRAILING_VERT_ORIGIN(mw))) {
                            column = mw->matrix.current_column;
                } else {
                        column = xbaeLeftColumn(mw);
                }
                ((XbaeMatrixWidgetClass) XtClass(mw))->matrix_class.edit_cell(mw, NULL, row, column, NULL, 0);
        }

        xbaeObjectUnlock((Widget) mw);
}

/*
 * This is the Clip widgets focusCallback.
 * The clip can only get the focus if the matrix doesn't have 
 * any cellwidgets.
 * We want to give the focus back to the cell that was edited when
 * we lost the focus or start to edit the top-left cell
 */
static void TraverseInCB(Widget clip, XbaeMatrixWidget mw, XtPointer call_data)
{
        DEBUGOUT(_XbaeDebug2(__FILE__, (Widget) mw, clip, "TraverseInCB\n"));

        /*
         * Under Motif 1.2, we can't call TraverseInTimeOut directly because it
         * calls XmProcessTraversal and recursive calls to XmProcessTraversal
         * are disallowed in 1.2 (we may be in this CB as a result of someone
         * calling XmProcessTraversal).  So we call it through a zero length timeout
         */
        Boolean mapped;
        XtVaGetValues(TextChild(mw), XmNmappedWhenManaged, &mapped, NULL);

        if (mapped) {
                mw->matrix.traverseId =
                    XtAppAddTimeOut(XtWidgetToApplicationContext(clip), 0L, TraverseInTimeOut, clip);
        }
}

/*
 * Add rows/columns of per-cell flags when set_values changes our rows/columns
 */
static void ResizePerCell(XbaeMatrixWidget current, XbaeMatrixWidget new)
{
        int i, j;
        int safe_rows = 0;

        DEBUGOUT(_XbaeDebug(__FILE__, (Widget) current, "ResizePerCell (%d,%d) -> (%d,%d)\n",
				current->matrix.rows, current->matrix.columns,
				new->matrix.rows, new->matrix.columns));
        /*
         * underlinedCells is allocated when the first cell is underlined.  If it
         * is still NULL, no cells have been underlined up to this point.
         */
        if (!new->matrix.per_cell)
                return;

        if (new->matrix.rows == current->matrix.rows)
                safe_rows = new->matrix.rows;

        /*
         * Adding rows
         */
        if (new->matrix.rows > current->matrix.rows) {
                /*
                 * Realloc a larger array of row pointers
                 */
                new->matrix.per_cell =
                    (XbaeMatrixPerCellRec **) XtRealloc((char *) new->matrix.per_cell,
                                                        new->matrix.rows *
                                                        sizeof(XbaeMatrixPerCellRec *));

                /*
                 * Calloc a new row array for each row. Use the new column size.
                 */
                for (i = current->matrix.rows; i < new->matrix.rows; i++) {
                        new->matrix.per_cell[i] =
                            (XbaeMatrixPerCellRec *) XtCalloc(new->matrix.columns,
                                                              sizeof(XbaeMatrixPerCellRec));
                        for (j = 0; j < new->matrix.columns; j++)
                                xbaeFill_WithEmptyValues_PerCell(new, &new->matrix.per_cell[i][j]);
                }

                safe_rows = current->matrix.rows;
        }

        /*
         * Deleting rows
         */
        if (new->matrix.rows < current->matrix.rows) {
                for (i = new->matrix.rows; i < current->matrix.rows; i++)
                        xbaeFreePerCellRow(new, i);
                safe_rows = new->matrix.rows;
        }

        /*
         * Adding columns
         */
        if (new->matrix.columns > current->matrix.columns) {
                /*
                 * Realloc each row array. Do not touch any rows added/deleted above
                 * (use safe_rows)
                 */
                for (i = 0; i < safe_rows; i++) {
                        int j;
                        new->matrix.per_cell[i] =
                            (XbaeMatrixPerCellRec *) XtRealloc((char *) new->matrix.per_cell[i],
                                                               new->matrix.columns *
                                                               sizeof(XbaeMatrixPerCellRec));
                        for (j = current->matrix.columns; j < new->matrix.columns; j++)
                                xbaeFill_WithEmptyValues_PerCell(new, &new->matrix.per_cell[i][j]);
                }
        }

        /*
         * Deleting columns
         *   if (new->matrix.columns < current->matrix.columns)
         * We don't bother to realloc, just leave some wasted space.
         * XXX is this a problem?
         */
}

#ifdef	WIN32
#ifdef	USING_EXCEED
/*
 * Exceed has a somewhat strange environment for DLL's : they require the application
 * to call some DLL initialisation function (i.e. porting to Exceed requires a source
 * change).
 *
 * In analogy to their approach with e.g. HCLXawInit() and HCLXtInit(), we now add a
 * function called HCLXbaeInit() to be called prior to any Xbae action.
 * In other Windows based environments, this doesn't appear to be necessary.
 *
 * Thanks to Karthik Rajagopalan for figuring this out for me.
 */
export void
HCLXbaeInit(void)
{
	HCLFixXtPointers(_XtInherit, XtInheritTranslations);
}
#else
/*
 * A Windows-based environment other than Exceed.
 */
int __stdcall
DllMain(unsigned long mod_handle, unsigned long flag, void *routine)
{
	switch (flag) {
	case 1: /* DLL_PROCESS_ATTACH - process attach */
		/* FIX ME What should happen here ? */
		break;
	case 0: /* DLL_PROCESS_DETACH - process detach */
		break;
	}
	return 1;
}
#endif
#endif
