/*
 * Copyright(c) 1999 Andrew Lister
 *                        All rights reserved
 *
 * Copyright  2001 by the LessTif Developers
 *
 * Permission to use, copy, modify and distribute this material for
 * any purpose and without fee is hereby granted, provided that the
 * above copyright notice and this permission notice appear in all
 * copies, and that the name of Bellcore not be used in advertising
 * or publicity pertaining to this material without the specific,
 * prior written permission of an authorized representative of
 * Bellcore.
 *
 * BELLCORE MAKES NO REPRESENTATIONS AND EXTENDS NO WARRANTIES, EX-
 * PRESS OR IMPLIED, WITH RESPECT TO THE SOFTWARE, INCLUDING, BUT
 * NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR ANY PARTICULAR PURPOSE, AND THE WARRANTY AGAINST IN-
 * FRINGEMENT OF PATENTS OR OTHER INTELLECTUAL PROPERTY RIGHTS.  THE
 * SOFTWARE IS PROVIDED "AS IS", AND IN NO EVENT SHALL BELLCORE OR
 * ANY OF ITS AFFILIATES BE LIABLE FOR ANY DAMAGES, INCLUDING ANY
 * LOST PROFITS OR OTHER INCIDENTAL OR CONSEQUENTIAL DAMAGES RELAT-
 * ING TO THE SOFTWARE.
 *
 * $Id: multibyte.c,v 1.5 2001/03/30 07:52:02 dannybackx Exp $
 */

#ifdef HAVE_CONFIG_H
#include <XbaeConfig.h>
#endif
#include <stdlib.h>

#include <locale.h>
#ifdef USE_EDITRES
#include <X11/Intrinsic.h>
#include <X11/Xmu/Editres.h>
#endif
#include <Xbae/Matrix.h>

static String fallback[] = {
	"Multibyte*XbaeMatrix*columnWidths:    35",
	"Multibyte*XbaeMatrix*fontList:		-*-*-*-*-*-*-*-*-*-*-*-*-iso8859-1;-*-*-*-*-*-*-*-*-*-*-*-*-jisx0208.1983-0;-*-*-*-*-*-*-*-*-*-*-*-*-jisx0201.1976-0: ",
	NULL
};

void
labelCB(Widget mw, XtPointer cd, XtPointer cb)
{
    XbaeMatrixLabelActivateCallbackStruct *cbs =
	( XbaeMatrixLabelActivateCallbackStruct * )cb;

    if( cbs->row_label )
	if( XbaeMatrixIsRowSelected( mw, cbs->row ) )
	    XbaeMatrixDeselectRow( mw, cbs->row );
	else
	    XbaeMatrixSelectRow( mw, cbs->row );
    else
	if( XbaeMatrixIsColumnSelected( mw, cbs->column ) )
	    XbaeMatrixDeselectColumn( mw, cbs->column );
	else
	    XbaeMatrixSelectColumn( mw, cbs->column );
}

/*
 * Simple example of loaded Matrix
 */


String text[] =
{
    "ΥüǤϡե饰򻲾Ȥˤ ",
    "ưǤޤ󡣤Τ褦üǽ",
    "顼ɤˤϡ e ե饰ꤹȤ t Ʊ˻ꤷ",
    "ơŪˤƤӽФƤβ",
    "Ȥȡѡץ (դʸ) ȥ֥ץ (",
    "դʸ) νϤȤüνϵǽäƤƤ",
    "ԲǽˤʤäƤޤȤޤüν",
    " ˤưʤʤäƤޤä顢Ȥ",
};


int
main(int argc, char *argv[])
{
    Widget toplevel, mw;
    XtAppContext app;


    setlocale(LC_ALL, "");
    toplevel = XtVaAppInitialize(&app, "Multibyte",
				 NULL, 0,
				 &argc, argv,
				 fallback,
				 NULL);
#ifdef USE_EDITRES
    XtAddEventHandler( toplevel, (EventMask)0, True,
                       _XEditResCheckMessages, NULL);
#endif

    mw = XtVaCreateManagedWidget("mw",
				 xbaeMatrixWidgetClass, toplevel,
				 XmNrows, sizeof(text)/sizeof(text[0]),
				 XmNcolumns, 1,
				 NULL);

    XtAddCallback( mw, XmNlabelActivateCallback, ( XtCallbackProc )labelCB,
		   NULL );
    
    XtRealizeWidget(toplevel);

    XtAppMainLoop(app);
    
    /*NOTREACHED*/
    return 0;
}
