#!/bin/bash

counter=1;

function testcount()
{
  echo -n "$counter."
  if(( $counter < 10 )); 
  then
    echo -n " "; 
  fi;
  (( counter=$counter+1 ))
}

#########################
# function test
#
# run argument given and put output
# in a .new file, then compare the .new and .out
# if diff gives back results -> test failed!
function test()
{
  testcount
    
  echo -n " testing : $1.b  ->  ";
  ./$1.b  > $1.new 2>&1 #also the errors to this file

  local ok;
  ok=`diff $1.out $1.new`;
  
  if [[ $ok  == "" ]] ;
  then
    echo "ok";
    rm -f $1.new;
  else
    echo "TEST FAILED!!!";
  fi;
}


#########################
# main
#

rm -f *.new

test "argtest"
test "assigns"
test "datatest"
test "deftest"
test "foreach"
test "forloops"
test "functions"
test "ifs"
test "modtest"
test "strings"
test "while"
test "speed2"
test "shelltest"
