//typedef double number;
//number class to store variables ...

#ifndef NUMBER_H
#define NUMBER_H


#include <string>
#include <iostream>
#include <sstream>

using namespace std;

class Number{
  public:
    
    //constructor/destructor
    //======================
    Number();
    Number( double d );
    Number( const string& s );
    Number( const Number& );
    ~Number(){}
    
    //public members
    //==============
    void toString(); //explicit conversion to string strVal
    void toDouble(); //explicit conversion to double val
    void setValue( double d ){ val=d; bString=false;}
    void setValue( const string& s ){ strVal=s; bString=true;}

    void minus(){ val=-val; }
    void notOperation(){ val=1-val; }
    
    //operators
    //=========
    Number& operator=(const Number&);
    Number& operator=(const string&);
    Number& operator=(double);

    Number& operator+(const Number&);
    Number& operator-(const Number&);
    Number& operator*(const Number&);
    Number& operator/(const Number&);
    
    Number& sin ( const Number& );
    Number& cos ( const Number& );
    Number& tan ( const Number& );
    Number& sqrt( const Number& );
    Number& log ( const Number& );
    Number& exp ( const Number& );
    Number& mod ( const Number&, const Number& );
    
    

    bool operator==(const Number&) const;
    bool operator!=(const Number&) const;
    bool operator<(const Number&) const;
    bool operator<=(const Number&) const;
    bool operator>(const Number&) const;
    bool operator>=(const Number&) const;

    friend ostream& operator<<(ostream&, const Number&); //outputs double or string
    friend istream& operator>>(istream&, Number&); //reads double
  

    //public members  
    bool bString; //set to true if Number represents a string...
    string strVal;
    double val;

};

#endif

