#include "number.h"
#include <cmath>

Number::Number(){
  strVal="";
  val=0;
  bString=false;
}


Number::Number( const string& s ){
  strVal=s;
  val=0;
  bString=true;
}

Number::Number( double d ){
  val=d;
  bString=false;
}


Number::Number( const Number& n ){
  *this=n;
}

void Number::toString(){
  ostringstream os;
  os<<val;
  strVal=os.str();
  bString=true;
}

void Number::toDouble(){
  istringstream is(strVal);
  is>>val;
  bString=false;
}
    

Number& Number::operator=( const Number& n ){
  if(this != &n){

    if( !bString && !n.bString ){
      val=n.val;
    }
    else if( bString && n.bString ){
      strVal=n.strVal;
    }
    else if(n.bString){
      bString=true;
      strVal=n.strVal;
    }
    else{
      bString=false;
      val=n.val;
    }
    
  }
  return *this;
}


Number& Number::operator=( const string& s ){
  strVal=s;
  bString=true;
  return *this;
}


Number& Number::operator=( double n ){
  val=n;
  bString=false;
  return *this;
}



Number& Number::operator+( const Number& n ){
  if(!bString && !n.bString){
    val+=n.val;
  }
  else if(bString && n.bString){
    strVal+=n.strVal;
  }
  else{
    if(!bString){
      bool b=bString; 
      toString();
      bString=b;
    }
    
    if(!n.bString){
      Number tmp=n;
      tmp.toString();
      strVal+=tmp.strVal;
    }
    else{
      strVal+=n.strVal;
    }
    
    val+=n.val;
  }
  return *this;
}


Number& Number::operator-( const Number& n ){
  if(!bString && !n.bString){
    val-=n.val;
  }
  else if(bString && n.bString){
    //strVal-=n.strVal;
    cerr<<"cannot subtract strings"<<endl;
  }
  else {
    val-=n.val;
    toString();
    bString=false;
  }

  return *this;
}


Number& Number::operator*( const Number& n ){
  if(!bString && !n.bString){
    val*=n.val;
  }
  else if(bString && n.bString){
    //strVal*=n.strVal;
    cerr<<"cannot multiply strings"<<endl;
  }
  else{
    val*=n.val;
    toString();
    bString=false;
  }
  return *this;
}


Number& Number::operator/( const Number& n ){
  if(!bString && !n.bString){
    val/=n.val;
  }
  else if(bString && n.bString){
    //strVal/=n.strVal;
    cerr<<"cannot divide strings"<<endl;
  }
  else{
    val/=n.val;
    toString();
    bString=false;
  }
  return *this;
}



bool Number::operator==( const Number& n ) const {
  if( bString && n.bString ) return strVal==n.strVal; 
  if( !bString && !n.bString ) return val == n.val;
  return false;
}


bool Number::operator!=( const Number& n ) const {
  if( bString && n.bString ) return strVal!=n.strVal; 
  if( !bString && !n.bString ) return val != n.val;
  return false;
}


bool Number::operator<( const Number& n ) const {
  if( bString && n.bString ) return strVal<n.strVal; 
  if( !bString && !n.bString ) return val < n.val;
  return false;
}


bool Number::operator<=( const Number& n ) const {
  if( bString && n.bString ) return strVal<=n.strVal; 
  if( !bString && !n.bString ) return val <= n.val;
  return false;
}


bool Number::operator>( const Number& n ) const {
  if( bString && n.bString ) return strVal>n.strVal; 
  if( !bString && !n.bString ) return val > n.val;
  return false;
}


bool Number::operator>=( const Number& n ) const {
  if( bString && n.bString ) return strVal>=n.strVal; 
  if( !bString && !n.bString ) return val >= n.val;
  return false;
}



//output double or string
ostream& operator<<(ostream& os, const Number& n){
  if(n.bString){
    os<<n.strVal;
  }  
  else{
    os<<n.val<<" ";
  }
  return os;
}

//read double
istream& operator>>(istream& is, Number& n){
  n.bString=false;
  is>>n.val;
  return is;
}




Number& Number::sin ( const Number& n ){
  if( n.bString ){
    cerr << "Sin does not work on strings!" << endl;
    return *this;
  }
  this->val = ::sin( n.val );
  bString = false;
  strVal  = "";
  return  *this;  
}


Number& Number::cos ( const Number& n ){
  if( n.bString ){
    cerr << "cos does not work on strings!" << endl;
    return *this;
  }
  this->val = ::cos( n.val );
  bString = false;
  strVal  = "";
  return  *this;
  
}


Number& Number::tan ( const Number& n ){
  if( n.bString ){
    cerr << "tan does not work on strings!" << endl;
    return *this;
  }
  this->val = ::tan( n.val );
  bString = false;
  strVal  = "";
  return  *this;
  
}


Number& Number::sqrt( const Number& n ){
  if( n.bString ){
    cerr << "Sqrt does not work on strings!" << endl;
    return *this;
  }
  this->val = ::sqrt( n.val );
  bString = false;
  strVal  = "";
  return  *this;
  
}

Number& Number::log( const Number& n ){
  if( n.bString ){
    cerr << "log does not work on strings!" << endl;
    return *this;
  }
  this->val = ::log( n.val );
  bString = false;
  strVal  = "";
  return  *this;
  
}


Number& Number::exp( const Number& n ){
  if( n.bString ){
    cerr << "log does not work on strings!" << endl;
    return *this;
  }
  this->val = ::exp( n.val );
  bString = false;
  strVal  = "";
  return  *this;
  
}

Number& Number::mod( const Number& a, const Number& b ){
  if( b.bString || a.bString ){
    cerr << "mod does not work on strings!" << endl;
    return *this;
  }
  this->val = (double)((int)a.val % (int)b.val);
  bString = false;
  strVal  = "";
  return  *this;
  
}




