/* import.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001-2006 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "import.h"
#include "worker_commands.h"
#include "wc_color.hh"
#include "wcdoubleshortkey.hh"
#include "wcpath.hh"
#include "wcfiletype.hh"
#include "wchotkey.hh"
#include "wcbutton.hh"
#include "workerversion.h"

void WConfig::setDefaultConfig()
{
  List *np, *nb, *nh, *nf;
  WCPath *p1;
  WCDoubleShortkey *key;
  WCButton *b1;
  WCHotkey *h1;
  List *nc, *keylist;
  FunctionProto *fp,*rfp;
  int i;

  setLang("");
  setRows(6);
  setColumns(7);
  setCacheSize(10);
  List *ncolors=new List();
  ncolors->addElement(new WC_Color(160,160,160));
  ncolors->addElement(new WC_Color(0,0,0));
  ncolors->addElement(new WC_Color(255,255,255));
  ncolors->addElement(new WC_Color(0,85,187));
  ncolors->addElement(new WC_Color(204,34,0));
  ncolors->addElement(new WC_Color(50,180,20));
  ncolors->addElement(new WC_Color(119,0,119));
  ncolors->addElement(new WC_Color(238,170,68));
  setColors(ncolors);
  WC_Color *col=(WC_Color*)ncolors->getFirstElement();
  while(col!=NULL) {
    delete col;
    col=(WC_Color*)ncolors->getNextElement();
  }
  delete ncolors;
  setHBarTop(0,false);
  setHBarTop(1,false);
  setVBarLeft(0,false);
  setVBarLeft(1,true);
  setHBarHeight(0,10);
  setHBarHeight(1,10);
  setVBarWidth(0,10);
  setVBarWidth(1,10);
  clearVisCols( 0 );
  clearVisCols( 1 );
  addListCol( 0, WorkerTypes::LISTCOL_PERM );
  addListCol( 0, WorkerTypes::LISTCOL_SIZE );
  addListCol( 0, WorkerTypes::LISTCOL_NAME );
  addListCol( 0, WorkerTypes::LISTCOL_TYPE );
  addListCol( 1, WorkerTypes::LISTCOL_PERM );
  addListCol( 1, WorkerTypes::LISTCOL_SIZE );
  addListCol( 1, WorkerTypes::LISTCOL_NAME );
  addListCol( 1, WorkerTypes::LISTCOL_TYPE );
  setStatusbar(0,2);
  setStatusbar(1,3);
  setSelLVB(0,2);
  setSelLVB(1,4);
  setUnselLVB(0,1);
  setUnselLVB(1,0);
  setSelDir(0,2);
  setSelDir(1,3);
  setUnselDir(0,3);
  setUnselDir(1,0);
  setSelFile(0,2);
  setSelFile(1,1);
  setUnselFile(0,1);
  setUnselFile(1,0);
  setClockbar(0,2);
  setClockbar(1,6);
  setRequest(0,1);
  setRequest(1,0);
  setLVHeader( 0, 1 );
  setLVHeader( 1, 0 );
  setStartDir(0,"");
  setStartDir(1,"");
  setFont(0,"fixed");
  setFont(1,"fixed");
  setFont(2,"fixed");
  setFont(3,"fixed");
  
  // now setup paths
  key=new WCDoubleShortkey();
  keylist = new List();
  keylist->addElement( key );
  np=new List();

  p1=new WCPath();
  p1->setName("/");
  p1->setFG(2);
  p1->setBG(3);
  p1->setPath("/");
  p1->setCheck(true);
  
  key->setMod( 0, 0 );
  key->setKeySym( XK_1, 0 );
  
  p1->setDoubleKeys( keylist );
  np->addElement(p1);
  p1=new WCPath();
  p1->setName("/home");
  p1->setPath("/home");
  p1->setCheck(true);
  
  key->setMod(0, 0);
  key->setKeySym(XK_2,0);
  
  p1->setDoubleKeys( keylist );
  np->addElement(p1);
  p1=new WCPath();
  p1->setName("/usr");
  p1->setPath("/usr");
  p1->setCheck(true);
  
  key->setMod(0,0);
  key->setKeySym(XK_3,0);
  
  p1->setDoubleKeys( keylist );
  np->addElement(p1);
  p1=new WCPath();
  p1->setName("/usr/local");
  p1->setPath("/usr/local");
  p1->setCheck(true);
  
  key->setMod(0,0);
  key->setKeySym(XK_4,0);
  
  p1->setDoubleKeys( keylist );
  np->addElement(p1);
  p1=new WCPath();
  p1->setName("CD");
  p1->setPath("/cdrom");
  p1->setCheck(true);
  
  key->setMod( 0, 0 );
  key->setKeySym(XK_5,0);
  
  p1->setDoubleKeys( keylist );
  np->addElement(p1);
  p1=new WCPath();
  p1->setName("Floppy");
  p1->setPath("/floppy");
  p1->setCheck(true);
  
  key->setMod( 0, 0 );
  key->setKeySym(XK_6,0);
  
  p1->setDoubleKeys( keylist );
  np->addElement(p1);

  setPaths(np);
  
  p1=(WCPath*)np->getFirstElement();
  while(p1!=NULL) {
    delete p1;
    p1=(WCPath*)np->getNextElement();
  }
  delete np;
  
  // setup buttons
  nc=new List();
  nb=new List();
  
  b1=new WCButton();
  b1->setText("All");
  b1->setCheck(true);
  key->setKeySym(XK_KP_Add,0);
  key->setMod( 0, 0 );
  b1->setDoubleKeys( keylist );
  fp=new SelectAllOp();
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);

  b1=new WCButton();
  b1->setText("None");
  b1->setCheck(true);
  key->setKeySym(XK_KP_Subtract,0);
  key->setMod( 0, 0 );
  b1->setDoubleKeys( keylist );
  fp=new SelectNoneOp();
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);
  
  b1=new WCButton();
  b1->setText("Invert selection");
  b1->setCheck(true);
  key->setKeySym(XK_KP_Multiply,0);
  key->setMod( 0, 0 );
  b1->setDoubleKeys( keylist );
  fp=new InvertAllOp();
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);

  b1=new WCButton();
  nb->addElement(b1);

  b1=new WCButton();
  b1->setText("Patternselect");
  b1->setCheck(true);
  key->setKeySym(XK_KP_Divide,0);
  key->setMod( 0, 0 );
  b1->setDoubleKeys( keylist );
  fp=new FilterSelectOp();
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);

  b1=new WCButton();
  b1->setText("PatternUnselect");
  b1->setCheck(true);
  fp=new FilterUnSelectOp();
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);

  b1=new WCButton();
  b1->setText("Path2otherside");
  b1->setCheck(true);
  fp=new Path2OSideOp();
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);

  b1=new WCButton();
  b1->setText("Active2Other");
  b1->setCheck(true);
  fp=new EnterDirOp();
  ((EnterDirOp*)fp)->setMode(EnterDirOp::ENTERDIROP_ACTIVE2OTHER);
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);

  b1=new WCButton();
  b1->setText("Reload");
  b1->setCheck(true);
  key->setKeySym(XK_u,0);
  key->setMod( 0, 0 );
  b1->setDoubleKeys( keylist );
  fp=new ReloadOp();
  ((ReloadOp*)fp)->setReloadside(ReloadOp::RELOADOP_THISSIDE);
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);

  b1=new WCButton();
  b1->setText("Reload other");
  b1->setCheck(true);
  fp=new ReloadOp();
  ((ReloadOp*)fp)->setReloadside(ReloadOp::RELOADOP_OTHERSIDE);
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);

  for(i=0;i<4;i++) nb->addElement(new WCButton());

  b1=new WCButton();
  b1->setText("Run");
  b1->setCheck(true);
  key->setMod( ControlMask, 0);
  key->setKeySym(XK_x,0);
  b1->setDoubleKeys( keylist );
  fp=new StartProgOp();
  ((StartProgOp*)fp)->setStart(StartProgOp::STARTPROGOP_START_IN_TERMINAL_AND_WAIT4KEY);
  ((StartProgOp*)fp)->setRequestFlags(true);
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);

  for(i=0;i<13;i++) nb->addElement(new WCButton());

  b1=new WCButton();
  b1->setText("Copy");
  b1->setCheck(true);
  b1->setFG(2);
  b1->setBG(6);
  key->setKeySym(XK_F5,0);
  key->setMod( 0, 0 );
  b1->setDoubleKeys( keylist );
  fp=new CopyOp();
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);

  b1=new WCButton();
  b1->setText("Copy++");
  b1->setCheck(true);
  b1->setFG(2);
  b1->setBG(6);
  key->setMod( ShiftMask, 0);
  key->setKeySym(XK_F5,0);
  b1->setDoubleKeys( keylist );
  fp=new CopyOp();
  ((CopyOp*)fp)->setRequestFlags(true);
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);

  b1=new WCButton();
  b1->setText("Delete");
  b1->setCheck(true);
  b1->setFG(2);
  b1->setBG(4);
  key->setKeySym(XK_F8,0);
  key->setMod( 0, 0 );
  b1->setDoubleKeys( keylist );
  fp=new DeleteOp();
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);

  nb->addElement(new WCButton());
  
  b1=new WCButton();
  b1->setText("Rename");
  b1->setCheck(true);
  b1->setFG(2);
  b1->setBG(3);
  key->setKeySym(XK_n,0);
  key->setMod( 0, 0 );
  b1->setDoubleKeys( keylist );
  fp=new RenameOp();
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);

  nb->addElement(new WCButton());
  
  b1=new WCButton();
  b1->setText("Move");
  b1->setCheck(true);
  b1->setFG(1);
  b1->setBG(7);
  key->setKeySym(XK_F6,0);
  key->setMod( 0, 0 );
  b1->setDoubleKeys( keylist );
  fp=new CopyOp();
  ((CopyOp*)fp)->setMove(true);
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);

  b1=new WCButton();
  b1->setText("Move++");
  b1->setCheck(true);
  b1->setFG(1);
  b1->setBG(7);
  key->setMod( ShiftMask, 0 );
  key->setKeySym(XK_F6,0);
  b1->setDoubleKeys( keylist );
  fp=new CopyOp();
  ((CopyOp*)fp)->setMove(true);
  ((CopyOp*)fp)->setRequestFlags(true);
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);

  b1=new WCButton();
  b1->setText("Create Symlink");
  b1->setCheck(true);
  fp=new CreateSymlinkOp();
  ((CreateSymlinkOp*)fp)->setRequestFlags(true);
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);

  nb->addElement(new WCButton());
  
  b1=new WCButton();
  b1->setText("new dir");
  b1->setCheck(true);
  fp=new MakeDirOp();
  key->setKeySym(XK_F7,0);
  key->setMod( 0, 0 );
  b1->setDoubleKeys( keylist );
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);

  nb->addElement(new WCButton());
  nb->addElement(new WCButton());
  nb->addElement(new WCButton());
  
  b1=new WCButton();
  b1->setText("Show pics");
  b1->setCheck(true);
  fp=new OwnOp();
  key->setKeySym(XK_F3,0);
  key->setMod( 0, 0 );
  b1->setDoubleKeys( keylist );
  ((OwnOp*)fp)->setComStr("xv {A}");
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);

  b1=new WCButton();
  b1->setText("Show");
  b1->setCheck(true);
  fp=new ShowAction();
  key->setMod( ShiftMask, 0 );
  key->setKeySym(XK_F3,0);
  b1->setDoubleKeys( keylist );
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);

  b1=new WCButton();
  b1->setText("Edit");
  b1->setCheck(true);
  key->setKeySym(XK_F4,0);
  key->setMod( 0, 0 );
  b1->setDoubleKeys( keylist );
  fp=new OwnOp();
  ((OwnOp*)fp)->setComStr("nedit {f}");
  nc->addElement(fp);
  rfp=new ReloadOp();
  nc->addElement(rfp);
  b1->setComs(nc);
  delete fp;
  delete rfp;
  nc->removeAllElements();
  nb->addElement(b1);

  for(i=0;i<5;i++) nb->addElement(new WCButton());

  b1=new WCButton();
  b1->setText("Change Symlink");
  b1->setCheck(true);
  fp=new ChangeSymlinkOp();
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);

  for(i=0;i<3;i++) nb->addElement(new WCButton());

  b1=new WCButton();
  b1->setText("DirSize");
  b1->setCheck(true);
  fp=new DirSizeOp();
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);

  for(i=0;i<15;i++) nb->addElement(new WCButton());

  b1=new WCButton();
  b1->setText("ChMod");
  b1->setCheck(true);
  fp=new ChModOp();
  ((ChModOp*)fp)->setRequestFlags(true);
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);

  for(i=0;i<12;i++) nb->addElement(new WCButton());

  b1=new WCButton();
  b1->setText("Quit");
  b1->setCheck(true);
  b1->setFG(2);
  b1->setBG(1);
  fp=new QuitOp();
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);

  // apply list
  setButtons(nb);
  
  b1=(WCButton*)nb->getFirstElement();
  while(b1!=NULL) {
    delete b1;
    b1=(WCButton*)nb->getNextElement();
  }
  delete nb;
  
  // setup hotkeys
  nh=new List();
  
  h1=new WCHotkey();
  h1->setName("Up");
  key->setKeySym(XK_Up,0);
  key->setMod( 0, 0 );
  h1->setDoubleKeys( keylist );
  fp=new RowUp();
  nc->addElement(fp);
  h1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nh->addElement(h1);

  h1=new WCHotkey();
  h1->setName("Down");
  key->setKeySym(XK_Down,0);
  key->setMod( 0, 0 );
  h1->setDoubleKeys( keylist );
  fp=new RowDown();
  nc->addElement(fp);
  h1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nh->addElement(h1);

  h1=new WCHotkey();
  h1->setName("Toggle HiddenFlag");
  key->setKeySym(XK_asciicircum,0);
  key->setMod( 0, 0 );
  h1->setDoubleKeys( keylist );
  fp=new ChangeHiddenFlag();
  nc->addElement(fp);
  h1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nh->addElement(h1);

  h1=new WCHotkey();
  h1->setName("Top");
  key->setKeySym(XK_Home,0);
  key->setMod( 0, 0 );
  h1->setDoubleKeys( keylist );
  fp=new FirstRow();
  nc->addElement(fp);
  h1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nh->addElement(h1);

  h1=new WCHotkey();
  h1->setName("Last");
  key->setKeySym(XK_End,0);
  key->setMod( 0, 0 );
  h1->setDoubleKeys( keylist );
  fp=new LastRow();
  nc->addElement(fp);
  h1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nh->addElement(h1);

  h1=new WCHotkey();
  h1->setName("PageUp");
  key->setKeySym(XK_Prior,0);
  key->setMod( 0, 0 );
  h1->setDoubleKeys( keylist );
  fp=new PageUp();
  nc->addElement(fp);
  h1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nh->addElement(h1);

  h1=new WCHotkey();
  h1->setName("PageDown");
  key->setKeySym(XK_Next,0);
  key->setMod( 0, 0 );
  h1->setDoubleKeys( keylist );
  fp=new PageDown();
  nc->addElement(fp);
  h1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nh->addElement(h1);

  h1=new WCHotkey();
  h1->setName("Invert actual entry");
  key->setKeySym(XK_Insert,0);
  key->setMod( 0, 0 );
  h1->setDoubleKeys( keylist );
  fp=new SelectOp();
  nc->addElement(fp);
  h1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nh->addElement(h1);

  h1=new WCHotkey();
  h1->setName("Parent");
  key->setKeySym(XK_Left,0);
  key->setMod( 0, 0 );
  h1->setDoubleKeys( keylist );
  fp=new ParentDirOp();
  nc->addElement(fp);
  h1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nh->addElement(h1);

  h1=new WCHotkey();
  h1->setName("EnterDir");
  key->setKeySym(XK_Right,0);
  key->setMod( 0, 0 );
  h1->setDoubleKeys( keylist );
  fp=new EnterDirOp();
  nc->addElement(fp);
  h1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nh->addElement(h1);

  h1=new WCHotkey();
  h1->setName("Change lister settings (left)");
  key->setMod( Mod1Mask, 0 );
  key->setKeySym(XK_F1,0);
  h1->setDoubleKeys( keylist );
  fp=new ChangeListerSetOp();
  nc->addElement(fp);
  h1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nh->addElement(h1);

  h1=new WCHotkey();
  h1->setName("Change lister settings (right)");
  key->setMod( Mod1Mask, 0 );
  key->setKeySym(XK_F2,0);
  h1->setDoubleKeys( keylist );
  fp=new ChangeListerSetOp();
  ((ChangeListerSetOp*)fp)->setMode(ChangeListerSetOp::CLS_RIGHT_LISTER);
  nc->addElement(fp);
  h1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nh->addElement(h1);

  h1=new WCHotkey();
  h1->setName("Switch side");
  key->setKeySym(XK_Tab,0);
  key->setMod( 0, 0 );
  h1->setDoubleKeys( keylist );
  fp=new SwitchListerOp();
  nc->addElement(fp);
  h1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nh->addElement(h1);

  h1=new WCHotkey();
  h1->setName("Simulate DoubleClick");
  key->setKeySym(XK_Return,0);
  key->setMod( 0, 0 );
  h1->setDoubleKeys( keylist );
  fp=new SimDDOp();
  nc->addElement(fp);
  h1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nh->addElement(h1);

  h1=new WCHotkey();
  h1->setName("Search Entry");
  key->setKeySym(XK_s,0);
  key->setMod( ControlMask, 0 );
  h1->setDoubleKeys( keylist );
  fp=new SearchEntryOp();
  nc->addElement(fp);
  h1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nh->addElement(h1);

  h1=new WCHotkey();
  h1->setName("Edit path");
  key->setKeySym(XK_Return,0);
  key->setMod( ControlMask, 0 );
  h1->setDoubleKeys( keylist );
  fp=new EnterPathOp();
  nc->addElement(fp);
  h1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nh->addElement(h1);

  h1=new WCHotkey();
  h1->setName("Edit other path");
  key->setKeySym(XK_Return,0);
  key->setMod( ControlMask | ShiftMask, 0 );
  h1->setDoubleKeys( keylist );
  fp=new EnterPathOp();
  ((EnterPathOp*)fp)->setSide(EnterPathOp::ENTERPATHOP_OTHERSIDE);
  nc->addElement(fp);
  h1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nh->addElement(h1);

  h1=new WCHotkey();
  h1->setName("Scroll left");
  key->setKeySym(XK_Left,0);
  key->setMod( ControlMask, 0 );
  h1->setDoubleKeys( keylist );
  fp=new ScrollListerOp();
  ((ScrollListerOp*)fp)->setDir(ScrollListerOp::SCROLLLISTEROP_LEFT);
  nc->addElement(fp);
  h1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nh->addElement(h1);

  h1=new WCHotkey();
  h1->setName("Scroll right");
  key->setKeySym(XK_Right,0);
  key->setMod( ControlMask, 0 );
  h1->setDoubleKeys( keylist );
  fp=new ScrollListerOp();
  ((ScrollListerOp*)fp)->setDir(ScrollListerOp::SCROLLLISTEROP_RIGHT);
  nc->addElement(fp);
  h1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nh->addElement(h1);

  setHotkeys(nh);
  
  h1=(WCHotkey*)nh->getFirstElement();
  while(h1!=NULL) {
    delete h1;
    h1=(WCHotkey*)nh->getNextElement();
  }
  delete nh;

  nf = new List();  
  setFiletypes( nf );
  delete nf;
  initFixTypes();

  delete nc;
  delete key;
  delete keylist;
}

bool WConfig::loadBinConfig( const char *file )
{
  int id;
  unsigned long chunksize;
  unsigned short us1=0,us2=0,us3=0,colorsize=0;
  int pathsize=0,filetypesize=0,buttonsize=0,hotkeysize=0;
  char *str,buf[5],*tstr;
  Requester *req;
  char *textstr;
  int x1;
  bool viscolsend;
  
  Datei *fh=new Datei();
  if(fh->open(file,"r")==0) {
    fh->getString(buf,4);
    if(strcmp(buf,"FORM")==0) {
      fh->getULong();
      fh->getString(buf,4);
      if(strcmp(buf,"WCFG")==0) {
        fh->getString(buf,4);
        if(strcmp(buf,"VERS")==0) {
          chunksize=fh->getULong();
          if(chunksize>=3*2) {
            us1=fh->getUShort();
            chunksize-=2;
            us2=fh->getUShort();
            chunksize-=2;
            us3=fh->getUShort();
            chunksize-=2;
          }
          while(chunksize>0) {
            fh->getUChar();
            chunksize--;
          }
          if( ((us1==WORKER_MAJOR)&&(us2>WORKER_MINOR)) ||
              ((us1==WORKER_MAJOR)&&(us2==WORKER_MINOR)&&(us3>WORKER_PATCH)) ) {
            // Konfig-Datei hat neuere Version => nicht laden
            req=new Requester(worker->getAGUIX());
            textstr = (char*)_allocsafe( strlen( catalog.getLocale( 384 ) ) + 3 * A_BYTESFORNUMBER( int ) + 1 );
            sprintf(textstr,catalog.getLocale(384),us1,us2,us3);
            req->request(catalog.getLocale(347),textstr,catalog.getLocale(11));
            _freesafe(textstr);
            delete req;
          } else {
            fh->getString(buf,4);
            if(strcmp(buf,"SETS")==0) {
              chunksize=fh->getULong();
              unsigned long len;
              if(chunksize>=(4+11*2+2*9*5+18*5+5+5+5+5+5+5+2+4*5)) {
                len=fh->getULong();
                chunksize-=4;
                str=fh->getString(len);
                setLang(str);
                _freesafe(str);
                chunksize-=len;
                setRows(fh->getUShort());
                chunksize-=2;
                setColumns(fh->getUShort());
                chunksize-=2;
                setCacheSize(fh->getUShort());
                chunksize-=2;
                setHBarTop(0,(fh->getUShort()==1)?true:false);
                chunksize-=2;
                setHBarTop(1,(fh->getUShort()==1)?true:false);
                chunksize-=2;
                setHBarHeight(0,fh->getUShort());
                chunksize-=2;
                setHBarHeight(1,fh->getUShort());
                chunksize-=2;
                setVBarLeft(0,(fh->getUShort()==1)?true:false);
                chunksize-=2;
                setVBarLeft(1,(fh->getUShort()==1)?true:false);
                chunksize-=2;
                setVBarWidth(0,fh->getUShort());
                chunksize-=2;
                setVBarWidth(1,fh->getUShort());
                chunksize-=2;
                for(int i=0;i<2;i++) {
                  viscols[i].clear();
                  viscolsend = false;
                  for(int j=0;j<9;j++) {
                    x1 = fh->getInt();
                    if ( viscolsend == false ) {
                      switch ( x1 ) {
                        case 0:
                          viscols[i].push_back( WorkerTypes::LISTCOL_NAME );
                          break;
                        case 1:
                          viscols[i].push_back( WorkerTypes::LISTCOL_SIZE );
                          break;
                        case 2:
                          viscols[i].push_back( WorkerTypes::LISTCOL_TYPE );
                          break;
                       case 3:
                          viscols[i].push_back( WorkerTypes::LISTCOL_PERM );
                          break;
                        case 4:
                          viscols[i].push_back( WorkerTypes::LISTCOL_OWNER );
                          break;
                        case 5:
                          viscols[i].push_back( WorkerTypes::LISTCOL_DEST );
                          break;
                        case 6:
                          viscols[i].push_back( WorkerTypes::LISTCOL_MOD );
                          break;
                        case 7:
                          viscols[i].push_back( WorkerTypes::LISTCOL_ACC );
                         break;
                        case 8:
                          viscols[i].push_back( WorkerTypes::LISTCOL_CHANGE );
                          break;
                        default:
                          viscolsend = true;
                          break;
                      }
                    }
                    chunksize-=5;
                  }
                }
                setStatusbar(0,fh->getInt());
                chunksize-=5;
                setStatusbar(1,fh->getInt());
                chunksize-=5;
                setSelLVB(0,fh->getInt());
                chunksize-=5;
                setSelLVB(1,fh->getInt());
                chunksize-=5;
                setUnselLVB(0,fh->getInt());
                chunksize-=5;
                setUnselLVB(1,fh->getInt());
                chunksize-=5;
                setSelDir(0,fh->getInt());
                chunksize-=5;
                setSelDir(1,fh->getInt());
                chunksize-=5;
                setUnselDir(0,fh->getInt());
                chunksize-=5;
                setUnselDir(1,fh->getInt());
                chunksize-=5;
                setSelFile(0,fh->getInt());
                chunksize-=5;
                setSelFile(1,fh->getInt());
                chunksize-=5;
                setUnselFile(0,fh->getInt());
                chunksize-=5;
                setUnselFile(1,fh->getInt());
                chunksize-=5;
                setClockbar(0,fh->getInt());
                chunksize-=5;
                setClockbar(1,fh->getInt());
                chunksize-=5;
                setRequest(0,fh->getInt());
                chunksize-=5;
                setRequest(1,fh->getInt());
                chunksize-=5;
    
                len=fh->getInt();
                chunksize-=5;
                str=fh->getString(len);
                setStartDir(0,str);
                _freesafe(str);
                chunksize-=len;
                len=fh->getInt();
                chunksize-=5;
                str=fh->getString(len);
                setStartDir(1,str);
                _freesafe(str);
                chunksize-=len;
                len=fh->getInt();
                chunksize-=5;
                str=fh->getString(len);
                setFont(0,str);
                _freesafe(str);
                chunksize-=len;
                len=fh->getInt();
                chunksize-=5;
                str=fh->getString(len);
                setFont(1,str);
                _freesafe(str);
                chunksize-=len;
                len=fh->getInt();
                chunksize-=5;
                str=fh->getString(len);
                setFont(2,str);
                _freesafe(str);
                chunksize-=len;
                len=fh->getInt();
                chunksize-=5;
                str=fh->getString(len);
                setFont(3,str);
                _freesafe(str);
                chunksize-=len;
                colorsize=fh->getUShort();
                chunksize-=2;
                pathsize=fh->getInt();
                chunksize-=5;
                filetypesize=fh->getInt();
                chunksize-=5;
                buttonsize=fh->getInt();
                chunksize-=5;
                hotkeysize=fh->getInt();
                chunksize-=5;
                
                // this is since version 2.0.2 so do extra check for older configs
                if(chunksize>=1) {
                  setOwnerstringtype(fh->getUChar());
                  chunksize-=1;

                  // new option
                  if(chunksize>=4) {
                    len=fh->getULong();
                    chunksize-=4;
                    str=fh->getString(len);
                    setTerminalBin(str);
                    _freesafe(str);
                    chunksize-=len;
                    
                    // new option from 16.3.2001
                    if(chunksize>=(unsigned long)(Datei::getUCharSize()+2*Datei::getIntSize())) {
                      unsigned char nm=fh->getUChar();
                      chunksize-=Datei::getUCharSize();
                      switch(nm) {
                        case 1:
                          setClockbarMode(CLOCKBAR_MODE_TIME);
                          break;
                        case 2:
                          setClockbarMode(CLOCKBAR_MODE_VERSION);
                          break;
                        case 3:
                          setClockbarMode(CLOCKBAR_MODE_EXTERN);
                          break;
                        default:
                          setClockbarMode(CLOCKBAR_MODE_TIMERAM);
                          break;
                      }
                      setClockbarUpdatetime(fh->getInt());
                      chunksize-=Datei::getIntSize();
                      int ilen=fh->getInt();
                      chunksize-=Datei::getIntSize();
                      str=fh->getString(ilen);
                      setClockbarCommand(str);
                      _freesafe(str);
                      chunksize-=ilen;
                      
                      if(chunksize>=(unsigned int)Datei::getIntSize()) {
                        // load the dontcheckdirs
                        List *ndcd=new List();
                        int dcdsize=fh->getInt();
                        chunksize-=Datei::getIntSize();
                        while(dcdsize>0) {
                          len=fh->getInt();
                          chunksize-=fh->getIntSize();
                          tstr=fh->getString(len);
                          chunksize-=len;
                          ndcd->addElement(tstr);
                          dcdsize--;
                        }
                        setDontCheckDirs(ndcd);
                        id=ndcd->initEnum();
                        tstr=(char*)ndcd->getFirstElement(id);
                        while(tstr!=NULL) {
                          _freesafe(tstr);
                          tstr=(char*)ndcd->getNextElement(id);
                        }
                        ndcd->closeEnum(id);
                        delete ndcd;
                        
                        // new in version 2.2.1
                        if(chunksize>=(unsigned int)(8*Datei::getIntSize())) {
                          setSelDirAct(0,fh->getInt());
                          chunksize-=Datei::getIntSize();
                          setSelDirAct(1,fh->getInt());
                          chunksize-=Datei::getIntSize();
                          setUnselDirAct(0,fh->getInt());
                          chunksize-=Datei::getIntSize();
                          setUnselDirAct(1,fh->getInt());
                          chunksize-=Datei::getIntSize();
                          setSelFileAct(0,fh->getInt());
                          chunksize-=Datei::getIntSize();
                          setSelFileAct(1,fh->getInt());
                          chunksize-=Datei::getIntSize();
                          setUnselFileAct(0,fh->getInt());
                          chunksize-=Datei::getIntSize();
                          setUnselFileAct(1,fh->getInt());
                          chunksize-=Datei::getIntSize();

                          // new in version 2.2.2
                          if(chunksize>=(unsigned int)(Datei::getIntSize())) {
                            setListerBG(fh->getInt());
                            chunksize-=Datei::getIntSize();
                            
                            // new in version 2.2.3
                            if(chunksize>=(unsigned long)(Datei::getUCharSize()+Datei::getIntSize())) {
                              setShowStringForDirSize((fh->getUChar()==1)?true:false);
                              chunksize-=fh->getUCharSize();
                              len=fh->getInt();
                              chunksize-=fh->getIntSize();
                              tstr=fh->getString(len);
                              chunksize-=len;
                              setStringForDirSize(tstr);
                              _freesafe(tstr);
                              
                              // new in >2.3.1
                              if ( chunksize >= (unsigned long)( Datei::getIntSize() +
                                                                 Datei::getIntSize() +
                                                                 Datei::getUCharSize() +
                                                                 Datei::getIntSize() +
                                                                 Datei::getIntSize() +
                                                                 Datei::getUCharSize() ) ) {
                                setDateFormat( fh->getInt() );
                                chunksize -= Datei::getIntSize();
                                
                                len = fh->getInt();
                                chunksize -= Datei::getIntSize();
                                
                                tstr = fh->getString( len );
                                chunksize -= len;
                                setDateFormatString( tstr );
                                _freesafe( tstr );
                                
                                setDateSubst( ( fh->getUChar() == 1 ) ? true : false );
                                chunksize -= Datei::getUCharSize();
                                
                                setTimeFormat( fh->getInt() );
                                chunksize -= Datei::getIntSize();

                                len = fh->getInt();
                                chunksize -= Datei::getIntSize();
                                
                                tstr = fh->getString( len );
                                chunksize -= len;
                                setTimeFormatString( tstr );
                                _freesafe( tstr );
                                
                                setDateBeforeTime( ( fh->getUChar() == 1 ) ? true : false );
                                chunksize -= Datei::getUCharSize();
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
              while(chunksize>0) {
                fh->getUChar();
                chunksize--;
              }
              WC_Color *col;
              List *l1=new List();
              while(colorsize>0) {
                col=new WC_Color();
                loadBinColor( fh, col );
                l1->addElement(col);
                colorsize--;
              }
              setColors(l1);
              applyColorList(colors);
              id=l1->initEnum();
              while(l1->size()>0) {
                col=(WC_Color*)l1->getFirstElement(id);
                delete col;
                l1->removeFirstElement();
              }
              l1->closeEnum(id);
              WCPath *p1;
              while(pathsize>0) {
                p1=new WCPath();
                loadBinPath( fh, p1 );
                l1->addElement(p1);
                pathsize--;
              }
              setPaths(l1);
              id=l1->initEnum();
              while(l1->size()>0) {
                p1=(WCPath*)l1->getFirstElement(id);
                delete p1;
                l1->removeFirstElement();
              }
              l1->closeEnum(id);
              WCFiletype *f1;
              while(filetypesize>0) {
                f1=new WCFiletype();
                loadBinFiletype( fh, f1 );
                l1->addElement(f1);
                filetypesize--;
              }
              setFiletypes(l1);
              initFixTypes();
              id=l1->initEnum();
              while(l1->size()>0) {
                f1=(WCFiletype*)l1->getFirstElement(id);
                delete f1;
                l1->removeFirstElement();
              }
              l1->closeEnum(id);
              WCHotkey *h1;
              while(hotkeysize>0) {
                h1=new WCHotkey();
                loadBinHotkey( fh, h1 );
                l1->addElement(h1);
                hotkeysize--;
              }
              setHotkeys(l1);
              id=l1->initEnum();
              while(l1->size()>0) {
                h1=(WCHotkey*)l1->getFirstElement(id);
                delete h1;
                l1->removeFirstElement();
              }
              l1->closeEnum(id);
              WCButton *b1;
              while(buttonsize>0) {
                b1=new WCButton();
                loadBinButton( fh, b1 );
                l1->addElement(b1);
                buttonsize--;
              }
              setButtons(l1);
              id=l1->initEnum();
              while(l1->size()>0) {
                b1=(WCButton*)l1->getFirstElement(id);
                delete b1;
                l1->removeFirstElement();
              }
              l1->closeEnum(id);
              delete l1;
            }
          }
        } else {
          // Keine 2er-Version
	  req = new Requester( worker->getAGUIX() );
	  req->request( catalog.getLocale( 125 ), catalog.getLocale( 665 ), catalog.getLocale( 11 ) );
	  delete req;
        }
      } else {
        // kein Config-file
        req=new Requester(worker->getAGUIX());
        textstr=(char*)_allocsafe(strlen(catalog.getLocale(367))+strlen(file)+1);
        sprintf(textstr,catalog.getLocale(367),file);
        req->request(catalog.getLocale(125),textstr,catalog.getLocale(11));
        _freesafe(textstr);
        delete req;
      }
    } else {
      // kein IFF-file
      req=new Requester(worker->getAGUIX());
      textstr=(char*)_allocsafe(strlen(catalog.getLocale(367))+strlen(file)+1);
      sprintf(textstr,catalog.getLocale(367),file);
      req->request(catalog.getLocale(125),textstr,catalog.getLocale(11));
      _freesafe(textstr);
      delete req;
    }
    fh->close();
  } else {
    return false;
  }
  delete fh;
  return true;
}

int WConfig::loadBinColor( Datei *fh, WC_Color *col )
{
  char *str;

  if ( ( fh == NULL ) || ( col == NULL ) ) return 1;
  
  str = fh->getString( 4 );
  if ( strncmp( str, "CLOR", 4 ) != 0 ) {
    _freesafe( str );
    fh->seek( -4, SEEK_CUR );
    return 1;
  } else {
    int chunksize = fh->getULong();
    if ( chunksize >= 3*5 ) {
      col->setRed( fh->getInt() );
      col->setGreen( fh->getInt() );
      col->setBlue( fh->getInt() );
      chunksize -= 3*5;
    }
    while ( chunksize > 0 ) {
      fh->getUChar();
      chunksize--;
    }
  }
  _freesafe( str );
  return 0;
}

int WConfig::loadBinPath( Datei *fh, WCPath *p1 )
{
  WCDoubleShortkey *dk;
  int nok;
  List *tdkeys;
  int id;
  char *str;
  WCDoubleShortkey *key;

  if ( ( fh == NULL ) || ( p1 == NULL ) ) return 1;

  str = fh->getString( 4 );
  if ( strncmp( str, "PATH", 4 ) != 0 ) {
    _freesafe( str );
    fh->seek( -4, SEEK_CUR );
    return 1;
  } else {
    _freesafe( str );
    int chunksize = fh->getULong();
    if ( chunksize >= 14 ) {
      unsigned long len = fh->getULong();
      chunksize -= 4;
      str = fh->getString( len );
      chunksize -= len;
      p1->setName( str );
      _freesafe( str );
      p1->setFG( fh->getUShort() );
      chunksize -= 2;
      p1->setBG( fh->getUShort() );
      chunksize -= 2;
      len = fh->getULong();
      chunksize -= 4;
      str = fh->getString( len );
      chunksize -= len;
      p1->setPath( str );
      _freesafe( str );
      p1->setCheck( ( fh->getUShort() == 1 ) ? true : false );
      chunksize -= 2;
      if ( chunksize >= Datei::getIntSize() ) {
        // new in >2.4.0
        nok = fh->getInt();
        chunksize -= Datei::getIntSize();
        tdkeys = new List();
        while ( nok > 0 ) {
          dk = new WCDoubleShortkey();
          chunksize -= loadBinDoubleShortkey( fh, dk );
          tdkeys->addElement( dk );
          nok--;
        }
        p1->setDoubleKeys( tdkeys );
        id = tdkeys->initEnum();
        dk = (WCDoubleShortkey*)tdkeys->getFirstElement( id );
        while ( dk != NULL ) {
          delete dk;
          tdkeys->removeFirstElement();
          dk = (WCDoubleShortkey*)tdkeys->getFirstElement( id );
        }
        tdkeys->closeEnum( id );
        delete tdkeys;
      }
    }
    while ( chunksize > 0 ) {
      fh->getUChar();
      chunksize--;
    }
    // Hier sollte das Shortkey folgen, aber die Load-Funktion prueft das schon :-)
    key = new WCDoubleShortkey();
    loadBinShortkey( fh, key );
    if ( key->isReal() == true ) {
      // real key but it's not used anymore so convert into doubleshortkey
      if ( p1->hasKey( key->getKeySym( 0 ), key->getMod( 0 ) ) == false ) {
        p1->addKey( key->getKeySym( 0 ), key->getMod( 0 ) );
      }
    }
    delete key;
  }
  return 0;
}

int WConfig::loadBinShortkey( Datei *fh, WCDoubleShortkey *key )
{
  if ( ( fh == NULL ) || ( key == NULL ) ) return 1;
  char *str = fh->getString( 4 );
  if ( strncmp( str, "WSHK", 4 ) != 0 ) {
    _freesafe( str );
    fh->seek( -4, SEEK_CUR );
    return 1;
  } else {
    unsigned long chunksize = fh->getULong();
    if ( chunksize >= 9 ) {
      key->setType( WCDoubleShortkey::WCDS_NORMAL );
      key->setKeySym( fh->getULong(), 0 );
      chunksize -= 4;
      key->setMod( fh->getInt(), 0 );
      chunksize -= 5;
    }
    while ( chunksize > 0 ) {
      fh->getUChar();
      chunksize--;
    }
  }
  _freesafe( str );
  return 0;
}

int WConfig::loadBinDoubleShortkey( Datei *fh, WCDoubleShortkey *dk )
{
  if ( ( fh == NULL ) || ( dk == NULL ) ) return 0;
  char *str = fh->getString( 4 );
  int ls = 0, len;
  char *kstr1;
  KeySym nkey;

  if ( strncmp( str, "WDSK", 4 ) != 0 ) {
    _freesafe( str );
    fh->seek( -4, SEEK_CUR );
    return 0;
  } else {
    long chunksize = (long)fh->getULong();
    unsigned short sh;
    
    ls = chunksize + 4 + Datei::getULongSize();
    
    if ( chunksize >= ( Datei::getUShortSize() +
                        Datei::getIntSize() * 2 +
                        Datei::getIntSize() * 2 ) ) {
      len = fh->getInt();
      chunksize -= Datei::getIntSize();
      if ( len > 0 ) {
        kstr1 = fh->getString( len );
        chunksize -= len;
        nkey = AGUIX::getKeySymForString( kstr1 );
        if ( kstr1 != NULL ) _freesafe( kstr1 );
        if ( nkey != NoSymbol )
          dk->setKeySym( nkey, 0 );
        else
          dk->setKeySym( 0, 0 );
      } else {
        dk->setKeySym( 0, 0 );
      }
      dk->setMod( fh->getInt(), 0 );
      chunksize -= Datei::getIntSize();

      len = fh->getInt();
      chunksize -= Datei::getIntSize();
      if ( len > 0 ) {
        kstr1 = fh->getString( len );
        chunksize -= len;
        nkey = AGUIX::getKeySymForString( kstr1 );
        if ( kstr1 != NULL ) _freesafe( kstr1 );
        if ( nkey != NoSymbol )
          dk->setKeySym( nkey, 1 );
        else
          dk->setKeySym( 0, 1 );
      } else {
        dk->setKeySym( 0, 1 );
      }
      dk->setMod( fh->getInt(), 1 );
      chunksize -= Datei::getIntSize();
      
      sh = fh->getUShort();
      chunksize -= Datei::getUShortSize();
      switch ( sh ) {
      case 1:
        dk->setType( WCDoubleShortkey::WCDS_DOUBLE );
        break;
      default:
        dk->setType( WCDoubleShortkey::WCDS_NORMAL );
        break;
      }
    }
    while ( chunksize > 0 ) {
      fh->getUChar();
      chunksize--;
    }
  }
  _freesafe( str );
  return ls;
}

int WConfig::loadBinFiletype( Datei *fh, WCFiletype *f1 )
{
  int i;
  List *l1;
  int id;
  
  if ( ( fh == NULL ) || ( f1 == NULL ) ) return 1;
  char *str = fh->getString( 4 );
  if ( strncmp( str, "FITY", 4 ) != 0 ) {
    _freesafe( str );
    fh->seek( -4, SEEK_CUR );
    return 1;
  } else {
    _freesafe( str );
    unsigned long chunksize = fh->getULong();
    int dndsize = 0;
    int dcsize = 0;
    int showsize = 0;
    int rssize = 0;
    int usize[10];
    short filedesc[64];
    
    if ( chunksize >= ( 4 + 4 + 2 + 64 * 5 + 2 + 14 * 5 + 5 ) ) {
      unsigned long len = fh->getULong();
      chunksize -= 4;
      str = fh->getString( len );
      chunksize -= len;
      f1->setName( str );
      _freesafe( str );
      len = fh->getULong();
      chunksize -= 4;
      str = fh->getString( len );
      chunksize -= len;
      f1->setPattern( str );
      _freesafe( str );
      unsigned short us = fh->getUShort();
      chunksize -= 2;
      f1->setUsePattern( ( us == 1 ) ? true : false );
      for ( i = 0; i < 64; i++ ) {
        filedesc[i] = fh->getInt();
        chunksize -= 5;
      }
      f1->setFiledesc( filedesc );
      us = fh->getUShort();
      f1->setUseFiledesc( ( us == 1 ) ? true : false );
      chunksize -= 2;
      dndsize = fh->getInt();
      chunksize -= 5;
      dcsize = fh->getInt();
      chunksize -= 5;
      showsize = fh->getInt();
      chunksize -= 5;
      rssize = fh->getInt();
      chunksize -= 5;
      for ( i = 0; i < 10; i++ ) {
        usize[i] = fh->getInt();
        chunksize -= 5;
      }
      f1->setinternID( fh->getInt() );
      chunksize -= 5;
      
      // new in >2.3.1
      if ( chunksize >= (unsigned long)( Datei::getIntSize() + Datei::getUShortSize() ) ) {
        len = fh->getInt();
        chunksize -= Datei::getIntSize();
        
        str = fh->getString( len ); // was fileExp
        chunksize -= len;
        _freesafe(str);
        
	// was useFileExp
        fh->getUShort();
        chunksize -= Datei::getUShortSize();
        
        // new >2.5.0
        if ( chunksize >= (unsigned long)( 2 * Datei::getUShortSize() ) ) {
          f1->setPatternIgnoreCase( ( fh->getUShort() == 1 ) ? true : false );
          f1->setPatternUseRegExp( ( fh->getUShort() == 1 ) ? true : false );
          chunksize -= 2 * Datei::getUShortSize();
        }
      }
    }
    while ( chunksize > 0 ) {
      fh->getUChar();
      chunksize--;
    }
    // Jetzt Flags laden
    loadBinGlobalFlags( fh );
    loadBinGlobalFlags( fh );
    loadBinGlobalFlags( fh );
    loadBinGlobalFlags( fh );
    for(i=0;i<10;i++) {
      loadBinGlobalFlags( fh );
    }
    // Und nun die Kommandos
    FunctionProto *fp;
    while ( dndsize > 0 ) {
      l1 = loadBinFunction( fh );
      if ( l1 != NULL ) {
        id = l1->initEnum();
        fp = (FunctionProto*)l1->getFirstElement( id );
        while ( fp != NULL ) {
          f1->addComDNDAction( fp );
          delete fp;
          l1->removeFirstElement();
          fp = (FunctionProto*)l1->getFirstElement( id );
        }
        l1->closeEnum( id );
        delete l1;
      }
      dndsize--;
    }

    while ( dcsize > 0 ) {
      l1 = loadBinFunction( fh );
      if ( l1 != NULL ) {
        id = l1->initEnum();
        fp = (FunctionProto*)l1->getFirstElement( id );
        while ( fp != NULL ) {
          f1->addComDoubleClickAction( fp );
          delete fp;
          l1->removeFirstElement();
          fp = (FunctionProto*)l1->getFirstElement( id );
        }
        l1->closeEnum( id );
        delete l1;
      }
      dcsize--;
    }

    while ( showsize > 0 ) {
      l1 = loadBinFunction( fh );
      if ( l1 != NULL ) {
        id = l1->initEnum();
        fp = (FunctionProto*)l1->getFirstElement( id );
        while ( fp != NULL ) {
          f1->addComShowAction( fp );
          delete fp;
          l1->removeFirstElement();
          fp = (FunctionProto*)l1->getFirstElement( id );
        }
        l1->closeEnum( id );
        delete l1;
      }
      showsize--;
    }
    while ( rssize > 0 ) {
      l1 = loadBinFunction( fh );
      if ( l1 != NULL ) {
        id = l1->initEnum();
        fp = (FunctionProto*)l1->getFirstElement( id );
        while ( fp != NULL ) {
          f1->addComRawShowAction( fp );
          delete fp;
          l1->removeFirstElement();
          fp = (FunctionProto*)l1->getFirstElement( id );
        }
        l1->closeEnum( id );
        delete l1;
      }
      rssize--;
    }
    for(i=0;i<10;i++) {
      while ( usize[i] > 0 ) {
        l1 = loadBinFunction( fh );
        if ( l1 != NULL ) {
          id = l1->initEnum();
          fp = (FunctionProto*)l1->getFirstElement( id );
          while ( fp != NULL ) {
            f1->addComUserAction( i, fp );
            delete fp;
            l1->removeFirstElement();
            fp = (FunctionProto*)l1->getFirstElement( id );
          }
          l1->closeEnum( id );
          delete l1;
        }
        usize[i]--;
      }
    }
  }
  return 0;
}

int WConfig::loadBinHotkey( Datei *fh, WCHotkey *h1 )
{
  WCDoubleShortkey *dk;
  int nok;
  List *tdkeys;
  int id;
  List *l1;

  if ( ( fh == NULL ) || ( h1 == NULL ) ) return 1;
  char *str = fh->getString( 4 );
  if ( strncmp( str, "HOTK", 4 ) != 0 ) {
    _freesafe( str );
    fh->seek( -4, SEEK_CUR );
    return 1;
  } else {
    _freesafe( str );
    unsigned long chunksize = fh->getULong();
    unsigned long comsize = 0;
    if ( chunksize >= 8 ) {
      unsigned long len = fh->getULong();
      chunksize -= 4;
      str = fh->getString( len );
      chunksize -= len;
      h1->setName( str );
      _freesafe( str );
      comsize = fh->getULong();
      chunksize -= 4;
      if ( chunksize >= (unsigned long)Datei::getIntSize() ) {
        // new in >2.4.0
        nok = fh->getInt();
        chunksize -= Datei::getIntSize();
        tdkeys = new List();
        while ( nok > 0 ) {
          dk = new WCDoubleShortkey();
          chunksize -= loadBinDoubleShortkey( fh, dk );
          tdkeys->addElement( dk );
          nok--;
        }
        h1->setDoubleKeys( tdkeys );
        id = tdkeys->initEnum();
        dk = (WCDoubleShortkey*)tdkeys->getFirstElement( id );
        while ( dk != NULL ) {
          delete dk;
          tdkeys->removeFirstElement();
          dk = (WCDoubleShortkey*)tdkeys->getFirstElement( id );
        }
        tdkeys->closeEnum( id );
        delete tdkeys;
      }
    }
    while ( chunksize > 0 ) {
      fh->getUChar();
      chunksize--;
    }
    WCDoubleShortkey *key;
    key = new WCDoubleShortkey();
    loadBinShortkey( fh, key );
    if ( key->isReal() == true ) {
      // real key but it's not used anymore so convert into doubleshortkey
      if ( h1->hasKey( key->getKeySym( 0 ), key->getMod( 0 ) ) == false ) {
        h1->addKey( key->getKeySym( 0 ), key->getMod( 0 ) );
      }
    }
    delete key;
    loadBinGlobalFlags( fh );
    FunctionProto *f1;
    while ( comsize > 0 ) {
      l1 = loadBinFunction( fh );
      if ( l1 != NULL ) {
        id = l1->initEnum();
        f1 = (FunctionProto*)l1->getFirstElement( id );
        while ( f1 != NULL ) {
          h1->addCom( f1 );
          delete f1;
          l1->removeFirstElement();
          f1 = (FunctionProto*)l1->getFirstElement( id );
        }
        l1->closeEnum( id );
        delete l1;
      }
      comsize--;
    }
  }
  return 0;
}

int WConfig::loadBinButton( Datei *fh, WCButton *b1 )
{
  WCDoubleShortkey *dk;
  int nok;
  List *tdkeys, *l1;
  int id;

  if ( ( fh == NULL ) || ( b1 == NULL ) ) return 1;
  char *str = fh->getString( 4 );
  if ( strncmp( str, "BTTN", 4 ) != 0 ) {
    _freesafe( str );
    fh->seek( -4, SEEK_CUR );
    return 1;
  } else {
    _freesafe( str );
    unsigned long chunksize = fh->getULong();
    unsigned long comsize = 0;
    if ( chunksize >= ( 4 + 5 + 5 + 4 + 2 ) ) {
      unsigned long len = fh->getULong();
      chunksize -= 4;
      str = fh->getString( len );
      chunksize -= len;
      b1->setText( str );
      _freesafe( str );
      b1->setFG( fh->getInt() );
      chunksize -= 5;
      b1->setBG( fh->getInt() );
      chunksize -= 5;
      comsize = fh->getULong();
      chunksize -= 4;
      unsigned short us = fh->getUShort();
      chunksize -= 2;
      b1->setCheck( ( us == 1 ) ? true : false );
      if ( chunksize >= (unsigned long)Datei::getIntSize() ) {
        // new in >2.4.0
        nok = fh->getInt();
        chunksize -= Datei::getIntSize();
        tdkeys = new List();
        while ( nok > 0 ) {
          dk = new WCDoubleShortkey();
          chunksize -= loadBinDoubleShortkey( fh, dk );
          tdkeys->addElement( dk );
          nok--;
        }
        b1->setDoubleKeys( tdkeys );
        id = tdkeys->initEnum();
        dk = (WCDoubleShortkey*)tdkeys->getFirstElement( id );
        while ( dk != NULL ) {
          delete dk;
          tdkeys->removeFirstElement();
          dk = (WCDoubleShortkey*)tdkeys->getFirstElement( id );
        }
        tdkeys->closeEnum( id );
        delete tdkeys;
      }
    }
    while ( chunksize > 0 ) {
      fh->getUChar();
      chunksize--;
    }
    
    WCDoubleShortkey *key;
    key = new WCDoubleShortkey();
    loadBinShortkey( fh, key );
    if ( key->isReal() == true ) {
      // real key but it's not used anymore so convert into doubleshortkey
      if ( b1->hasKey( key->getKeySym( 0 ), key->getMod( 0 ) ) == false ) {
        b1->addKey( key->getKeySym( 0 ), key->getMod( 0 ) );
      }
    }
    delete key;
    loadBinGlobalFlags( fh );
    FunctionProto *f1;
    while ( comsize > 0 ) {
      l1 = loadBinFunction( fh );
      if ( l1 != NULL ) {
        id = l1->initEnum();
        f1 = (FunctionProto*)l1->getFirstElement( id );
        while ( f1 != NULL ) {
          b1->addCom( f1 );
          delete f1;
          l1->removeFirstElement();
          f1 = (FunctionProto*)l1->getFirstElement( id );
        }
        l1->closeEnum( id );
        delete l1;
      }
      comsize--;
    }
  }
  return 0;
}

/*
 * Spezialbehandlung: Ich habe die GlobalFlags nicht benutzt,
 * deshalb lade ich nur, aber mache nichts damit
 */
int WConfig::loadBinGlobalFlags( Datei *fh )
{
  if ( fh == NULL ) return 1;
  char *str = fh->getString( 4 );
  if ( strncmp( str, "GLFL", 4 ) != 0 ) {
    _freesafe( str );
    fh->seek( -4, SEEK_CUR );
    return 1;
  } else {
    unsigned long chunksize = fh->getULong();
    if ( chunksize >= 4 ) {
      fh->getULong();
      chunksize -= 4;
    }
    while ( chunksize > 0 ) {
      fh->getUChar();
      chunksize--;
    }
  }
  _freesafe( str );
  return 0;
}

List *WConfig::loadBinFunction( Datei *fh )
{
  int comid;
  FunctionProto *fp;
  List *comlist;
  int chunksize;
  int nr;
  int cs = Datei::getUCharSize(),
      is = Datei::getIntSize(),
      len;
  unsigned char c1;
  char *tstr;
  CopyOp *cop;
  char *str;
  OwnOp *op;
  ScriptOp *scop;
  StartProgOp *stpop;

  if ( fh == NULL ) return NULL;
  comid = fh->getInt();

  comlist = new List();
  chunksize = fh->getInt();
  switch ( comid ) {
    case DNDACTION_NUMBER:
      fp = new DNDAction();
      comlist->addElement( fp );
      break;
    case DOUBLECLICKACTION_NUMBER:
      fp = new DoubleClickAction();
      comlist->addElement( fp );
      break;
    case SHOWACTION_NUMBER:
      fp = new ShowAction();
      comlist->addElement( fp );
      break;
    case RAWSHOWACTION_NUMBER:
      fp = new RawShowAction();
      comlist->addElement( fp );
      break;
    case USERACTION_NUMBER:
      fp = new UserAction();
      if ( chunksize >= Datei::getIntSize() ) {
        nr = fh->getInt();
        chunksize -= Datei::getIntSize();
        if ( ( nr < 0 ) || ( nr > 9 ) ) nr = 0;
        ((UserAction*)fp)->setNr( nr );
      }
      comlist->addElement( fp );
      break;
    case ROWUP_NUMBER:
      fp = new RowUp();
      comlist->addElement( fp );
      break;
    case ROWDOWN_NUMBER:
      fp = new RowDown();
      comlist->addElement( fp );
      break;
    case CHANGEHIDDENFLAG_NUMBER:
      fp = new ChangeHiddenFlag();
      if ( chunksize >= Datei::getIntSize() ) {
        ((ChangeHiddenFlag*)fp)->setMode( fh->getInt() );
        chunksize -= Datei::getIntSize();
      }
      comlist->addElement( fp );
      break;
    case COPYOP_NUMBER:
      cop = new CopyOp();
      if ( chunksize >= ( 8 * cs + 2 * is ) ) {
        if ( fh->getUChar() == 1 ) cop->setFollowSymlinks( true ); else cop->setFollowSymlinks( false );
        if ( fh->getUChar() == 1 ) cop->setMove( true ); else cop->setMove( false );
        if ( fh->getUChar() == 1 ) cop->setRename( true ); else cop->setRename( false );
        if ( fh->getUChar() == 1 ) cop->setSameDir( true ); else cop->setSameDir( false );
        if ( fh->getUChar() == 1 ) cop->setRequestDest( true ); else cop->setRequestDest( false );
        if ( fh->getUChar() == 1 ) cop->setRequestFlags( true ); else cop->setRequestFlags( false );
        c1 = fh->getUChar();
        switch ( c1 ) {
          case 1:
            cop->setOverwrite( CopyOp::COPYOP_OVERWRITE_ALWAYS );
            break;
          case 2:
            cop->setOverwrite( CopyOp::COPYOP_OVERWRITE_NEVER );
            break;
          default:
            cop->setOverwrite( CopyOp::COPYOP_OVERWRITE_NORMAL );
        }
        c1 = fh->getUChar();
        switch ( c1 ) {
          case 1:
            cop->setFastcopy( CopyOp::COPYOP_FASTCOPY );
            break;
          case 2:
            cop->setFastcopy( CopyOp::COPYOP_FASTESTCOPY );
            break;
          default:
            cop->setFastcopy( CopyOp::COPYOP_NORMALCOPY );
        }
        chunksize -= 8 * cs;
    
        len = fh->getInt();
        chunksize -= is;
        if ( len > 0 ) {
          // this is no longer used and was the cp_com string
          tstr = fh->getString( len );
          chunksize -= len;
          _freesafe( tstr );
        }
    
        len = fh->getInt();
        chunksize -= is;
        if ( len > 0 ) {
          // this is no longer used and was the cp_com string
          tstr = fh->getString( len );
          chunksize -= len;
          _freesafe( tstr );
        }
        
        if ( chunksize >= cs ) {
          if ( fh->getUChar() == 1 ) cop->setPreserveAttr( true ); else cop->setPreserveAttr( false );
          chunksize -= cs;
        }
      }
      comlist->addElement( cop );
      break;
    case FIRSTROW_NUMBER:
      fp = new FirstRow();
      comlist->addElement( fp );
      break;
    case LASTROW_NUMBER:
      fp = new LastRow();
      comlist->addElement( fp );
      break;
    case PAGEUP_NUMBER:
      fp = new PageUp();
      comlist->addElement( fp );
      break;
    case PAGEDOWN_NUMBER:
      fp = new PageDown();
      comlist->addElement( fp );
      break;
    case SELECTOP_NUMBER:
      fp = new SelectOp();
      comlist->addElement( fp );
      break;
    case SELECTALLOP_NUMBER:
      fp = new SelectAllOp();
      comlist->addElement( fp );
      break;
    case SELECTNONEOP_NUMBER:
      fp = new SelectNoneOp();
      comlist->addElement( fp );
      break;
    case INVERTALLOP_NUMBER:
      fp = new InvertAllOp();
      comlist->addElement( fp );
      break;
    case PARENTDIROP_NUMBER:
      fp = new ParentDirOp();
      comlist->addElement( fp );
      break;
    case ENTERDIROP_NUMBER:
      fp = new EnterDirOp();
      if ( chunksize >= ( Datei::getIntSize() + Datei::getUCharSize() ) ) {
        len = fh->getInt();
        chunksize -= Datei::getIntSize();
        str = fh->getString( len );
        ((EnterDirOp*)fp)->setDir( str );
        _freesafe( str );
        chunksize -= len;
        c1 = fh->getUChar();
        switch ( c1 ) {
          case 1:
            ((EnterDirOp*)fp)->setMode( EnterDirOp::ENTERDIROP_ACTIVE2OTHER );
            break;
          case 2:
            ((EnterDirOp*)fp)->setMode( EnterDirOp::ENTERDIROP_SPECIAL );
            break;
          case 3:
            ((EnterDirOp*)fp)->setMode( EnterDirOp::ENTERDIROP_REQUEST );
            break;
          default:
            ((EnterDirOp*)fp)->setMode( EnterDirOp::ENTERDIROP_ACTIVE );
            break;
        }
        chunksize -= Datei::getUCharSize();
      }
      comlist->addElement( fp );
      break;
    case CHANGELISTERSETOP_NUMBER:
      fp = new ChangeListerSetOp();
      if ( chunksize >= cs ) {
        c1 = fh->getUChar();
        switch ( c1 ) {
          case 1:
            ((ChangeListerSetOp*)fp)->setMode( ChangeListerSetOp::CLS_RIGHT_LISTER );
            break;
          case 2:
            ((ChangeListerSetOp*)fp)->setMode( ChangeListerSetOp::CLS_CURRENT_LISTER );
            break;
          case 3:
            ((ChangeListerSetOp*)fp)->setMode( ChangeListerSetOp::CLS_OTHER_LISTER );
            break;
          default:
            ((ChangeListerSetOp*)fp)->setMode( ChangeListerSetOp::CLS_LEFT_LISTER );
            break;
        }
        chunksize -= cs;
      }
      comlist->addElement( fp );
      break;
    case SWITCHLISTEROP_NUMBER:
      fp = new SwitchListerOp();
      comlist->addElement( fp );
      break;
    case FILTERSELECTOP_NUMBER:
      fp = new FilterSelectOp();
      if ( chunksize >= Datei::getIntSize() ) {
        len = fh->getInt();
        chunksize -= Datei::getIntSize();
        str = fh->getString( len );
        ((FilterSelectOp*)fp)->setFilter( str );
        _freesafe( str);
        chunksize -= len;
      }
      comlist->addElement( fp );
      break;
    case FILTERUNSELECTOP_NUMBER:
      fp = new FilterUnSelectOp();
      if ( chunksize >= Datei::getIntSize() ) {
        len = fh->getInt();
        chunksize -= Datei::getIntSize();
        str = fh->getString( len );
        ((FilterUnSelectOp*)fp)->setFilter( str );
        _freesafe( str );
        chunksize -= len;
      }
      comlist->addElement( fp );
      break;
    case PATH2OSIDEOP_NUMBER:
      fp = new Path2OSideOp();
      comlist->addElement( fp );
      break;
    case QUITOP_NUMBER:
      fp = new QuitOp();
      if ( chunksize >= cs ) {
        c1 = fh->getUChar();
        switch ( c1 ) {
          case 1:
            ((QuitOp*)fp)->setMode( QuitOp::Q_QUICK_QUIT );
            break;
          default:
            ((QuitOp*)fp)->setMode( QuitOp::Q_NORMAL_QUIT );
            break;
        }
        chunksize -= cs;
      }
      comlist->addElement( fp );
      break;
    case DELETEOP_NUMBER:
      fp = new DeleteOp();
      if ( chunksize >= Datei::getUCharSize() ) {
        if ( fh->getUChar() == 1 ) ((DeleteOp*)fp)->setAlsoActive( true );
        else ((DeleteOp*)fp)->setAlsoActive( false );
    
        chunksize -= Datei::getUCharSize();
      }
      comlist->addElement( fp );
      break;
    case RELOADOP_NUMBER:
      fp = new ReloadOp();
      if ( chunksize >= cs ) {
        c1 = fh->getUChar();
        switch ( c1 ) {
          case 1:
            ((ReloadOp*)fp)->setReloadside( ReloadOp::RELOADOP_OTHERSIDE );
            break;
          case 2:
            ((ReloadOp*)fp)->setReloadside( ReloadOp::RELOADOP_LEFTSIDE );
            break;
          case 3:
            ((ReloadOp*)fp)->setReloadside( ReloadOp::RELOADOP_RIGHTSIDE );
            break;
          default:
            ((ReloadOp*)fp)->setReloadside( ReloadOp::RELOADOP_THISSIDE );
            break;
        }
        chunksize -= cs;
        if ( chunksize >= cs ) {
          if ( fh->getUChar() == 1 ) ((ReloadOp*)fp)->setResetDirSizes( true );
          else ((ReloadOp*)fp)->setResetDirSizes( false );
          chunksize -= cs;
          
          // new >2.3.1
          if ( chunksize >= cs ) {
            if ( fh->getUChar() == 1 ) ((ReloadOp*)fp)->setKeepFiletypes( true );
            else ((ReloadOp*)fp)->setKeepFiletypes( false );
            chunksize -= cs;
          }
        }
      }
      comlist->addElement( fp );
      break;
    case MAKEDIROP_NUMBER:
      fp = new MakeDirOp();
      comlist->addElement( fp );
      break;
    case OWNOP_NUMBER:
      op = new OwnOp();
      if ( chunksize >= ( 4 * cs + 2 * is ) ) {
        fh->getUChar(); // was with_apo
        if ( fh->getUChar() == 1 ) op->setSeparateEachEntry( true ); else op->setSeparateEachEntry( false );
        if ( fh->getUChar() == 1 ) op->setRecursive( true ); else op->setRecursive( false );
        c1 = fh->getUChar();
        switch ( c1 ) {
          case 1:
            op->setOwnStart( OwnOp::OWNOP_START_IN_TERMINAL );
            break;
          case 2:
            op->setOwnStart( OwnOp::OWNOP_START_IN_TERMINAL_AND_WAIT4KEY );
            break;
          case 3:
            op->setOwnStart( OwnOp::OWNOP_SHOW_OUTPUT );
            break;
          default:
            op->setOwnStart( OwnOp::OWNOP_START_NORMAL );
        }
        chunksize -= 4 * cs;
    
        len = fh->getInt();
        chunksize -= is;
        str = fh->getString(len);
        op->setComStr( str );
        _freesafe( str );
        chunksize -= len;
    
        len = fh->getInt();
        chunksize -= is;
        str = fh->getString( len );
        op->setViewStr( str );
        _freesafe( str );
        chunksize -= len;
        
        // new >2.3.1
        if ( chunksize >= cs ) {
          if ( fh->getUChar() == 1 ) op->setInBackground( true ); else op->setInBackground( false );
          chunksize -= cs;
          
          // new >2.5.0
          if ( chunksize >= cs ) {
            if ( fh->getUChar() == 1 ) op->setTakeDirs( true ); else op->setTakeDirs( false );
            chunksize -= cs;
          }
        }
      }
      comlist->addElement( op );
      break;
    case RENAMEOP_NUMBER:
      fp = new RenameOp();
      comlist->addElement( fp );
      break;
    case DIRSIZEOP_NUMBER:
      fp = new DirSizeOp();
      comlist->addElement( fp );
      break;
    case SIMDDOP_NUMBER:
      fp = new SimDDOp();
      comlist->addElement( fp );
      break;
    case STARTPROGOP_NUMBER:
      stpop = new StartProgOp();
      if ( chunksize >= ( 3 * cs + is ) ) {
        c1 = fh->getUChar();
        switch ( c1 ) {
          case 1:
            stpop->setStart( StartProgOp::STARTPROGOP_START_IN_TERMINAL );
            break;
          case 2:
            stpop->setStart( StartProgOp::STARTPROGOP_START_IN_TERMINAL_AND_WAIT4KEY );
            break;
          case 3:
            stpop->setStart( StartProgOp::STARTPROGOP_SHOW_OUTPUT );
            break;
          default:
            stpop->setStart( StartProgOp::STARTPROGOP_START_NORMAL );
        }
        chunksize -= cs;
    
        len = fh->getInt();
        chunksize -= is;
        str = fh->getString( len );
        stpop->setViewStr( str );
        _freesafe(str );
        chunksize -= len;

        if ( fh->getUChar() == 1 ) stpop->setGlobal( true ); else stpop->setGlobal( false );
        if ( fh->getUChar() == 1 ) stpop->setRequestFlags( true ); else stpop->setRequestFlags( false );
        chunksize -= 2 * cs;
        
        // new >2.3.1
        if ( chunksize >= cs ) {
          if ( fh->getUChar() == 1 ) stpop->setInBackground( true ); else stpop->setInBackground( false );
          chunksize -= cs;
        }
      }
      comlist->addElement( stpop );
      break;
    case SEARCHENTRYOP_NUMBER:
      fp = new SearchEntryOp();
      comlist->addElement( fp );
      break;
    case ENTERPATHOP_NUMBER:
      fp = new EnterPathOp();
      if ( chunksize >= cs ) {
        c1 = fh->getUChar();
        switch ( c1 ) {
          case 1:
            ((EnterPathOp*)fp)->setSide( EnterPathOp::ENTERPATHOP_OTHERSIDE );
            break;
          case 2:
            ((EnterPathOp*)fp)->setSide( EnterPathOp::ENTERPATHOP_LEFTSIDE );
            break;
          case 3:
            ((EnterPathOp*)fp)->setSide( EnterPathOp::ENTERPATHOP_RIGHTSIDE );
            break;
          default:
            ((EnterPathOp*)fp)->setSide( EnterPathOp::ENTERPATHOP_THISSIDE );
            break;
        }
        chunksize -= cs;
      }
      comlist->addElement( fp );
      break;
    case SCROLLLISTEROP_NUMBER:
      fp = new ScrollListerOp();
      if ( chunksize >= cs ) {
        c1 = fh->getUChar();
        switch ( c1 ) {
          case 1:
            ((ScrollListerOp*)fp)->setDir( ScrollListerOp::SCROLLLISTEROP_RIGHT );
            break;
          default:
            ((ScrollListerOp*)fp)->setDir( ScrollListerOp::SCROLLLISTEROP_LEFT );
            break;
        }
        chunksize -= cs;
      }
      comlist->addElement( fp );
      break;
    case CREATESYMLINKOP_NUMBER:
      fp = new CreateSymlinkOp();
      if ( chunksize >= ( 3 * cs ) ) {
        if ( fh->getUChar() == 1 ) ((CreateSymlinkOp*)fp)->setSameDir( true );
        else ((CreateSymlinkOp*)fp)->setSameDir( false );
        if ( fh->getUChar() == 1 ) ((CreateSymlinkOp*)fp)->setLocal( true );
        else ((CreateSymlinkOp*)fp)->setLocal( false );
        if ( fh->getUChar() == 1 ) ((CreateSymlinkOp*)fp)->setRequestFlags( true );
        else ((CreateSymlinkOp*)fp)->setRequestFlags( false );
        chunksize -= 3 * cs;
      }
      comlist->addElement( fp );
      break;
    case CHANGESYMLINKOP_NUMBER:
      fp = new ChangeSymlinkOp();
      comlist->addElement( fp );
      break;
    case CHMODOP_NUMBER:
      fp = new ChModOp();
      if ( chunksize >= ( 4 * cs ) ) {
        if ( fh->getUChar() == 1 ) ((ChModOp*)fp)->setOnFiles( true );
        else ((ChModOp*)fp)->setOnFiles( false );
        if ( fh->getUChar() == 1 ) ((ChModOp*)fp)->setOnDirs( true );
        else ((ChModOp*)fp)->setOnDirs( false );
        if ( fh->getUChar() == 1 ) ((ChModOp*)fp)->setRecursive( true );
        else ((ChModOp*)fp)->setRecursive( false );
        if ( fh->getUChar() == 1 ) ((ChModOp*)fp)->setRequestFlags( true );
        else ((ChModOp*)fp)->setRequestFlags( false );
        chunksize -= 4 * cs;
      }
      comlist->addElement( fp );
      break;
    case TOGGLELISTERMODEOP_NUMBER:
      fp = new ToggleListermodeOp();
      if ( chunksize >= is ) {
        chunksize -= is;
        ((ToggleListermodeOp*)fp)->setMode( fh->getInt() );
      }
      comlist->addElement( fp );
      break;
    case SETSORTMODEOP_NUMBER:
      fp = new SetSortmodeOp();
      if ( chunksize >= 5 ) {
        ((SetSortmodeOp*)fp)->setMode( fh->getInt() );
        chunksize -= 5;
      }
      comlist->addElement( fp );
      break;
    case SETFILTEROP_NUMBER:
      fp = new SetFilterOp();
      if ( chunksize >= ( 2 * cs + is ) ) {
        if ( fh->getUChar() == 1 ) ((SetFilterOp*)fp)->setRequestFlags( true );
        else ((SetFilterOp*)fp)->setRequestFlags( false );
        c1 = fh->getUChar();
        switch ( c1 ) {
          case 1:
            ((SetFilterOp*)fp)->setFiltermode( SetFilterOp::EXCLUDE_FILTER );
            break;
          case 2:
            ((SetFilterOp*)fp)->setFiltermode( SetFilterOp::UNSET_FILTER );
            break;
          case 3:
            ((SetFilterOp*)fp)->setFiltermode( SetFilterOp::UNSET_ALL );
            break;
          default:
            ((SetFilterOp*)fp)->setFiltermode( SetFilterOp::INCLUDE_FILTER );
        }
        chunksize -= 2 * cs;
    
        len = fh->getInt();
        chunksize -= is;
        str = fh->getString(len);
        ((SetFilterOp*)fp)->setFilter( str );
        _freesafe( str );
        chunksize -= len;
      }
      comlist->addElement( fp );
      break;
    case SHORTKEYFROMLISTOP_NUMBER:
      fp = new ShortkeyFromListOp();
      comlist->addElement( fp );
      break;
    case CHOWNOP_NUMBER:
      fp = new ChOwnOp();
      if ( chunksize >= ( 4 * cs ) ) {
        if ( fh->getUChar() == 1 ) ((ChOwnOp*)fp)->setOnFiles( true );
        else ((ChOwnOp*)fp)->setOnFiles( false );
        if ( fh->getUChar() == 1 ) ((ChOwnOp*)fp)->setOnDirs( true );
        else ((ChOwnOp*)fp)->setOnDirs( false );
        if ( fh->getUChar() == 1 ) ((ChOwnOp*)fp)->setRecursive( true );
        else ((ChOwnOp*)fp)->setRecursive( false );
        if ( fh->getUChar() == 1 ) ((ChOwnOp*)fp)->setRequestFlags( true );
        else ((ChOwnOp*)fp)->setRequestFlags( false );
        chunksize -= 4 * cs;
      }
      comlist->addElement( fp );
      break;
    case SCRIPTOP_NUMBER:
      scop = new ScriptOp();
      if ( chunksize >= ( 11 * cs + 7 * is ) ) {
        c1 = fh->getUChar();
        switch ( c1 ) {
        case 1:
          scop->setType( ScriptOp::SCRIPT_PUSH );
          break;
        case 2:
          scop->setType( ScriptOp::SCRIPT_LABEL );
          break;
        case 3:
          scop->setType( ScriptOp::SCRIPT_IF );
          break;
        case 4:
          scop->setType( ScriptOp::SCRIPT_END );
          break;
        case 5:
          scop->setType( ScriptOp::SCRIPT_POP );
          break;
        case 6:
          scop->setType( ScriptOp::SCRIPT_SETTINGS );
          break;
        case 7:
          scop->setType( ScriptOp::SCRIPT_WINDOW );
          break;
        case 8:
          scop->setType( ScriptOp::SCRIPT_GOTO );
          break;
        default:
          scop->setType( ScriptOp::SCRIPT_NOP );
          break;
        }
        if ( fh->getUChar() == 1 ) scop->setPushUseOutput( true );
        else scop->setPushUseOutput( false );
        if ( fh->getUChar() == 1 ) scop->setDoDebug( true );
        else scop->setDoDebug( false );
        if ( fh->getUChar() == 1 ) scop->setWPURecursive( true );
        else scop->setWPURecursive( false );
        fh->getUChar();  // was with quotes
        if ( fh->getUChar() == 1 ) scop->setWPUTakeDirs( true );
        else scop->setWPUTakeDirs( false );
        chunksize -= 6 * cs;
        
        scop->setStackNr( fh->getInt() );
        chunksize -= is;
    
        len = fh->getInt();
        chunksize -= is;
        if ( len > 0 ) {
          tstr = fh->getString(len);
          scop->setLabel( tstr );
          _freesafe( tstr );
        } else {
          scop->setLabel( NULL );
        }
        chunksize -= len;
    
        len = fh->getInt();
        chunksize -= is;
        if ( len > 0 ) {
          tstr = fh->getString(len);
          scop->setPushString( tstr );
          _freesafe( tstr );
        } else {
          scop->setPushString( NULL );
        }
        chunksize -= len;
    
        len = fh->getInt();
        chunksize -= is;
        if ( len > 0 ) {
          tstr = fh->getString(len);
          scop->setIfTest( tstr );
          _freesafe( tstr );
        } else {
          scop->setIfTest( NULL );
        }
        chunksize -= len;
    
        len = fh->getInt();
        chunksize -= is;
        if ( len > 0 ) {
          tstr = fh->getString(len);
          scop->setIfLabel( tstr );
          _freesafe( tstr );
        } else {
          scop->setIfLabel( NULL );
        }
        chunksize -= len;
    
        c1 = fh->getUChar();
        switch ( c1 ) {
        case 1:
          scop->setWinType( ScriptOp::SCRIPT_WINDOW_OPEN );
          break;
        case 2:
          scop->setWinType( ScriptOp::SCRIPT_WINDOW_CLOSE );
          break;
        default:
          scop->setWinType( ScriptOp::SCRIPT_WINDOW_LEAVE );
          break;
        }
        if ( fh->getUChar() == 1 ) scop->setChangeProgress( true );
        else scop->setChangeProgress( false );
        if ( fh->getUChar() == 1 ) scop->setChangeText( true );
        else scop->setChangeText( false );
        if ( fh->getUChar() == 1 ) scop->setProgressUseOutput( true );
        else scop->setProgressUseOutput( false );
        if ( fh->getUChar() == 1 ) scop->setWinTextUseOutput( true );
        else scop->setWinTextUseOutput( false );
        chunksize -= 5 * cs;
    
        len = fh->getInt();
        chunksize -= is;
        if ( len > 0 ) {
          tstr = fh->getString( len );
          scop->setProgress( tstr );
          _freesafe( tstr );
        } else {
          scop->setProgress( NULL );
        }
        chunksize -= len;
    
        len = fh->getInt();
        chunksize -= is;
        if ( len > 0 ) {
          tstr = fh->getString(len);
          scop->setWinText( tstr );
          _freesafe( tstr );
        } else {
          scop->setWinText( NULL );
        }
        chunksize -= len;
      }
      comlist->addElement( scop );
      break;
    case SHOWDIRCACHEOP_NUMBER:
      fp = new ShowDirCacheOp();
      comlist->addElement( fp );
      break;
    default:
      break;
  }
  while ( chunksize > 0 ) {
    fh->getUChar();
    chunksize--;
  }

  return comlist;
}

