/* $Id: newhash.c,v 1.1.1.1 2000/05/07 20:26:20 mauhuur Exp $ */
/*
 *
 * $Log: newhash.c,v $
 * Revision 1.1.1.1  2000/05/07 20:26:20  mauhuur
 * Initial import
 *
 *
 *
 */

/* New hash functions for iLisp */

/* Interface:
 * void IL_init_hash()
 * hash *IL_mkha()
 * ui IL_find_in_hash(hash *h,ui d,uc *n);
 * ui IL_put_in_hash (hash *h,ui d,uc *n,ui val);
 * void IL_kill_hash (hash *h);
 */

#include <stdio.h>
#include <stdlib.h>
#include "l_defs.h"

static hash *IL_NULL_hash;
static ui IL_hash_leng;

void 
IL_init_hash ()
{
  ui i;
  IL_NULL_hash = (hash *) malloc (sizeof (hash) * 256);
  for (i = 0; i < 256; i++)
    {
      IL_NULL_hash[i].h = NULL;
      IL_NULL_hash[i].c = NOSYM;
    }
  IL_hash_leng = sizeof (hash) * 256;
}


hash *
IL_mkha ()
{
  hash *tmp;

  tmp = (hash *) malloc (sizeof (struct _hash) * 256);
  memcpy (tmp, IL_NULL_hash, IL_hash_leng);
  return tmp;
}

ui 
IL_find_in_hash1 (hash * tab, ui len, uc * n)
{
  hash *h=tab;
  ui c, d=0;
  for (;;)
    {
      c = n[d];
      if (d == len)
	return h[c].c;
      if (h[c].h == NULL)
	return NOSYM;
      d++;
      h = h[c].h;
    }
}

ui 
IL_find_in_hash (hash * h, ui d, uc * n)
{
/*
   ui c;
   hash *h1;
   c=n[d];h1=h+c;
   if(!n[d+1]) {if(d+1==strlen(n)) return h1->c; else return NOSYM;}
   if((h1->h)==NULL) 
   {
   if(d+1==strlen(n)) return h1->c; else return NOSYM;
   }
   return IL_find_in_hash(h1->h,d+1,n);
 */
  return IL_find_in_hash1 (h, strlen (n) - 1, n);
}

ui 
IL_put_in_hash (hash * h, ui d, uc * n, ui val)
{
  ui c;
  hash *h1;
  c = n[d];
  h1 = h + c;
  if (!n[d + 1])
    {
      h1->c = val;
      return val;
    }
  if ((h1->h) == NULL)
    {
      h1->h = IL_mkha ();
      return IL_put_in_hash (h1->h, d + 1, n, val);
    }
  return IL_put_in_hash (h1->h, d + 1, n, val);
}

void 
IL_kill_hash (hash * h)
{
  ui i;
  for (i = 0; i < 256; i++)
    if (h[i].h)
      IL_kill_hash (h[i].h);
  free (h);
}
